#ifndef __CHECKS_H
#define __CHECKS_H

#include "crc.h"
#include "files.h"

inline int CheckCRC(char *fname)
{
    unsigned long CRC1,CRC2;
    unsigned char sCRC[4];
    int hFile,iReaded,iReadPos,pos;
    unsigned char *buf,*strp;

    hFile = open(fname, O_RDONLY | O_BINARY);
    if (hFile == -1)
    {
        printf("\nCan't open file '%s'\n",fname);
        exit(1);
    }
    printf("reading file '%s'\n",fname);

    buf = new unsigned char[16384];
    pos = 1; CRC1 = 0xffffffff; CRC2 = 0;
    for (;;)
    {
        iReaded = read(hFile, buf, 16384);
        if (iReaded == 0) break;

        strp = buf; iReadPos = 0;
        while (iReadPos < iReaded)
        {
            if (pos < 0)
            {
                if (pos == -1) { sCRC[0] = *strp; pos--; }
                else if (pos == -2) { sCRC[1] = *strp; pos--; }
                else if (pos == -3) { sCRC[2] = *strp; pos--; }
                else if (pos == -4) { sCRC[3] = *strp; pos = 255; memcpy(&CRC2,sCRC,4); }
            }
            else
            {
                CalcCRC(CRC1, *strp);
                if (pos != 255)
                {
                    if (*strp == CRCSTRING[pos])
                    {
                        pos++;
                        if (pos == sizeof(CRCSTRING)-5) pos = -1; // Found CRC position!
                    }
                    else
                    {
                        pos = 1;
                    }
                }
            }
            strp++; iReadPos++;
        }
    }

    close(hFile);
    return CRC1 != CRC2;
}

#endif
