#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pkt_hipp.h"
#include "files.h"
#include "keyb.h"
#include "bluewave.h"
#include "vars.h"
#include "general.h"
#include "screen.h"

char dots(char *str)
{
    char dot;

    dot = 1;
    while (*str != '\0')
    {
        if (*str++ == ',') dot++;
    }
    return dot;
}

char *getdot(char *str, char *output, int dotnum)
{
    char *start;
    int dots;

    dots = 0; *output = '\0'; start = output;
    for (;;)
    {
        /* Skip spaces */
        while (*str == ' ') str++;
        if (*str == '\0') return output;

        dots++;
        for (;;)
        {
            if (*str == ',' && dotnum != dots)
            {
                str++;
                break;
            }

            if (*str == '\0' || *str == ',')
            {
                /* Strip trailing spaces */
                while (output > start && (*(output-1) == ' ' || *(output-1) == 9)) output--;
                *output = '\0';
                return output;
            }
            if (dotnum == dots) *output++ = *str;
            str++;
        }
    }
}

char hippo_packet::open_packet(char *str)
{
    unsigned short cx,cy,cx2,cy2;
    char *oldscr,*oldscr2;

    char usr[36],usr1[36],usr2[36],tmp[256],tmp2[81],*pstr;
    char mainaddr[26],idxname[13],mixname[13],datname[13],lastarea[81];
    char *datbuf,quit,maybeinf;
    int bnum;
    long num,num2;
    int datpos;
    unsigned msgareas,infareas;
    size_t slen;

    unsigned long msgpos,msgs;

    msgtype *msgidx;
    MIX_REC mixrec;

    INF_HEADER infohdr;
    INF_AREA_INFO infarea;

    FILE *F,*Fhd;


    know_areas = 0;
    offline_config = 1;
    
    from_to_len = 35;
    subj_len = 71;

    inf_header_slen = sizeof(INF_HEADER);
    inf_area_slen = sizeof(INF_AREA_INFO);

    area_start = 1; area_end = 0;

    if (replymgr)
    {
        dat_start = 1; dat_end = 0; pkt->lastarea[0] = '\0'; first_linerec = NULL;
        replyopen = 0; replies = 0; fupl_opened = 0; arealist = 0;

        hippoinf = 1;
        if ((txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;
        if ((Finfo = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"rb")) == NULL)
        {
            free(txt_buf);
            return 1;
        }
        //setbuf(Finfo,NULL);
        fread(&info,sizeof(info),1,Finfo);
        fseek(Finfo,0,SEEK_END);
        strcpy(username, (char *) info.loginname);
        strcpy(useralias, (char *) info.aliasname);
        strcpy(board_name, (char *) info.systemname);
        strcpy(sysop_name, (char *) info.sysop);
        areas = (ftell(Finfo)-sizeof(INF_HEADER))/sizeof(INF_AREA_INFO);
        if (areas < MAX_AREAS)
            abufsize = areas;
        else
            abufsize = MAX_AREAS;
        if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL) {
            fclose(Finfo);
            free(txt_buf);
            return 2;
        }
        return 0;
    }


    save_scr(&cx,&cy,&oldscr);
    first = 0;
    curarea = 0;
    hippoinf = 0;
    maybeinf = 0;
    idxstart = 65535; idxend = 0;
    strcpy(username,setup.UsrName);
    strcpy(useralias,opt.alias);
    strupr(strcpy(usr1,setup.UsrName));
    strupr(strcpy(usr2,opt.alias));
    strcpy(board_name,"<unknown>");
    strcpy(sysop_name,"<unknown>");
    if (!packet.open)
    {
        slen = strlen(lang[23]);
        if (strlen(lang[25])+2 > slen) slen = strlen(lang[25])+2;
        draw_shaded_box(scrwidth/2-slen/2-2,8,scrwidth/2+slen/2+2,12,color[col_box_frame],color[col_box_title],lang[23]);
    }

    if (!packet.open)
    {
        if ((Fhd = fopen_ign(strcat(strcpy(tmp,str),"hd"),"r+t")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 1;
        }
    }

    if (packet.open)
    {
        if ((Fpktidx = fopen_ign(strcat(strcat(strcpy(tmp,setup.packetpath),pktname),".___"),"r+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 1;
        }
        while (fread(&pktidx,sizeof(pktidx),1,Fpktidx))
        {
            if (pktidx.packet == packet.pktnumber)
                if (strcmp(pktidx.oldname,strcat(strcpy(tmp,pktname),".idx")) == 0)
                    strcpy(idxname,pktidx.idxname);
                else if (strcmp(pktidx.oldname,strcat(strcpy(tmp,pktname),".mix")) == 0)
                    strcpy(mixname,pktidx.idxname);
                else if (strcmp(pktidx.oldname,strcat(strcpy(tmp,pktname),".dat")) == 0)
                    strcpy(datname,pktidx.idxname);
                else if (strcmp(pktidx.oldname,strcat(strcpy(tmp,pktname),".xti")) == 0)
                    strcpy(xtiname,pktidx.idxname);
        }
        fclose(Fpktidx);
        if ((Fidx = fopen_ign(strcat(strcpy(tmp,setup.packetpath),idxname),"r+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 1;
        }
    }
    else if (setup.packet_flags & PKT_SAVE_UNPACKED)
    {
        sprintf(tmp,"%s%s.___",setup.packetpath,pktname);

        first = 0;
        if ((Fpktidx = fopen_ign(tmp,"r+b")) != NULL) {
            while (fread(&pktidx,1,sizeof(pktidx),Fpktidx))
                if (first <= pktidx.packet) first = pktidx.packet+1;

            if (first > 65535)
            {
                unsigned char *arr = (unsigned char *) malloc(65536/8);
                if (arr == NULL) abort();

                memset(arr,0,65536/8);
                fseek(Fpktidx,0,SEEK_SET);
                while (fread(&pktidx,1,sizeof(pktidx),Fpktidx))
                    arr[pktidx.packet/8] |= (unsigned char) (1 << (pktidx.packet & 7));

                for (num=0; num<65536; num++)
                    if ((arr[num/8] & (1 << (num & 7))) == 0) {
                        first = num;
                        break;
                    }
                if (first > 65535) {
                    while (sk_kbhit()) sk_getch();
                    draw_shaded_box(scrwidth/2-10,8,scrwidth/2+30,16,color[col_warn_frame],color[col_warn_title],NULL);
                    cmiddle(10,"Sorry, you have too many open mail packets",color[col_warn_text]);
                    cmiddle(11,"(65536 or this program bugs). You have to",color[col_warn_text]);
                    cmiddle(12,"delete some of them to continue.",color[col_warn_text]);
                    cmiddle(14,"Press any key to continue",color[col_warn_hilight]);
                    if (sk_getch() == 0) sk_getch();
                    return 6;
                }
                free(arr);
            }
        } else if ((Fpktidx = FileOpen(tmp,"w+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 4;
        }

        pktidx.packet = (unsigned short) first;

        tmp[strlen(tmp)-3] = 0;
        adder(tmp);

        strcat(strcpy(pktidx.oldname,pktname),".idx");
        if ((pstr = strrchr(tmp,SLASH)) == NULL) pstr = tmp; else pstr++;
        strcpy(pktidx.idxname,pstr);
        fwrite(&pktidx,sizeof(pktidx),1,Fpktidx);

        if ((Fidx = FileOpen(tmp,"w+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 4;
        }
    }
    else if ((Fidx = FileOpen(strcat(strcpy(tmp,str),"idx"),"w+b")) == NULL)
    {
        old_scr(cx,cy,&oldscr);
        return 4;
    }
    //setbuf(Fidx,NULL);

    if (packet.open)
    {
        if ((Fmix = fopen_ign(strcat(strcpy(tmp,setup.packetpath),mixname),"r+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 1;
        }
    }
    else if (setup.packet_flags & PKT_SAVE_UNPACKED)
    {
        sprintf(tmp,"%s%s.",setup.packetpath,pktname);
        adder(tmp);

        strcat(strcpy(pktidx.oldname,pktname),".MIX");
        if ((pstr = strrchr(tmp,SLASH)) == NULL) pstr = tmp; else pstr++;
        strcpy(pktidx.idxname,pstr);
        pktidx.packet = (unsigned short) first;
        fwrite(&pktidx,sizeof(pktidx),1,Fpktidx);

        if ((Fmix = FileOpen(tmp,"w+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 4;
        }
    }
    else if ((Fmix = FileOpen(strcat(strcpy(tmp,str),"mix"),"w+b")) == NULL)
    {
        old_scr(cx,cy,&oldscr);
        return 4;
    }

    infareas = 0;
    if ((Finfo = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"r+b")) != NULL)
    {
        if (fread(&infohdr,sizeof(infohdr),1,Finfo))
        {
            strcpy(board_name,(char *) infohdr.systemname);
            strcpy(sysop_name,(char *) infohdr.sysop);
            fseek(Finfo,0,SEEK_END);
            infareas = (ftell(Finfo)-sizeof(INF_HEADER)) / sizeof(INF_AREA_INFO);
            if (!packet.open) {
                areas = infareas;
                infareas = 0;
            }
            maybeinf = 1;
        }
    }
    else if ((Finfo = FileOpen(strcat(strcat(strcpy(tmp,setup.workpath),pktname),".inf"),"w+b")) != NULL)
    {
        memset(&infohdr,0,sizeof(infohdr));
        fwrite(&infohdr,sizeof(infohdr),1,Finfo);
    }

    if (packet.open)
    {
        if ((Fdat = fopen_ign(strcat(strcpy(tmp,setup.packetpath),datname),"r+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 1;
        }
    }
    else if (setup.packet_flags & PKT_SAVE_UNPACKED)
    {
        sprintf(tmp,"%s%s.",setup.packetpath,pktname);
        adder(tmp);

        strcat(strcpy(pktidx.oldname,pktname),".dat");
        if ((pstr = strrchr(tmp,SLASH)) == NULL) pstr = tmp; else pstr++;
        strcpy(pktidx.idxname,pstr);
        pktidx.packet = (unsigned short) first;
        fwrite(&pktidx,sizeof(pktidx),1,Fpktidx);

        if ((Fdat = FileOpen(tmp,"w+b")) == NULL)
        {
            old_scr(cx,cy,&oldscr);
            return 4;
        }
    }
    else if ((Fdat = FileOpen(strcat(strcpy(tmp,str),"dat"),"w+b")) == NULL)
    {
        old_scr(cx,cy,&oldscr);
        return 4;
    }
    //setbuf(Fdat,NULL);

    msgareas = 0;
    mainaddr[0] = 0;

    if (packet.open)
    {
        hippoinf = 1;
        fseek(Fmix,0,SEEK_END);
        msgareas = ftell(Fmix) / sizeof(MIX_REC);
        fseek(Finfo,0,SEEK_END);
        areas = (ftell(Finfo)-sizeof(INF_HEADER)) / sizeof(INF_AREA_INFO);
        offline_packet::open_packet(str);
        old_scr(cx,cy,&oldscr);
        return 0;
    }

    if ((datbuf = (char *) malloc(4096)) == NULL)
    {
        old_scr(cx,cy,&oldscr);
        return 2;
    }

    abufsize = MAX_AREAS;
    if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL)
    {
        free(datbuf);
        old_scr(cx,cy,&oldscr);
        return 2;
    }

    if ((msgidx = (msgtype *) malloc(sizeof(msgtype)*MAX_MSGS)) == NULL)
    {
        old_scr(cx,cy,&oldscr);
        return 2;
    }

__index_again:
    lastarea[0] = '\0';
    msgpos = 0;
    datpos = 0;
    msgs = 0;
    ansi_files = 0;
    while (_fgets(tmp,sizeof(tmp)-1,Fhd) != NULL)
    {
        if (strncmp(tmp,"Command",7) == 0)
        {
            if (strcmp(tmp+9,"Message") == 0)
            {
                msgs++;
                memset(&msg,0,sizeof(msg));
                msg.area = 0;
                strcpy(msg.mto,"All");
                msg.date[0] = 0;
                quit = 0;
                while (!quit)
                {
                    _fgets(tmp,sizeof(tmp)-1,Fhd);
                    num = (int) (strchr(tmp,':')-tmp);
                    switch (num)
                    {
                        case 2:
                            if ((tmp[0] == 'T') && (tmp[1] == 'o'))
                                strcpy(msg.mto,tmp+4);
                            break;
                        case 4:
                            if (strncmp(tmp,"From",4) == 0)
                                strcpy(msg.mfrom,tmp+6);
                            else
                                if (strncmp(tmp,"Area",4) == 0)
                                {
                                    if (msgareas == 0 || strcmp(lastarea,tmp+6) != 0)
                                    {
                                        if (msgareas > 0)
                                            fwrite(&mixrec,sizeof(mixrec),1,Fmix);

                                        strcpy(lastarea,tmp+6);
                                        msgareas++;
                                        memset(&mixrec,0,sizeof(mixrec));
                                        if (maybeinf)
                                        {
                                            if ((num = getaname(lastarea)) == 0)
                                            {
                                                while (sk_kbhit()) sk_getch();
                                                save_scr(&cx2,&cy2,&oldscr2);
                                                draw_shaded_box(scrwidth/2-25,9,scrwidth/2+26,19,color[col_warn_frame],color[col_warn_title],"Area not found from list");
                                                cmiddle(11,tmp,color[col_warn_hilight]);
                                                cmiddle(13,"Area names have changed since your last area",color[col_warn_text]);
                                                cmiddle(14,"information update. You should take new area",color[col_warn_text]);
                                                cmiddle(15,"informations to your next Hippo packet. Now",color[col_warn_text]);
                                                cmiddle(16,"ignoring the area information file.",color[col_warn_text]);
                                                cmiddle(18,"Press any key to continue",color[col_warn_hilight]);
                                                if (sk_getch() == 0) sk_getch();
                                                old_scr(cx2,cy2,&oldscr2);
                                                fseek(Fidx,0,SEEK_SET);
                                                fseek(Fmix,0,SEEK_SET);
                                                fseek(Fdat,0,SEEK_SET);
                                                fseek(Fhd,0,SEEK_SET);
                                                fclose(Finfo);

                                                sprintf(tmp,"%s%s.inf",setup.workpath,pktname);
                                                Finfo = FileOpen(tmp,"w+b");
                                                if (Finfo != NULL)
                                                {
                                                    memset(&infohdr,0,sizeof(infohdr));
                                                    fwrite(&infohdr,sizeof(infohdr),1,Finfo);
                                                }
                                                maybeinf = 0;
                                                msgareas = 0;
                                                area_start = 1; area_end = 0;
                                                goto __index_again;
                                            }
                                            strcpy((char *) mixrec.areanum,get_area_number(num));
                                        }
                                        else
                                        {
                                            sprintf((char *) mixrec.areanum,"%u",msgareas);
                                            memset(&infarea,0,sizeof(infarea));
                                            sprintf((char *) infarea.areanum,"%u",msgareas);
                                            sprintf((char *) infarea.echotag,"%u",msgareas);
                                            strcpy((char *) infarea.title,tmp+6);
                                            infarea.area_flags = INF_SCANNING | INF_POST;
                                            fwrite(&infarea,sizeof(infarea),1,Finfo);
                                        }
                                        mixrec.msghptr = ftell(Fidx) / sizeof(msgtype) + msgpos;
                                    }
                                    msg.area = (unsigned short) msgareas;
                                } else if (strncmp(tmp,"Date",4) == 0)
                                {
                                    strcpy(msg.date,"00-00-00 00:00");
                                    msg.date[0] = tmp[10];
                                    msg.date[1] = tmp[11];
                                    msg.date[3] = tmp[12];
                                    msg.date[4] = tmp[13];
                                    msg.date[6] = tmp[8];
                                    msg.date[7] = tmp[9];
                                    msg.date[9] = tmp[14];
                                    msg.date[10] = tmp[15];
                                    msg.date[12] = tmp[16];
                                    msg.date[13] = tmp[17];
                                }
                                else if (strncmp(tmp,"Next",4) == 0)
                                    msg.replyat = atol(tmp+6);
                            break;
                        case 5:
                            if (strncmp(tmp,"Reply",5) == 0)
                                msg.replyto = atol(tmp+7);
                            else
                                if (strncmp(tmp,"Lines",5) == 0)
                                {
                                    if (msg.area > 0)
                                    {
                                        mixrec.totmsgs++;
                                        strupr(strcpy(usr,msg.mto));
                                        if ((strcmp(usr,usr1) == 0) || (strcmp(usr,usr2) == 0))
                                            mixrec.numpers++;
                                    }
                                    quit = 1;
                                }
                            break;
                        case 6:
                            if (strncmp(tmp,"Status",6) == 0)
                            {
                                strupr(tmp+8);
                                msg.flags = 0;
                                num2 = dots(tmp);
                                for (num=1; num<=num2; num++)
                                {
                                    getdot(tmp+8,tmp2,num);
                                    if (strcmp(tmp2,"PRIVATE") == 0)
                                        msg.flags = flag_private;
                                }
                            } else
                                if (strncmp(tmp,"Number",6) == 0)
                                    msg.mnum = atol(tmp+8);
                            break;
                        case 7:
                            if (strncmp(tmp,"Subject",7) == 0)
                                strcpy(msg.subj,tmp+9);
                            break;
                    }
                }
                
                if (msg.area > 0)
                {
                    msg.blockpos = ftell(Fdat) + datpos;
                    msg.txtblocks = 0;
                    
                    num2 = atol(tmp+7);
                    for (num=1; num<=num2; num++)
                    {
                        _fgets(tmp,sizeof(tmp)-1,Fhd);
                        slen = strlen(tmp) + 1; tmp[slen-1] = 13;
                        msg.txtblocks += slen;
                        if (datpos+slen > 4095)
                        {
                            fwrite(datbuf,1,datpos,Fdat);
                            datpos = 0;
                        }
                        memcpy(&datbuf[datpos],tmp,slen);
                        datpos += slen;
                    }
                    
                    memcpy(&msgidx[msgpos],&msg,sizeof(msg));
                    if (msgpos == MAX_MSGS-1)
                    {
                        msgpos = 0;
                        fwrite(msgidx,sizeof(msgtype),MAX_MSGS,Fidx);
                    }
                    else msgpos++;

                    if ((msgs & 31) == 0)
                    {
                        sprintf(tmp,lang[25],msgs);
                        cmiddle(10,tmp,color[col_box_hilight]);
                        refresh();
                    }
                }
                quit = 0;
            }
            else if (strcmp(tmp+9,"Info") == 0)
            {
                slen = strlen(lang[24]);
                if (strlen(lang[26])+2 > slen) slen = strlen(lang[26])+2;
                draw_shaded_box(scrwidth/2-slen/2-2,8,scrwidth/2+slen/2+2,12,color[col_box_frame],color[col_box_title],lang[24]);
                quit = 0;
                while (!quit)
                {
                    _fgets(tmp,sizeof(tmp)-1,Fhd);
                    if (strncmp(tmp,"System",6) == 0)
                        strcpy(board_name,tmp+8);
                    else if (strncmp(tmp,"SysOp",5) == 0)
                        strcpy(sysop_name,tmp+7);
                    else if (strncmp(tmp,"UserName",8) == 0)
                        strcpy(username,tmp+7);
                    else if (strncmp(tmp,"Area",4) == 0)
                    {
                        strcpy(tmp2,tmp+6);
                        if (infareas > 0)
                        {
                            fseek(Finfo,sizeof(INF_HEADER)+(infareas-1)*sizeof(INF_AREA_INFO),SEEK_SET);
                            fwrite(&infarea,sizeof(infarea),1,Finfo);
                        }
                        else if (!maybeinf)
                        {
                            fclose(Finfo);
                            if ((Finfo = FileOpen(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"w+b")) != NULL)
                            {
                                memset(&infohdr,0,sizeof(infohdr));
                                fwrite(&infohdr,sizeof(infohdr),1,Finfo);
                            }
                        }
                        infareas++;
                        sprintf((char *) infarea.areanum,"%d",infareas);
                        strcpy((char *) infarea.echotag,(char *) infarea.areanum);
                        strcpy((char *) infarea.title,tmp2);
                        infarea.area_flags = INF_NO_PRIVATE;
                        infarea.network_type = INF_NET_FIDONET;
                        if ((infareas & 15) == 0)
                        {
                            sprintf(tmp2,lang[26],infareas);
                            cmiddle(10,tmp2,color[col_box_hilight]);
                        }
                    }
                    else if (strncmp(tmp,"Status",6) == 0)
                    {
                        strupr(tmp+8);
                        num2 = dots(tmp+8);
                        for (num=1; num<=num2; num++)
                        {
                            getdot(tmp+8,tmp2,num);
                            if (strcmp(tmp2,"NET") == 0)
                                infarea.area_flags |= INF_ECHO;
                            else if (strcmp(tmp2,"MAIL") == 0)
                            {
                                infarea.area_flags |= INF_NETMAIL | INF_NO_PUBLIC;
                                infarea.area_flags &= ~INF_NO_PRIVATE;
                            }
                            else if (strcmp(tmp2,"PRIVATE") == 0)
                                infarea.area_flags &= ~INF_NO_PRIVATE;
                            else if (strcmp(tmp2,"NOTAGLINE") == 0)
                                infarea.area_flags |= INF_NO_TAGLINE;
                        }
                        if  (infarea.area_flags & INF_NETMAIL && (infarea.area_flags & INF_ECHO) == 0)
                            infarea.area_flags &= ~INF_NETMAIL;
                    }
                    /*else if (strncmp(tmp,"Description",11) == 0)
                    {
                        sprintf(tmp2,"%s, %s",infarea.title,tmp+13);
                        tmp2[60] = '\0';
                        strcpy((char *) infarea.title, tmp2);
                    }*/
                    else if (strncmp(tmp,"Address",7) == 0)
                    {
                        if ((pstr = strchr(tmp+9,' ')) != NULL)
                        {
                            pstr--; pstr[0] = 0;
                        }
                        if (mainaddr[0] == 0) strcpy(mainaddr,tmp+9);
                    }
                    else if (strncmp(tmp,"Access",6) == 0)
                    {
                        strupr(tmp+8);
                        num2 = dots(tmp+8);
                        for (num=1; num<=num2; num++)
                        {
                            getdot(tmp+8,tmp2,num);
                            if (strcmp(tmp2,"MEMBER") == 0)
                                infarea.area_flags |= INF_SCANNING;
                            else if (strcmp(tmp2,"WRITE") == 0)
                                infarea.area_flags |= INF_POST;
                        }
                    }
                    else if (strncmp(tmp,"Lines",5) == 0)
                    {
                        fseek(Finfo,sizeof(INF_HEADER)+(infareas-1)*sizeof(INF_AREA_INFO),SEEK_SET);
                        fwrite(&infarea,sizeof(infarea),1,Finfo);

                        quit = 1;
                        num2 = atol(tmp+7);
                        for (num=1; num<=num2; num++)
                            _fgets(tmp,sizeof(tmp)-1,Fhd);
                    }
                }
                quit = 0;
            }
            else if (strcmp(tmp+9,"Bulletin") == 0)
            {
                quit = 0;
                while (!quit)
                {
                    _fgets(tmp,sizeof(tmp)-1,Fhd);
                    bnum = ansi_files+1;
                    if (strncmp(tmp,"Number",6) == 0)
                        bnum = atol(tmp+8);
                    if (strncmp(tmp,"Lines",5) == 0)
                    {
                        quit = 1;
                        sprintf(ansi_name[ansi_files],"%u.bul",bnum);
                        if ((F = FileOpen(strcat(strcpy(tmp,setup.workpath),ansi_name[ansi_files]),"w+b")) != NULL)
                        {
                            num2 = atol(tmp+7);
                            for (num=1; num<=num2; num++)
                            {
                                _fgets(tmp,sizeof(tmp)-1,Fhd);
                                fprintf(F,"%s\r\n",tmp);
                            }
                            fclose(F);
                            strcpy(ansi_time[ansi_files],"<unknown>");
                            if (ansi_files < 255) ansi_files++;
                        }
                    }
                }
                quit = 0;
            }
            else if (strcmp(tmp+9,"NewFiles") == 0)
            {
                quit = 0;
                while (!quit)
                {
                    _fgets(tmp,sizeof(tmp)-1,Fhd);
                    if (strncmp(tmp,"Lines",5) == 0)
                    {
                        quit = 1;
                        num2 = atol(tmp+7);
                        if ((F = FileOpen(strcat(strcpy(tmp,setup.workpath),"newfiles.dat"),"w+b")) != NULL)
                        {
                            for (num=1; num<=num2; num++)
                            {
                                _fgets(tmp,sizeof(tmp)-1,Fhd);
                                fprintf(F,"%s\r\n",tmp);
                            }
                            fclose(F);
                        }
                    }
                }
                quit = 0;
            }
        }
    }
    fclose(Fhd);
    if (msgareas > 0)
        fwrite(&mixrec,sizeof(mixrec),1,Fmix);

    if (infareas > 0)
    {
        if (!maybeinf)
        {
            sprintf(tmp,"%s%s.inf",setup.workpath,pktname);
            F = fopen_ign(tmp,"rb");
            if (F != NULL)
            {
                fseek(Fmix,0,SEEK_SET);
                num = 0;
                areas = infareas;
                while (fread(&mixrec,sizeof(mixrec),1,Fmix))
                {
                    fseek(Fmix,num*sizeof(mixrec),SEEK_SET);
                    fseek(F,sizeof(INF_HEADER)+(atol((char *) mixrec.areanum)-1)*sizeof(INF_AREA_INFO),SEEK_SET);
                    if (fread(&infarea,sizeof(infarea),1,F))
                    {
                        strcpy((char *) mixrec.areanum,get_area_number(getaname((char *) infarea.title)));
                        fwrite(&mixrec,sizeof(mixrec),1,Fmix);
                    }
                    num++;
                    fseek(Fmix,num*sizeof(mixrec),SEEK_SET);
                }
                fclose(F);
                FileRemove(tmp);
            }
        }
        memset(&infohdr,0,sizeof(infohdr));
        infohdr.ver = 254;
        infohdr.mashtype = arcfmt;
        strcpy((char *) infohdr.loginname,setup.UsrName);
        strcpy((char *) infohdr.aliasname,useralias);
        str2addr(mainaddr,&infohdr.zone,&infohdr.net,&infohdr.node,&infohdr.point);
        strcpy((char *) infohdr.sysop,sysop_name);
        strcpy((char *) infohdr.systemname,board_name);
        infohdr.inf_header_len = sizeof(INF_HEADER);
        infohdr.inf_areainfo_len = sizeof(INF_AREA_INFO);
        infohdr.mix_structlen = sizeof(MIX_REC);
        infohdr.fti_structlen = sizeof(FTI_REC);
        infohdr.uses_upl_file = 1;
        infohdr.from_to_len = 35;
        infohdr.subject_len = 71;
        strcpy((char *) infohdr.packet_id,pktname);

        fseek(Finfo,0,SEEK_SET);
        fwrite(&infohdr,1,sizeof(INF_HEADER),Finfo);

        hippoinf = 1;
    }
    else
    {
        if (maybeinf)
        {
            hippoinf = 1;
            infareas = areas;
        }
    }

    if (hippoinf) know_areas = 1;

    if (datpos > 0) fwrite(datbuf,1,datpos,Fdat);
    free(datbuf);
    if (msgpos > 1) fwrite(msgidx,sizeof(msgtype),msgpos,Fidx);
    free(msgidx);

    areas = hippoinf ? infareas : msgareas;

    old_scr(cx,cy,&oldscr);

    return offline_packet::open_packet(str);
}

void hippo_packet::close_packet(void)
{
    fclose(Finfo);
    free(area_buf);

    if (replymgr)
    {
        free(txt_buf);
        return;
    }

    fclose(Fidx);
    fclose(Fmix);
    fclose(Fdat);
    offline_packet::close_packet();
}

void hippo_packet::open_replypacket(void)
{
    FILE *F,*Fa,*Fhr;
    char tmp[256],str[256],quit,ch;
    unsigned area,num,num2;

    if (fupl_opened) return;

    replyopen = 0;
    fupl_opened = 1;
    replies = 0;
    sprintf(tmp,"%s%s.upl",setup.replypath,pktname);

    Fupl = fopen_ign(tmp,"r+b");
    if (Fupl != NULL)
    {
        //setbuf(Fupl,NULL);
        fseek(Fupl,0,SEEK_END);
        replies = (ftell(Fupl)-sizeof(UPL_HEADER))/sizeof(UPL_REC);
        return;
    }

    Fupl = FileOpen(tmp,"w+b");
    if (Fupl == NULL)
    {
        fupl_opened = 0;
        return;
    }

    //setbuf(Fupl,NULL);
    memset(&uplheader,0,sizeof(uplheader));
    fwrite(&uplheader,sizeof(uplheader),1,Fupl);

    sprintf(tmp,"%s%s.hr",setup.replypath,pktname);
    Fhr = fopen_ign(tmp,"rt");
    if (Fhr == NULL) return;

    sprintf(tmp,"%sAREAS.DAT",setup.replypath);
    Fa = FileOpen(tmp,"w+b");
    if (Fa == NULL)
    {
        fclose(Fhr);
        return;
    }

    /* AREAS.DAT to full of zeros */
    memset(tmp,0,sizeof(tmp));
    for (area=1; area<=areas/sizeof(tmp); area++)
        fwrite(tmp,1,sizeof(tmp),Fa);
    fwrite(tmp,1,areas % sizeof(tmp),Fa);

    while (_fgets(str,sizeof(str),Fhr) != NULL)
    {
        if (strncmp(str,"Command",7) == 0)
        {
            if (strcmp(str+9,"Post") == 0)
            {
                quit = 0;
                memset(&uplrec,0,sizeof(uplrec));
                strcpy((char *) uplrec.from,setup.UsrName);
                strcpy((char *) uplrec.to,"All");
                while (!quit)
                {
                    _fgets(str,sizeof(str)-1,Fhr);
                    if (strncmp(str,"Area",4) == 0)
                        sprintf((char *) uplrec.echotag,"%u",getaname(str+6));
                    else if ((str[0] == 'T') && (str[1] == 'o'))
                        strcpy((char *) uplrec.to,str+4);
                    else if (strncmp(str,"Subject",7) == 0)
                        strcpy((char *) uplrec.subj,str+9);
                    else if (strncmp(str,"Reply",5) == 0)
                        uplrec.replyto = atol(str+7);
                    else if (strncmp(str,"Destination",11) == 0)
                    {
                        uplrec.msg_attr |= UPL_NETMAIL;
                        str2addr(str+13,&uplrec.destzone,&uplrec.destnet,&uplrec.destnode,&uplrec.destpoint);
                    }
                    else if (strncmp(str,"Status",6) == 0)
                    {
                        strupr(str+8);
                        num2 = dots(str+8);
                        for (num=1; num<=num2; num++)
                        {
                            getdot(str,tmp,num);
                            if (strcmp(tmp,"PRIVATE") == 0)
                                uplrec.msg_attr |= UPL_PRIVATE;
                        }
                    }
                    else if (strncmp(str,"Lines",5) == 0)
                    {
                        quit = 1;
                        replies++;
                        sprintf((char *) uplrec.filename,"%05i.MSG",replies);
                        if ((F = FileOpen(strcat(strcpy(tmp,setup.replypath),(char *) uplrec.filename),"w+b")) != NULL)
                        {
                            num2 = atol(str+7);
                            for (num=1; num<=num2; num++)
                            {
                                _fgets(str,sizeof(str)-1,Fhr);
                                fprintf(F,"%s\r\n",str);
                            }
                            fclose(F);
                            fwrite(&uplrec,sizeof(uplrec),1,Fupl);
                        } else replies--;
                    }
                }
                quit = 0;
            }
            else if (strcmp(str+9,"Join") == 0)
            {
                arealist = 1;
                quit = 0;
                ch = 1;
                while (!quit)
                {
                    _fgets(str,sizeof(str)-1,Fhr);
                    if (strncmp(str,"Area",4) == 0)
                    {
                        area = getaname(str+6);
                        if (area > 0)
                        {
                            fseek(Fa,area-1,SEEK_SET);
                            fwrite(&ch,1,1,Fa);
                        }
                    } else if (strncmp(str,"Lines",5) == 0)
                    {
                        quit = 1;
                        num2 = atol(str+7);
                        for (num=1; num<=num2; num++)
                            _fgets(str,sizeof(str)-1,Fhr);
                    }
                }
                quit = 0;
            }
            else if (strcmp(str+9,"Resign") == 0)
            {
                arealist = 1;
                quit = 0;
                ch = 2;
                while (!quit) {
                    _fgets(str,sizeof(str)-1,Fhr);
                    if (strncmp(str,"Area",4) == 0)
                    {
                        area = getaname(str+6);
                        if (area > 0) {
                            fseek(Fa,area-1,SEEK_SET);
                            fwrite(&ch,1,1,Fa);
                        }
                    }
                    else if (strncmp(str,"Lines",5) == 0)
                    {
                        quit = 1;
                        num2 = atol(str+7);
                        for (num=1; num<=num2; num++)
                            _fgets(str,sizeof(str)-1,Fhr);
                    }
                }
                quit = 0;
            }
        }
    }
    fclose(Fhr);

    /* Remove .HR file */
    sprintf(tmp,"%s%s.hr",setup.replypath,pktname);
#ifdef __linux__
    search_ign_file(tmp);
#endif
    FileRemove(tmp);

    fseek(Fa,0,SEEK_END);
    if (ftell(Fa) == 0 || !arealist)
    {
        fclose(Fa);
        sprintf(tmp,"%sAREAS.DAT",setup.replypath);
        FileRemove(tmp);
    } else fclose(Fa);
}

void hippo_packet::check_areas(FILE *Fhr)
{
    long astart,aend,fsize;
    char *areabuf,tmp[256];
    int area;
    FILE *Fa;

    if ((Fa = fopen_ign(strcat(strcpy(tmp,setup.replypath),"AREAS.DAT"),"r+b")) == NULL) return;

    arealist = 1;
    if ((areabuf = (char *) malloc(1024)) == NULL) return;
    astart = -1;
    aend = -1;

    fseek(Fa,0,SEEK_END); fsize = ftell(Fa);
    for (area=1; area<=fsize; area++) {
        if ((astart > area) || (aend < area)) {
            fseek(Fa,area-1,SEEK_SET);
            astart = area;
            aend = area-1+fread(areabuf,1,1024,Fa);
        }
        switch (areabuf[area-astart]) {
            case 1:
                fprintf(Fhr,"Command: Join\r\n");
                fprintf(Fhr,"Area: %s\r\n",get_area_name(area));
                fprintf(Fhr,"Lines: 0\r\n");
                break;
            case 2:
                fprintf(Fhr,"Command: Resign\r\n");
                fprintf(Fhr,"Area: %s\r\n",get_area_name(area));
                fprintf(Fhr,"Lines: 0\r\n");
                break;
        }
    }
    fclose(Fa);
    free(areabuf);
}

void hippo_packet::close_replypacket(void)
{
    FILE *F,*Fhr;
    char tmp[256];
    long lines,n2;

    if (!fupl_opened) return;

    fupl_opened = 0;
    arealist = 0;
    if (replies == 0)
    {
        fclose(Fupl);
        /* Remove .UPL file */
        FileRemove(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".upl"));

        if ((Fhr = FileOpen(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".hr"),"w+b")) == NULL) return;
        check_areas(Fhr);
        fclose(Fhr);
        return;
    }

    if ((Fhr = FileOpen(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".hr"),"w+b")) == NULL)
    {
        /* Could not create .HR file!! */
        fclose(Fupl);
        /* Remove .UPL file */
        FileRemove(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".upl"));
        return;
    }

    /* Convert BW replies -> Hippo replies */
    fseek(Fupl,sizeof(uplheader),SEEK_SET);
    while (fread(&uplrec,sizeof(uplrec),1,Fupl))
    {
        if ((F = FileOpen(strcat(strcpy(tmp,setup.replypath),(char *) uplrec.filename),"rt")) != NULL)
        {
            lines = 0;
            while (_fgets(tmp,sizeof(tmp),F) != NULL) lines++;
            fseek(F,0,SEEK_SET);

            fprintf(Fhr,"Command: Post\r\n");
            fprintf(Fhr,"Area: %s\r\n",get_area_name(gettag((char *) uplrec.echotag)));
            if (uplrec.msg_attr & UPL_NETMAIL)
                fprintf(Fhr,"Destination: %u:%u/%u.%u\r\n",uplrec.destzone,uplrec.destnet,uplrec.destnode,uplrec.destpoint);
            if (uplrec.msg_attr & UPL_PRIVATE)
                fprintf(Fhr,"Status: Private\r\n");
            if (uplrec.replyto > 0)
                fprintf(Fhr,"Reply: %ld\r\n",uplrec.replyto);
            fprintf(Fhr,"Subject: %s\r\n",(char *) uplrec.subj);
            fprintf(Fhr,"To: %s\r\n",(char *) uplrec.to);
            fprintf(Fhr,"Lines: %lu\r\n",lines);

            for (n2=1; n2<=lines; n2++)
            {
                _fgets(tmp,sizeof(tmp),F);
                fprintf(Fhr,"%s\r\n",tmp);
            }
            fclose(F);
        }
        /* Remove BW reply */
        FileRemove(strcat(strcpy(tmp,setup.replypath),(char *) uplrec.filename));
    }
    check_areas(Fhr);

    fclose(Fhr);
    fclose(Fupl);

    /* Remove .UPL file */
    FileRemove(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".upl"));
}
