#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "pkt_obj.h"
#include "screen.h"
#include "files.h"
#include "keyb.h"
#include "shell.h"
#include "vars.h"
#include "general.h"
#include "readsets.h"

static char open_inited;

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != '\0')
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

char off_open_packet(offline_packet *pkt, char *str)
{
    char *oldscr;
    unsigned short ox, oy;
    char tmp[256],*anum,defalias[36];
    char *pstr;
    unsigned n1,n2,msgs;
    XTI_REC xti;

    if (fmt == format_omen) strcpy(pktname, omentag);
    read_setup(NULL); /* To get opt.alias work right.. */
    if (opt.alias[0] != '\0') strcpy(pkt->useralias, opt.alias);
    strcpy(defalias, pkt->useralias);

    pkt->txt_buf = NULL; pkt->mix_buf = NULL; pkt->xti_buf = NULL;
    open_inited = 1; pkt->lastareanum = 0;

    pkt->first_linerec = NULL;
    if (fmt != format_qwk) pkt->mixedcase = 1;
    pkt->dat_start = 1; pkt->dat_end = 0;
    pkt->lastarea[0] = '\0';
    if ((pkt->txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;
    if ((pkt->xti_buf = (XTI_REC *) malloc(sizeof(XTI_REC)*XTI_SIZE)) == NULL) return 2;
    pkt->mix_start = 1; pkt->mix_end = 0;
    if ((pkt->mix_buf = (MIX_REC *) malloc(sizeof(MIX_REC)*MAX_MIXES)) == NULL) return 2;
    fseek(pkt->Fmix,0,SEEK_END);
    pkt->total_mixes = ftell(pkt->Fmix)/sizeof(MIX_REC);

    replyopen = 0;
    pkt->replies = 0;
    pkt->fupl_opened = 0;
    pkt->arealist = 0;

    pkt->curarea = 0;
    if (setup.left_margin == 0) setup.left_margin = 1;
    if ((setup.right_margin > scrwidth-1) || (setup.right_margin == 0))
        pkt->txt_length = (char) ((scrwidth-1)-setup.left_margin+1);
    else
        pkt->txt_length = (char) (setup.right_margin-setup.left_margin+1);

    if (fmt != format_bw)
    {
        pkt->allow_crash = 0;
        pkt->allow_direct = 0;
        pkt->allow_immediate = 0;
        pkt->allow_hold = 0;
        pkt->allow_killsent = 0;
        pkt->allow_fattach = 0;
        pkt->allow_net_freq = 0;
        pkt->ansi_newfiles = 0;
        pkt->max_freqs = 0;
        pkt->allow_freq = 0;
    }

    if (packet.open)
    {
        /* Packet already open, save old .xti file */
        strcat(strcpy(pkt->xti_path,setup.packetpath),pkt->xtiname);
        strcat(strcpy(tmp,setup.workpath),pkt->xtiname);
        copyfile(pkt->xti_path,tmp);
    }
    else
    {
        if ((setup.packet_flags & PKT_SAVE_UNPACKED) && (fmt == format_hippo))
        {
            /* Keep packets unpacked */
            sprintf(pkt->xti_path,"%s%s.",setup.packetpath,pktname);
            adder(pkt->xti_path);

            sprintf(pktidx.oldname,"%s.xti",pktname);
            if ((pstr = strrchr(pkt->xti_path,SLASH)) == NULL) pstr = pkt->xti_path; else pstr++;
            strcpy(pktidx.idxname,pstr);
            pktidx.packet = (char) pkt->first;
            if (fwrite(&pktidx,sizeof(pktidx),1,Fpktidx) == 0) return 5;
        }
        else
        {
            sprintf(pkt->xti_path,"%sxti",str);
        }
    }

    /* Open .xti file */
    pkt->Fxti = fopen_ign(pkt->xti_path,"r+b");

    if (pkt->Fxti == NULL)
    {
        int slen;

        /* Not found, create it */
        pkt->Fxti = FileOpen(pkt->xti_path,"w+b");
        if (pkt->Fxti == NULL) return 4;

        save_scr(&ox, &oy, &oldscr);
        slen = strlen(lang[332]);
        draw_shaded_box(scrwidth/2-slen/2-2, scrsize/2-2, scrwidth/2+slen/2+2, scrsize/2+2, color[col_box_frame], color[col_box_title], NULL);
        cmiddle(scrsize/2, lang[332], color[col_box_hilight]);
        refresh();

        memset(&xti,0,sizeof(xti));
        for (n1=1; n1<=pkt->areas; n1++)
        {
            /* Open area */
            anum = pkt->get_area_number(pkt, n1);
            read_setup(pkt->get_area_tag(pkt, n1)); /* To get alias from area override */
            if (opt.alias[0] != '\0')
                strcpy(pkt->useralias, opt.alias);
            else
                strcpy(pkt->useralias, defalias);

            read_table(1,inbound,opt.intable);

            msgs = pkt->get_msgs(pkt, anum);
            if (msgs > 0 && pkt->open_area(pkt, anum))
            {
                /* Get number of messages */
                for (n2=1; n2<=msgs; n2++)
                {
                    /* Read message */
                    pkt->read_msg(pkt, n2); tran(msg.mto);
                    if (stricmp(pkt->username,msg.mto) == 0 || stricmp(pkt->useralias,msg.mto) == 0)
                    {
                        /* Message is personal */
                        xti.flags = XTI_IS_PERSONAL;
                    }
                    else
                    {
                        xti.flags = 0;
                    }

                    if (fwrite(&xti,sizeof(xti),1,pkt->Fxti) == 0) return 5;
                }
            }
        }
        old_scr(ox, oy, &oldscr);

        /* Reopen .xti file to make sure it is saved to disk */
        fclose(pkt->Fxti);
        pkt->Fxti = FileOpen(pkt->xti_path,"r+b");
    }

    /* No .xti file buffering */
    //setbuf(pkt->Fxti,NULL);

    pkt->xti_start = 65535;
    pkt->xti_end = 0;

    pkt->references = NULL;
    pkt->message_id = NULL;
    pkt->newsgroups = NULL;
    if ((setup.packet_flags & PKT_SAVE_UNPACKED) && (fmt == format_hippo) && (!packet.open))
        fclose(Fpktidx);
    return 0;
}

void off_close_packet(offline_packet *pkt)
{
    if (!open_inited) return;

    if (pkt->references != NULL) free(pkt->references);
    if (pkt->message_id != NULL) free(pkt->message_id);
    if (pkt->newsgroups != NULL) free(pkt->newsgroups);

    free(pkt->mix_buf);
    free(pkt->txt_buf);
    free(pkt->xti_buf);
    fclose(pkt->Fxti);
    open_inited = 0;
}

char off_save_info(offline_packet *pkt, char *path)
{
    return 0;
}

/* Read record from .inf file */
void off_read_inf_area(offline_packet *pkt, unsigned area)
{
    if (pkt->area_start > area || pkt->area_end < area)
    {
        fseek(pkt->Finfo,pkt->inf_header_slen+(area-1)*pkt->inf_area_slen,SEEK_SET);
        pkt->area_start = area;
        pkt->area_end = pkt->area_start+fread(pkt->area_buf,pkt->inf_area_slen,pkt->abufsize,pkt->Finfo)-1;
    }
}

/* Read record from .mix file */
void off_read_mix(offline_packet *pkt, unsigned area)
{
    long lnum;
    size_t readed;

    if (area > pkt->total_mixes) return;

    if (pkt->mix_end < area || pkt->mix_start > area)
    {
        lnum = (long) area - (MAX_MIXES / 2);
        if (lnum < 1) lnum = 1;
        pkt->mix_start = pkt->mix_end = lnum = area;
        fseek(pkt->Fmix,(lnum-1)*sizeof(MIX_REC),SEEK_SET);
        readed = fread(pkt->mix_buf,sizeof(MIX_REC),MAX_MIXES,pkt->Fmix);
        if (readed)
        {
            pkt->mix_start = lnum;
            pkt->mix_end = pkt->mix_start-1+readed;
        }
    }
}

/* Write record to .mix file */
void off_write_mix(offline_packet *pkt, unsigned area, MIX_REC *mix)
{
    if (area > pkt->total_mixes) return;

    fseek(pkt->Fmix, (area-1)*sizeof(MIX_REC), SEEK_SET);
    fwrite(mix, sizeof(MIX_REC), 1, pkt->Fmix);

    /*if (pkt->mix_end >= area && pkt->mix_start <= area)
        pkt->mix_start = area+1;
        memcpy(&pkt->mix_buf[area-pkt->mix_start], mix, sizeof(MIX_REC));*/
    pkt->mix_start = 65535; pkt->mix_end = 0;
}

/* Delete .mix record */
void off_delete_mix(offline_packet *pkt, unsigned area)
{
    unsigned long fsize;

    if (area > pkt->total_mixes) return;

    fseek(pkt->Fmix, 0, SEEK_END); fsize = ftell(pkt->Fmix);
    delete_space(pkt->Fmix, (area-1)*sizeof(MIX_REC), sizeof(MIX_REC), fsize);
    ftrunc(pkt->Fmix, fsize-sizeof(MIX_REC));

    pkt->mix_start = 65535; pkt->mix_end = 0; pkt->curarea = 0; pkt->lastarea[0] = '\0';
}

char off_area_selected(offline_packet *pkt, unsigned area)
{
    pkt->read_inf_area(pkt, area);
    if ((pkt->area_buf[area-pkt->area_start].area_flags & INF_SCANNING) == 0) return 0;
    if (pkt->area_buf[area-pkt->area_start].area_flags & INF_TO_ALL) return 3;
    if (pkt->area_buf[area-pkt->area_start].area_flags & INF_PERSONAL) return 2;
    return 1;
}

/* Get area name */
char *off_get_area_name(offline_packet *pkt, unsigned area)
{
    pkt->read_inf_area(pkt, area);
    return (char *) pkt->area_buf[area-pkt->area_start].title;
}

/* Get area number */
char *off_get_area_number(offline_packet *pkt, unsigned area)
{
    pkt->read_inf_area(pkt, area);
    return (char *) pkt->area_buf[area-pkt->area_start].areanum;
}

/* Get area tag */
char *off_get_area_tag(offline_packet *pkt, unsigned area)
{
    pkt->read_inf_area(pkt, area);
    return (char *) pkt->area_buf[area-pkt->area_start].echotag;
}

/* Get "real" area number */
unsigned off_getarea(offline_packet *pkt, char *areanum)
{
    unsigned arean, first, last;

    if (strcmp(pkt->lastarea,areanum) == 0 && pkt->mix_start < pkt->mix_end) return pkt->lastareanum;

    strcpy(pkt->lastarea,areanum);
    first = pkt->lastareanum == 0 || pkt->lastareanum > pkt->total_mixes ? 1 : pkt->lastareanum+1;
    last = pkt->total_mixes;
    for (arean=first; arean<=last || first != 1; arean++)
    {
        if (arean > pkt->total_mixes)
        {
            first = 1;
            arean = 1;
            last = pkt->lastareanum;
        }
        pkt->read_mix(pkt, arean);
        if (arean > pkt->mix_end) break;

        if (strcmp((char *) pkt->mix_buf[arean-pkt->mix_start].areanum,areanum) == 0)
        {
            pkt->lastareanum = arean;
            return arean;
        }
    }
    pkt->lastareanum = 0;
    return 0;
}

/* Search area with name */
unsigned off_getaname(offline_packet *pkt, char *area)
{
    unsigned arean;

    for (arean=1; arean<=pkt->areas; arean++)
    {
        pkt->read_inf_area(pkt, arean);
        if (strcmp((char *) pkt->area_buf[arean-pkt->area_start].title,area) == 0) return arean;
    }
    return 0;
}

/* Search area with tag */
unsigned off_gettag(offline_packet *pkt, char *tag)
{
    unsigned area;

    for (area=1; area<=pkt->areas; area++)
    {
        pkt->read_inf_area(pkt, area);
        if (strcmp((char *) pkt->area_buf[area-pkt->area_start].echotag,tag) == 0) return area;
    }
    return 0;
}

/* Get number of messages in area */
unsigned off_get_msgs(offline_packet *pkt, char *areanum)
{
    unsigned area;

    area = pkt->getarea(pkt, areanum);
    if (area == 0) return 0;

    return pkt->mix_buf[area-pkt->mix_start].totmsgs;
}

/* Get number of personal messages in area */
unsigned off_get_personal_msgs(offline_packet *pkt, char *areanum)
{
    unsigned area;

    area = pkt->getarea(pkt, areanum);
    if (area == 0) return 0;

    return pkt->mix_buf[area-pkt->mix_start].numpers;
}

/* Get number of unread messages in area */
unsigned off_get_unread_msgs(offline_packet *pkt, char *areanum)
{
    size_t readed;
    unsigned unread,max,num;

    pkt->open_area(pkt, areanum);

    num = pkt->msgptr+1;
    max = pkt->get_msgs(pkt, areanum)+num;
    unread = 0;
    while (num < max)
    {
        if ((pkt->xti_start > num) || (pkt->xti_end < num))
        {
            /* Read .xti file */
            fseek(pkt->Fxti,(num-1)*sizeof(XTI_REC),SEEK_SET);
            readed = fread(pkt->xti_buf,sizeof(XTI_REC),XTI_SIZE,pkt->Fxti);
            pkt->xti_start = num;
            pkt->xti_end = pkt->xti_start+readed-1;
            if (readed == 0) break;
        }

        if ((pkt->xti_buf[num-pkt->xti_start].flags & XTI_HAS_READ) == 0) unread++;
        num++;
    }

    return unread;
}

char off_open_area(offline_packet *pkt, char *area)
{
    unsigned num;

    num = pkt->getarea(pkt, area);
    if (pkt->curarea == num) return 1;

    pkt->idxstart = 65535;
    pkt->idxend = 0;

    if (num > 0)
    {
        pkt->curarea = num;
        pkt->msgptr = pkt->mix_buf[num-pkt->mix_start].msghptr;
        if (fmt == format_bw) pkt->msgptr /= sizeof(FTI_REC);
        return 1;
    }
    return 0;
}

char off_read_msg(offline_packet *pkt, unsigned msgnum)
{
    if (opt.rflags & STRIP_RE)
    {
        /* Remove 'RE:' */
        if (strnicmp(msg.subj,"RE:",3) == 0)
        {
            if (msg.subj[3] == ' ')
            {
                memmove(msg.subj,msg.subj+4,strlen(msg.subj)-3);
            }
            else
            {
                memmove(msg.subj,msg.subj+3,strlen(msg.subj)-2);
            }
        }
    }

    pkt->msgid_kludge[0] = '\0';
    return 1;
}

void off_write_msg(offline_packet *pkt, unsigned n)
{
}

void off_delete_msg(offline_packet *pkt, unsigned n)
{
}

long off_read_num(offline_packet *pkt, unsigned msgnum)
{
    return 0;
}

char *off_read_from(offline_packet *pkt, unsigned msgnum)
{
    return 0;
}

char *off_read_to(offline_packet *pkt, unsigned msgnum)
{
    return 0;
}

char *off_read_subj(offline_packet *pkt, unsigned msgnum)
{
    if (opt.rflags & STRIP_RE)
    {
        /* Remove 'RE:' */
        if (strnicmp(msg.subj,"RE:",3) == 0)
        {
            if (msg.subj[3] == ' ')
            {
                memmove(msg.subj,msg.subj+4,strlen(msg.subj)-3);
            }
            else
            {
                memmove(msg.subj,msg.subj+3,strlen(msg.subj)-2);
            }
        }
    }

    return msg.subj;
}

static int soup_firstlen;
int reply_email;
char reply_email_addr[100];

char *get_email_addr(char *orig, char *dest)
{
    char *strp;
    int n;

    strp = strchr(orig, '<');
    if (strp != NULL)
    {
        /* user name <email@addr> */
        orig = strp+1;
        strcpy(dest, orig);
        strp = strchr(dest, '>');
        if (strp != NULL) *strp = '\0';
        return dest;
    }

    strp = strchr(orig, '(');
    if (strp == NULL)
    {
        strcpy(dest, orig);
        return dest;
    }
    while (*(strp-1) == ' ') strp--;
    n = (int) (strp-orig);
    strncpy(dest, orig, n); dest[n] = '\0';

    return dest;
}

char off_init_text(offline_packet *pkt)
{
    unsigned long last_line,totalread;
    size_t readed;

    unsigned pos,ptr_pos,num;

    char buf[256],tmp[11],*strp,mtype, *save_line, *saveto, **savein;
    int spos,origin,seenby,reformat,no_quote,start,soup_first,soup_header;
    unsigned chars,tens;

    LINE_REC *linep;

    /* If old reply is still in memory, delete it */
    if (pkt->first_linerec != NULL) pkt->deinit_msgtext(pkt);

    pkt->txt_lines = 0; last_line = 0; tens = 0; chars = 0; spos = 0; seenby = 0;
    pkt->chrs_kludge[0] = '\0'; pkt->fmpt = '\0'; pkt->intl_kludge[0] = '\0'; pkt->origin_line[0] = '\0';

    /* Init first line */
    pkt->linerec = (LINE_REC *) malloc(sizeof(LINE_REC));
    pkt->linerec->prev = NULL;
    pkt->linerec->next = NULL;
    pkt->linerec->line_type = fmt == format_soup ? LINE_TYPE_KLUDGE : LINE_TYPE_NORMAL;
    pkt->linerec->ptr = pkt->msgtxtptr;
    if (fmt == format_bw) pkt->linerec->ptr++;
    pkt->linerec->len = 0;

    if (pkt->references != NULL) { free(pkt->references); pkt->references = NULL; }
    if (pkt->message_id != NULL) { free(pkt->message_id); pkt->message_id = NULL; }
    if (pkt->newsgroups != NULL) { free(pkt->newsgroups); pkt->newsgroups = NULL; }

    pkt->first_linerec = pkt->linerec;

    if (fmt == format_soup)
    {
        mtype = *(pkt->get_area_tag(pkt, pkt->curarea)+20);
        soup_first = mtype == 'u' || mtype == 'm';
        soup_header = 1;
    }
    else
    {
        mtype = 0; soup_first = 0;
        soup_header = 0;
    }

    save_line = (char *) malloc(10000); saveto = NULL; savein = NULL;

    totalread = 0; readed = 0; soup_firstlen = 0; reply_email = 0;
    start = 1; origin = 0; seenby = 0; reformat = (setup.justify != JUSTIFY_NONE) && !soup_header; no_quote = 0;
    while (totalread+readed+1 < pkt->msgtxtsize)
    {
        totalread += readed;

        /* How much to read? */
        if (pkt->msgtxtsize+(fmt == format_soup ? 80:0)-totalread < BUF_SIZE)
            readed = pkt->msgtxtsize+(fmt == format_soup ? 80:0)-totalread;
        else
            readed = BUF_SIZE;

        if ((pkt->dat_start > pkt->msgtxtptr+totalread) || (pkt->dat_end < pkt->msgtxtptr+readed-1+totalread))
        {
            /* Read text from file */
            fseek(pkt->Fdat,pkt->msgtxtptr+totalread,SEEK_SET);
            pkt->dat_start = ftell(pkt->Fdat);
            readed = fread(pkt->txt_buf,1,readed,pkt->Fdat);
            pkt->dat_end = pkt->dat_start+readed-1;
        }
        else
        {
            /* Text already in memory */
            readed = pkt->dat_end-pkt->msgtxtptr+1-totalread;
        }

        if (fmt != format_soup && readed >= pkt->msgtxtsize-totalread) readed = pkt->msgtxtsize-totalread;

        if (totalread == 0 && fmt == format_bw)
        {
            /* Strip first ' ' character from Blue Wave messages */
            if (pkt->txt_buf[pkt->msgtxtptr-pkt->dat_start] != ' ') return 0;
            pos = pkt->msgtxtptr-pkt->dat_start+1;
            ptr_pos = 0;
        }
        else
        {
            pos = pkt->msgtxtptr+totalread-pkt->dat_start;
            ptr_pos = (unsigned) -1;
        }

        for (; pos<readed+(pkt->msgtxtptr+totalread-pkt->dat_start); pos++)
        {
            if (fmt == format_soup && pos >= pkt->msgtxtsize-totalread+soup_firstlen) break;

            ptr_pos++;
            switch (pkt->txt_buf[pos])
            {
                case 10:
                    if (fmt == format_soup)
                    {
                        if (soup_first)
                        {
                            /* Skip first line */
                            soup_firstlen = chars+tens+1;
                            pkt->linerec->ptr = pkt->msgtxtptr+totalread+ptr_pos+1;
                            chars = 0; tens = 0; spos = 0; start = 1; soup_first = 0;
                            break;
                        }
                        goto __cr;
                    }
                __lf:
                    /* Do nothing to LFs */
                    tens++;
                    break;
                case 227:
                    /* "CR" with QWK format */
                    if (fmt != format_qwk) goto __write_chr;
                case 13:
                    if (fmt == format_soup) goto __lf;
                __cr:
                    /* CR found */
                    if (saveto != NULL)
                    {
                        *saveto = '\0';
                        saveto = NULL;
                        *savein = (char *) malloc(strlen(save_line)+1);
                        strcpy(*savein, save_line);
                    }

                    /* Check kludges and spaces and CR */
                    if (reformat && spos > 0)
                    {
                        /* Copy next 10 characters to 'tmp' */
                        if (pos+13 < BUF_SIZE)
                        {
                            /* They're in memory, great. */
                            if (pkt->txt_buf[pos+1] == 10)
                                memcpy(tmp,pkt->txt_buf+pos+2,10);
                            else
                                memcpy(tmp,pkt->txt_buf+pos+1,10);
                            tmp[10] = '\0';
                        }
                        else
                        {
                            /* Gotta read them from file. */
                            fseek(pkt->Fdat,pkt->msgtxtptr+totalread+pos+1,SEEK_SET);
                            if (fread(tmp,1,1,pkt->Fdat) == 0)
                            {
                                tmp[0] = '\0';
                            }
                            else
                            {
                                if (tmp[0] == 10)
                                    tmp[fread(tmp,1,11,pkt->Fdat)] = '\0';
                                else
                                    tmp[fread(tmp+1,1,10,pkt->Fdat)+1] = '\0';
                            }
                            num = totalread+pos+1;
                            if (num >= pkt->msgtxtsize)
                            {
                                /* It's next message text in here already.. */
                                tmp[0] = '\0';
                            }
                            else if (num+10 > pkt->msgtxtsize)
                            {
                                tmp[pkt->msgtxtsize-num] = '\0';
                            }
                        }

                        if (tmp[0] != 1 && tmp[0] != ' ' && (tmp[0] != 13 || (fmt == format_soup && tmp[0] != 10)) && ((unsigned char) tmp[0] != 227 || fmt != format_qwk))
                        {
                            /* Check quoting */
                            for (num=0; num<QUOTE_MAX && tmp[num] != '\0'; num++)
                            {
                                if ((tmp[num] == '"') || (tmp[num] == '\'') || (tmp[num] == '<')) break;
                                if (tmp[num] == '>' || (num == 0 && tmp[num] == ':' && tmp[num+1] != ')' && tmp[num+1] != '(' && tmp[num+1] != '-'))
                                {
                                    num = 0;
                                    break;
                                }
                            }

                            if (num)
                            {
                                /* Origin, tagline, etc. */
                                if ((strncmp(tmp," * Origin:",10)) && (strncmp(tmp,"--- ",4)) && (strncmp(tmp,"... ",4)) && (strncmp(tmp,"~~~",3)) && (strncmp(tmp,"\xff@SUBJECT:",10)))
                                {
                                    if ((!origin) || (strncmp(tmp,"SEEN-BY:",8)))
                                    {
                                        buf[spos] = ' ';
                                        chars++; spos++;
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    if (chars == 0) soup_header = 0; /* Empty line terminates SOUP header */
                    reformat = (setup.justify != JUSTIFY_NONE) && !soup_header;
                    no_quote = 0;

                    /* Remove trailing spaces */
                    while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;
                    buf[spos] = '\0';

                    if (spos == 3 && start && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
                    {
                        /* Update line type */
                        pkt->linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }

                    if (pkt->linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                    {
                        /* Not a kludge, or displaying kludges is set on, */
                        /* so add line to linked list */

                        if (chars > 0) last_line = pkt->txt_lines;
                        pkt->txt_lines++;

                        /* Allocate memory for new line */
                        linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                        /* Set last line length and pointer to next line */
                        pkt->linerec->len = (char) (chars+tens);
                        pkt->linerec->next = linep;

                        if (linep == NULL) goto __end; /* Out of memory! */

                        linep->prev = pkt->linerec;
                        linep->next = NULL;
                        linep->len = 0;
                        pkt->linerec = linep;
                    }

                    if (origin && start && strncmp(buf," * Origin:",10) == 0)
                    {
                        /* This was origin line, save it for later use */
                        strcpy(pkt->origin_line, buf);
                    }

                    if (fmt == format_qwk && start && strncmp(buf, "\xff@SUBJECT:",10) == 0)
                    {
                        strncpy(msg.subj, buf+10, 60); msg.subj[60] = '\0';
                        spos = strlen(msg.subj);
                        while (msg.subj[spos-1] == ' ') spos--;
                        msg.subj[spos] = '\0';
                    }

                    if (start && strncmp(buf, "\x01REPLYADDR", 10) == 0)
                    {
                        reply_email = 1;
                        strcpy(reply_email_addr, buf+11);
                    }

                    if (!reply_email && start && (strncmp(buf, "From:", 5) == 0 && strchr(buf+5, '@') != NULL))
                    {
                        reply_email = 1;
                        get_email_addr(buf+6, reply_email_addr);
                    }

                    if (buf[0] == 1 && start)
                    {
                        /* Kludge */
                        if (strncmp(buf+1,"MSGID:",6) == 0)
                            strcpy(pkt->msgid_kludge,buf+8);
                        else if (strncmp(buf+1,"CHRS:",5) == 0)
                            strcpy(pkt->chrs_kludge,buf+7);
                        else if (strncmp(buf+1,"CHARSET:",8) == 0)
                            strcpy(pkt->chrs_kludge,buf+10);
                        else if (strncmp(buf+1,"INTL",4) == 0)
                            strcpy(pkt->intl_kludge,buf+6);
                        else if (strncmp(buf+1,"FMPT",4) == 0)
                            pkt->fmpt = atol(buf+6);
                    }

                    pkt->linerec->line_type = soup_header ? LINE_TYPE_KLUDGE : LINE_TYPE_NORMAL;
                    pkt->linerec->ptr = pkt->msgtxtptr+totalread+ptr_pos+1;
                    chars = 0; tens = 0; spos = 0; seenby = 0; start = 1;
                    break;
                case 141:
                    if ((opt.rflags & TREAT_I_NORMAL) == 0)
                    {
                        /* Soft-CR */
                        tens++;
                        break;
                    }
                default:
                __write_chr:
                    if (saveto != NULL) *saveto++ = pkt->txt_buf[pos];

                    /* Normal character */
                    if ((chars >= pkt->txt_length && reformat) || chars+1 >= scrwidth)
                    {
                        /* Too long line, split it */
                        if (pkt->txt_buf[pos] == ' ')
                        {
                            /* Great, we can split it right here! */
                            spos = 0;

                            if (pkt->linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                            {
                                /* Remove trailing spaces */
                                while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;

                                if (chars > 0) last_line = pkt->txt_lines;
                                pkt->txt_lines++;

                                /* Allocate memory for new line */
                                linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                                /* Set last line length and pointer to next line */
                                pkt->linerec->len = (char) (chars+tens);
                                pkt->linerec->next = linep;

                                if (linep == NULL) goto __end; /* Out of memory! */

                                linep->prev = pkt->linerec;
                                linep->next = NULL;
                                linep->line_type = pkt->linerec->line_type == LINE_TYPE_SPECIAL ? LINE_TYPE_NORMAL : pkt->linerec->line_type;
                                linep->len = 0;
                                pkt->linerec = linep;
                            }

                            pkt->linerec->ptr = pkt->msgtxtptr+totalread+ptr_pos+1;
                            chars = 0; tens = 0; start = 0;
                            continue;
                        }

                        /* Search split position */
                        num = spos-1;
                        while (num > 0 && buf[num] != ' ') num--;

                        if (num > 0)
                        {
                            /* Found split character */
                            chars = num;

                            if (pkt->linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                            {
                                /* Remove trailing spaces */
                                while (chars > 0 && buf[chars-1] == ' ') chars--;

                                if (chars > 0) last_line = pkt->txt_lines;
                                pkt->txt_lines++;

                                /* Allocate memory for new line */
                                linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                                /* Set last line length and pointer to next line */
                                pkt->linerec->next = linep;
                                pkt->linerec->len = (char) (chars+tens);

                                if (linep == NULL) goto __end; /* Out of memory! */

                                linep->prev = pkt->linerec;
                                linep->next = NULL;
                                linep->line_type = pkt->linerec->line_type == LINE_TYPE_SPECIAL ? LINE_TYPE_NORMAL : pkt->linerec->line_type;
                                linep->len = 0;
                                pkt->linerec = linep;
                            }

                            pkt->linerec->ptr = pkt->msgtxtptr+totalread+ptr_pos+2-(spos-num+1);
                            chars = 0; tens = 0; start = 0;

                            memmove(buf,buf+num+1,spos-num); spos -= num+1;
                            chars = spos;
                        }
                        else
                        {
                            /* Couldn't find split pos so just split somewhere */
                            spos = 0;

                            if (pkt->linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                            {
                                /* Remove trailing spaces */
                                while (chars > 0 && buf[chars-1] == ' ') chars--;

                                if (chars>0) last_line = pkt->txt_lines;
                                pkt->txt_lines++;

                                /* Allocate memory for new line */
                                linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                                /* Set last line length and pointer to next line */
                                pkt->linerec->next = linep;
                                pkt->linerec->len = (char) (chars+tens);

                                if (linep == NULL) goto __end; /* Out of memory! */

                                linep->prev = pkt->linerec;
                                linep->next = NULL;
                                linep->line_type = pkt->linerec->line_type == LINE_TYPE_SPECIAL ? LINE_TYPE_NORMAL : pkt->linerec->line_type;
                                linep->len = 0;
                                pkt->linerec = linep;
                            }

                            pkt->linerec->ptr = pkt->msgtxtptr+totalread+ptr_pos;
                            chars = 0; tens = 0; start = 0;
                        }
                    }

                    /* Add to buffer */
                    buf[spos++] = pkt->txt_buf[pos];
                    chars++;

                    /* Check if line should be saved */
                    if (fmt == format_soup && spos == 12 && start && soup_header && saveto == NULL)
                    {
                        if (strncmp(buf,"Newsgroups: ", 12) == 0)
                        {
                            savein = &pkt->newsgroups; saveto = save_line;
                        }
                        else if (strncmp(buf,"Message-ID: ", 12) == 0)
                        {
                            savein = &pkt->message_id; saveto = save_line;
                        }
                        else if (strncmp(buf,"References: ", 12) == 0)
                        {
                            savein = &pkt->references; saveto = save_line;
                        }
                    }

                    if (pkt->linerec->line_type != LINE_TYPE_NORMAL && pkt->linerec->line_type != LINE_TYPE_SPECIAL) break;

                    if (spos == 8 && start)
                    {
                        /* Check if this is a SEEN-BY line */
                        if (origin)
                        {
                            seenby = strncmp(buf,"SEEN-BY:",8) == 0;
                            if (seenby) pkt->linerec->line_type = LINE_TYPE_KLUDGE;
                            reformat = 0;
                        }
                    }

                    /* Check QWK long subject */
                    if (spos == 10 && start && fmt == format_qwk && strncmp(buf,"\xff@SUBJECT:", 10) == 0)
                    {
                        pkt->linerec->line_type = LINE_TYPE_KLUDGE;
                        reformat = 0;
                    }

                    /* Check origin */
                    if (spos == 10 && start && strncmp(buf," * Origin:",10) == 0)
                    {
                        pkt->linerec->line_type = LINE_TYPE_ORIGIN;
                        origin = 1;
                        reformat = 0;
                    }

                    if (spos == 1 && start && (pkt->txt_buf[pos] == 1 || pkt->txt_buf[pos] == ' '))
                    {
                        /* Line starts with space or is a kludge, don't
                         reformat this line */
                        reformat = 0;
                        if (pkt->txt_buf[pos] == 1) pkt->linerec->line_type = LINE_TYPE_KLUDGE;
                    }
                    if (spos == 4 && start && (strncmp(buf,"--- ",4) == 0 || strncmp(buf,"... ",4) == 0 || strncmp(buf,"~~~ ",4) == 0))
                    {
                        /* Tear or tag, don't reformat this line */
                        reformat = 0;
                        pkt->linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }
                    if (pkt->txt_buf[pos] == '_' || pkt->txt_buf[pos] == '*')
                    {
                        pkt->linerec->line_type = LINE_TYPE_SPECIAL;
                    }
                    if (spos < QUOTE_MAX && !no_quote && start)
                    {
                        if (pkt->txt_buf[pos] == '"' || pkt->txt_buf[pos] == '\'' || pkt->txt_buf[pos] == '<') no_quote = 1;
                        if (pkt->txt_buf[pos] == '>' || (spos == 1 && pkt->txt_buf[pos] == ':' && pkt->txt_buf[pos+1] != ')' && pkt->txt_buf[pos+1] != '(' && pkt->txt_buf[pos+1] != '-'))
                        {
                            /* Quoted line, don't reformat */
                            reformat = 0;
                            pkt->linerec->line_type = LINE_TYPE_QUOTE;
                        }
                    }
                    break;
            }
        }
    }
    free(save_line);

    /* Remove trailing spaces */
    while (chars > 0 && buf[chars-1] == ' ') chars--;

    if ((buf[0] != 1 && !seenby) || show_kludges || !start)
    {
        /* OK to display this line. */
        if (chars > 0) last_line = pkt->txt_lines;
        pkt->linerec->len = (char) (chars+tens);
        pkt->txt_lines++;
    }

    if (spos == 3 && start && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
    {
        /* Update line type */
        pkt->linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
    }

    if (buf[0] == 1 && start)
    {
        /* Kludge, save it */
        buf[spos] = '\0';
        if (strncmp(buf+1,"MSGID:",6) == 0)
            strcpy(pkt->msgid_kludge,buf+8);
        else if (strncmp(buf+1,"CHRS:",5) == 0)
            strcpy(pkt->chrs_kludge,buf+7);
        else if (strncmp(buf+1,"CHARSET:",8) == 0)
            strcpy(pkt->chrs_kludge,buf+10);
        else if (strncmp(buf+1,"INTL",4) == 0)
            strcpy(pkt->intl_kludge,buf+6);
        else if (strncmp(buf+1,"FMPT",4) == 0)
            pkt->fmpt = atol(buf+6);
    }

    /* Cut CHARSET-kludge from first space */
    strp = strchr(pkt->chrs_kludge,' ');
    if (strp != NULL) *strp = '\0';
__end:
    pkt->txt_lines = last_line+1;

    pkt->linerec = pkt->first_linerec;
    pkt->current_line = 1;
    return 1;
}

void off_deinit_msgtext(offline_packet *pkt)
{
    while (pkt->first_linerec != NULL)
    {
        pkt->linerec = pkt->first_linerec->next;
        free(pkt->first_linerec);
        pkt->first_linerec = pkt->linerec;
    }
}

char *off_read_line(offline_packet *pkt, char *str, unsigned line)
{
    int nro,slen;
    long maxsize;

    /* Go to right position */
    while (line < pkt->current_line)
    {
        if (pkt->linerec->prev == NULL)
        {
            str[0] = '\0';
            return str;
        }
        pkt->linerec = pkt->linerec->prev;
        pkt->current_line--;
    }

    while (line > pkt->current_line)
    {
        if (pkt->linerec->next == NULL)
        {
            str[0] = '\0';
            return str;
        }
        pkt->linerec = pkt->linerec->next;
        pkt->current_line++;
    }

    if (str == NULL) return NULL;

    /* Read from file */
    if ((pkt->dat_start > pkt->linerec->ptr) || (pkt->dat_end < pkt->linerec->ptr+pkt->linerec->len))
    {
        fseek(pkt->Fdat,pkt->linerec->ptr,SEEK_SET);
        pkt->dat_start = pkt->linerec->ptr;
        if (BUF_SIZE > pkt->msgtxtsize+soup_firstlen)
            maxsize = pkt->msgtxtsize+soup_firstlen;
        else
            maxsize = BUF_SIZE;
        pkt->dat_end = pkt->dat_start+fread(pkt->txt_buf,1,maxsize,pkt->Fdat)-1;
    }
    memcpy(str,pkt->txt_buf+pkt->linerec->ptr-pkt->dat_start,pkt->linerec->len);
    str[pkt->linerec->len] = '\0';

    nro = 0;
    slen = pkt->linerec->len;

    /* Remove LFs, change CRs to spaces */
    while (nro < slen)
    {
        switch ((unsigned char) str[nro])
        {
            case 227:
                if (fmt != format_qwk) break;
            case 13:
            __cr:
                str[nro] = ' ';
                break;
            case 141:
                if (opt.rflags & TREAT_I_NORMAL) break;
            case 10:
                if (fmt == format_soup) goto __cr;
                memmove(str+nro,str+nro+1,slen-nro-1);
                slen--;
                nro--;
                break;
        }
        nro++;
    }

    /* Remove trailing spaces */
    while (slen > 0 && str[slen-1] == ' ') slen--;
    str[slen] = '\0';

    /* Rot13 convertion */
    if (rot13)
    {
        nro = 1;
        if (str[0] == 1)
            nro = 0;
        else if ((slen > 4) && (strncmp(str,"--- ",4) == 0))
            nro = 0;
        else if ((slen >= 10) && (strncmp(str," * Origin:",10) == 0))
            nro = 0;

        if (nro)
        {
            nro = 0;
            while (nro < slen)
            {
                if ((str[nro] >= 'A') && (str[nro] <= 'Z'))
                {
                    if (str[nro] >= 'A'+13) str[nro] -= 13; else str[nro] += 13;
                }
                else
                {
                    if ((str[nro] >= 'a') && (str[nro] <= 'z'))
                    {
                        if (str[nro] >= 'a'+13) str[nro] -= 13; else str[nro] += 13;
                    }
                }
                nro++;
            }
        }
    }

    return str;
}

void off_area_flags(offline_packet *pkt, unsigned num, XTI_REC *xti)
{
    size_t readed;

    if ((pkt->xti_start>pkt->msgptr+num) || (pkt->xti_end<pkt->msgptr+num))
    {
        fseek(pkt->Fxti,(pkt->msgptr+num-1)*sizeof(XTI_REC),SEEK_SET);
        readed = fread(pkt->xti_buf,sizeof(XTI_REC),XTI_SIZE,pkt->Fxti);
        pkt->xti_start = pkt->msgptr+num;
        pkt->xti_end = pkt->xti_start+readed-1;
        if (readed == 0)
        {
            memset(xti,0,sizeof(XTI_REC));
            return;
        }
    }
    memcpy(xti,&pkt->xti_buf[pkt->msgptr+num-pkt->xti_start],sizeof(XTI_REC));
}

extern int packet_modified;

void off_save_area_flags(offline_packet *pkt, unsigned num, XTI_REC *xti)
{
    if (!((pkt->xti_start>pkt->msgptr+num) || (pkt->xti_end<pkt->msgptr+num)))
      memcpy(&pkt->xti_buf[pkt->msgptr+num-pkt->xti_start],xti,sizeof(XTI_REC));

    fseek(pkt->Fxti,(pkt->msgptr+num-1)*sizeof(XTI_REC),SEEK_SET);
    fwrite(xti,sizeof(XTI_REC),1,pkt->Fxti);

    packet_modified = 1;
}

void off_update_area_flags(offline_packet *pkt)
{
    fclose(pkt->Fxti);
    pkt->Fxti = FileOpen(pkt->xti_path,"r+b");
    //setbuf(pkt->Fxti,NULL);
}

void off_delete_xti(offline_packet *pkt, unsigned num)
{
    unsigned long fsize;

    fseek(pkt->Fxti, 0, SEEK_END); fsize = ftell(pkt->Fxti);
    delete_space(pkt->Fxti, (pkt->msgptr+num-1)*sizeof(XTI_REC), sizeof(XTI_REC), fsize);
    ftrunc(pkt->Fxti, fsize-sizeof(XTI_REC));

    pkt->xti_start = 65535; pkt->xti_end = 0;
}

void off_open_replypacket(offline_packet *pkt)
{
}

void off_close_replypacket(offline_packet *pkt)
{
}

char off_read_reply(offline_packet *pkt, unsigned num)
{
    struct tm *tim;

    fseek(pkt->Fupl,sizeof(UPL_HEADER)+(num-1)*sizeof(UPL_REC),SEEK_SET);
    fread(&uplrec,sizeof(UPL_REC),1,pkt->Fupl);

    strcpy(reply.mfrom,(char *) uplrec.from);
    if (uplrec.network_type == INF_NET_INTERNET)
        strcpy(reply.mto,(char *) uplrec.net_dest);
    else
        strcpy(reply.mto,(char *) uplrec.to);
    strcpy(reply.subj,(char *) uplrec.subj);
    if (uplrec.unix_date == 0)
    {
        strcpy(reply.date,"<unknown>");
    }
    else
    {
        tim = localtime((time_t *) &uplrec.unix_date);
        sprintf(reply.date,"%02d %s %02d %02d:%02d:%02d",
                tim->tm_mday,month[tim->tm_mon],tim->tm_year%100,
                tim->tm_hour,tim->tm_min,tim->tm_sec);
    }

    reply.replyto = uplrec.replyto;
    reply.destzone = uplrec.destzone;
    reply.destnet = uplrec.destnet;
    reply.destnode = uplrec.destnode;
    reply.destpoint = uplrec.destpoint;

    strcpy(reply.area,(char *) uplrec.echotag);
    strcpy(reply.fname,(char *) uplrec.filename);

    reply.flags = 0;
    reply.netflags = 0;
    if (uplrec.msg_attr & UPL_INACTIVE) reply.flags |= flag_deleted;
    if (uplrec.msg_attr & UPL_PRIVATE) reply.flags |= flag_private;
    if (uplrec.msg_attr & UPL_NETMAIL)
    {
        reply.flags |= flag_netmail;
        if (uplrec.netmail_attr & UPL_NETCRASH) reply.netflags |= NET_CRASH;
        if (uplrec.netmail_attr & UPL_NETDIRECT) reply.netflags |= NET_DIRECT;
        if (uplrec.netmail_attr & UPL_NETIMMEDIATE) reply.netflags |= NET_IMMEDIATE;
        if (uplrec.netmail_attr & UPL_NETHOLD) reply.netflags |= NET_HOLD;
        if (uplrec.netmail_attr & UPL_NETKILL) reply.netflags |= NET_KILLSENT;
        if (uplrec.netmail_attr & UPL_NETFILE) reply.netflags |= NET_FATTACH;
        if (uplrec.netmail_attr & UPL_NETFRQ) reply.netflags |= NET_FREQ;
    }

    pkt->dat_start = 1; pkt->dat_end = 0;
    return 1;
}

char off_init_replytext(offline_packet *pkt, char *fname)
{
    unsigned long last_line,totalread;
    size_t readed;

    unsigned pos,ptr_pos,num;

    char buf[256];
    int spos,no_quote;
    unsigned chars,tens;

    LINE_REC *linep;

    /* If old reply is still in memory, delete it */
    if (pkt->first_linerec != NULL) pkt->deinit_replytext(pkt);

    /* Open reply file */
    pkt->Freply = FileOpen(fname,"rb");
    if (pkt->Freply == NULL)
    {
        /* Didn't find it. */
        replyopen = 0; pkt->txt_lines = 0;
        return 0;
    }
    replyopen = 1;
    pkt->dat_start = 1; pkt->dat_end = 0;

    /* Get size of reply */
    fseek(pkt->Freply,0,SEEK_END);
    pkt->msgtxtsize = ftell(pkt->Freply);
    fseek(pkt->Freply,0,SEEK_SET);

    pkt->txt_lines = 0; last_line = 0; tens = 0; chars = 0; spos = 0; no_quote = 0;

    /* Init first line */
    pkt->linerec = (LINE_REC *) malloc(sizeof(LINE_REC));
    pkt->linerec->prev = NULL;
    pkt->linerec->next = NULL;
    pkt->linerec->line_type = LINE_TYPE_NORMAL;
    pkt->linerec->ptr = 0;
    pkt->linerec->len = 0;

    pkt->first_linerec = pkt->linerec;

    totalread = 0; readed = 0;
    while (totalread+readed+1 < pkt->msgtxtsize)
    {
        totalread += readed;

        /* How much to read? */
        if (pkt->msgtxtsize-totalread < BUF_SIZE)
            readed = pkt->msgtxtsize-totalread;
        else
            readed = BUF_SIZE;

        if (pkt->dat_start > totalread || pkt->dat_end < readed-1+totalread)
        {
            /* Read text from file */
            fseek(pkt->Freply,totalread,SEEK_SET);
            pkt->dat_start = ftell(pkt->Freply);
            readed = fread(pkt->txt_buf,1,readed,pkt->Freply);
            pkt->dat_end = pkt->dat_start+readed-1;
        }
        else
        {
            /* Text already in memory */
            readed = pkt->dat_end+1-totalread;
            //readed = pkt->dat_end-1-totalread;
        }

        if (readed >= pkt->msgtxtsize-totalread) readed = pkt->msgtxtsize-totalread;

        pos = totalread-pkt->dat_start;
        ptr_pos = (unsigned) -1;

        for (; pos<readed+totalread-pkt->dat_start; pos++)
        {
            ptr_pos++;
            switch (pkt->txt_buf[pos])
            {
                case 10:
                    if (fmt == format_soup) goto __cr;
                    /* Do nothing to LFs */
                    tens++;
                    break;
                case 227:
                    /* "CR" with QWK format */
                    if (fmt != format_qwk) goto __write_chr;
                case 13:
                __cr:
                    /* CR found */

                    no_quote = 0;

                    /* Remove trailing spaces */
                    while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;
                    buf[spos] = '\0';

                    if (spos == 3 && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
                    {
                        /* Update line type */
                        pkt->linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }

                    if (buf[0] != 1 || show_kludges)
                    {
                        /* Not a kludge, or displaying kludges is set on, */
                        /* so add line to linked list */

                        if (chars > 0) last_line = pkt->txt_lines;
                        pkt->txt_lines++;

                        /* Allocate memory for new line */
                        linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                        /* Set last line length and pointer to next line */
                        pkt->linerec->len = (char) (chars+tens);
                        pkt->linerec->next = linep;

                        if (linep == NULL) goto __end; /* Out of memory! */

                        linep->prev = pkt->linerec;
                        linep->next = NULL;
                        linep->len = 0;
                        pkt->linerec = linep;
                    }

                    pkt->linerec->line_type = LINE_TYPE_NORMAL;
                    pkt->linerec->ptr = totalread+ptr_pos+1;
                    chars = 0; tens = 0; spos = 0;
                    break;
                case 141:
                    if ((opt.rflags & TREAT_I_NORMAL) == 0)
                    {
                        /* Soft-CR */
                        tens++;
                        break;
                    }
                default:
                __write_chr:
                    /* Normal character */
                    if (chars+1 >= scrwidth)
                    {
                        /* Too long line, split it */
                        if (pkt->txt_buf[pos] == ' ')
                        {
                            /* Great, we can split it right here! */
                            spos = 0;

                            /* Remove trailing spaces */
                            while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;

                            if (chars > 0) last_line = pkt->txt_lines;
                            pkt->txt_lines++;

                            /* Allocate memory for new line */
                            linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                            /* Set last line length and pointer to next line */
                            pkt->linerec->len = (char) (chars+tens);
                            pkt->linerec->next = linep;

                            if (linep == NULL) goto __end; /* Out of memory! */

                            linep->prev = pkt->linerec;
                            linep->next = NULL;
                            linep->line_type = LINE_TYPE_NORMAL;
                            linep->len = 0;
                            pkt->linerec = linep;

                            pkt->linerec->ptr = totalread+ptr_pos+1;
                            chars = 0; tens = 0;
                            continue;
                        }

                        /* Search split position */
                        num = spos-1;
                        while (num > 0 && buf[num] != ' ') num--;

                        if (num > 0)
                        {
                            /* Found split character */
                            chars = num;

                            /* Remove trailing spaces */
                            while (chars > 0 && buf[chars-1] == ' ') chars--;

                            if (chars > 0) last_line = pkt->txt_lines;
                            pkt->txt_lines++;

                            /* Allocate memory for new line */
                            linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                            /* Set last line length and pointer to next line */
                            pkt->linerec->next = linep;
                            pkt->linerec->len = (char) (chars+tens);

                            if (linep == NULL) goto __end; /* Out of memory! */

                            linep->prev = pkt->linerec;
                            linep->next = NULL;
                            linep->line_type = LINE_TYPE_NORMAL;
                            linep->len = 0;
                            pkt->linerec = linep;

                            pkt->linerec->ptr = totalread+ptr_pos+2-(spos-num+1);
                            chars = 0; tens = 0;

                            memmove(buf,buf+num+1,spos-num); spos -= num+1;
                            chars = spos;
                        }
                        else
                        {
                            /* Couldn't find split pos so just split somewhere */
                            spos = 0;

                            /* Remove trailing spaces */
                            while (chars > 0 && buf[chars-1] == ' ') chars--;

                            if (chars>0) last_line = pkt->txt_lines;
                            pkt->txt_lines++;

                            /* Allocate memory for new line */
                            linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                            /* Set last line length and pointer to next line */
                            pkt->linerec->next = linep;
                            pkt->linerec->len = (char) (chars+tens);

                            if (linep == NULL) goto __end; /* Out of memory! */

                            linep->prev = pkt->linerec;
                            linep->next = NULL;
                            linep->line_type = LINE_TYPE_NORMAL;
                            linep->len = 0;
                            pkt->linerec = linep;

                            pkt->linerec->ptr = totalread+ptr_pos;
                            chars = 0; tens = 0;
                        }
                    }

                    /* Add to buffer */
                    buf[spos++] = pkt->txt_buf[pos];
                    chars++;

                    if (pkt->linerec->line_type != LINE_TYPE_NORMAL && pkt->linerec->line_type != LINE_TYPE_SPECIAL) break;

                    if (spos == 1 && pkt->txt_buf[pos] == 1)
                    {
                        /* Kludge line */
                        pkt->linerec->line_type = LINE_TYPE_KLUDGE;
                    }
                    if (spos == 4 && (strncmp(buf,"--- ",4) == 0 || strncmp(buf,"... ",4) == 0 || strncmp(buf,"~~~ ",4) == 0))
                    {
                        /* Tear or tag */
                        pkt->linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }
                    if (pkt->txt_buf[pos] == '_' || pkt->txt_buf[pos] == '*')
                    {
                        pkt->linerec->line_type = LINE_TYPE_SPECIAL;
                    }
                    if (spos < QUOTE_MAX && !no_quote)
                    {
                        if (pkt->txt_buf[pos] == '"' || pkt->txt_buf[pos] == '\'' || pkt->txt_buf[pos] == '<') no_quote = 1;
                        if (pkt->txt_buf[pos] == '>' || (spos == 1 && pkt->txt_buf[pos] == ':' && pkt->txt_buf[pos+1] != ')' && pkt->txt_buf[pos+1] != '(' && pkt->txt_buf[pos+1] != '-'))
                        {
                            /* Quoted line */
                            pkt->linerec->line_type = LINE_TYPE_QUOTE;
                        }
                    }
            }
        }
    }

    /* Remove trailing spaces */
    while (chars > 0 && buf[chars-1] == ' ') chars--;

    if (buf[0] != 1 || show_kludges)
    {
        /* OK to display this line. */
        if (chars > 0) last_line = pkt->txt_lines;
        pkt->linerec->len = (char) (chars+tens);
        pkt->txt_lines++;
    }

    if (spos == 3 && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
    {
        /* Update line type */
        pkt->linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
    }

__end:
    pkt->txt_lines = last_line+1;

    pkt->linerec = pkt->first_linerec;
    pkt->current_line = 1;
    return 1;
}

char *off_read_replyline(offline_packet *pkt, char *str, unsigned line)
{
    int nro,slen;

    /* Go to right position */
    while (line < pkt->current_line)
    {
        if (pkt->linerec->prev == NULL)
        {
            str[0] = '\0';
            return str;
        }
        pkt->linerec = pkt->linerec->prev;
        pkt->current_line--;
    }

    while (line > pkt->current_line)
    {
        if (pkt->linerec->next == NULL)
        {
            str[0] = '\0';
            return str;
        }
        pkt->linerec = pkt->linerec->next;
        pkt->current_line++;
    }

    /* Read from file */
    if ((pkt->dat_start > pkt->linerec->ptr) || (pkt->dat_end < pkt->linerec->ptr+pkt->linerec->len))
    {
        fseek(pkt->Freply,pkt->linerec->ptr,SEEK_SET);
        pkt->dat_start = pkt->linerec->ptr;
        pkt->dat_end = pkt->dat_start+fread(pkt->txt_buf,1,BUF_SIZE,pkt->Freply)-1;
    }
    memcpy(str,pkt->txt_buf+pkt->linerec->ptr-pkt->dat_start,pkt->linerec->len);
    str[pkt->linerec->len] = '\0';

    nro = 0;
    slen = pkt->linerec->len;

    while (nro < slen)
    {
        switch ((unsigned char) str[nro])
        {
            case 13:
                str[nro] = 32;
                break;
            case 141:
                if (opt.rflags & TREAT_I_NORMAL) break;
            case 10:
                memmove(str+nro,str+nro+1,slen-nro-1);
                slen--;
                nro--;
                break;
        }
        nro++;
    }
    while ((slen > 0) && (str[slen-1] == 32)) slen--;
    str[slen] = '\0';

    if (rot13)
    {
        nro = 1;
        if (str[0] == 1)
            nro = 0;
        else if ((slen > 4) && (strncmp(str,"--- ",4) == 0))
            nro = 0;
        else if ((slen >= 10) && (strncmp(str," * Origin:",10) == 0))
            nro = 0;

        if (nro)
        {
            nro = 0;
            while (nro < slen)
            {
                if ((str[nro] >= 'A') && (str[nro] <= 'Z'))
                {
                    if (str[nro] >= 'A'+13) str[nro] -= 13; else str[nro] += 13;
                }
                else
                {
                    if ((str[nro] >= 'a') && (str[nro] <= 'z'))
                    {
                        if (str[nro] >= 'a'+13) str[nro] -= 13; else str[nro] += 13;
                    }
                }
                nro++;
            }
        }
    }

    return str;
}

void off_export_reply(offline_packet *pkt, unsigned num, char *name)
{
}

void off_deinit_replytext(offline_packet *pkt)
{
    if (pkt->Freply != 0)
    {
        fclose(pkt->Freply);
        pkt->Freply = NULL;
    }
    replyopen = 0;
    pkt->dat_start = 1; pkt->dat_end = 0;

    while (pkt->first_linerec != NULL)
    {
        pkt->linerec = pkt->first_linerec->next;
        free(pkt->first_linerec);
        pkt->first_linerec = pkt->linerec;
    }
}

unsigned off_area_type(offline_packet *pkt, unsigned area)
{
    int flags;
    unsigned aflags;

    pkt->read_inf_area(pkt, area);
    flags = 0;
    aflags = pkt->area_buf[area-pkt->area_start].area_flags;
    if (pkt->area_buf[area-pkt->area_start].network_type == INF_NET_INTERNET) flags = TYPE_INET;
    if (aflags & INF_ALIAS_NAME) flags |= TYPE_ALIAS;
    if (aflags & INF_ANY_NAME) flags |= TYPE_ANYNAME;
    if (aflags & INF_ECHO) flags |= TYPE_ECHO;
    if (aflags & INF_NETMAIL) flags |= TYPE_NET;
    if (aflags & INF_NO_PRIVATE) flags |= TYPE_NOPVT;
    if (aflags & INF_NO_PUBLIC) flags |= TYPE_NOPUB;
    if ((aflags & INF_POST) == 0) flags |= TYPE_NORIGHTS;
    if (aflags & INF_NO_TAGLINE) flags |= TYPE_NOTAGS;
    return flags;
}

void off_enter_msg(offline_packet *pkt)
{
    unsigned reparea;
    char tmp[256];

    reparea = pkt->gettag(pkt, reply.area);
    pkt->read_inf_area(pkt, reparea);

    memset(&uplrec,0,sizeof(UPL_REC));
    strcpy((char *) uplrec.from,reply.mfrom);
    if (reply.flags & flag_email || fmt == format_soup)
        strcpy((char *) uplrec.net_dest,reply.mto);
    else
        strcpy((char *) uplrec.to,reply.mto);
    strcpy((char *) uplrec.subj,reply.subj);

    uplrec.destzone = reply.destzone;
    uplrec.destnet = reply.destnet;
    uplrec.destnode = reply.destnode;
    uplrec.destpoint = reply.destpoint;

    uplrec.msg_attr = 0;
    if (reply.flags & flag_private) uplrec.msg_attr |= UPL_PRIVATE;
    if (reply.flags & flag_email) uplrec.msg_attr |= UPL_NETMAIL;
    if (reply.flags & flag_netmail)
    {
        uplrec.msg_attr |= UPL_NETMAIL;
        if (reply.netflags & NET_CRASH) uplrec.netmail_attr |= UPL_NETCRASH;
        if (reply.netflags & NET_DIRECT) uplrec.netmail_attr |= UPL_NETDIRECT;
        if (reply.netflags & NET_IMMEDIATE) uplrec.netmail_attr |= UPL_NETIMMEDIATE;
        if (reply.netflags & NET_HOLD) uplrec.netmail_attr |= UPL_NETHOLD;
        if (reply.netflags & NET_KILLSENT) uplrec.netmail_attr |= UPL_NETKILL;
        if (reply.netflags & NET_FATTACH) uplrec.netmail_attr |= UPL_NETFILE;
        if (reply.netflags & NET_FREQ) uplrec.netmail_attr |= UPL_NETFRQ;
    }
    if (fmt == format_omen)
    {
        if (reply.flags & flag_omen_del)
            uplrec.user_area[0] = 1;
        else if (reply.flags & flag_omen_tog)
            uplrec.user_area[0] = 2;
        else if (reply.flags & flag_omen_move)
        {
            uplrec.user_area[0] = 3;
            strcpy((char *) uplrec.net_dest, reply.fname);
            reply.fname[0] = '\0';
        }
    }

    uplrec.unix_date = time(NULL);

    if (uplrec.replyto) uplrec.msg_attr |= UPL_IS_REPLY;
    uplrec.replyto = reply.replyto;
    if ((reply.replyto > 0) && (pkt->msgid_kludge[0] != 0) && ((reply.flags & flag_email) == 0))
        strcat(strcpy((char *) uplrec.net_dest,"REPLY: "),pkt->msgid_kludge);
    strcpy((char *) uplrec.filename,reply.fname);
    strcpy((char *) uplrec.echotag,(char *) pkt->area_buf[reparea-pkt->area_start].echotag);
    uplrec.area_flags = pkt->area_buf[reparea-pkt->area_start].area_flags;
    uplrec.network_type = pkt->area_buf[reparea-pkt->area_start].network_type;

    fseek(pkt->Fupl,0,SEEK_END);
    if (fwrite(&uplrec,sizeof(UPL_REC),1,pkt->Fupl)) pkt->replies++;

    fclose(pkt->Fupl);
    if (fmt == format_omen)
        sprintf(tmp,"%sOMEN%s.upl",setup.replypath,omentag);
    else
        sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    pkt->Fupl = fopen_ign(tmp,"r+b");
}

void off_edit_msg(offline_packet *pkt, unsigned num)
{
    char tmp[256];
    unsigned reparea;

    reparea = pkt->gettag(pkt, reply.area);
    pkt->read_inf_area(pkt,
                       reparea);

    memset(&uplrec,0,sizeof(UPL_REC));
    strcpy((char *) uplrec.from,reply.mfrom);
    if (reply.flags & flag_email || fmt == format_soup)
        strcpy((char *) uplrec.net_dest,reply.mto);
    else
        strcpy((char *) uplrec.to,reply.mto);
    strcpy((char *) uplrec.subj,reply.subj);

    uplrec.destzone = reply.destzone;
    uplrec.destnet = reply.destnet;
    uplrec.destnode = reply.destnode;
    uplrec.destpoint = reply.destpoint;
    
    uplrec.msg_attr = 0;
    if ((reply.flags & flag_private) > 0) uplrec.msg_attr |= UPL_PRIVATE;
    if (reply.flags & flag_netmail)
    {
        uplrec.msg_attr |= UPL_NETMAIL;
        if (reply.netflags & NET_CRASH) uplrec.netmail_attr |= UPL_NETCRASH;
        if (reply.netflags & NET_DIRECT) uplrec.netmail_attr |= UPL_NETDIRECT;
        if (reply.netflags & NET_IMMEDIATE) uplrec.netmail_attr |= UPL_NETIMMEDIATE;
        if (reply.netflags & NET_HOLD) uplrec.netmail_attr |= UPL_NETHOLD;
        if (reply.netflags & NET_KILLSENT) uplrec.netmail_attr |= UPL_NETKILL;
        if (reply.netflags & NET_FATTACH) uplrec.netmail_attr |= UPL_NETFILE;
        if (reply.netflags & NET_FREQ) uplrec.netmail_attr |= UPL_NETFRQ;
    }

    uplrec.unix_date = time(NULL);

    uplrec.replyto = reply.replyto;
    strcpy((char *) uplrec.filename,reply.fname);
    strcpy((char *) uplrec.echotag,(char *) pkt->area_buf[reparea-pkt->area_start].echotag);
    uplrec.area_flags = pkt->area_buf[reparea-pkt->area_start].area_flags;
    uplrec.network_type = pkt->area_buf[reparea-pkt->area_start].network_type;

    fseek(pkt->Fupl,sizeof(UPL_HEADER)+(num-1)*sizeof(UPL_REC),SEEK_SET);
    fwrite(&uplrec,sizeof(UPL_REC),1,pkt->Fupl);

    fclose(pkt->Fupl);
    if (fmt == format_omen)
        sprintf(tmp,"%somen%s.upl",setup.replypath,omentag);
    else
        sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    pkt->Fupl = fopen_ign(tmp,"r+b");
}

void off_toggle_deleted(offline_packet *pkt, unsigned msgnum, char deleted)
{
    fseek(pkt->Fupl,sizeof(UPL_HEADER)+(msgnum-1)*sizeof(UPL_REC),SEEK_SET);
    if (fread(&uplrec,sizeof(UPL_REC),1,pkt->Fupl) == 1) {
        if (deleted)
            uplrec.msg_attr |= UPL_INACTIVE;
        else
            uplrec.msg_attr &= ~UPL_INACTIVE;
        
        fseek(pkt->Fupl,sizeof(UPL_HEADER)+(msgnum-1)*sizeof(UPL_REC),SEEK_SET);
        fwrite(&uplrec,sizeof(UPL_REC),1,pkt->Fupl);
        fflush(pkt->Fupl);
    }
}

void off_delete_reply(offline_packet *pkt, unsigned msgnum)
{
    char tmp[256];
    fpos_t fsize;
    
    pkt->read_reply(pkt, msgnum);
    
    fseek(pkt->Fupl,0,SEEK_END);
    fgetpos(pkt->Fupl,&fsize);
    delete_space(pkt->Fupl,sizeof(UPL_HEADER)+(msgnum-1)*sizeof(UPL_REC),
                 sizeof(UPL_REC),fsize);
    ftrunc(pkt->Fupl,fsize-sizeof(UPL_REC));
    
    FileRemove(strcat(strcpy(tmp,setup.replypath),reply.fname));
    pkt->replies--;
}

char *off_export_msg(offline_packet *pkt, char *out)
{
    return NULL;
}

void off_read_arealist(offline_packet *pkt, FILE *F)
{
}

void off_write_arealist(offline_packet *pkt, FILE *F)
{
}

offline_packet *new_offpacket(void)
{
    offline_packet *off;

    off = (offline_packet *) malloc(sizeof(offline_packet));
    memset(off, 0, sizeof(*off));

    off->open_packet = off_open_packet;
    off->close_packet = off_close_packet;
    off->save_info = off_save_info;
    off->read_inf_area = off_read_inf_area;
    off->area_selected = off_area_selected;
    off->get_area_number = off_get_area_number;
    off->get_area_name = off_get_area_name;
    off->get_area_tag = off_get_area_tag;

    off->getarea = off_getarea;
    off->getaname = off_getaname;
    off->gettag = off_gettag;

    off->get_msgs = off_get_msgs;
    off->get_personal_msgs = off_get_personal_msgs;
    off->get_unread_msgs = off_get_unread_msgs;

    off->open_area = off_open_area;
    off->read_msg = off_read_msg;
    off->write_msg = off_write_msg;
    off->delete_msg = off_delete_msg;

    off->read_num = off_read_num;
    off->read_from = off_read_from;
    off->read_to = off_read_to;
    off->read_subj = off_read_subj;

    off->init_text = off_init_text;
    off->deinit_msgtext = off_deinit_msgtext;
    off->read_line = off_read_line;

    off->area_flags = off_area_flags;
    off->save_area_flags = off_save_area_flags;
    off->update_area_flags = off_update_area_flags;
    off->delete_xti = off_delete_xti;

    off->open_replypacket = off_open_replypacket;
    off->close_replypacket = off_close_replypacket;

    off->read_reply = off_read_reply;

    off->export_msg = off_export_msg;
    off->init_replytext = off_init_replytext;
    off->read_replyline = off_read_replyline;
    off->export_reply = off_export_reply;
    off->deinit_replytext = off_deinit_replytext;

    off->area_type = off_area_type;

    off->enter_msg = off_enter_msg;
    off->edit_msg = off_edit_msg;

    off->toggle_deleted = off_toggle_deleted;
    off->delete_reply = off_delete_reply;

    off->read_arealist = off_read_arealist;
    off->write_arealist = off_write_arealist;

    off->read_mix = off_read_mix;
    off->write_mix = off_write_mix;
    off->delete_mix = off_delete_mix;

    return off;
}
