#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "files.h"
#include "screen.h"
#include "general.h"
#include "pkt_omen.h"
#include "bluewave.h"

#include "keyb.h"

char omen_packet::open_packet(char *str)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned num,area;
    unsigned oldarea;
    char pos,quit,ch,error,ok,longnames;

    struct stat statbuf;
    char usr[36],usr1[36],usr2[36],mareanum[6];
    char tmp[256],readstr[256],st[256],*strp;
    size_t slen;

    long msgs;

    FILE *Ftxt,*Fsys,*F;

    INF_HEADER infohdr;
    INF_AREA_INFO infarea;

    MIX_REC mixrec;
    BrdRecord brdrec;


    know_areas = 1;
    offline_config = 0;
    strcpy(username,setup.UsrName);
    strcpy(useralias,opt.alias);

    from_to_len = 35;
    subj_len = 71;

    inf_header_slen = sizeof(INF_HEADER);
    inf_area_slen = sizeof(INF_AREA_INFO);

    replies = 0;
    ok = 1;
    curarea = 0;
    sysop_name[0] = 0;

    memset(delarr,0,sizeof(delarr));
    strupr(strcpy(usr1,setup.UsrName));
    strupr(strcpy(usr2,opt.alias));

    if (replymgr)
    {
        dat_start = 1; dat_end = 0; lastarea[0] = '\0'; first_linerec = NULL;
        replyopen = 0; replies = 0; fupl_opened = 0; arealist = 0;

        if ((txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;
        if ((Finfo = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"rb")) == NULL) return 2;
        //setbuf(Finfo,NULL);
        fread(&info,sizeof(info),1,Finfo);
        fseek(Finfo,0,SEEK_END);
        strcpy(username, (char *) info.loginname);
        strcpy(useralias, (char *) info.aliasname);
        strcpy(board_name, (char *) info.systemname);
        strcpy(sysop_name, (char *) info.sysop);
        areas = (ftell(Finfo)-sizeof(INF_HEADER))/sizeof(INF_AREA_INFO);
        if (areas < MAX_AREAS)
            abufsize = areas;
        else
            abufsize = MAX_AREAS;
        if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL) return 2;
        return 0;
    }

    msgs = 0;
    /* Open message text file */
    sprintf(tmp,"%snewmsg%s.txt",setup.workpath,omentag);
    Ftxt = fopen_ign(tmp,"rt");
    if (Ftxt == NULL) return 1;

    /* Open system information file */
    sprintf(tmp,"%ssystem%s.bbs",setup.workpath,omentag);
    Fsys = fopen_ign(tmp,"rb");
    if (Fsys == NULL)
    {
        fclose(Ftxt);
        return 1;
    }

    /* Get number of areas */
    fseek(Fsys,0,SEEK_END);
    areas = (ftell(Fsys)-41) / sizeof(BrdRecord);

    if (areas < MAX_AREAS)
        abufsize = areas;
    else
        abufsize = MAX_AREAS;

    if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL)
    {
        fclose(Ftxt);
        return 2;
    }

    sprintf(tmp,"%sinfo%s.bbs",setup.workpath,omentag);
    if ((F = fopen_ign(tmp,"rt")) != NULL)
    {
        do
        {
            quit = _fgets(tmp,sizeof(tmp)-1,F) == NULL;
            strupr(strcpy(st,tmp));
            if (strncmp(st,"SYSOP",5) == 0)
                strcpy(sysop_name,tmp+6);
            else if (strncmp(st,"SELECT",6) == 0)
                know_areas = (st[7] == 'O') && (st[8] == 'N');
        } while (!quit);
        fclose(F);
    }
    offline_config = know_areas;

    if ((Fidx = FileOpen(strcat(strcpy(tmp,setup.workpath),"msgs.idx"),"w+b")) == NULL) return 4;
    if ((Fdat = FileOpen(strcat(strcpy(tmp,setup.workpath),"msgs.dat"),"w+b")) == NULL)
    {
        fclose(Ftxt);
        return 4;
    }
    if ((Fmix = FileOpen(strcat(strcpy(tmp,setup.workpath),"msgs.mix"),"w+b")) == NULL)
    {
        fclose(Ftxt);
        return 4;
    }

    fseek(Fsys,0,SEEK_SET);
    fread(&ch,1,1,Fsys);
    fread(board_name,1,ch,Fsys);
    board_name[ch] = 0;

    error = 0;

    /* Create .INF file */
    if ((Finfo = FileOpen(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".inf"),"w+b")) == NULL)
    {
        fclose(Ftxt);
        return 4;
    }
    //setbuf(Finfo,NULL);

    memset(&infohdr,0,sizeof(infohdr));
    infohdr.mashtype = arcfmt;
    infohdr.ver = 253;
    strcpy((char *) infohdr.loginname,setup.UsrName);
    strcpy((char *) infohdr.aliasname,opt.alias);
    strcpy((char *) infohdr.sysop,sysop_name);
    strcpy((char *) infohdr.systemname,board_name);
    infohdr.inf_header_len = sizeof(INF_HEADER);
    infohdr.inf_areainfo_len = sizeof(INF_AREA_INFO);
    infohdr.mix_structlen = sizeof(MIX_REC);
    infohdr.fti_structlen = sizeof(FTI_REC);
    infohdr.uses_upl_file = 1;
    infohdr.from_to_len = 35;
    infohdr.subject_len = 71;
    strcpy((char *) infohdr.packet_id,omentag);

    fwrite(&infohdr,sizeof(INF_HEADER),1,Finfo);

    sprintf(tmp,"%sbnames%s.bbs",setup.workpath,omentag);
    longnames = (F = fopen_ign(tmp,"rt")) != NULL;

    /* Create areas for .INF file */
__areas_again:
    fseek(Fsys,41,SEEK_SET);

    for (num=1; num<=areas; num++)
    {
        memset(&infarea,0,sizeof(infarea));
        fread(&brdrec,sizeof(brdrec),1,Fsys);
        if (longnames)
        {
            /* Use BNAMESxx.BBS file for long area names */
            if (_fgets(tmp,sizeof(tmp)-1,F) == NULL)
            {
                longnames = 0;
                fclose(F);
                goto __areas_again;
            }
            if ((strp = strchr(tmp,':')) == NULL)
            {
                longnames = 0;
                fclose(F);
                goto __areas_again;
            }
            *strp++ = '\0';
            strcpy((char *) infarea.areanum,tmp);
            strcpy((char *) infarea.echotag,tmp);
            strp[sizeof(infarea.title)-1] = '\0';
            strcpy((char *) infarea.title,strp);
        }
        else
        {
            /* Use old short area names */
            sprintf((char *) infarea.areanum,"%u",brdrec.brdnum/*+(unsigned) brdrec.brdhighnum << 8*/);
            strcpy((char *) infarea.echotag,(char *) infarea.areanum);
            strncpy((char *) infarea.title,brdrec.brdname+1,brdrec.brdname[0]);
            infarea.title[brdrec.brdname[0]] = 0;
            infarea.area_flags = INF_POST; /* some old omen packets are buggy.. :( */
        }

        if (brdrec.brdstatus & 0x01)
            infarea.area_flags = INF_POST;
        if (brdrec.brdstatus & 0x04)
            infarea.area_flags |= INF_NO_PUBLIC;
        if (brdrec.brdstatus & 0x08)
            infarea.area_flags |= INF_NO_PRIVATE;
        if (brdrec.brdstatus & 0x10)
            infarea.area_flags |= INF_ECHO | INF_NETMAIL;
        if (brdrec.brdstatus & 0x20)
            infarea.area_flags |= INF_ALIAS_NAME | INF_ANY_NAME;
        if (brdrec.brdstatus & 0x40)
            infarea.area_flags |= INF_SCANNING;
        fwrite(&infarea,1,sizeof(INF_AREA_INFO),Finfo);
    }

    if (longnames) fclose(F);
    fclose(Fsys);

    save_scr(&cx,&cy,&oldscr);

    slen = strlen(lang[23]);
    if (strlen(lang[25])+2 > slen) slen = strlen(lang[25])+2;
    draw_shaded_box(scrwidth/2-slen/2-2,8,scrwidth/2+slen/2+2,12,color[col_box_frame],color[col_box_title],lang[23]);

    /* Create indexes for OMEN messages */
    _fgets(readstr,sizeof(readstr)-1,Ftxt);
    oldarea = (unsigned) -1;
    do
    {
        if (readstr[0] != 1) goto __quit;
        if (readstr[1] != '#') goto __quit;

        /* Message number */
        memset(&msg,0,sizeof(msg));
        ch = readstr[2]; pos = 3;
        while (!((ch == ' ') && (readstr[pos] == ' ')))
        {
            st[pos-3] = ch;
            ch = readstr[pos];
            pos++;
        }
        st[pos-3] = 0;
        pos++;
        msg.mnum = atol(st);

        /* Msg area number */
        ch = readstr[pos]; pos++; slen = 0;
        while (ch != ':')
        {
            st[slen] = ch;
            ch = readstr[pos];
            pos++; slen++;
        }
        st[slen] = 0;
        strcpy(mareanum,st);
        msg.area = (unsigned short) atol(st);

        ch = readstr[pos]; pos++; /* msg area name */
        while (!((ch == ' ') && (readstr[pos] == ' ')))
        {
            ch = readstr[pos];
            pos++;
        }
        pos++;

        /* msg date */
        slen = 0; ch = readstr[pos]; pos++;
        while (!((ch == ' ') && (readstr[pos] == ' ')))
        {
            if (slen < sizeof(msg.date)-1) msg.date[slen++] = ch;
            ch = readstr[pos];
            pos++;
        }
        pos++;

        /* msg time */
        if (slen < sizeof(msg.date)-1) msg.date[slen++] = ' ';
        ch = readstr[pos]; pos++;
        while (!((ch == ' ') && (readstr[pos] == ' ')) && readstr[pos] != '\0')
        {
            if (slen < sizeof(msg.date)-1) msg.date[slen++] = ch;
            ch = readstr[pos];
            pos++;
        }
        if (readstr[pos] != '\0') pos++;
        msg.date[slen] = '\0';

        /* chain */
        ch = readstr[pos]; pos++; slen = 0;
        while (!((ch == ' ') && (readstr[pos] == ' ')) && readstr[pos] != '\0')
        {
            st[slen] = ch;
            ch = readstr[pos];
            pos++; slen++;
        }

        if (readstr[pos] != '\0')
        {
            pos++;
            st[slen] = 0;

            if (st[0] != '-')
            {
                if ((strp = strchr(st,'/')) != NULL) *strp = '\0';
                msg.replyto = atol(st);
                strp++;
            }
            else strp = st+2;

            if (*strp != '-')
                msg.replyat = atol(strp);

            strcpy(st,readstr+pos);

            slen = strlen(st);
            if ((st[0] != '(') || (st[slen-1] != ')')) goto __quit;
            if (st[1] == 'R' || st[2] == 'R') msg.flags |= flag_received;
            if (st[1] == 'P') msg.flags |= flag_private;
        }

        /* From / To */
        _fgets(readstr,sizeof(readstr)-1,Ftxt);
        strp = strstr(readstr," => ");
        if (strp == NULL)
        {
            strp = strstr(readstr," =>");
            if (strp != NULL) *strp = '\0';
            strcpy(msg.mfrom,readstr);
            msg.mto[0] = '\0';
        }
        else
        {
            *strp = '\0';
            strcpy(msg.mfrom,readstr);
            strcpy(msg.mto,strp+4);
        }

        /* Subject */
        _fgets(readstr,sizeof(readstr)-1,Ftxt);
        if ((strp = strchr(readstr,2)) == NULL) goto __quit;
        *strp = '\0';
        if (strncmp(readstr,"Subj: ",6) == 0)
            strcpy(msg.subj,readstr+6);
        else
            strcpy(msg.subj,readstr);

        strp++;
        msg.blockpos = ftell(Fdat);
        slen = strlen(strp)+1; strp[slen-1] = 13;
        fwrite(strp,1,slen,Fdat);
        msg.txtblocks += slen;

        area = 0;
        for (num=1; num<=areas; num++)
        {
            if (strcmp(get_area_number(num),mareanum) == 0)
            {
                area = num;
                break;
            }
        }

        if (area > 0)
        {
            if (oldarea != area)
            {
                if (oldarea != (unsigned) -1)
                    fwrite(&mixrec,sizeof(mixrec),1,Fmix);
                memset(&mixrec,0,sizeof(mixrec));
                strcpy((char *) mixrec.areanum,get_area_number(area));
                mixrec.msghptr = ftell(Fidx) / sizeof(msg);
                oldarea = area;
            }

            mixrec.totmsgs++;

            strupr(strcpy(usr,msg.mto));
            if ((strcmp(usr,usr1) == 0) || (strcmp(usr,usr2) == 0))
                mixrec.numpers++;
        }

        /* Read until #3 is found */
        for (;;)
        {
            if (_fgets(readstr,sizeof(readstr)-1,Ftxt) == NULL) goto __quit;
            strp = readstr;
            while (*strp != '\0' && *strp != 3) strp++;

            /* Write to file */
            slen = (int) (strp-readstr);
            msg.txtblocks += slen+1;
            fwrite(readstr,1,slen,Fdat);
            fwrite("\r",1,1,Fdat);

            if (*strp == 3) break; /* Got it! */
        }

        fwrite(&msg,sizeof(msg),1,Fidx);

        msgs++;
        if ((msgs & 31) == 0)
        {
            sprintf(tmp,lang[25],msgs);
            cmiddle(10,tmp,color[col_box_hilight]);
            refresh();
        }
        memmove(readstr,strp+1,strlen(strp+1)+1);
    } while (readstr[0] != '\0' && readstr[0] != 26);

    if (oldarea != (unsigned) -1)
        fwrite(&mixrec,sizeof(mixrec),1,Fmix);

    fflush(Fmix);
    //setbuf(Fmix,NULL);

    sprintf(tmp,"%sBULLET%s.BBS",setup.workpath,omentag);
    if (FileStat(tmp,&statbuf) == 0) {
        ansi_files = 1;
        sprintf(ansi_name[0],"BULLET%s.BBS",omentag);
        dtstr(ansi_time[ansi_files], *ST_MTIME(&statbuf));
    } else ansi_files = 0;

    ok = offline_packet::open_packet(str);

__quit:
    old_scr(cx,cy,&oldscr);
    fclose(Ftxt);
    return ok;
}

void omen_packet::close_packet(void)
{
    fclose(Finfo);
    free(area_buf);

    if (replymgr)
    {
        free(txt_buf);
        return;
    }

    fclose(Fdat);
    fclose(Fidx);
    fclose(Fmix);

    offline_packet::close_packet();
}

char omen_packet::read_msg(unsigned msgnum)
{
    long num;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        msgtxtptr = msg.blockpos;
        msgtxtsize = msg.txtblocks;
        return 1;
    }
    num = msgptr+msgnum-1;
    fseek(Fidx,num*sizeof(msgtype),SEEK_SET);
    fread(&msg,sizeof(msg),1,Fidx);
    msgtxtptr = msg.blockpos;
    msgtxtsize = msg.txtblocks;
    offline_packet::read_msg(msgnum);
    return 1;
}

long omen_packet::read_num(unsigned msgnum)
{
    long num;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mnum;
    }
    num = msgptr+msgnum-1;
    fseek(Fidx,num*sizeof(msgtype),SEEK_SET);
    fread(&msg,sizeof(msg),1,Fidx);
    return msg.mnum;
}

char *omen_packet::read_from(unsigned msgnum) {
    long num;

    if (msgs_in_mem) {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mfrom;
    }
    num = msgptr+msgnum-1;
    fseek(Fidx,num*sizeof(msgtype),SEEK_SET);
    fread(&msg,sizeof(msg),1,Fidx);
    return msg.mfrom;
}

char *omen_packet::read_to(unsigned msgnum)
{
    long num;

    num = msgptr+msgnum-1;
    fseek(Fidx,num*sizeof(msgtype),SEEK_SET);
    fread(&msg,sizeof(msg),1,Fidx);
    return msg.mto;
}

char *omen_packet::read_subj(unsigned msgnum)
{
    long num;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.subj;
    }
    num = msgptr+msgnum-1;
    fseek(Fidx,num*sizeof(msgtype),SEEK_SET);
    fread(&msg,sizeof(msg),1,Fidx);
    offline_packet::read_subj(msgnum);
    return msg.subj;
}

void omen_packet::open_replypacket(void)
{
    RepRecord reply;
    FILE *Frep;
    char tmp[256],tmp2[256];

    if (fupl_opened) return;

    replies = 0;

    replyopen = 0;
    sprintf(tmp,"%sselect%s.cnf",setup.replypath,omentag);
    if (exists(tmp)) arealist = 1;

    /* Create .UPL file */
    sprintf(tmp,"%somen%s.upl",setup.replypath,omentag);
    if ((Fupl = fopen_ign(tmp, "r+b")) != NULL)
    {
        fseek(Fupl,0,SEEK_END);
        if (ftell(Fupl) >= (int) sizeof(UPL_HEADER))
        {
            replies = (ftell(Fupl)-sizeof(UPL_HEADER))/sizeof(UPL_REC);
            fupl_opened = 1;
            return;
        }
        fclose(Fupl);
    }

    if ((Fupl = FileOpen(tmp,"w+b")) == NULL)
    {
        fupl_opened = 0;
        return;
    }
    memset(&uplheader,0,sizeof(uplheader));
    fwrite(&uplheader,sizeof(uplheader),1,Fupl);
    fupl_opened = 1;

    /* OMEN replies -> BW replies */
    sprintf(tmp,"%sheader%s.bbs",setup.replypath,omentag);
    if ((Frep = fopen_ign(tmp,"rb")) != NULL)
    {
        while (fread(&reply,sizeof(reply),1,Frep))
        {
            replies++;
            memset(&uplrec,0,sizeof(uplrec));
            uplrec.area_flags = INF_POST;
            strncpy((char *) uplrec.to,reply.whoto+1,reply.whoto[0]);
            uplrec.to[reply.whoto[0]] = 0;
            strncpy((char *) uplrec.subj,reply.subject+1,reply.subject[0]);
            uplrec.subj[reply.subject[0]] = 0;
            uplrec.destzone = reply.destzone;
            uplrec.destnet = reply.destnet;
            uplrec.destnode = reply.destnode;
            sprintf((char *) uplrec.echotag,"%u",reply.curboard+reply.moveboard*256);
            if ((reply.command & 0x0f) == 0) uplrec.msg_attr = UPL_INACTIVE;
            if (reply.command & 0x10) uplrec.msg_attr = UPL_PRIVATE;
            if (reply.command & 0x20)
            {
                /* Alias */
                strncpy((char *) uplrec.from,reply.alias+1,reply.alias[0]);
                uplrec.from[reply.alias[0]] = 0;
                uplrec.area_flags |= INF_ALIAS_NAME|INF_ANY_NAME;
            } else
                strcpy((char *) uplrec.from,setup.UsrName);
            if (reply.netattrib & 0x01) uplrec.netmail_attr |= UPL_NETKILL;
            if (reply.netattrib & 0x02) uplrec.netmail_attr |= UPL_NETCRASH;
            uplrec.replyto = reply.msgnumber + ((unsigned long) reply.msghighnumber << 16);

            sprintf(tmp,"%sMSG%s%02d.TXT",setup.replypath,omentag,replies-1);
            search_ign_file(tmp);
            sprintf((char *) uplrec.filename,"%06d.MSG",replies);
            FileRename(tmp,strcat(strcpy(tmp2,setup.replypath),(char *) uplrec.filename));

            /* Write to .UPL file */
            fwrite(&uplrec,sizeof(uplrec),1,Fupl);
        }
        fclose(Frep);
        sprintf(tmp,"%sheader%s.bbs",setup.replypath,omentag);
        FileRemove(search_ign_file(tmp));
    }
}

char *strownupr(char *str)
{
    while (*str != '\0')
    {
        if (*str >= 'a' && *str <= 'z')
            *str -= 32;
        else
        {
            if (*str == '') *str = '';
            else if (*str == '') *str = '';
            else if (*str == '') *str = '';
        }
        str++;
    }

    return str;
}

void omen_packet::close_replypacket(void)
{
    RepRecord reply;
    FILE *Frep;
    char tmp[256],tmp2[256];
    int num,slen;
    unsigned areanum;

    if (!fupl_opened) return;

    /* BW replies -> OMEN replies */
    sprintf(tmp,"%sHEADER%s.BBS",setup.replypath,omentag);
    num = 0;
    if (replies > 0 && (Frep = FileOpen(tmp,"w+b")) != NULL)
    {
        fseek(Fupl,sizeof(UPL_HEADER),SEEK_SET);
        while (fread(&uplrec,sizeof(uplrec),1,Fupl))
        {
            memset(&reply,0,sizeof(reply));
            if (mixedcase == 0)
            {
                strownupr((char *) uplrec.from);
                strownupr((char *) uplrec.to);
            }
            /* Flags */
            if ((uplrec.msg_attr & UPL_INACTIVE) == 0)
                reply.command = 0x01;
            if (uplrec.msg_attr & UPL_PRIVATE)
                reply.command |= 0x10;
            if ((uplrec.area_flags & INF_ALIAS_NAME) || (uplrec.area_flags & INF_ANY_NAME))
                reply.command |= 0x20;

            /* OMEN moderating commands */
            if (uplrec.user_area[0] == 1)
                reply.command = 0x02;
            else if (uplrec.user_area[0] == 2)
                reply.command = 0x04;
            else if (uplrec.user_area[0] == 3)
                reply.command = 0x08;

            slen = strlen((char *) uplrec.from);
            memcpy(reply.alias+1,(char *) uplrec.from,slen); reply.alias[0] = (char) slen;
            slen = strlen((char *) uplrec.to);
            memcpy(reply.whoto+1,(char *) uplrec.to,slen); reply.whoto[0] = (char) slen;
            slen = strlen((char *) uplrec.subj);
            memcpy(reply.subject+1,(char *) uplrec.subj,slen); reply.subject[0] = (char) slen;
            reply.destzone = uplrec.destzone;
            reply.destnet = uplrec.destnet;
            reply.destnode = uplrec.destnode;
            areanum = (unsigned) atol((char *) uplrec.echotag);
            reply.curboard = (unsigned char) (areanum & 0xff);
            reply.moveboard = (unsigned char) (areanum >> 8);
            if (uplrec.user_area[0] == 3)
            {
                /* Move message command .. */
                reply.curhighboard = reply.moveboard;
                areanum = (unsigned) atol((char *) uplrec.net_dest);
                reply.moveboard = (unsigned char) (areanum & 0xff);
                reply.movehighboard = (unsigned char) (areanum >> 8);
            }
            if (uplrec.netmail_attr & UPL_NETKILL) reply.netattrib |= 0x01;
            if (uplrec.netmail_attr & UPL_NETCRASH) reply.netattrib |= 0x02;
            reply.msgnumber = (unsigned short) (uplrec.replyto & 0xffff);
            reply.msghighnumber = (unsigned short) (uplrec.replyto >> 16);

            sprintf(tmp,"%sMSG%s%02d.TXT",setup.replypath,omentag,num);
            if (strcmp((char *) uplrec.filename,tmp) != 0)
                FileRename(strcat(strcpy(tmp2,setup.replypath),(char *) uplrec.filename),tmp);
            num++;

            /* Write to HEADERxx.BBS */
            fwrite(&reply,sizeof(reply),1,Frep);
        }
        fclose(Frep);
    }
    fupl_opened = 0;
    fclose(Fupl);

    /* Remove .UPL file */
    sprintf(tmp,"%sOMEN%s.UPL",setup.replypath,omentag);
    FileRemove(search_ign_file(tmp));
}

char *omen_packet::export_msg(char *out)
{
    FILE *F;
    unsigned num,num2;
    size_t readed;

    strcat(strcpy(out,setup.workpath),"TMP_ANSI.");
    if ((F = FileOpen(out,"w+b")) == NULL) return NULL;

    fseek(Fdat,msgtxtptr,SEEK_SET);
    num2 = msgtxtsize/BUF_SIZE;
    for (num=1; num<=num2; num++) {
        readed = fread(txt_buf,1,BUF_SIZE,Fdat);
        fwrite(txt_buf,1,readed,F);
    }
    readed = fread(txt_buf,1,msgtxtsize % BUF_SIZE,Fdat);
    fwrite(txt_buf,1,readed,F);

    fclose(F);
    return out;
}

void omen_packet::read_arealist(FILE *F)
{
    unsigned anum,astart,area;
    char str[21];
    FILE *Fcnf;

    char areabuf[512],num;

    sprintf(areabuf,"%sselect%s.cnf",setup.replypath,omentag);
    if ((Fcnf = fopen_ign(areabuf,"rt")) == NULL) return;

    /* Write current configuration to area file */
    fseek(F,0,SEEK_SET);
    astart = 0;
    for (area=1; area<=areas; area++)
    {
        if (!area_selected(area))
            areabuf[astart] = 0;
        else
            areabuf[astart] = 2;

        astart++;
        if (astart == sizeof(areabuf))
        {
            astart = 0;
            fwrite(areabuf,1,sizeof(areabuf),F);
        }
    }
    if (astart > 0) fwrite(areabuf,1,astart,F);

    /* Write selectxx.cnf to area file */
    while (_fgets(str,sizeof(str),Fcnf))
    {
        if (sscanf(str,"%u",&anum) == 1)
        {
            sprintf(str,"%u",anum);
            for (area=1; area<=areas; area++)
            {
                if (stricmp(get_area_number(area),str) == 0) break;
            }
            if (area > areas) continue; /* Area not found */

            num = area_selected(area) ? 0 : 1;
            fseek(F,area-1,SEEK_SET);
            fwrite(&num,1,1,F);
        }
    }
    fclose(Fcnf);
}

void omen_packet::write_arealist(FILE *F)
{
    unsigned astart,aend,area;
    char areabuf[512];

    FILE *Fcnf;

    arealist = 1;
    astart = 0; aend = 0;

    sprintf(areabuf,"%sselect%s.cnf",setup.replypath,omentag);
    if ((Fcnf = FileOpen(areabuf,"w+b")) == NULL) return;

    for (area=1; area<=areas; area++)
    {
        if (astart > area || aend < area)
        {
            fseek(F,area-1,SEEK_SET);
            astart = area;
            aend = area+fread(areabuf,1,sizeof(areabuf),F)-1;
        }
        if ((areabuf[area-astart] == 0 && area_selected(area)) || areabuf[area-astart] == 1)
            fprintf(Fcnf,"%s\r\n",get_area_number(area));
    }
    fclose(Fcnf);
}
