#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "pkt_qwk.h"
#include "screen.h"
#include "general.h"
#include "vars.h"
#include "files.h"
#include "bluewave.h"
#include "pkt_obj.h"
#include "readsets.h"

void qwk_packet::put_file(char *name)
{
    char tmp[256];
    struct stat statbuf;

    strcat(strcpy(tmp,setup.workpath),name);
#ifdef __linux__
    search_ign_file(tmp);
#endif
    if (FileStat(tmp, &statbuf) == 0)
    {
        strcpy(ansi_name[ansi_files],name);
        dtstr(ansi_time[ansi_files], *ST_MTIME(&statbuf));
        if (ansi_files < 255) ansi_files++;
    }
}

char qwk_packet::open_packet(char *str)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned char *ndxused;

    FILE *F;
    find_t SR;

    char usr[36],usr1[36],usr2[36];
    char tmp[256],tmp2[13],*pstr,*pstr2;
    unsigned long num;
    size_t slen;
    NDX_REC ndx;
    MIX_REC mixrec;
    INF_AREA_INFO infarea;
    msg_header msghdr;

    char create_indexes;
    long confopen;

    from_to_len = 25;
    subj_len = 25;

    inf_header_slen = sizeof(INF_HEADER);
    inf_area_slen = sizeof(INF_AREA_INFO);

    endwin();
    printf("eieieieie\n");
    exit(1);
    area_start = 0;
    area_end = 0;

    ndxopen = 0;
    if (replymgr)
    {
        dat_start = 1; dat_end = 0; lastarea[0] = '\0'; first_linerec = NULL;
        replyopen = 0; replies = 0; fupl_opened = 0; arealist = 0;

        if ((txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;
        if ((Finfo = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"rb")) == NULL) return 1;
        //setbuf(Finfo,NULL);
        fread(&info,sizeof(info),1,Finfo);
        fseek(Finfo,0,SEEK_END);
        strcpy(username, (char *) info.loginname);
        strcpy(useralias, (char *) info.aliasname);
        strcpy(board_name, (char *) info.systemname);
        strcpy(sysop_name, (char *) info.sysop);
        strcpy(pktname,(char *) info.packet_id);
        areas = (ftell(Finfo)-sizeof(INF_HEADER))/sizeof(INF_AREA_INFO);
        if (areas < MAX_AREAS)
            abufsize = areas;
        else
            abufsize = MAX_AREAS;

        if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL) return 2;

        return 0;
    }

    if ((Finfo = FileOpen(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"w+b")) == NULL) return 1;
    //setbuf(Finfo,NULL);

    know_areas = 0;
    offline_config = 0;
    allow_forwarding = 1;
    remove_replyfile = 1;

    replies = 0;

    curarea = 0;
    
    idxstart = 0;
    idxend = 0;
    

    mixedcase = (setup.packet_flags & PKT_QWK_MIXED_CASE) > 0;
    if ((Fdat = fopen_ign(strcat(strcpy(tmp,setup.workpath),"messages.dat"),"r+b")) == NULL) return 1;
    
    if ((F = fopen_ign(strcat(strcpy(tmp,setup.workpath),"door.id"),"rt")) != NULL)
    {
        offline_config = 0;
        while (_fgets(tmp,sizeof(tmp)-1,F))
        {
            pstr = strchr(tmp,'=');
            if (pstr != NULL)
            {
                *pstr++ = '\0';

                /* Remove trailing spaces */
                pstr2 = pstr-2;
                while (pstr2 > tmp && *pstr2 == ' ') pstr2--;
                *(pstr2+1) = '\0';

                /* Remove forwarding spaces */
                while (*pstr == ' ') pstr++;

                if (strcmp(tmp,"CONTROLNAME") == 0)
                    strcpy(whoto,pstr);
                else if (strcmp(tmp,"CONTROLTYPE") == 0)
                {
                    if ((strcmp(pstr,"ADD") == 0) || (strcmp(pstr,"DROP")) == 0)
                        offline_config++;
                }
                else if (strcmp(tmp,"MIXEDCASE") == 0)
                {
                    if (strcmp(pstr,"YES") == 0) mixedcase = 1;
                }
            }
        }
        fclose(F);
        offline_config = offline_config==2 ? 1 : 0;
    }

    if ((F = fopen_ign(strcat(strcpy(tmp,setup.workpath),"control.dat"),"rt")) == NULL) return 1;
    _fgets(tmp,sizeof(tmp),F); strncpy(board_name,tmp,sizeof(board_name)-1); board_name[sizeof(board_name)-1] = '\0';
    _fgets(tmp,sizeof(tmp),F);
    _fgets(tmp,sizeof(tmp),F);
    _fgets(tmp,sizeof(tmp),F); strncpy(sysop_name,tmp,sizeof(sysop_name)-1); sysop_name[sizeof(sysop_name)-1] = '\0';
    if (strlen(sysop_name) > 7)
        sysop_name[strlen(sysop_name)-7] = '\0';
    _fgets(tmp,sizeof(tmp),F); /* BBSID */
    if ((pstr = strchr(tmp,',')) != NULL)
        strcpy(pktname,pstr+1);
    _fgets(tmp,sizeof(tmp),F);
    _fgets(tmp,sizeof(tmp)-1,F); strncpy(username,tmp,sizeof(username)-1); username[sizeof(username)-1] = '\0';
    _fgets(tmp,sizeof(tmp),F);
    _fgets(tmp,sizeof(tmp),F);
    _fgets(tmp,sizeof(tmp),F);
    _fgets(tmp,sizeof(tmp),F); areas = atol(tmp);
    areas++;

    /* Allocate buffer to read_inf_area() */
    if (areas < MAX_AREAS)
        abufsize = areas;
    else
        abufsize = MAX_AREAS;

    if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL) return 2;

    /* Make INF_HEADER */
    memset(&info,0,sizeof(info));
    info.mashtype = arcfmt;
    info.ver = 0;
    strcpy((char *) info.loginname,username);
    strcpy((char *) info.sysop,sysop_name);
    strcpy((char *) info.systemname,board_name);
    info.from_to_len = 25;
    info.subject_len = 25;
    info.inf_header_len = sizeof(INF_HEADER);
    info.inf_areainfo_len = sizeof(INF_AREA_INFO);
    info.mix_structlen = sizeof(MIX_REC);
    info.fti_structlen = sizeof(FTI_REC);
    info.uses_upl_file = 1;
    info.is_QWK = 1;
    strcpy((char *) info.packet_id,pktname);

    /* Write INF_HEADER */
    fwrite(&info,sizeof(info),1,Finfo);

    /* Write INF_AREA_INFO records */
    for (num=0; num<areas; num++)
    {
        memset(&infarea, 0, sizeof(infarea));
        _fgets(tmp, sizeof(tmp), F);
        strncpy((char *) infarea.areanum, tmp, sizeof(infarea.areanum)-1);
        strcpy((char *) infarea.echotag, (char *) infarea.areanum);
        _fgets(tmp,sizeof(tmp), F);
        strncpy((char *) infarea.title, tmp, sizeof(infarea.title)-1);
        infarea.title[sizeof(infarea.title)-1] = 0;
        infarea.area_flags = INF_POST | INF_ANY_NAME;
        fwrite(&infarea, sizeof(infarea), 1, Finfo);
    }

    _fgets(tmp2,sizeof(tmp2),F);
    if (exists(strcat(strcpy(tmp,setup.workpath),tmp2))) put_file(tmp2);
    _fgets(tmp2,sizeof(tmp2),F);
    if (exists(strcat(strcpy(tmp,setup.workpath),tmp2))) put_file(tmp2);
    _fgets(tmp2,sizeof(tmp2),F);
    if (exists(strcat(strcpy(tmp,setup.workpath),tmp2))) put_file(tmp2);
    fclose(F);

    ansi_files = 0;

    if (_dos_findfirst(strcat(strcpy(tmp,setup.workpath),"blt-*.*"),0,&SR) == 0)
        do {
            put_file(SR.name);
        } while (_dos_findnext(&SR) == 0);
#ifdef FIND_CLOSE
    _dos_findclose(&SR);
#endif
    
    if (_dos_findfirst(strcat(strcpy(tmp,setup.workpath),"*.txt"),0,&SR) == 0)
        do {
            put_file(SR.name);
        } while (_dos_findnext(&SR) == 0);
#ifdef FIND_CLOSE
    _dos_findclose(&SR);
#endif
    
    /* Check if indexes should be created */
    if (_dos_findfirst(strcat(strcpy(tmp,setup.workpath),"*.ndx"),0,&SR) == 0) {
        if (setup.packet_flags & PKT_QWK_INDEXES_ALWAYS) {
            create_indexes = 1;
            do {
                FileRemove(strcat(strcpy(tmp,setup.workpath),SR.name));
            } while (_dos_findnext(&SR) == 0);
        } else
            create_indexes = 0;
#ifdef __FIND_CLOSE
        _dos_findclose(&SR);
#endif
    } else
        create_indexes = 1;

    /* Create QWK indexes */
    if (create_indexes) {
        save_scr(&cx,&cy,&oldscr);
        slen = strlen(lang[27]);
        if (strlen(lang[28])+2 > slen) slen = strlen(lang[28])+2;
        draw_shaded_box(scrwidth/2-slen/2-2,10,scrwidth/2+slen/2+2,14,color[col_box_frame],color[col_box_title],lang[27]);
        fseek(Fdat,128,SEEK_SET);
        confopen = -1;
        while (fread(&msghdr,sizeof(msghdr),1,Fdat))
        {
            if (confopen != msghdr.conf)
            {
                if (confopen != -1)
                    fclose(Fndx);

                tbar(scrwidth/2-slen/2-1,12,scrwidth/2+slen/2+1,12,color[col_box_text]);
                sprintf(tmp,lang[28],msghdr.conf);
                cmiddle(12,tmp,color[col_box_text]);
                sprintf(tmp,"%s%03u.ndx",setup.workpath,msghdr.conf);
                if ((Fndx = FileOpen(tmp,"a+b")) == NULL)
                {
                    confopen = -1;
                    continue;
                }
                confopen = msghdr.conf;
            }
            ndx.pos = long2basicreal(ftell(Fdat)/128);
            ndx.conf = (char) msghdr.conf;
            fwrite(&ndx,sizeof(ndx),1,Fndx);

            memcpy(tmp,msghdr.blocks,sizeof(msghdr.blocks)); get_qwk_str(tmp,sizeof(msghdr.blocks));
            fseek(Fdat,(atol(tmp)-1)*128,SEEK_CUR);
        }
        if (confopen != -1)
            fclose(Fndx);
        old_scr(cx,cy,&oldscr);
    }

    read_setup(NULL); /* To get opt.alias work right.. */
    strcpy(usr1,username);
    strcpy(usr2,opt.alias);

    msgptr = 0;
    /* Create BW style .MIX file */
    sprintf(tmp,"%s%s.mix",setup.workpath,pktname);
    if ((Fmix = FileOpen(tmp,"w+b")) == NULL) return 4;

    if (_dos_findfirst(strcat(strcpy(tmp,setup.workpath),"*.ndx"),0,&SR) == 0)
    {
        /* .NDX files found from msg packet */
        if ((ndxused = (unsigned char *) malloc(8192)) == NULL) return 2;
        memset(ndxused,0,8192);

        do {
            SR.name[strlen(SR.name)-4] = 0;
            if (sscanf(SR.name,"%lu",&num) != 1) continue;
            ndxused[num >> 3] |= (unsigned char) (1 << (num & 7));
        } while (_dos_findnext(&SR) == 0);
#ifdef __FIND_CLOSE
        _dos_findclose(&SR);
#endif

        for (num=0; num<65536; num++)
        {
            if (ndxused[num >> 3] & (1 << (num & 7)))
            {
                memset(&mixrec,0,sizeof(mixrec));
                mixrec.msghptr = msgptr;

                sprintf((char *) mixrec.areanum,"%lu",num);

                sprintf(tmp,"%s%03li.ndx",setup.workpath,num);
                F = fopen_ign(tmp,"rb");
                if (F != NULL)
                {
                    /* Find personal messages */
                    while (fread(&ndx,sizeof(ndx),1,F))
                    {
                        ndx.pos = basicreal2long(ndx.pos);
                        fseek(Fdat,(ndx.pos-1)*128,SEEK_SET);
                        if (fread(&msghdr,sizeof(msghdr),1,Fdat))
                        {
                            memcpy(usr,msghdr.mto,25); get_qwk_str(usr,25);
                            if ((stricmp(usr,usr1) == 0) || (stricmp(usr,usr2) == 0))
                                mixrec.numpers++;
                        }
                    }
                    mixrec.totmsgs = (unsigned short) (ftell(F) / sizeof(ndx));
                    fclose(F);
                }
                fwrite(&mixrec,sizeof(mixrec),1,Fmix);
                msgptr += mixrec.totmsgs;
            }
        }
        free(ndxused);
    }
    fflush(Fmix);
    //setbuf(Fmix,NULL);

    return offline_packet::open_packet(str);
}

void qwk_packet::close_packet(void)
{
    fclose(Finfo);
    free(area_buf);

    if (replymgr)
    {
        free(txt_buf);
        return;
    }

    /* Close files */
    fclose(Fdat);
    fclose(Fmix);
    if (ndxopen > 0)
        free(ndxarr);

    offline_packet::close_packet();
}

void qwk_packet::open_replypacket(void)
{
    char tmp[256],output[256];
    unsigned blocks,pos,nro,wpos;
    struct tm tim;

    FILE *Frep,*F;

    msg_header replyhdr;

    if (fupl_opened) return;

    replies = 0;

    /* Convert QWK reply packet to Blue Wave reply packet format */

    replyopen = 0;
    if ((Fupl = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".upl"),"r+b")) != NULL)
    {
        fseek(Fupl,0,SEEK_END);
        if (ftell(Fupl) >= sizeof(UPL_HEADER))
        {
            replies = (ftell(Fupl)-sizeof(UPL_HEADER))/sizeof(UPL_REC);
            fupl_opened = 1;
            return;
        }
        fclose(Fupl);
    }
    if ((Fupl = FileOpen(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".upl"),"w+b")) == NULL) return;

    memset(&uplheader,0,sizeof(uplheader));
    fwrite(&uplheader,sizeof(uplheader),1,Fupl);
    fupl_opened = 1;

    if ((Frep = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".msg"),"rb")) == NULL) return;

    fread(&replyhdr,sizeof(replyhdr),1,Frep);
    while (fread(&replyhdr,sizeof(replyhdr),1,Frep))
    {
        memset(&uplrec,0,sizeof(uplrec));
        replies++;

        memcpy(tmp,replyhdr.blocks,6); get_qwk_str(tmp,6);
        blocks = atol(tmp);

        /* Filename & echotag */
        sprintf((char *) uplrec.filename,"%06i.msg",replies);
        sprintf((char *) uplrec.echotag,"%u",replyhdr.conf);

        /* From, To & Subject */
        memcpy(uplrec.from,replyhdr.mfrom,25); get_qwk_str((char *) uplrec.from,25);
        memcpy(uplrec.to,replyhdr.mto,25); get_qwk_str((char *) uplrec.to,25);
        memcpy(uplrec.subj,replyhdr.subj,25); get_qwk_str((char *) uplrec.subj,25);

        /* Date & Time */
        memset(&tim,0,sizeof(tim));
        tim.tm_mday = (replyhdr.date[3]-'0')*10 + (replyhdr.date[4]-'0');
        tim.tm_mon = (replyhdr.date[0]-'0')*10 + (replyhdr.date[1]-'0');
        tim.tm_year = (replyhdr.date[6]-'0')*10 + (replyhdr.date[7]-'0');
        tim.tm_hour = (replyhdr.time[0]-'0')*10 + (replyhdr.time[1]-'0');
        tim.tm_min = (replyhdr.time[3]-'0')*10 + (replyhdr.time[4]-'0');
        tim.tm_sec = 0;
        uplrec.unix_date = mktime(&tim);

        /* Reply to */
        memcpy(tmp,replyhdr.reply,sizeof(replyhdr.reply)); get_qwk_str(tmp,sizeof(replyhdr.reply));
        uplrec.replyto = atol(tmp);

        /* Private, deleted ? */
        uplrec.msg_attr = 0;
        if (replyhdr.flag == '*') uplrec.msg_attr |= UPL_PRIVATE;
        if ((unsigned char) replyhdr.active == 226) uplrec.msg_attr |= UPL_INACTIVE;

        /* Reply text */
        if ((F = FileOpen(strcat(strcpy(tmp,setup.replypath),(char *) uplrec.filename),"w+b")) == NULL) return;

        while (blocks > 2)
        {
            if (!fread(tmp,128,1,Frep)) break;
            wpos = 0;
            for (nro=0; nro<128; nro++)
            {
                if ((unsigned char) tmp[nro] == 227)
                {
                    output[wpos] = 13;
                    wpos++;
                    output[wpos] = 10;
                }
                else
                {
                    output[wpos] = tmp[nro];
                }
                wpos++;
            }
            fwrite(output,1,wpos,F);
            blocks--;
        }

        /* And the last block.. Also removes all the spaces. */
        if (fread(tmp,128,1,Frep))
        {
            for (pos=127; pos>0; pos--)
                if ((tmp[pos] != ' ') && (tmp[pos] != 0))
                {
                    wpos = 0;
                    for (nro=0; nro<=pos; nro++)
                    {
                        if ((unsigned char) tmp[nro] == 227)
                        {
                            output[wpos] = 13;
                            wpos++;
                            output[wpos] = 10;
                        }
                        else
                        {
                            output[wpos] = tmp[nro];
                        }
                        wpos++;
                    }
                    fwrite(output,1,wpos,F);
                    break;
                }
        }
        fclose(F);
        fwrite(&uplrec,sizeof(uplrec),1,Fupl);
    }
    fclose(Frep);
    sprintf(tmp, "%s%s.msg", setup.replypath, pktname);
#ifdef __linux__
    search_ign_file(tmp);
#endif
    FileRemove(tmp);
}

void qwk_packet::close_replypacket(void)
{
    char str[21],buf[256],buf2[256];
    unsigned num,bufsz;
    struct tm *tim;

    FILE *Frep,*F;
    size_t readed;
    long totalsize,blocks,oldFpos;

    msg_header replyhdr;


    if (!fupl_opened) return;
    
    fupl_opened = 0;
    
    /* No replies, quit */
    if (replies == 0)
    {
        fclose(Fupl);

        /* Remove .UPL file */
        FileRemove(strcat(strcat(strcpy(buf,setup.replypath),pktname),".upl"));
        return;
    }

    /* Open QWK reply file */
    if ((Frep = FileOpen(strcat(strcat(strcpy(buf,setup.replypath),pktname),".msg"),"w+b")) == NULL)
    {
        fclose(Fupl);

        /* Remove .UPL file */
        FileRemove(strcat(strcat(strcpy(buf,setup.replypath),pktname),".upl"));
        return;
    }

    /* QWK reply file header */
    memset(&replyhdr,32,sizeof(replyhdr));
    memcpy(&replyhdr,pktname,strlen(pktname));
    fwrite(&replyhdr,128,1,Frep);

    /* BW reply files -> QWK reply file */
    fseek(Fupl,sizeof(UPL_HEADER),SEEK_SET);
    while (fread(&uplrec,sizeof(uplrec),1,Fupl))
    {
        memset(&replyhdr,32,sizeof(replyhdr));

        /* From, to and subject */
        if (mixedcase == 0)
        {
            strupr((char *) uplrec.from);
            strupr((char *) uplrec.to);
        }
        memcpy(replyhdr.mfrom,(char *) uplrec.from,strlen((char *) uplrec.from));
        memcpy(replyhdr.mto,(char *) uplrec.to,strlen((char *) uplrec.to));
        memcpy(replyhdr.subj,uplrec.subj,strlen((char *) uplrec.subj));

        /* Date and time */
        tim = localtime((time_t *) &uplrec.unix_date);
        sprintf(str,"%02d-%02d-%02d",tim->tm_mon+1,tim->tm_mday+1,tim->tm_year%100);
        memcpy(replyhdr.date,str,strlen(str));

        sprintf(str,"%02d:%02d",tim->tm_hour,tim->tm_min);
        memcpy(replyhdr.time,str,strlen(str));

        /* Reply to */
        sprintf(str,"%lu",uplrec.replyto);
        memcpy(replyhdr.reply,str,strlen(str));

        /* Reply area */
        sprintf(str,"%s",(char *) uplrec.echotag);
        memcpy(replyhdr.num,str,strlen(str));
        replyhdr.conf = (unsigned short) atol(str);

        /* Flags */
        replyhdr.active = 225;
        if (uplrec.msg_attr & UPL_PRIVATE)
            replyhdr.flag = '*';

        /* Reply text file -> QWK reply file */

        if ((F = fopen_ign(strcat(strcpy(buf,setup.replypath),(char *) uplrec.filename),"rb")) != NULL)
        {
            /* Write QWK reply header */
            oldFpos = ftell(Frep);
            fwrite(&replyhdr,sizeof(replyhdr),1,Frep);

            /* Then the reply text... */
            totalsize = 0;
            while ((readed = fread(buf2,1,128,F)) > 0)
            {
                bufsz = 0;
                for (num=0; num<readed; num++)
                {
                    /* CR to #227 */
                    if (buf2[num] == 13)
                    {
                        buf[bufsz] = 227; bufsz++;
                    }
                    else
                    {
                        if (buf2[num] != 10) { /* Ignore LF */
                            buf[bufsz] = buf2[num];
                            bufsz++;
                        }
                    }
                }
                if (bufsz > 0) {
                    /* Write buffer */
                    fwrite(buf,1,bufsz,Frep);
                    totalsize += bufsz;
                }
            }
            fclose(F);

            /* Pad text always to 128 chars */
            blocks = 1 + (totalsize/128);
            if (totalsize & 127) {
                blocks++;
                memset(buf,32,128);
                fwrite(buf,1,128 - (totalsize & 127),Frep);
            }
            sprintf(str,"%lu",blocks);
            memcpy(replyhdr.blocks,str,strlen(str));

            /* Remove BW reply text */
            if (strcmp((char *) uplrec.filename, "ADD.MSG") != 0 && strcmp((char *) uplrec.filename, "DROP.MSG") != 0)
                FileRemove(strcat(strcpy(buf,setup.replypath),(char *) uplrec.filename));

            /* Update replyhdr.blocks.. */
            fseek(Frep,oldFpos,SEEK_SET);
            fwrite(&replyhdr,sizeof(replyhdr),1,Frep);
            fseek(Frep,0,SEEK_END);
        }
    }
    fclose(Fupl);
    fclose(Frep);

    /* Remove .UPL file */
    FileRemove(strcat(strcat(strcpy(buf,setup.replypath),pktname),".upl"));
}
