#ifdef __OS2__
#  define INCL_VIO
#  include <os2.h>
#elif defined (__NT__)
#  include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "scrolbox.h"
#include "readfunc.h"
#include "readmail.h"
#include "readrepl.h"
#include "readsets.h"
#include "general.h"
#include "screen.h"
#include "readarea.h"
#include "entermsg.h"
#include "writemsg.h"
#include "files.h"
#include "vars.h"
#include "keyb.h"
#include "scrsaver.h"

#define ispunc(c) (((c) <= 47) || (((c) >= 58) && ((c) <= 64)) || (((c) >= 91) && ((c) <= 96)) || (((c) >= 123) && ((c) <= 126)))

#ifdef __linux__
#  define CHECK 'x'
#else
#  define CHECK ''
#endif

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != 0)
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

char zip_to_reply(void)
{
    unsigned num;
    char str[80];

    if (!try_open_reply()) return 0;
    if (area < 0)
        strcpy(str,pkt->get_area_tag(pkt, pers.area));
    else
        strcpy(str,pkt->get_area_tag(pkt, area));

    for (num=1; num<=pkt->replies; num++)
    {
        pkt->read_reply(pkt, num);
        if ((reply.replyto == msg.mnum) && (strcmp(str,reply.area) == 0))
        {
            read_replies(num);
            return 1;
        }
    }
    return 0;
}

void reply_another(char orig, char newmsg, char forw)
{
    unsigned short cx,cy;
    char *oldscr;
    
    char msgto[36],astr[61],*strp;
    unsigned num,_area,max;
    
    char priv;
    
    int ypos;
    unsigned upy;
    XTI_REC xti;
    
    if (forw)
        tran(strcpy(msgto,"All"));
    else {
        if (orig)
            tran(strcpy(msgto,msg.mto));
        else
            tran(strcpy(msgto,msg.mfrom));
    }
        
    replyanother = 1;
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    max = scrwidth-36; if (max > 60) max = 60;
    cwritexy(18+max,4,lang[100],color[col_area_help]);
    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    ypos = 1; upy = origarea-1;
    if (pkt->areas-upy < scrsize-7) max = pkt->areas-upy; else max = scrsize-7;

    for (num=1; num<=max; num++)
        draw_line_em(num+5,num+upy);
    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

    area_list_em(0,&ypos,&upy);
    _area = ypos+upy;
    if ((ypos == 0) || (!try_open_reply()))
    {
        old_scr(cx,cy,&oldscr);
        return;
    }

    if (_area == origarea) replyanother = 0;

    read_setup(pkt->get_area_tag(pkt, _area));
    read_table(0,outbound,opt.outtable);

    num = pkt->area_type(pkt, _area);
    if ((num & TYPE_NOPVT) > 0)
        priv = 0;
    else
    {
        if ((num & TYPE_NOPUB) > 0)
            priv = 1;
        else
            priv = (msg.flags & flag_private) > 0;
    }

    strcpy(astr, pkt->get_area_tag(pkt, _area));

    if (newmsg)
    {
        num = pkt->area_type(pkt, _area);
        if ((num & TYPE_NOPVT) > 0)
            priv = 0;
        else
        {
            if ((num & TYPE_NOPUB) > 0)
                priv = 1;
            else
                priv = 0;
        }

        if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
            write_msg(0,astr,pkt->get_area_name(pkt, _area),NULL,priv,0,0);
        else
            write_msg(0,astr,"All",NULL,priv,0,0);
    }
    else
    {
        if (area < 0)
            pkt->area_flags(pkt, pers.msgnum,&xti);
        else
            pkt->area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);

        if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
            strp = pkt->get_area_name(pkt, _area);
        else
            strp = msgto;

        if (write_msg(msg.mnum,astr,strp,tran(msg.subj),priv,(char) (forw*2+1),(xti.flags & XTI_IS_PERSONAL) > 0))
        {
            if (area < 0)
            {
                xti.flags |= XTI_HAS_REPLIED;
                pkt->save_area_flags(pkt, pers.msgnum,&xti);
            }
            else
            {
                xti.flags |= XTI_HAS_REPLIED;
                pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
            }
        }
    }
    old_scr(cx,cy,&oldscr);
    replyanother = 0;
    read_setup(pkt->get_area_tag(pkt, origarea));
    read_table(0,outbound,opt.outtable);
}

typedef struct NET_AREA_REC
{
    struct NET_AREA_REC *next;
    unsigned areanum;
}
NET_AREA_REC;

static NET_AREA_REC *net_first,*net_rec;
static unsigned net_pos;

int get_net_area(unsigned pos)
{
    if (pos != net_pos)
    {
        if (net_pos > pos || net_rec == NULL)
        {
            net_pos = 1;
            net_rec = net_first;
        }
        while (net_pos < pos)
        {
            net_pos++;
            net_rec = net_rec->next;
            if (net_rec == NULL) return 0;
        }
    }
    return 1;
}

void draw_netmail_line(unsigned ypos, unsigned pos)
{
    char str[81];
    unsigned area;

    tbar(scrwidth/2-36,ypos,scrwidth/2+36,ypos,color[col_area_name]);

    if (!get_net_area(pos)) return;
    area = net_rec->areanum;

    /* Number */
    strcpy(str,pkt->get_area_number(pkt, area));
    cwritexy(scrwidth/2-30-strlen(str),ypos,str,color[col_area_number]);

    /* Net/E-Mail */
    if (pkt->area_type(pkt, area) & TYPE_INET)
        cwritexy(scrwidth/2-29,ypos,"EMail",color[col_area_type]);
    else if (pkt->area_type(pkt, area) & TYPE_ECHO)
        cwritexy(scrwidth/2-29,ypos,"Net",color[col_area_type]);
    else
        cwritexy(scrwidth/2-29,ypos,"Local",color[col_area_type]);

    /* Name */
    tran(strcpy(str,pkt->get_area_name(pkt, area))); str[41] = '\0';
    cwritexy(scrwidth/2-22,ypos,str,color[col_area_name]);

    /* Tag */
    tran(strcpy(str,pkt->get_area_tag(pkt, area))); str[15] = '\0';
    cwritexy(scrwidth/2+20,ypos,str,color[col_area_tagname]);
}

int is_net_name(unsigned area)
{
    char name[41];

    strupr(strncpy(name,pkt->get_area_name(pkt, area),40)); name[40] = '\0';
    if (strstr(name,"NETMAIL") != NULL) return 1;
    if (strstr(name,"E-MAIL") != NULL) return 1;
    if (strstr(name,"EMAIL") != NULL) return 1;
    return 0;
}

int is_email_area(unsigned area)
{
    char name[41];

    strupr(strncpy(name,pkt->get_area_name(pkt, area),40)); name[40] = '\0';
    if (strstr(name,"E-MAIL") != NULL) return 1;
    if (strstr(name,"EMAIL") != NULL) return 1;
    return 0;
}

extern int reply_email; // great, the perfect coding! who cares, i'll delete this code soon anyway.
extern char reply_email_addr[100];

void reply_netmail(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char msgto[36],astr[81],*strp;
    unsigned num,max;
    unsigned netarea,netareas;

    char priv;
    int slen, loc;
    XTI_REC xti;

    NET_AREA_REC *tmpnet;
    SCROLL_BOX scrbox;

    tran(strcpy(msgto,msg.mfrom));

    netareas = 0;
    netarea = 0;
    max = pkt->area_type(pkt, area);
    loc = (max & TYPE_ECHO) == 0  && (max & TYPE_INET) == 0 && (max & TYPE_NET) == 0;
    max = 0;

    net_rec = NULL;
    replyanother = 1;
    for (num=1; num<=pkt->areas; num++)
    {
        max = pkt->area_type(pkt, num);
        if ((loc && (max & TYPE_NOPUB)) || (((max & TYPE_NET) && (max & TYPE_ECHO)) || ((fmt == format_qwk || fmt == format_omen) && is_net_name(num))))
        {
            netareas++;
            tmpnet = (NET_AREA_REC *) malloc(sizeof(NET_AREA_REC));
            if (net_rec != NULL) net_rec->next = tmpnet; else net_first = tmpnet;
            net_rec = tmpnet;
            net_rec->areanum = num;
            net_rec->next = NULL;
        }
    }

    if (netareas == 1)
    {
        netarea = net_first->areanum;
        free(net_first);
        netareas = 0;
    }

    if (netareas > 1)
    {
        net_pos = 1;
        net_rec = net_first;

        save_scr(&cx,&cy,&oldscr);
        draw_shaded_box(scrwidth/2-37,5,scrwidth/2+37,scrsize-3,color[col_area_frame],color[col_area_title],"Select Netmail/E-Mail area");
        draw_hline(scrwidth/2-37,scrwidth/2+37,7,color[col_area_frame]);
        cwritexy(scrwidth/2-35,6,lang[101],color[col_area_help]);

        /* Ask which area to use */
        memset(&scrbox,0,sizeof(scrbox));
        scrbox.ypos = 1;
        scrbox.upy = 0;
        scrbox.xstart = scrwidth/2-36;
        scrbox.xend = scrwidth/2+36;
        scrbox.ystart = 8;
        scrbox.yend = scrsize-4;
        scrbox.lines = &netareas;
        scrbox.scrollbar_color = color[col_area_selectbar];
        scrbox.background_color = color[col_area_name];
        scrbox.draw_func = (DRAW_FUNC) draw_netmail_line;
        netarea = scroll_box(&scrbox);
        if (netarea > 0 && get_net_area(netarea)) netarea = net_rec->areanum;
        deinit_scroll_box(&scrbox);

        old_scr(cx,cy,&oldscr);

        /* Release memory */
        while (net_first != NULL)
        {
            tmpnet = net_first->next;
            free(net_first);
            net_first = tmpnet;
        }
    }

    if (netarea > 0)
    {
        /* Area found, write here */
        if (!try_open_reply())
        {
            replyanother = 0;
            return;
        }
        if (netarea != origarea) replyanother = 1;

        read_setup(pkt->get_area_tag(pkt, netarea));
        read_table(0,outbound,opt.outtable);

        if (max & TYPE_NOPVT)
            priv = 0;
        else
        {
            if (max & TYPE_NOPUB)
                priv = 1;
            else
                priv = (msg.flags & flag_private) > 0;
        }

        strcpy(astr, pkt->get_area_tag(pkt, netarea));

        if (area < 0)
            pkt->area_flags(pkt, pers.msgnum,&xti);
        else
            pkt->area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);

        strp = (reply_email && pkt->area_type(pkt, netarea) & TYPE_INET) ? reply_email_addr : msgto;
        if (write_msg(msg.mnum,astr,strp,tran(msg.subj),priv,1,(xti.flags & XTI_IS_PERSONAL) > 0))
        {
            if (area < 0)
            {
                xti.flags |= XTI_HAS_REPLIED;
                pkt->save_area_flags(pkt, pers.msgnum,&xti);
            }
            else
            {
                xti.flags |= XTI_HAS_REPLIED;
                pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
            }
        }

        read_setup(pkt->get_area_tag(pkt, origarea));
        read_table(0,outbound,opt.outtable);
        replyanother = 0;
        return;
    }

    if (netareas == 0)
    {
        save_scr(&cx,&cy,&oldscr);
        slen = strlen(lang[102])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[102],color[col_warn_hilight]);
        try_key(3);
        old_scr(cx,cy,&oldscr);
    }
    replyanother = 0;
}

void forward_msg(void)
{
    unsigned short cx,cy;
    char *oldscr;
    int slen;

    if (!pkt->allow_forwarding)
    {
        save_scr(&cx,&cy,&oldscr);
        slen = strlen(lang[103])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[103],color[col_warn_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return;
    }

    reply_another(0,0,1);
    replyanother = 0;
}

void turn_flag(unsigned char flag)
{
    XTI_REC xti;
    if (area < 0)
    {
        fseek(Fpers,(sortrec[ra_ypos+ra_upy-1]-1)*sizeof(pers_rec),SEEK_SET);
        fread(&pers,sizeof(pers_rec),1,Fpers);
        pkt->open_area(pkt, pkt->get_area_number(pkt, pers.area));
        pkt->area_flags(pkt, pers.msgnum,&xti);
    } else pkt->area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);

    xti.flags ^= flag;

    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,&xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);

    draw_line_ra(ra_ypos+3,ra_ypos+ra_upy);
    tattrbar(2,ra_ypos+3,scrwidth-1,ra_ypos+3,color[col_list_selectbar]);
}

void turn_mark(unsigned char flag)
{
    XTI_REC xti;
    if (area < 0)
    {
        fseek(Fpers,(sortrec[ra_ypos+ra_upy-1]-1)*sizeof(pers_rec),SEEK_SET);
        fread(&pers,sizeof(pers_rec),1,Fpers);
        pkt->open_area(pkt, pkt->get_area_number(pkt, pers.area));
        pkt->area_flags(pkt, pers.msgnum,&xti);
    } else pkt->area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);

    xti.marks ^= flag;

    if (area<0)
        pkt->save_area_flags(pkt, pers.msgnum,&xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
    
    draw_line_ra(ra_ypos+3,ra_ypos+ra_upy);
    tattrbar(2,ra_ypos+3,scrwidth-1,ra_ypos+3,color[col_list_selectbar]);
}

void steal_tagline(char ask, long typos)
{
    unsigned short cx,cy;
    char *oldscr;

    char str[256],tagline[256],upstr[91],fname[256],*pstr;
    char field,quit,ch;
    unsigned info,num,num2,slen,xstart,xpos,ypos;

    FILE *Ftext;


    ypos = 0;
    if (opt.adoptfile[0] == 0)
        strcpy(fname,opt.tagfile);
    else
        strcpy(fname,opt.adoptfile);

    for (num=pkt->txt_lines; num>=1; num--)
    {
        pkt->read_line(pkt, str,num);

        if ((str[0] == '.') && (str[1] == '.') && (str[2] == '.') && (str[3] == ' ')) {
            pstr = str+4;
            tran(pstr);
        __steal_it:
            save_scr(&cx,&cy,&oldscr);
            
            info = 0;
            if (ask) {
                draw_shaded_box(scrwidth/2-38,12,scrwidth/2+38,19,color[col_info_frame],color[col_info_title],lang[105]);
                cwritexy(scrwidth/2-37,14,lang[106],color[col_info_hilight]);
                cwritexy(scrwidth/2-37,15,lang[107],color[col_info_hilight]);
                cwritexy(scrwidth/2-31,15,fname,color[col_info_text]);
                keyb_keys = 1; keys[0] = 'C';
                cwritexy(scrwidth/2-22,17,"Alt-C",color[col_info_hilight]);
                cwritexy(scrwidth/2-16,17,lang[108],color[col_info_text]);
                field = 0; key_xpos = 0; key_xovr = 0;
                do {
                    if (field == 0)
                        info = get_string(scrwidth/2-31,14,75,68,pstr,4+8+128,color[col_info_text],color[col_info_hilight],0);
                    else
                        info = get_string(scrwidth/2-31,15,80,68,fname,4+8+128,color[col_info_text],color[col_info_hilight],0);
                    
                    if (key_found == 'C')
                    {
                        old_scr(cx,cy,&oldscr);
                        save_scr(&cx,&cy,&oldscr);
                        tbar(1,5,scrwidth,5,color[col_warn_hilight]);
                        cmiddle(5,lang[109],color[col_warn_hilight]);
                        cursorsize(c_height-2,c_height-2);
                        get_attr(1,scrwidth,ypos,str);
                        quit = 0; info = 0; ypos = 7; xpos = 1; xstart = 1;
                        gotoxy(xpos,ypos); tagline[0] = 0;
                        while (!quit)
                        {
                            if (sk_kbhit())
                            {
                                ch = sk_getch();
                                switch (ch)
                                {
                                    case 0:
                                        ch = sk_getch();
                                        switch (ch)
                                        {
                                            case 'H':
                                                if ((!info) && (ypos > 7))
                                                {
                                                    ypos--;
                                                    gotoxy(xpos,ypos);
                                                    get_attr(1,scrwidth,ypos,str);
                                                }
                                                break;
                                            case 'P':
                                                if ((!info) && (ypos < scrsize))
                                                {
                                                    ypos++;
                                                    gotoxy(xpos,ypos);
                                                    get_attr(1,scrwidth,ypos,str);
                                                }
                                                break;
                                            case 'K':
                                                /* Left */
                                                if ((xpos > 1) && ((!info) || (xpos > xstart)))
                                                {
                                                    if (info) tattr(xpos,ypos,str[xpos-1]);
                                                    xpos--;
                                                    gotoxy(xpos,ypos);
                                                }
                                                break;
                                            case 'M':
                                                /* Right */
                                                pkt->read_line(pkt, NULL,typos+ypos-6);
                                                if (!info || (typos+ypos-6 < pkt->txt_lines && xpos < pkt->linerec->len))
                                                {
                                                    xpos++;
                                                    gotoxy(xpos,ypos);
                                                    if (info) tattr(xpos,ypos,7 << 4);
                                                }
                                                break;
                                            case 'O':
                                                pkt->read_line(pkt, NULL,typos+ypos-6);
                                                if (!info || xpos < pkt->linerec->len)
                                                {
                                                    xpos = pkt->linerec->len;
                                                    if (xpos < xstart) xpos = xstart;
                                                    gotoxy(xpos,ypos);
                                                    if (info) tattrbar(xstart,ypos,xpos,ypos,7 << 4);
                                                }
                                                break;
                                            case 'Q':
                                                if (!info && ypos < scrsize)
                                                {
                                                    ypos = scrsize;
                                                    gotoxy(xpos,ypos);
                                                    get_attr(1,scrwidth,ypos,str);
                                                }
                                                break;
                                            case 'G':
                                                if (xpos > 1)
                                                {
                                                    if (info)
                                                        for (num2=xstart+1; num2<=xpos; num2++)
                                                            tattr(num2,ypos,str[num2-1]);
                                                    xpos = xstart;
                                                    gotoxy(xpos,ypos);
                                                }
                                                break;
                                            case 'I':
                                                if ((!info) && (ypos > 7))
                                                {
                                                    ypos = 7;
                                                    gotoxy(xpos,ypos);
                                                    get_attr(1,scrwidth,ypos,str);
                                                }
                                                break;
                                        }
                                        break;
                                    case 13:
                                        info++;
                                        if (info == 2)
                                            quit = 1;
                                        else
                                        {
                                            xstart = xpos;
                                            tattr(xpos,ypos,7 << 4);
                                            tbar(1,5,scrwidth,5,color[col_warn_hilight]);
                                            cmiddle(5,lang[110],color[col_warn_hilight]);
                                        }
                                        break;
                                    case 27:
                                        quit = 1;
                                        break;
                                }
                            } else give_timeslice();
                        }
                        if (info == 2)
                        {
                            pkt->read_line(pkt, tagline,typos+ypos-6);
                            strcpy(str,tagline+xstart-1);
                            str[xpos-xstart+1] = 0;
                            str[75] = 0;
                        } else str[0] = 0;
                        nocursor();
                        old_scr(cx,cy,&oldscr);
                        if (str[0] != 0) {
                            pstr = str;
                            goto __steal_it;
                        }
                        gotoxy(1,1);
                        return;
                    } else
                        field = !field;
                } while ((info == 1) || (info == 2));
            } else {
                draw_shaded_box(scrwidth/2-38,12,scrwidth/2+38,16,color[col_info_frame],color[col_info_title],lang[112]);
                cmiddle(14,pstr,color[col_info_hilight]);
                try_key(2);
            }
            
            if (!((info == 5) || (*pstr == 0))) {
                if ((Ftext = FileOpen(fname,"r+t")) != NULL) {
                    strupr(strcpy(upstr,pstr));
                    while (fgets(tagline,80,Ftext) != NULL) {
                        info = strlen(tagline);
                        if (tagline[info-1] == '\n') tagline[info-1] = 0;
                        strupr(tagline);
                        if (strcmp(tagline,upstr) == 0) {
                            slen = strlen(lang[111])/2;
                            draw_shaded_box(scrwidth/2-slen-2,9,scrwidth/2+slen+2,13,color[col_warn_frame],color[col_warn_title],NULL);
                            cmiddle(11,lang[111],color[col_warn_hilight]);
                            try_key(2);
                            old_scr(cx,cy,&oldscr);
                            fclose(Ftext);
                            return;
                        }
                    }
                } else
                    if ((Ftext = FileOpen(fname,"w+t")) == NULL) {
                        old_scr(cx,cy,&oldscr);
                        return;
                    }
                
                fprintf(Ftext,"%s\n",pstr);
                fclose(Ftext);
            }
            old_scr(cx,cy,&oldscr);
            return;
        }
    }
    
    if (ask) {
        pstr = str;
        str[0] = 0;
        goto __steal_it;
    }
    
    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-18,12,scrwidth/2+18,16,color[col_warn_frame],color[col_warn_title],NULL);
    cmiddle(14,lang[113],color[col_warn_hilight]);
    try_key(2);
    old_scr(cx,cy,&oldscr);
}

void toggle_replyflag(XTI_REC *xti)
{
    char col;
    
    if (xti->flags & XTI_HAS_REPLIED)
        col = color[col_msg_flags_off];
    else
        col = color[col_msg_flags_on];
    
    xti->flags ^= XTI_HAS_REPLIED;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(58,2,"Replied",col);
}

void toggle_saveflag(XTI_REC *xti)
{
    char col;
    
    if (xti->flags & XTI_HAS_SAVED)
        col = color[col_msg_flags_off];
    else
        col = color[col_msg_flags_on];
    
    xti->flags ^= XTI_HAS_SAVED;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(66,2,"Saved",col);
}

void toggle_printflag(XTI_REC *xti)
{
    char col;
    
    if (xti->flags & XTI_HAS_PRINTED)
        col = color[col_msg_flags_off];
    else
        col = color[col_msg_flags_on];
    
    xti->flags ^= XTI_HAS_PRINTED;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(72,2,"Printed",col);
}

void toggle_replymark(XTI_REC *xti)
{
    char col;
    
    if (xti->marks & XTI_MARK_REPLY)
        col = color[col_msg_marks_off];
    else
        col = color[col_msg_marks_on];
    
    xti->marks ^= XTI_MARK_REPLY;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(59,4,"Reply",col);
}

void toggle_savemark(XTI_REC *xti)
{
    char col;
    
    if (xti->marks & XTI_MARK_SAVE)
        col = color[col_msg_marks_off];
    else
        col = color[col_msg_marks_on];
    
    xti->marks ^= XTI_MARK_SAVE;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(65,4,"Save",col);
}

void toggle_printmark(XTI_REC *xti)
{
    char col;
    
    if (xti->marks & XTI_MARK_PRINT)
        col = color[col_msg_marks_off];
    else
        col = color[col_msg_marks_on];
    
    xti->marks ^= XTI_MARK_PRINT;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(70,4,"Print",col);
}

void toggle_deletemark(XTI_REC *xti)
{
    char col;
    
    if (xti->marks & XTI_MARK_DELETE)
        col = color[col_msg_marks_off];
    else
        col = color[col_msg_marks_on];
    
    xti->marks ^= XTI_MARK_DELETE;
    
    if (area < 0)
        pkt->save_area_flags(pkt, pers.msgnum,xti);
    else
        pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(76,4,"Del",col);
}

void reply_orig(void)
{
    char str[81], *strp;
    int num;
    XTI_REC xti;

    num = pkt->area_type(pkt, pers.area);
    if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
        strp = pkt->get_area_name(pkt, pers.area);
    else
        strp = msg.mto;
    replyanother = 0;
    if (!try_open_reply()) return;
    if (area < 0)
    {
        strcpy(str,pkt->get_area_tag(pkt, pers.area));

        if (write_msg(msg.mnum,str,strp,msg.subj,(msg.flags & flag_private) > 0,1,0)) {
            pkt->open_area(pkt, pkt->get_area_number(pkt, pers.area));
            pkt->area_flags(pkt, pers.msgnum,&xti);
            xti.flags |= XTI_HAS_REPLIED;
            pkt->save_area_flags(pkt, pers.msgnum,&xti);
        }
    }
    else
    {
        strcpy(str,pkt->get_area_tag(pkt, area));

        if (write_msg(msg.mnum,str,strp,msg.subj,(msg.flags & flag_private) > 0,1,0))
        {
            pkt->area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
            xti.flags |= XTI_HAS_REPLIED;
            pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
        }
    }
}

void print_tpl(char *fname, FILE *Fout)
{
    FILE *Ftpl;
    char str[256],str2[256];


    Ftpl = fopen_ign(fname,"rt");
    if (Ftpl == NULL) return;

    while (_fgets(str,sizeof(str),Ftpl) != NULL)
    {
        if (str[0] != ';') fprintf(Fout,"%s\n",conv_macros(str,str2));
    }

    fclose(Ftpl);
}

void save_msg(char isreply)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned line;
    char info,str[256],quit,ch,striphdr,old_justify;
    int ypos,oldlen,oldwidth,slen;
    
    FILE *Ftext;

    Ftext = NULL; striphdr = 0;
    if (isreply == 2)
    {
#ifdef __linux__
        strcpy(str, "~/.skyreader/extsave.txt");
#else
        strcpy(str, "extsave.txt");
#endif
        goto __hohohohohoo;
    }
    if (isreply)
        conv_macros(opt.replysave,str);
    else
        conv_macros(opt.savefile,str);
__again:
    save_scr(&cx,&cy,&oldscr);

    draw_shaded_box(5,10,scrwidth-4,16,color[col_info_frame],color[col_info_title],lang[114]);
    cmiddle(12,lang[115],color[col_info_text]);
    highwrite_hicol = color[col_info_hilight];
    highwrite_locol = color[col_info_text];
    keys[0] = toupper(highwrite(scrwidth/2-14,14,lang[116],&keypos[0]));
    highwrite_hicol = color[col_box_hilight];
    highwrite_locol = color[col_box_text];
    key_xpos = 0; key_xovr = 0; keyb_keys = 1;
    striphdr = 0;
    for (;;)
    {
        info = get_string(7,13,255,scrwidth-12,str,128,color[col_info_text],color[col_info_hilight],0);
        if (key_found != keys[0]) break;

        striphdr = !striphdr;
        if (striphdr)
            writechr(scrwidth/2-13,14,CHECK,color[col_info_hilight]);
        else
            writechr(scrwidth/2-13,14,' ',color[col_info_hilight]);
    }
    old_scr(cx,cy,&oldscr);
    
    if ((str[0] == 0) || (info == 5)) return;
    
    Ftext = NULL;
    if (setup.misc_flags & MISC_ASK_APPEND)
    {
        if (exists(str))
        {
            save_scr(&cx,&cy,&oldscr);
            slen = get_max_langtext_len(117,120)/2;
            draw_shaded_box(scrwidth/2-slen-3,18,scrwidth/2+slen+3,22,color[col_info_frame],color[col_info_title],lang[117]);
            cmiddle(19,lang[118],color[col_info_hilight]);
            cmiddle(20,lang[119],color[col_info_hilight]);
            cmiddle(21,lang[120],color[col_info_hilight]);
            tattrbar(scrwidth/2-slen-2,19,scrwidth/2+slen+2,19,color[col_info_selectbar]);
            ypos = 0; quit = 0;
            while (!quit)
            {
                if (sk_kbhit())
                {
                    ch = sk_getch();
                    switch (ch)
                    {
                        case 0:
                            ch = sk_getch();
                            switch (ch)
                            {
                                case 'H':
                                    tattrbar(scrwidth/2-slen-2,19+ypos,scrwidth/2+slen+2,19+ypos,color[col_info_hilight]);
                                    if (ypos > 0) ypos--; else ypos = 2;
                                    tattrbar(scrwidth/2-slen-2,19+ypos,scrwidth/2+slen+2,19+ypos,color[col_info_selectbar]);
                                    break;
                                case 'P':
                                    tattrbar(scrwidth/2-slen-2,19+ypos,scrwidth/2+slen+2,19+ypos,color[col_info_hilight]);
                                    if (ypos < 2) ypos++; else ypos = 0;
                                    tattrbar(scrwidth/2-slen-2,19+ypos,scrwidth/2+slen+2,19+ypos,color[col_info_selectbar]);
                                    break;
                            }
                            break;
                        case 13:
                            quit = 1;
                            break;
                        case 27:
                            ypos = 2; quit = 1;
                            break;
                    }
                } else give_timeslice();
            }
            old_scr(cx,cy,&oldscr);
            switch (ypos)
            {
                case 0:
                    if ((Ftext = FileOpen(str,"r+t")) == NULL)
                        if ((Ftext = FileOpen(str,"w+t")) == NULL)
                        {
                            err_box("Can't create save file");
                            return;
                        }
                    fseek(Ftext,0,SEEK_END);
                    break;
                case 1:
                    if ((Ftext = FileOpen(str,"w+t")) == NULL)
                    {
                        err_box("Can't create save file");
                        return;
                    }
                    break;
                default:
                    goto __again;
            }
        }
    }

__hohohohohoo:
    if (Ftext == NULL)
    {
        if (isreply != 2 && setup.misc_flags & MISC_APPEND_SAVEFILE)
        {
            if ((Ftext = FileOpen(str,"r+t")) == NULL)
            {
                if ((Ftext = FileOpen(str,"w+t")) == NULL)
                {
                    err_box("Can't create save file");
                    return;
                }
            }
            else
            {
                fseek(Ftext,0,SEEK_END);
            }
        }
        else
        {
            if ((Ftext = FileOpen(str,"w+t")) == NULL)
            {
                err_box("Can't create save file");
                return;
            }
        }
    }

    if (!striphdr)
    {
        /* Process template file */
        if (isreply == 2)
            print_tpl("saveext.tpl",Ftext);
        else
            print_tpl(isreply ? "saverep.tpl" : "savemsg.tpl",Ftext);
    }

    old_justify = setup.justify; setup.justify = JUSTIFY_NONE;
    oldlen = pkt->txt_length; pkt->txt_length = 79;
    oldwidth = scrwidth; scrwidth = 79;

    if (isreply == 1)
    {
        sprintf(str,"%s%s",setup.replypath,reply.fname);
        if (pkt->init_replytext(pkt, str))
        {
            for (line=1; line<=pkt->txt_lines; line++)
            {
                fprintf(Ftext,"%s\n",pkt->read_replyline(pkt, str,line));
            }
        }
    }
    else
    {
        if (pkt->init_text(pkt))
        {
            for (line=1; line<=pkt->txt_lines; line++)
                fprintf(Ftext,"%s\n",pkt->read_line(pkt, str,line));
        }
    }

    setup.justify = old_justify; pkt->txt_length = oldlen; scrwidth = oldwidth;
    if (isreply == 1)
    {
        pkt->init_replytext(pkt, reply.fname);
    }
    else
    {
        pkt->init_text(pkt);
    }

    fprintf(Ftext,"\n");
    fclose(Ftext);

    /* Set on "saved" flag */
    if (!isreply && (xti.flags & XTI_HAS_SAVED) == 0) toggle_saveflag(&xti);
}

unsigned jump_msg(void)
{
    unsigned short ox,oy;
    char *oldscr;
    char tmp[6];
    int slen;

    save_scr(&ox,&oy,&oldscr);
    slen = strlen(lang[121]);
    draw_shaded_box(scrwidth/2-slen/2-5,13,scrwidth/2+slen/2+4+(slen & 1),15,color[col_info_frame],color[col_info_title],NULL);
    cwritexy(scrwidth/2-slen/2-3,14,lang[121],color[col_info_text]);
    tmp[0] = 0;
    get_string(scrwidth/2+slen/2-2+(slen & 1),14,5,5,tmp,6,color[col_info_hilight],color[col_info_text],0);
    old_scr(ox,oy,&oldscr);
    return atol(tmp);
}

void reply_msg(void)
{
    char str[81],*strp;
    int num;
    XTI_REC xti;
    
    replyanother = 0;
    if (!try_open_reply()) return;
    if (area < 0)
    {
        num = pkt->area_type(pkt, pers.area);
        if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
            strp = pkt->newsgroups;
        else
            strp = msg.mfrom;

        strcpy(str,pkt->get_area_tag(pkt, pers.area));
        
        pkt->open_area(pkt, pkt->get_area_number(pkt, pers.area));
        pkt->area_flags(pkt, pers.msgnum,&xti);
        if (write_msg(msg.mnum,str,strp,msg.subj,(msg.flags & flag_private) > 0,1,(xti.flags & XTI_IS_PERSONAL) > 0))
        {
            xti.flags |= XTI_HAS_REPLIED;
            pkt->save_area_flags(pkt, pers.msgnum,&xti);
        }
    }
    else
    {
        num = pkt->area_type(pkt, area);
        if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
            strp = pkt->newsgroups;
        else
            strp = msg.mfrom;
        strcpy(str,pkt->get_area_tag(pkt, area));

        pkt->area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
        if (write_msg(msg.mnum,str,strp,msg.subj,(msg.flags & flag_private) > 0,1,(xti.flags & XTI_IS_PERSONAL) > 0))
        {
            xti.flags |= XTI_HAS_REPLIED;
            pkt->save_area_flags(pkt, sortrec[ra_ypos+ra_upy-1],&xti);
        }
    }
}

void enter_newmsg(unsigned pos)
{
    unsigned num;
    char pvt, *strp;

    if (area < 0)
    {
        fseek(Fpers,(pos-1)*sizeof(pers_rec),SEEK_SET);
        if (fread(&pers,sizeof(pers_rec),1,Fpers) == 0) return;
        
        num = pkt->area_type(pkt, pers.area);
    }
    else
        num = pkt->area_type(pkt, area);

    if (num & TYPE_NOPUB)
        pvt = 1;
    else
        pvt = 0;

    if (fmt == format_soup && num & TYPE_INET && (num & TYPE_NET) == 0)
        strp = pkt->get_area_name(pkt, area < 0 ? pers.area : area);
    else
        strp = "All";
    if (try_open_reply())
    {
        if (area < 0)
            write_msg(0,pkt->get_area_tag(pkt, pers.area),strp,NULL,pvt,0,0);
        else
            write_msg(0,pkt->get_area_tag(pkt, area),strp,NULL,pvt,0,0);
    }
}

int find_text(unsigned char *mask, unsigned char *txt, char upper, char whole)
{
    int num,mpos,start;
    unsigned char last;

    if (*mask == 0) return -1;
    num = 0; mpos = 0;
    start = 0;
    last = 1;
    while (txt[num] != 0)
    {
        if (upper)
        {
            if (((last) || (mpos > 0)) && (toupper(txt[num]) == toupper(mask[mpos])))
                mpos++;
            else
            {
                if (mpos != 0)
                {
                    mpos = 0;
                    num = start;
                }
                start = num+1;
            }
        }
        else
        {
            if (((last) || (mpos > 0)) && (txt[num] == mask[mpos]))
                mpos++;
            else
            {
                if (mpos != 0)
                {
                    mpos = 0;
                    num = start;
                }
                start = num+1;
            }
        }
        if (whole) last = ispunc(txt[num]);
        num++;
        if (mask[mpos] == 0)
        {
            if ((!whole) || (ispunc(txt[num])))
                return start;
            else
                mpos = 0;
        }
    }
    return -1;
}

enum { KW_FOUND_FROM = 1, KW_FOUND_TO, KW_FOUND_SUBJ, KW_FOUND_TEXT };

char search_message(long msgnum, int area, int msgs)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned mnum,anum;
    char found_from;

    unsigned num,n2,n3,n4,oldpos,found;
    unsigned mpos,slen,xpos,ypos,pos;
    char quit,info,current;

    char whole,upper,nofrom,noto,nosubj,notxt,last;

    char line[256];

    XTI_REC xti;
    pers_rec frec;


    save_scr(&cx,&cy,&oldscr);

    /* Already in searchmode? */
    if (search_mode)
    {
        slen = strlen(lang[262])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[262],color[col_warn_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return 0;
    }
    draw_shaded_box(scrwidth/2-30,3,scrwidth/2+30,21,color[col_box_frame],color[col_box_title],lang[263]);
    cwritexy(scrwidth/2-18,5,lang[264],color[col_box_hilight]);
    cwritexy(scrwidth/2-22,6,"#1:",color[col_box_hilight]);
    cwritexy(scrwidth/2-22,7,"#2:",color[col_box_hilight]);
    cwritexy(scrwidth/2-22,8,"#3:",color[col_box_hilight]);
    cwritexy(scrwidth/2-22,9,"#4:",color[col_box_hilight]);
    cwritexy(scrwidth/2-22,10,"#5:",color[col_box_hilight]);
    keys[0] = toupper(highwrite(scrwidth/2-22,12,lang[265],NULL));
    draw_hline(scrwidth/2-30,scrwidth/2+30,14,color[col_box_frame]);
    cwritexy(scrwidth/2-28,16,lang[266],color[col_box_text]);
    cwritexy(scrwidth/2-28,17,lang[267],color[col_box_text]);
    cwritexy(scrwidth/2-28,18,lang[268],color[col_box_text]);
    cwritexy(scrwidth/2-28,19,lang[269],color[col_box_text]);

    pos = scrwidth/2+29-get_max_langtext_len(270,271);
    cwritexy(pos,16,lang[270],color[col_box_text]);
    cwritexy(pos,17,lang[271],color[col_box_text]);
    sprintf(line," %s ",lang[272]);
    cmiddle(21,line,color[col_box_title]);
    quit = 0; ypos = 0; xpos = 0;
    keyb_keys = 1; current = 0;
    memset(kw_search,0,sizeof(kw_search));
    memset(kw_flags,0,sizeof(kw_flags));
    if (area == -3) Fpers = NULL;
    while (!quit)
    {
        key_xpos = 0; key_xovr = 0;
        do
        {
            if (xpos)
                info = get_string(scrwidth/2+15,ypos+6,6,6,kw_flags[ypos],1+4+8+128,color[col_box_text],color[col_box_hilight],0);
            else
                info = get_string(scrwidth/2-18,ypos+6,30,30,kw_search[ypos],4+8+128,color[col_box_text],color[col_box_hilight],0);
            if (key_found)
            {
                if (current)
                {
                    current = 0;
                    writechr(scrwidth/2-21,12,' ',color[col_box_hilight]);
                }
                else
                {
                    current = 1;
                    writechr(scrwidth/2-21,12,CHECK,color[col_box_hilight]);
                }
            }
        } while (key_found != 0);

        switch (info)
        {
            case 0:
            case 1: /* Down */
                if (!xpos)
                    xpos = 1;
                else
                {
                    if (ypos == 4)
                        ypos = 0;
                    else
                        ypos++;
                    xpos = 0;
                }
                break;
            case 2: /* Up */
                if (xpos)
                    xpos = 0;
                else
                {
                    if (ypos == 0)
                        ypos = 4;
                    else
                        ypos--;
                    xpos = 1;
                }
                break;
            case 3: /* F10 - OK */
                quit = 1;
                break;
            case 4: /* F5 - Clear */
                memset(kw_search,0,sizeof(kw_search));
                memset(kw_flags,0,sizeof(kw_flags));
                xpos = 0; ypos = 0;
                tbar(scrwidth/2-18,6,scrwidth/2+21,10,color[col_box_text]);
                break;
            case 5: /* ESC - Quit */
                quit = 2;
                break;
        }
    }

    if (quit == 1)
    {
        found = 0;
        if (!current) msgnum = 1;
        for (anum = 1; anum < pkt->areas; anum++)
        {
            if (area == -3)
            {
                msgs = pkt->get_msgs(pkt, pkt->get_area_number(pkt, anum));
                pkt->open_area(pkt, pkt->get_area_number(pkt, anum));
            }

            if (area > 0)
            {
                for (num = 1; num < (unsigned) msgnum; num++)
                {
                    pkt->area_flags(pkt, sortrec[num-1],&xti);
                    xti.marks |= XTI_MARK_DISABLED;
                    pkt->save_area_flags(pkt, sortrec[num-1],&xti);
                }
            }

            for (num = msgnum; num <= (unsigned) msgs; num++)
            {
                found_from = 0;
                if (area == -3)
                    mnum = num;
                else if (area < 0)
                {
                    fseek(Fpers,(sortrec[num-1]-1)*sizeof(pers_rec),SEEK_SET);
                    fread(&pers,sizeof(pers_rec),1,Fpers);
                    pkt->open_area(pkt, pkt->get_area_number(pkt, pers.area));
                    mnum = pers.msgnum;
                }
                else
                    mnum = sortrec[num-1];

                pkt->read_msg(pkt, mnum); tran(msg.mfrom); tran(msg.mto);
                if (pkt->init_text(pkt))
                {
                    for (n2=0; n2<5; n2++)
                    {
                        if (kw_search[n2][0] == 0) continue;
                        n3 = 0;
                        whole = 0; upper = 1;
                        nofrom = 0; noto = 0; nosubj = 0; notxt = 0;
                        while (kw_flags[n2][n3] > 0)
                        {
                            switch (kw_flags[n2][n3])
                            {
                                case '!':
                                    whole = 1;
                                    break;
                                case '@':
                                    upper = 0;
                                    break;
                                case 'F':
                                    nofrom = 1;
                                    break;
                                case 'T':
                                    noto = 1;
                                    break;
                                case 'S':
                                    nosubj = 1;
                                    break;
                                case 'X':
                                    notxt = 1;
                                    break;
                            }
                            n3++;
                        }

                        if ((!nofrom) && ((found_from & KW_FOUND_FROM) == 0))
                        {
                            /* Search from FROM field */
                            if (find_text((unsigned char *) kw_search[n2],(unsigned char *) msg.mfrom,upper,whole) != -1)
                                found_from |= KW_FOUND_FROM;
                        }

                        if ((found_from == 0) && (!noto) && ((found_from & KW_FOUND_TO) == 0))
                        {
                            /* Search from TO field */
                            if (find_text((unsigned char *) kw_search[n2],(unsigned char *) msg.mto,upper,whole) != -1)
                                found_from |= KW_FOUND_TO;
                        }

                        if ((found_from == 0) && (!nosubj) && ((found_from & KW_FOUND_SUBJ) == 0))
                        {
                            /* Search from SUBJECT */
                            if (find_text((unsigned char *) kw_search[n2],(unsigned char *) msg.subj,upper,whole) != -1)
                                found_from |= KW_FOUND_SUBJ;
                        }

                        if ((found_from == 0) && (!notxt) && ((found_from & KW_FOUND_TEXT) == 0))
                        {
                            /* Search string from message text */
                            mpos = 0;
                            for (n3=1; n3<=pkt->txt_lines; n3++)
                            {
                                pkt->read_line(pkt, line,n3);
                                n4 = 0;
                                oldpos = 0;
                                last = 1;
                                while (line[n4] != 0)
                                {
                                    if (upper)
                                    {
                                        if (((last) || (mpos > 0)) && (toupper(kw_search[n2][mpos]) == toupper(line[n4])))
                                            mpos++;
                                        else
                                        {
                                            if (mpos > 0)
                                            {
                                                mpos = 0;
                                                n4 = oldpos;
                                            }
                                            oldpos = n4+1;
                                        }
                                    }
                                    else
                                    {
                                        if (((last) || (mpos > 0)) && (kw_search[n2][mpos] == line[n4]))
                                            mpos++;
                                        else
                                        {
                                            if (mpos > 0)
                                            {
                                                mpos = 0;
                                                n4 = oldpos;
                                            }
                                            oldpos = n4+1;
                                        }
                                    }
                                    if (whole) last = ispunc(line[n4]);
                                    n4++;
                                    if (kw_search[n2][mpos] == 0)
                                    {
                                        /* Text was found */
                                        if ((!whole) || (ispunc(line[n4])))
                                        {
                                            found_from |= KW_FOUND_TEXT;
                                            break;
                                        }
                                        else
                                            mpos = 0;
                                    }
                                }

                                if (kw_search[n2][mpos] == ' ')
                                {
                                    if (kw_search[n2][mpos+1] == 0)
                                        found_from |= KW_FOUND_TEXT;
                                    mpos++;
                                }
                                else
                                    mpos = 0;
                                if (found_from & KW_FOUND_TEXT) break;
                            }
                        }
                    }

                    if (found_from == 0)
                    {
                        if (area != -3)
                        {
                            pkt->area_flags(pkt, mnum,&xti);
                            xti.marks |= XTI_MARK_DISABLED;
                            pkt->save_area_flags(pkt, mnum,&xti);
                        }
                    }
                    else
                    {
                        if (area == -3)
                        {
                            if (Fpers == NULL)
                            {
                                sprintf(line, "%ssky_find.idx", setup.workpath);
                                Fpers = FileOpen(line,"w+b");
                                if (Fpers == NULL) return 0;
                            }
                            memset(&frec, 0, sizeof(frec));
                            frec.area = anum;
                            frec.msgnum = mnum;
                            memcpy(&frec.msg, &msg, sizeof(msg));
                            fwrite(&frec, sizeof(frec), 1, Fpers);
                        }
                        found++;
                    }
                }
                else
                    err_box("blah");
            }

            if (area != -3) break;
        }

        if (found > 0)
            search_mode = 1;
        else
        {
            slen = strlen(lang[273])/2;
            draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(12,lang[273],color[col_warn_hilight]);
            try_key(2);

            if (area != -3)
            {
                for (num=1; num<=(unsigned) msgs; num++)
                {
                    if (area < 0)
                    {
                        fseek(Fpers,(num-1)*sizeof(pers_rec),SEEK_SET);
                        if (fread(&pers,sizeof(pers_rec),1,Fpers) == 0) return 0;

                        pkt->open_area(pkt, pkt->get_area_number(pkt, pers.area));
                        pkt->area_flags(pkt, pers.msgnum,&xti);
                        xti.marks &= ~XTI_MARK_DISABLED;
                        pkt->save_area_flags(pkt, pers.msgnum,&xti);
                    }
                    else
                    {
                        pkt->area_flags(pkt, num,&xti);
                        xti.marks &= ~XTI_MARK_DISABLED;
                        pkt->save_area_flags(pkt, num,&xti);
                    }
                }
            }
        }
    }
    old_scr(cx,cy,&oldscr);
    return search_mode;
}
