#ifdef __linux__
#  define CHECK 'x'
#else
#  define CHECK ''
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "keyb.h"

#include "vars.h"
#include "files.h"
#include "screen.h"
#include "shell.h"
#include "readsets.h"
#include "openpkt.h"
#include "general.h"
#include "showansi.h"
#include "scrsaver.h"
#include "entermsg.h"
#include "readmsgs.h"
#include "readrepl.h"
#include "newfiles.h"
#include "offcfg.h"
#include "keyb.h"

char renname[13],renpkt,movepkt,delpkt,makecmnt,savebook,cmnt[71];

/* Display a box in the middle of the screen */
void middle_box(char ypos, char *txt, char col1, char col2)
{
    size_t len;

    len = strlen(txt);
    draw_shaded_box(scrwidth/2-(len/2)-(len & 1)-1,ypos,scrwidth/2+(len/2)+2,ypos+2,col1,0,NULL);
    cmiddle(ypos+1,txt,col2);
    refresh();
}

/* Detect archiver */
char detect_archiver(FILE *F)
{
    char str[11];
    
    fseek(F,0,SEEK_SET);
    fread(str,10,1,F);

    /* Detect **SKY** file */
    if (strncmp(str,"**SKY**",7) == 0) return format_sky;

    /* Detect ZIP */
    if ((str[0] == 'P') && (str[1] == 'K')) return format_zip;
    
    /* Detect ARJ */
    if ((str[0] == '`') && (str[1] == '')) return format_arj;
    
    /* Detect RAR */
    if (strncmp(str,"Rar!\x1a",5) == 0) return format_rar;
    
    /* Detect LHA */
    if (strncmp(str+2,"-lh",3) == 0) return format_lha;
    
    /* Detect UC2 */
    if (strncmp(str,"UC2\x1a",4) == 0) return format_uc2;
    
    return format_aux;
}

/* Ask what to do to reply packet */
void doto_packet(char *path, char nowait)
{
    unsigned short ox,oy;
    char *oldscr;

    char *fname,tmp[256],str[256],*pstr;
    FILE *F;

#ifndef __NO_DRIVES__
    unsigned drive,drives;
#endif

    int quit,ch,repfmt;
    int slen,len,ypos;

    struct stat *statbuf;
    struct tm *tim;

    /* Open reply packet */
#ifdef __linux__
    search_ign_file(path);
#endif
    F = FileOpen(path,"rb");
    if (F == NULL) return;

    /* Get some information about reply packet */
    FileFStat(fileno(F),&statbuf);
    tim = localtime(ST_MTIME(statbuf));
    repfmt = detect_archiver(F);
    fclose(F);
    free(statbuf);

    /* Get reply packet name without path */
    fname = strrchr(path,SLASH);
    if (fname++ == NULL) fname = path;

    len = strlen(lang[57])-9+strlen(fname);
    slen = get_max_langtext_len(56,61);
    if (len > slen) slen = len;
    slen /= 2;

    highwrite_hicol = color[col_info_hilight];
    highwrite_locol = color[col_info_text];

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-slen-2,5,scrwidth/2+slen+2,13,color[col_info_frame],color[col_info_title],lang[56]);

    sprintf(tmp,lang[57],fname,tim->tm_mday,month[tim->tm_mon],tim->tm_year%100,tim->tm_hour,tim->tm_min);
    cwritexy(scrwidth/2-len/2,7,tmp,color[col_info_text]);
    cmiddle(8,lang[58],color[col_info_hilight]);

    keys[0] = toupper(highwrite(scrwidth/2-strlen(lang[59])/2,10,lang[59],&keypos[0]));
    keys[1] = toupper(highwrite(scrwidth/2-strlen(lang[60])/2,11,lang[60],&keypos[1]));
    keyb_keys = 2;

    if (!nowait)
    {
        keys[2] = toupper(highwrite(scrwidth/2-strlen(lang[61])/2,12,lang[61],&keypos[2]));
        keyb_keys++;
    }

    highwrite_hicol = color[col_box_hilight];
    highwrite_locol = color[col_box_text];

    ypos = 1;
    tattrbar(scrwidth/2-slen-1,9+ypos,scrwidth/2+slen+1,9+ypos,color[col_info_selectbar]);

    quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = toupper(sk_getch());
            if (ch == toupper(keys[0]))
            {
                ypos = 1;
                quit = 1;
                continue;
            }
            if (ch == toupper(keys[1]))
            {
                ypos = 2;
                quit = 1;
                continue;
            }
            if ((ch == toupper(keys[2])) && (!nowait))
            {
                ypos = 3;
                quit = 1;
                continue;
            }
            switch (ch)
            {
                case 27:
                    /* ESC = Wait */
                    ypos = 3; quit = 1; break;
                case 13:
                    /* Enter = OK */
                    quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            /* Shell to OS */
                            shell_dos();
                            break;
                        case 'P':
                            /* Down */
                            tattrbar(scrwidth/2-slen-1,9+ypos,scrwidth/2+slen+1,9+ypos,color[col_info_text]);
                            writechr(scrwidth/2-strlen(lang[58+ypos])/2+keypos[ypos-1]-1,9+ypos,keys[ypos-1],color[col_info_hilight]);
                            if (nowait)
                            {
                                if (ypos == 1)
                                    ypos = 2;
                                else
                                    ypos = 1;
                            }
                            else
                            {
                                ypos++;
                                if (ypos == 4) ypos = 1;
                            }
                            tattrbar(scrwidth/2-slen-1,9+ypos,scrwidth/2+slen+1,9+ypos,color[col_info_selectbar]);
                            break;
                        case 'H':
                            tattrbar(scrwidth/2-slen-1,9+ypos,scrwidth/2+slen+1,9+ypos,color[col_info_text]);
                            writechr(scrwidth/2-strlen(lang[58+ypos])/2+keypos[ypos-1]-1,9+ypos,keys[ypos-1],color[col_info_hilight]);
                            if (nowait)
                            {
                                if (ypos == 1)
                                    ypos = 2;
                                else
                                    ypos = 1;
                            }
                            else
                            {
                                ypos--;
                                if (ypos == 0) ypos = 3;
                            }
                            tattrbar(scrwidth/2-slen-1,9+ypos,scrwidth/2+slen+1,9+ypos,color[col_info_selectbar]);
                            break;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }

    switch (ypos)
    {
        case 1:
            /* Open reply packet */

            pkt->close_replypacket(pkt);
            sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
#ifdef __linux__
            if (search_ign_file(tmp) != NULL)
#endif
                FileRemove(tmp);

            replyopen = 1;

            slen = strlen(setup.replypath); setup.replypath[slen-1] = 0;
#ifndef __NO_DRIVES__
            _dos_getdrive(&drive);
#endif
            getcwd(tmp,sizeof(tmp));
            ChangeDir(setup.replypath);
            setup.replypath[slen-1] = SLASH;
#ifndef __NO_DRIVES__
            if (setup.replypath[1] == ':')
                _dos_setdrive(toupper(setup.replypath[0])-64,&drives);
#endif

            switch (repfmt)
            {
                case format_aux: strcpy(str,setup.unaux_cmd); break;
                case format_zip: strcpy(str,setup.unzip_cmd); break;
                case format_arj: strcpy(str,setup.unarj_cmd); break;
                case format_rar: strcpy(str,setup.unrar_cmd); break;
                case format_uc2: strcpy(str,setup.unuc2_cmd); break;
                case format_lha: strcpy(str,setup.unlha_cmd); break;
            }
            sprintf(str+strlen(str)," %s",path);

            if (setup.misc_flags & MISC_DISPLAY_OUTPUT)
            {
                /* Display archiver output .. */
                tclrscr();
                middle_box(3,lang[19],color[col_packing_frame],color[col_packing_text]);
                gotoxy(1,7);
            }
            else
            {
                /* Don't display archiver output, redirect stdout to NUL */
                middle_box(11,lang[19],color[col_packing_frame],color[col_packing_text]);
            }
            refresh();

            /* Unpack reply packet */
            pstr = strchr(str,' '); *pstr = '\0';
            swapexec(str,pstr+1,(setup.misc_flags & MISC_DISPLAY_OUTPUT) == 0);
            nocursor();

#ifndef __NO_DRIVES__
            _dos_setdrive(drive,&drives);
#endif
            ChangeDir(tmp);

            pkt->open_replypacket(pkt);
            break;
        case 2:
            /* Remove reply packet */
            FileRemove(path);
            replyopen = 1;
            break;
        case 3:
            /* Wait.. */
            replyopen = 0;
            break;
    }

    old_scr(ox,oy,&oldscr);
    if (!replymgr)
    {
        fseek(Fsky,14,SEEK_SET);
        fwrite(&replyopen,1,1,Fsky);

        /* Reopen work\~RESTART.SKY */
        fclose(Fsky);
        sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
        Fsky = FileOpen(tmp,"r+b");
    }
}

char try_open_reply(void)
{
    if (!replyopen)
    {
        if (exists(reppkt))
        {
            doto_packet(reppkt,1);
            if (!replyopen) return 0;
        }
    }
    return 1;
}

void erase_workdir(void)
{
    char str[256];
    DIR *dirp;

    strcpy(str, setup.workpath); str[strlen(str)-1] = '\0';
    dirp = OpenDir(str);

    for (;;)
    {
        struct stat *statbuf;
        struct dirent *d;
        if (dirp == NULL) break;

        d = readdir(dirp);
        if (d == NULL) break;

        sprintf(str,"%s%s",setup.workpath, d->d_name);
        if (FileStat(str, &statbuf) == 0 && !ISDIR(statbuf) && FileRemove(str) != 0)
        {
            tclrscr();
            printf("Sorry, file '%s' couldn't be erased!\n",str);
            sk_getch();
            exit(1);
        }
        free(statbuf);
    }
}

void erase_replydir(void)
{
    char str[256];
    DIR *dirp;

    strcpy(str, setup.replypath); str[strlen(str)-1] = '\0';
    dirp = OpenDir(str);

    for (;;)
    {
        struct stat *statbuf;
        struct dirent *d;
        if (dirp == NULL) break;

        d = readdir(dirp);
        if (d == NULL) break;

        sprintf(str,"%s%s",setup.workpath, d->d_name);
        if (FileStat(str, &statbuf) == 0 && !ISDIR(statbuf) && FileRemove(str) != 0)
        {
            tclrscr();
            printf("Sorry, file '%s' couldn't be erased!\n",str);
            sk_getch();
            exit(1);
        }
        free(statbuf);
    }
}

char detect_packet(void)
{
    char str[256];

    if (arcfmt == format_sky) return format_jam;

    /* Check Hippo */
    sprintf(str,"%s%s.HD",setup.workpath,pktname);
    if (exists(str)) return format_hippo;

    /* Check SOUP */
    if (exists(strcat(strcpy(str,setup.workpath),"AREAS"))) return format_soup;

    /* Check QWK */
    if (exists(strcat(strcpy(str,setup.workpath),"CONTROL.DAT"))) return format_qwk;

    /* Check OMEN */
    if (exists(strcat(strcpy(str,setup.workpath),"NEWMSG??.TXT"))) return format_omen;

    /* Check Blue Wave */
    if (exists(strcat(strcpy(str,setup.workpath),"*.inf"))) return format_bw;

    return 0;
}

void rm_clropt(int y)
{
    tattrbar(45,y+4,75,y+4,color[col_box_text]);
    writechr(45+keypos[y-1],y+4,keys[y-1],color[col_box_hilight]);
}

void corrupted(void)
{
    unsigned short ox,oy;
    char *oldscr;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-25,10,scrwidth/2+23,15,color[col_warn_frame],color[col_warn_title],"Corrupted mail packet");
    cmiddle(12,"One or more files were missing or broken",color[col_warn_text]);
    cmiddle(13,"from packet, don't know how to handle this",color[col_warn_text]);
    try_key(5);
    old_scr(ox,oy,&oldscr);
}

void not_enough_memory(void)
{
    unsigned short ox,oy;
    char *oldscr;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-20,10,scrwidth/2+20,14,color[col_warn_frame],color[col_warn_title],"Out of memory");
    cmiddle(12,"Not enough memory to open packet!",color[col_warn_text]);
    try_key(5);
    old_scr(ox,oy,&oldscr);
}

void cannot_create_file(void)
{
    unsigned short ox,oy;
    char *oldscr;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-15,10,scrwidth/2+15,14,color[col_warn_frame],color[col_warn_title],"Error opening mail packet");
    cmiddle(12,"Could not create file!",color[col_warn_text]);
    try_key(5);
    old_scr(ox,oy,&oldscr);
}

void cannot_write_file(void)
{
    unsigned short ox,oy;
    char *oldscr;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-25,10,scrwidth/2+25,14,color[col_warn_frame],color[col_warn_title],"Error opening mail packet");
    cmiddle(12,"Could not write to file! Out of disk space?",color[col_warn_text]);
    try_key(5);
    old_scr(ox,oy,&oldscr);
}

void get_comment(void)
{
    unsigned short ox,oy;
    char *oldscr;

    char info,tmp[50];

    save_scr(&ox,&oy,&oldscr);
    sprintf(tmp,lang[53],mailpktname);
    draw_shaded_box(scrwidth/2-36,11,scrwidth/2+37,15,color[col_info_frame],color[col_info_title],tmp);
    key_xpos = 0; key_xovr = 0;
    info = get_string(scrwidth/2-34,13,70,70,cmnt,4+128,color[col_info_hilight],color[col_info_text],0);
    if ((info == 5) || (cmnt[0] == 0)) makecmnt = 0; else makecmnt = 1;
    old_scr(ox,oy,&oldscr);
}

void ren_packet(void)
{
    unsigned short ox,oy;
    char *oldscr;

    char info;
    size_t slen,len;

    len = strlen(lang[55])+strlen(mailpktname)+1;
    if (strlen(lang[54]) > len) slen = strlen(lang[54]); else slen = len;
    slen /= 2;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-slen-2,11,scrwidth/2+slen+2,16,color[col_info_frame],color[col_info_title],lang[54]);
    cwritexy(scrwidth/2-len/2,13,lang[55],color[col_info_text]);
    cwritexy(scrwidth/2-len/2+strlen(lang[55])+1,13,mailpktname,color[col_info_hilight]);

    key_xpos = 0; key_xovr = 0;
    info = get_string(scrwidth/2-6,14,12,12,(char *) renname,4+128,color[col_info_hilight],color[col_info_text],0);
    if ((info == 5) || (renname[0] == 0)) renpkt = 0; else renpkt = 1;
    old_scr(ox,oy,&oldscr);
}

int packet_modified;

int ask_ending_box(void)
{
    unsigned short ox,oy;
    char *oldscr;

    int quit,ok,ch;
    char tmp[256], ext[4], tmp2[256];

    unsigned max,extnum,num;
    size_t slen;

    DIR *dirp;

    max = 0;
    if (fmt == format_omen)
        sprintf(tmp2,"omen%s.",omentag);
    else
        sprintf(tmp2,"%s.",pktname);

    strcpy(tmp, setup.downpath); tmp[strlen(tmp)-1] = '\0';
    dirp = OpenDir(tmp);
    for (;;)
    {
        struct dirent *d;
        if (dirp == NULL) break;

        d = readdir(dirp);
        if (d == NULL) break;

        if (strnicmp(d->d_name, tmp2, strlen(tmp2)) != 0) continue;
        extnum = atol(d->d_name+strlen(tmp2)+1);
        if (extnum > max) max = extnum;
    }

    if (fmt == format_omen)
        sprintf(renname,"omen%s.%03i",omentag,max+1);
    else
        sprintf(renname,"%s.%03i",pktname,max+1);

    strcpy(ext,strchr(mailpktname,'.')+1);

    renpkt = 0;
    if ((setup.packet_flags & PKT_REN_PACKET) > 0)
      if ((ext[0] < '0') || (ext[0] > '9')) renpkt = 1; else
      if ((ext[1] < '0') || (ext[1] > '9')) renpkt = 1; else
      if ((ext[2] < '0') || (ext[2] > '9')) renpkt = 1;

    savebook = (setup.packet_flags & PKT_SAVE_BOOK) > 0 && packet_modified;
    delpkt = 0;
    movepkt = (setup.packet_flags & PKT_AUTO_MOVE_PACKET) > 0;

    slen = get_max_langtext_len(49,52);
    if (slen < strlen(lang[240])) slen = strlen(lang[240]);
    num = strlen(lang[48])+strlen(mailpktname)+1;
    if (num > slen) slen = num;
    slen /= 2;

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(scrwidth/2-slen-4,9,scrwidth/2+slen+5,19,color[col_box_frame],color[col_box_title],NULL);
    num = (strlen(mailpktname)+strlen(lang[48]))/2;
    cwritexy(scrwidth/2-num,10,lang[48],color[col_box_text]);
    cwritexy(scrwidth/2-num+strlen(lang[48])+1,10,mailpktname,color[col_box_hilight]);

    cwritexy(scrwidth/2-slen,12,"[ ]",color[col_box_text]);
    keys[0] = toupper(highwrite(scrwidth/2-slen+4,12,lang[49],&keypos[0]));
    if (savebook) writechr(scrwidth/2-slen+1,12,CHECK,color[col_box_hilight]);

    cwritexy(scrwidth/2-slen,13,"[ ]",color[col_box_text]);
    keys[1] = toupper(highwrite(scrwidth/2-slen+4,13,lang[50],&keypos[1]));
    if (makecmnt) writechr(scrwidth/2-slen+1,13,CHECK,color[col_box_hilight]);

    cwritexy(scrwidth/2-slen,15,"[ ]",color[col_box_text]);
    keys[2] = toupper(highwrite(scrwidth/2-slen+4,15,lang[51],&keypos[2]));
    if (renpkt) writechr(scrwidth/2-slen+1,15,CHECK,color[col_box_hilight]);

    cwritexy(scrwidth/2-slen,16,"[ ]",color[col_box_text]);
    keys[3] = toupper(highwrite(scrwidth/2-slen+4,16,lang[52],&keypos[3]));
    if (delpkt) writechr(scrwidth/2-slen+1,16,CHECK,color[col_box_hilight]);

    cwritexy(scrwidth/2-slen,17,"[ ]",color[col_box_text]);
    keys[4] = toupper(highwrite(scrwidth/2-slen+4,17,lang[240],&keypos[4]));
    if (movepkt) writechr(scrwidth/2-slen+1,17,CHECK,color[col_box_hilight]);

    keyb_keys = 5;
    quit = 0; ok = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = toupper(sk_getch());
            if (ch == 0) ch = find_key(sk_getch());

            if (ch == keys[0])
            {
                savebook = !savebook;
                if (savebook)
                    writechr(scrwidth/2-slen+1,12,CHECK,color[col_box_hilight]);
                else
                    writechr(scrwidth/2-slen+1,12,' ',color[col_box_hilight]);
            }
            else if (ch == keys[1])
            {
                get_comment();
                if (makecmnt)
                    writechr(scrwidth/2-slen+1,13,CHECK,color[col_box_hilight]);
                else
                    writechr(scrwidth/2-slen+1,13,' ',color[col_box_hilight]);
            }
            else if (ch == keys[2])
            {
                ren_packet();
                if (renpkt)
                    writechr(scrwidth/2-slen+1,15,CHECK,color[col_box_hilight]);
                else
                    writechr(scrwidth/2-slen+1,15,' ',color[col_box_hilight]);
                if ((delpkt) && (renpkt))
                {
                    delpkt = 0;
                    writechr(scrwidth/2-slen+1,16,' ',color[col_box_hilight]);
                }
            }
            else if (ch == keys[3])
            {
                delpkt = !delpkt;
                if (delpkt)
                    writechr(scrwidth/2-slen+1,16,CHECK,color[col_box_hilight]);
                else
                    writechr(scrwidth/2-slen+1,16,' ',color[col_box_hilight]);
                if (renpkt)
                {
                    renpkt = 0;
                    writechr(scrwidth/2-slen+1,15,' ',color[col_box_hilight]);
                }
                if (movepkt)
                {
                    movepkt = 0;
                    writechr(scrwidth/2-slen+1,17,' ',color[col_box_hilight]);
                }
            }
            else if (ch == keys[4])
            {
                movepkt = !movepkt;
                if (movepkt)
                    writechr(scrwidth/2-slen+1,17,CHECK,color[col_box_hilight]);
                else
                    writechr(scrwidth/2-slen+1,17,' ',color[col_box_hilight]);
                if (delpkt)
                {
                    delpkt = 0;
                    writechr(scrwidth/2-slen+1,16,' ',color[col_box_hilight]);
                }
            }
            else if (ch == 13)
            {
                quit = 1;
                ok = 1;
            }
            else if (ch == 27)
            {
                quit = 1;
                ok = 0;
            }
        } else give_timeslice();
    }
    old_scr(ox,oy,&oldscr);
    return ok;
}

/* Pack reply packet */
char pack_replypacket(int arealist, unsigned replies)
{
    unsigned short cx,cy;
    char *oldscr;

    char tmp[256],str[256],*pstr;
    int slen;
    char ok;

    if (!replyopen) return 1;

    strcat(strcpy(tmp,setup.replypath),pktname);
    if ((replies == 0) && (!arealist) &&
        (!exists(strcat(strcpy(str,tmp),".req"))) &&
        (!exists(strcat(strcpy(str,tmp),".olc"))) &&
        (!exists(strcat(strcpy(str,tmp),".pdq"))))
    {
        sprintf(tmp,"%s%s%s",setup.uppath,pktname,ext);
        FileRemove(tmp);
        return 1;
    }

    /* Rename \upload\replypkt.new -> \upload\replypkt.bak */
    strcat(strcpy(tmp,setup.uppath),pktname);
    strcat(strcpy(str,tmp),".bak");
    strcat(tmp,ext);
    FileRename(tmp,str);

    /* Put packing parameters to tmp */
    switch (arcfmt)
    {
        case format_aux: strcpy(tmp,setup.aux_cmd); break;
        case format_zip: strcpy(tmp,setup.zip_cmd); break;
        case format_arj: strcpy(tmp,setup.arj_cmd); break;
        case format_rar: strcpy(tmp,setup.rar_cmd); break;
        case format_uc2: strcpy(tmp,setup.uc2_cmd); break;
        case format_lha: strcpy(tmp,setup.lha_cmd); break;
    }

    sprintf(tmp+strlen(tmp)," %s%s",setup.uppath,pktname);
    switch (fmt)
    {
        case format_bw:
            strcat(tmp,".new "REST);
            break;
        case format_qwk:
            strcat(tmp,".rep "REST);
            break;
        case format_hippo:
            strcat(tmp,".hra "REST);
            break;
        case format_omen:
            strcat(tmp," "REST);
            break;
        case format_soup:
            strcat(tmp,".rep "REST);
            break;
    }

    /* Change to reply path */
    slen = strlen(setup.replypath); setup.replypath[slen-1] = 0;
    ChangeDir(setup.replypath);
    setup.replypath[slen-1] = SLASH;

    if (setup.misc_flags & MISC_DISPLAY_OUTPUT)
    {
        tclrscr();
        middle_box(3,lang[20],color[col_packing_frame],color[col_packing_text]);
        gotoxy(1,7);
    }
    else
    {
        /* Redirect archiver output to NUL */
        save_scr(&cx,&cy,&oldscr);
        middle_box(11,lang[20],color[col_packing_frame],color[col_packing_text]);
    }
    refresh();

    /* Pack reply packet */
    pstr = strchr(tmp,' '); *pstr = 0;
    swapexec(tmp,pstr+1,(setup.misc_flags & MISC_DISPLAY_OUTPUT) == 0);
    nocursor();

    if ((setup.misc_flags & MISC_DISPLAY_OUTPUT) == 0) old_scr(cx,cy,&oldscr);

    /* Check if reply packet exists */
    if (fmt == format_omen)
    {
        DIR *dirp;

        strcpy(tmp, setup.uppath); tmp[strlen(tmp)-1] = '\0';
        dirp = OpenDir(tmp);
        sprintf(str, "%s%s", omentag, ext);

        ok = 0;
        for (;;)
        {
            struct dirent *d;
            if (dirp == NULL) break;

            d = readdir(dirp);
            if (d == NULL) break;
            if (stricmp(d->d_name, str) == 0)
            {
                if (arcfmt == format_aux)
                    strcpy(ext, strchr(mailpktname,'.')+1);
                ok = 1;
            }
        }
    }
    else
    {
        sprintf(tmp,"%s%s%s",setup.uppath,pktname,ext);
        ok = exists(tmp);
    }

    if (ok)
    {
        /* Yeah, FileRemove .bak file */
        FileRemove(strcat(strcat(strcpy(tmp,setup.uppath),pktname),".bak"));
    }
    else
    {
        /* Oh no, something's wrong!! */

        /* Rename replypkt.bak back to old name */
        strcat(strcpy(tmp,setup.uppath),pktname);
        strcat(strcpy(str,tmp),".bak");
        strcat(tmp,ext);
        FileRename(str,tmp);

        draw_shaded_box(scrwidth/2-30,6,scrwidth/2+31,14,color[col_warn_frame],color[col_warn_title],"Packet not found!");
        cmiddle(8,"Reply packet not found, you possibly have invalid packer",color[col_warn_text]);
        cmiddle(9,"command line. Old reply packet is left in upload",color[col_warn_text]);
        cmiddle(10,"directory and work directory not erased. You can edit",color[col_warn_text]);
        cmiddle(11,"your settings and come back to try if is works now.",color[col_warn_text]);
        cmiddle(13,"Press any key to continue",color[col_warn_hilight]);
        if (sk_getch() == 0) sk_getch();
        return 0;
    }

    return 1;
}

void save_bookmarks(void)
{
    unsigned short cx,cy;
    char *oldscr;

    int slen;
    char str[256],tmp[256],*pstr;

    struct stat *statbuf;
    struct utimbuf utim;


    slen = strlen(setup.workpath); setup.workpath[slen-1] = 0;
    ChangeDir(setup.workpath);
    setup.workpath[slen-1] = SLASH;

    if ((savebook) && (!packet.open))
    {
        if (FileStat(strcat(strcpy(tmp,downpath),mailpktname),&statbuf) != 0)
        {
            free(statbuf);
            return;
        }
        utim.actime = time(NULL);
        utim.modtime = *ST_MTIME(statbuf);
        free(statbuf);

        switch (arcfmt)
        {
            case format_aux: strcpy(tmp,setup.aux_cmd); break;
            case format_zip: strcpy(tmp,setup.zip_cmd); break;
            case format_arj: strcpy(tmp,setup.arj_cmd); break;
            case format_rar: strcpy(tmp,setup.rar_cmd); break;
            case format_uc2: strcpy(tmp,setup.uc2_cmd); break;
            case format_lha: strcpy(tmp,setup.lha_cmd); break;
        }

        if (fmt == format_bw)
        {
            strcpy(str, REST);
        }
        else if (fmt == format_omen)
        {
            sprintf(str, "omen%s.xti", omentag); search_ign_file(str);
        }
        else
        {
            sprintf(str, "%s.xti", pktname); search_ign_file(str);
        }
        sprintf(tmp+strlen(tmp), " %s%s %s", downpath, mailpktname, str);

        if (setup.misc_flags & MISC_DISPLAY_OUTPUT)
        {
            tclrscr();
            middle_box(3,lang[20],color[col_packing_frame],color[col_packing_text]);
            gotoxy(1,7);
        }
        else
        {
            save_scr(&cx,&cy,&oldscr);
            middle_box(11,lang[20],color[col_packing_frame],color[col_packing_text]);
        }
        refresh();

        pstr = strchr(tmp,' '); *pstr = 0;
        swapexec(tmp,pstr+1,(setup.misc_flags & MISC_DISPLAY_OUTPUT) == 0);
        nocursor();

        if ((setup.misc_flags & MISC_DISPLAY_OUTPUT) == 0) old_scr(cx,cy,&oldscr);
        FileTime(strcat(strcpy(tmp,downpath),mailpktname),&utim);
    }
    else if ((packet.open) && (!savebook))
    {
        strcat(strcpy(tmp,setup.packetpath),pkt->xtiname);
        strcat(strcpy(str,setup.workpath),pkt->xtiname);
        copyfile(str,tmp);
    }
}

void unpack_msgpacket(char *name)
{
    char path[256],tmp[256],*strp;
    size_t slen;
#ifndef __NO_DRIVES__
    unsigned drive,drives;
#endif

    /* Save old path */
#ifndef __NO_DRIVES__
    _dos_getdrive(&drive);
#endif
    getcwd(path,sizeof(path));

    /* Change to work drive */
#ifndef __NO_DRIVES__
    if (setup.workpath[1] == ':')
        _dos_setdrive(toupper(setup.workpath[0])-64,&drives);
#endif

    /* Change to work path */
    slen = strlen(setup.workpath); setup.workpath[slen-1] = 0;
    ChangeDir(setup.workpath);
    setup.workpath[slen-1] = SLASH;

    switch (arcfmt)
    {
        case format_aux: strcpy(tmp,setup.unaux_cmd); break;
        case format_zip: strcpy(tmp,setup.unzip_cmd); break;
        case format_arj: strcpy(tmp,setup.unarj_cmd); break;
        case format_rar: strcpy(tmp,setup.unrar_cmd); break;
        case format_uc2: strcpy(tmp,setup.unuc2_cmd); break;
        case format_lha: strcpy(tmp,setup.unlha_cmd); break;
    }
    sprintf(tmp+strlen(tmp)," %s",name);

    if (setup.misc_flags & MISC_DISPLAY_OUTPUT)
    {
        tclrscr();
        middle_box(3,lang[19],color[col_packing_frame],color[col_packing_text]);
        gotoxy(1,7);
    }
    else
    {
        /* Don't display output, redirect stdout */
        middle_box(11,lang[19],color[col_packing_frame],color[col_packing_text]);
    }

    /* Unpack msg packet */
    strp = strchr(tmp,' '); *(strp++) = '\0';
    swapexec(tmp,strp,(setup.misc_flags & MISC_DISPLAY_OUTPUT) == 0);
    nocursor();

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(path);
}

void read_mailpacket(char old)
{
    char eraseok;
    char str[256],tmp[256],path[256],*strp;

    FILE *F;
    struct stat *statbuf;

    unsigned short ox,oy;
    char *oldscr;

    pkt_type tmppkt;

#ifndef __NO_DRIVES__
    unsigned drive,drives;
#endif

    long lnum;
    int ypos,ch,quit,found,arealist,err,readed;
    unsigned num,replies;


    packet_modified = 0;
    show_kludges = 0;
    makecmnt = (packet.pkt_note[0] != 0);
    strcpy(cmnt, packet.pkt_note);

    eraseok = 1;

    /* Open mail packet */
    sprintf(str,"%s%s",downpath,mailpktname);
    F = FileOpen(str,"rb");
    if (F == NULL)
    {
        err_box("Can't open message packet");
        return;
    }
    arcfmt = detect_archiver(F);
    fclose(F);

    save_scr(&ox,&oy,&oldscr);
    if (packet.open)
    {
        arcfmt = packet.arcfmt;
        strncpy(pktname, mailpktname,8); pktname[8] = 0;

        strp = strrchr(pktname,'.');
        if (strp != NULL) *strp = '\0';

        if (!old)
        {
            /* Create work and reply paths if they don't exist */
            if (!isdir(setup.workpath)) mkpath(setup.workpath);
            if (!isdir(setup.replypath)) mkpath(setup.replypath);

            /* Erase work and reply paths */
            erase_workdir();
            erase_replydir();
        }
        goto oldpacket;
    }

    if (old) goto oldpacket;

    /* Create work and reply paths if they don't exist */
    if (!isdir(setup.workpath)) mkpath(setup.workpath);
    if (!isdir(setup.replypath)) mkpath(setup.replypath);

    /* Erase work and reply paths */
    erase_workdir();
    erase_replydir();

    /* Unpack message packet */
    if (arcfmt != format_sky) unpack_msgpacket(str);

    /* pktname = mailpktname without an extension */
    strp = strrchr(mailpktname,'.');
    if (strp != NULL) *strp = '\0';
    strcpy(pktname,mailpktname);
    if (strp != NULL) *strp = '.';

oldpacket:
    /* Create work\~RESTART.SKY */
    sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
    Fsky = FileOpen(tmp,"w+b");
    if (Fsky == NULL)
    {
        sprintf(str,"Could not create file %s",tmp);
        err_box(str);
        return;
    }
    fwrite(mailpktname,13,1,Fsky);
    fwrite(&arcfmt,1,1,Fsky);
    fwrite(&replyopen,1,1,Fsky);
    fwrite(&replymgr,1,1,Fsky);
    fwrite(&packet,sizeof(packet),1,Fsky);

    /* Close & open again to make sure it is saved to disk */
    fclose(Fsky);
    sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
    Fsky = FileOpen(tmp,"r+b");

    /* Get packet format */
    fmt = (char) (packet.open ? packet.fmt : detect_packet());

    old_scr(ox,oy,&oldscr);

    read_setup(NULL); /* To get opt.alias work right.. */

    replymgr = 0;
    switch (fmt)
    {
        case format_bw:
            /* Open Blue Wave packet */
            strcpy(fmt_short,"BW");
            strcpy(ext,".new");

            /* Search *.INF files */
            sprintf(tmp,"%s*.inf",setup.workpath);
            err = findfile(tmp, str) == NULL;
            str[strlen(str)-3] = '\0';

            if (!err)
            {
                sprintf(tmp,"%s%s",setup.workpath,str);
                open_packet(tmp,format_bw);
            }
            break;
        case format_hippo:
            /* Open Hippo packet */
            strcpy(ext,".hra");
            strcpy(fmt_short,"Hippo");
            sprintf(tmp,"%s%s.",setup.workpath,pktname);
            err = open_packet(tmp,format_hippo);
            break;
        case format_omen:
            /* Open OMEN packet */
            strcpy(fmt_short,"omen");
            switch (arcfmt) {
                case format_zip: strcpy(ext, ".zip"); break;
                case format_arj: strcpy(ext, ".arj"); break;
                case format_rar: strcpy(ext, ".rar"); break;
                case format_uc2: strcpy(ext, ".uc2"); break;
                case format_lha: strcpy(ext, ".lzh"); break;
                case format_aux: strcpy(ext, ".aux"); break;
            }

            sprintf(tmp, "%snewmsg??.txt", setup.workpath);
            findfile(tmp, str);
            omentag[0] = (char) tolower(str[6]);
            omentag[1] = (char) tolower(str[7]);
            omentag[2] = '\0';

            sprintf(tmp,"%s%s.",setup.workpath,pktname);
            err = open_packet(tmp,format_omen);
            strcat(strcpy(pktname,"return"),omentag);
            break;
        case format_qwk:
            /* Open QWK packet */
            strcpy(ext,".rep");
            strcpy(fmt_short,"QWK");
            sprintf(tmp,"%s%s.",setup.workpath,pktname);
            err = open_packet(tmp,format_qwk);
            break;
        case format_jam:
            /* Open JAM message base */
            ext[0] = '\0';
            strcpy(fmt_short,"JAM");
            sprintf(tmp,"%s%s",downpath,mailpktname);
            err = open_packet(tmp,format_jam);
            break;
        case format_soup:
            /* Open SOUP packet */
            strcpy(ext,".rep");
            strcpy(fmt_short,"SOUP");
            sprintf(tmp,"%s%s.",setup.workpath,pktname);
            err = open_packet(tmp,format_soup);
            break;
        default:
            /* Error, unidentified message packet */
            fclose(Fsky);
            sprintf(tmp,"%s~RESTART.SKY",setup.workpath); FileRemove(tmp);
            corrupted();
            return;
    }

    if (err)
    {
        /* Error opening mail packet */
        fclose(Fsky);
        sprintf(tmp,"%s~RESTART.SKY",setup.workpath); FileRemove(tmp);

        switch (err)
        {
            case 1:
                corrupted();
                return;
            case 2:
                not_enough_memory();
                return;
            case 4:
                cannot_create_file();
                return;
            case 5:
                cannot_write_file();
                return;
            default:
                return;
        }
    }

    /* Get reply packet name */
    strcpy(reppkt,setup.uppath);
    if (fmt == format_omen)
    {
        /* OMEN reply packet.. */
        sprintf(tmp,"%s%s.*",setup.uppath,pktname);
        if (!findfile(tmp, reppkt))
        {
            /* Reply packet not found */
            strcat(strcat(reppkt,pktname),ext);
        }
    }
    else
    {
        /* Any other format reply packet */
        strcat(strcat(reppkt,pktname),ext);
    }

    if ((old && replyopen) || !exists(reppkt))
    {
        /* Update work\~RESTART.SKY */
        replyopen = 1;
        fseek(Fsky,14,SEEK_SET);
        fwrite(&replyopen,1,1,Fsky);

        /* Reopen work\~RESTART.SKY */
        fclose(Fsky);
        sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
        Fsky = FileOpen(tmp,"r+b");
    }
    else
    {
        /* Ask what to do with reply packet */
        if (!replyopen) doto_packet(reppkt,0);
    }

    pkt->open_replypacket(pkt);

    /* Make data\packet.INF file */
    sprintf(tmp,"%s%s.inf",setup.datapath,pktname);
    pkt->save_info(pkt, tmp);

    mailscanned = 0;

    packet.fmt = fmt;
    packet.total = 0;
    packet.personal = 0;

    /* Get number of total and personal messages in message packet */
    for (num=1; num<=pkt->areas; num++)
    {
        strp = pkt->get_area_number(pkt, num);

        if (!pkt->open_area(pkt, strp)) continue;

        packet.total += pkt->get_msgs(pkt, strp);
        packet.personal += pkt->get_personal_msgs(pkt, strp);
    }

    msgs_in_mem = 0;

    if (!packet.open)
    {
        sprintf(tmp,"%s%s",downpath,mailpktname);
        if (FileStat(tmp,&statbuf) != 0)
        {
            /* Could not find message packet */
            packet.size = 0;
        }
        else
        {
            /* Get message packet time and size */
            packet.time = *ST_MTIME(statbuf);
            packet.size = ST_SIZE(statbuf);
        }
        free(statbuf);
    }

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(5,4,37,12,color[col_box_frame],color[col_box_title],lang[39]);
    cwritexy(7,5,lang[40],color[col_box_hilight]);
    cwritexy(7,6,lang[41],color[col_box_hilight]);
    cwritexy(7,7,lang[42],color[col_box_hilight]);
    cwritexy(7,8,lang[43],color[col_box_hilight]);
    cwritexy(7,9,lang[44],color[col_box_hilight]);
    cwritexy(7,10,lang[45],color[col_box_hilight]);
    cwritexy(7,11,lang[46],color[col_box_hilight]);

    switch(fmt)
    {
        case format_bw: cwritexy(19,5,"Blue Wave",color[col_box_text]); break;
        case format_qwk: cwritexy(19,5,"QWK",color[col_box_text]); break;
        case format_omen: cwritexy(19,5,"OMEN",color[col_box_text]); break;
        case format_hippo: cwritexy(19,5,"Hippo",color[col_box_text]); break;
        case format_soup: cwritexy(19,5,"SOUP",color[col_box_text]); break;
    }

    cwritexy(19,6,dtstr(tmp,packet.time),color[col_box_text]);
    sprintf(tmp,"%lu",packet.size);
    cwritexy(19,7,tmp,color[col_box_text]);
    sprintf(tmp,"%u",packet.total);
    cwritexy(19,8,tmp,color[col_box_text]);
    sprintf(tmp,"%u",packet.personal);
    cwritexy(19,9,tmp,color[col_box_text]);
    cwritexy(19,11,pkt->username,color[col_box_text]);

    settitle(conv_macros(setup.title,tmp));

    tbar(1,scrsize-1,scrwidth,scrsize-1,color[col_bbs_name]);
    tbar(1,scrsize,scrwidth,scrsize,color[col_sysop_name]);
    cwritexy(2,scrsize-1,"BBS   :",color[col_bbs_name_text]); cwritexy(10,scrsize-1,pkt->board_name,color[col_bbs_name]);
    cwritexy(2,scrsize,"Sysop :",color[col_sysop_name_text]); cwritexy(10,scrsize,pkt->sysop_name,color[col_sysop_name]);
    draw_shaded_box(44,4,76,12,color[col_box_frame],color[col_box_title],lang[11]);

    if (fmt == format_soup && setup.inet_addr[0] == '\0')
        err_box("Your internet address is empty, set it from setup -> string settings");

    ypos = 1;

    while (ypos > 0)
    {
        /* Read configuration */
        read_setup(NULL);
        read_table(1,inbound,opt.intable);
        read_table(0,outbound,opt.outtable);

        tbar(19,10,32,10,color[col_box_text]);
        if (replyopen)
        {
            /* Print number of replies */
            sprintf(tmp,"%u",pkt->replies);
            cwritexy(19,10,tmp,color[col_box_text]);
        }
        else
        {
            /* Number of replies not known */
            cwritexy(19,10,lang[47],color[col_box_text]);
        }

        for (num=0; num<7; num++)
            keys[num] = toupper(highwrite(46,num+5,lang[12+num],&keypos[num]));
        tattrbar(45,4+ypos,75,4+ypos,color[col_box_select]);

        quit = 0;
        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = toupper(sk_getch());
                for (num=0; num<7; num++)
                {
                    if (toupper(keys[num]) == ch)
                    {
                        rm_clropt(ypos); ypos--;
                        ypos = num+1;
                        quit = 1;
                        tattrbar(45,ypos+4,75,ypos+4,color[col_box_select]);
                    }
                }

                if (!quit)
                {
                    switch (ch)
                    {
                        case 27:
                            /* ESC */
                            rm_clropt(ypos);
                            ypos = 7;
                            quit = 1;
                            break;
                        case 13:
                            /* Enter */
                            quit = 1;
                            break;
                        case 0:
                            ch = sk_getch();
                            switch(ch)
                            {
                                case '$':
                                    /* Jump to OS shell */
                                    shell_dos();
                                    break;
                                case 'H':
                                    /* Up */
                                    rm_clropt(ypos); ypos--;
                                    if (ypos == 0) ypos = 7;
                                    tattrbar(45,ypos+4,75,ypos+4,color[col_box_select]);
                                    break;
                                case 'P':
                                    /* Down */
                                    rm_clropt(ypos); ypos++;
                                    if (ypos == 8) ypos = 1;
                                    tattrbar(45,ypos+4,75,ypos+4,color[col_box_select]);
                                    break;
                            }
                    }
                }
            }
            else
            {
                give_timeslice();
            }
        }

        /* What to do? */
        switch (ypos)
        {
            case 1: read_msgs(); break;
            case 2: read_replies(0); break;
            case 3: enter_msg(0); break;
            case 4: show_ansis(); break;
            case 5: show_file(1,NULL); break;
            case 6: offline_config(44,4,76,12); break;
            default:
                /* Ask "ending box" */
                if (arcfmt == format_sky || ask_ending_box()) ypos = 0;
                break;
        }
    }

    if (arcfmt == format_sky)
    {
        pkt->close_packet(pkt);
        erase_workdir();
        old_scr(ox,oy,&oldscr);
        settitle(Reader_Name);
        return;
    }

    /* Open data\packets.inf */
    sprintf(str,"%spackets.inf",setup.datapath);
    Finf = FileOpen(str,"r+b");
    if (Finf == NULL)
    {
        Finf = FileOpen(str,"w+b");
    }
    else
    {
        /* Seek to correct position of data\packets.inf */
        fseek(Finf,0,SEEK_SET);
        found = 0; num = 0;
        while (fread(&tmppkt,sizeof(tmppkt),1,Finf))
        {
            if (strcmp(tmppkt.fname,mailpktname) == 0)
            {
                found = 1;
                if (!renpkt) break;
            }
            if ((renpkt) && (stricmp(tmppkt.fname,renname) == 0)) renpkt = 0;
            if (!found) num++;
        }

        if (!found)
        {
            /* Not found, add to end of file */
            fseek(Finf,0,SEEK_END);
        }
        else
        {
            fseek(Finf,num*sizeof(pkt_type),SEEK_SET);
        }
    }

    /* Make packet comment */
    if (makecmnt) strcpy(packet.pkt_note,cmnt); else packet.pkt_note[0] = '\0';

    /* Do we have to FileRename message packet? */
    if (renpkt && arcfmt != format_sky)
    {
        if (packet.open)
        {
            /* Packet is "open" in packets directory, check if there's
               duplicates */
            sprintf(tmp,"%s%s",downpath, renname);
            if (!exists(tmp))
                strcpy(mailpktname,renname);
        }
        else
        {
            sprintf(tmp,"%s%s",downpath,mailpktname);
            sprintf(str,"%s%s",downpath,renname);

            if (FileRename(tmp,str) == 0)
            {
                /* Rename ok, no duplicates.. */
                strcpy(mailpktname,renname);
            }
            else
            {
                sprintf(tmp+strlen(tmp)," -> %s : Rename error",str);
                err_box(tmp);
            }
        }
    }

    lnum = 0;
    packet.fmt = fmt;
    packet.total = 0;
    packet.personal = 0;

    /* Get number of personal/unread/total messages in message packet */
    for (num=1; num<=pkt->areas; num++)
    {
        strp = pkt->get_area_number(pkt, num);

        if (!pkt->open_area(pkt, strp)) continue;

        packet.total += pkt->get_msgs(pkt, strp);
        packet.personal += pkt->get_personal_msgs(pkt, strp);
        lnum += pkt->get_unread_msgs(pkt, strp);
    }

    if (!packet.open) packet.pktnumber = (unsigned short) pkt->first;

    /* Close reply packet */
    pkt->close_replypacket(pkt);

    /* Close packet */
    arealist = pkt->arealist;
    replies = pkt->replies;
    close_packet();

    /* Just to make sure no messages are left in memory... */
    if (msgs_in_mem) free(mem_msgs);

    /* Save old drive & path */
#ifndef __NO_DRIVES__
    _dos_getdrive(&drive);
#endif
    getcwd(path,sizeof(path));

    fseek(Fsky, 0, SEEK_SET);
    readed = fread(str, 1, sizeof(str), Fsky);
    fclose(Fsky);

    sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
    FileRemove(tmp);

    switch (fmt)
    {
        case format_qwk:
            sprintf(tmp,"%s%s.mix", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);
            break;
        case format_omen:
            sprintf(tmp,"%smsgs.idx", setup.workpath); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%smsgs.dat", setup.workpath); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%smsgs.mix", setup.workpath); search_ign_file(tmp); FileRemove(tmp);
            break;
        case format_hippo:
            {
                find_t SR;
                int Error;

            sprintf(tmp,"%snewfiles.dat", setup.workpath); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%sAREAS.DAT", setup.workpath); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%s%s.dat", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%s%s.mix", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%s%s.idx", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%s%s.inf", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);

            sprintf(tmp,"%s*.bul", setup.workpath);
            Error = _dos_findfirst(tmp, 0, &SR);
            while (Error == 0)
            {
                sprintf(tmp, "%s%s", setup.workpath, SR.name);
                FileRemove(tmp);
                Error = _dos_findnext(&SR);
            }
#ifdef FIND_CLOSE
            _dos_findclose(&SR);
#endif
            }
            break;
        case format_soup:
            sprintf(tmp,"%s%s.inf", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);
            sprintf(tmp,"%s%s.mix", setup.workpath, pktname); search_ign_file(tmp); FileRemove(tmp);
            break;
    }

    /* Pack .XTI file inside msg packet */
    if (!delpkt) save_bookmarks();

    /* Pack reply packet */
    if (pack_replypacket(arealist,replies) == 0) eraseok = 0;

#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(path);

    if (eraseok)
    {
        erase_workdir();
        erase_replydir();
    }
    else
    {
        sprintf(tmp,"%s~RESTART.SKY",setup.workpath);
        Fsky = FileOpen(tmp,"w+b");
        if (Fsky == NULL)
        {
            sprintf(str,"Could not create file %s",tmp);
            err_box(str);
        }
        else
        {
            fwrite(str, readed, 1, Fsky);
            fclose(Fsky);
        }
    }
    old_scr(ox,oy,&oldscr);

    if (!packet.open)
    {
        /* Get mail packet size and time */
        sprintf(tmp,"%s%s",downpath,mailpktname);
        if (FileStat(tmp,&statbuf) != 0)
        {
            packet.size = 0;
        }
        else
        {
            packet.time = *ST_MTIME(statbuf);
            packet.size = ST_SIZE(statbuf);
        }
        free(statbuf);
    }

    if (lnum > packet.total) lnum = packet.total;

    strcpy(packet.fname, mailpktname);
    strcpy(packet.replypkt, pktname);

    /* Set percentage of unread messages */
    if (packet.total == 0)
        packet.unread = 0;
    else
        packet.unread = (char) (100-((lnum*100) / packet.total));

    if ((!packet.open) && (setup.packet_flags & PKT_SAVE_UNPACKED) && (fmt == format_hippo))
    {
        /* Packets are kept unpacked.. */
        sprintf(tmp,"%s%s",downpath,mailpktname);
        if (setup.packet_flags & PKT_KEEP_PACKED)
        {
            /* Move packet to "old packets" directory */
            sprintf(str,"%s%s",setup.oldpktpath,mailpktname);
            if (FileRename(tmp,str) != 0)
                if (copyfile(tmp,str)) FileRemove(tmp);
        }
        else
        {
            /* Remove packet */
            FileRemove(tmp);
        }
    }

    packet.open = (setup.packet_flags & PKT_SAVE_UNPACKED) && (fmt == format_hippo);

    packet.arcfmt = arcfmt;
    if ((delpkt) && (arcfmt != format_sky))
    {
        /* Mail packet should be deleted */
        sprintf(tmp,"%s%s",downpath,mailpktname);
        FileRemove(tmp);
    }
    else if ((movepkt) && (arcfmt != format_sky))
    {
        /* Mail packet should be moved to "old packets" directory */
        sprintf(tmp,"%s%s",downpath,mailpktname);
        sprintf(str,"%s%s",setup.oldpktpath,mailpktname);

        if (FileRename(tmp,str) != 0)
            if (copyfile(tmp,str)) FileRemove(tmp);
    }
    else
    {
        /* Updata data\packets.inf file */
        if (stricmp(downpath,setup.downpath) == 0)
        {
            if ((packet.size > 0) && (Finf != NULL))
                fwrite(&packet,sizeof(pkt_type),1,Finf);
        }
    }

    fclose(Finf);
    settitle(Reader_Name);
}
