#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "scrsaver.h"
#include "shell.h"
#include "readsets.h"
#include "entermsg.h"
#include "writemsg.h"
#include "readarea.h"
#include "readfunc.h"
#include "readmail.h"
#include "general.h"
#include "screen.h"
#include "vars.h"
#include "setup.h"
#include "keyb.h"

static unsigned rr_ypos,rr_upy;
static unsigned short *replysort;

char read_outbound(unsigned *ypos, unsigned *upy);

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != 0)
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

void draw_replyline(char ypos, unsigned num)
{
    unsigned subjlen,arealen,len;
    char tmp[256];

    subjlen = (scrwidth-14) / 2;
    if (subjlen*2 < scrwidth-14) subjlen++;

    arealen = subjlen/4;
    arealen += subjlen%4;
    len = (subjlen-arealen) / 2;

    tbar(2,ypos,scrwidth-1,ypos,color[col_list_number]);
    pkt->read_reply(pkt, replysort[num-1]);
    if (fmt != format_bw)
    {
        strcpy(tmp, pkt->get_area_name(pkt, pkt->gettag(pkt, reply.area))); tmp[arealen] = '\0';
        cwritexy(3,ypos,tran(tmp),color[col_list_number]);
    }
    else
    {
        if (arealen < sizeof(reply.area)-1) reply.area[arealen] = 0;
        cwritexy(3,ypos,tran(reply.area),color[col_list_number]);
    }
    if (len < sizeof(reply.mfrom)-1) reply.mfrom[len] = 0;
    cwritexy(4+arealen,ypos,tran(reply.mfrom),color[col_list_from]);
    if (len < sizeof(reply.mto)-1) reply.mto[len] = 0;
    cwritexy(5+arealen+len,ypos,tran(reply.mto),color[col_list_to]);
    if (subjlen < sizeof(reply.subj)-1) reply.subj[subjlen] = 0;
    cwritexy(6+arealen+len*2,ypos,tran(reply.subj),color[col_list_subj]);

    if (reply.flags & flag_deleted)
        cwritexy(scrwidth-7,ypos,"Delete",color[col_list_flags]);
    else
    {
#ifdef __linux__
        if (reply.flags & flag_private)
            cwritexy(scrwidth-7,ypos,"Pvt...",color[col_list_flags]);
        else
            cwritexy(scrwidth-7,ypos,"......",color[col_list_flags]);
#else
        if (reply.flags & flag_private)
            cwritexy(scrwidth-7,ypos,"Pvt",color[col_list_flags]);
        else
            cwritexy(scrwidth-7,ypos,"",color[col_list_flags]);
#endif
    }
}

void delete_toggled(void)
{
    unsigned short ox,oy;
    char *oldscr;

    char quit,yes,ch;
    unsigned nro;
    size_t slen;

    save_scr(&ox,&oy,&oldscr);
    slen = get_max_langtext_len(189,191)/2;
    draw_shaded_box(scrwidth/2-slen-2,8,scrwidth/2+slen+2,13,color[col_info_frame],color[col_info_title],lang[189]);
    cmiddle(10,lang[190],color[col_info_text]);
    cmiddle(11,lang[191],color[col_info_text]);
    tattrbar(scrwidth/2-slen-1,10,scrwidth/2+slen+1,10,color[col_info_selectbar]);
    quit = 0; yes = 1;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    quit = 1; break;
                case 0:
                    ch = sk_getch();
                    if ((ch == 'H') || (ch == 'P')) {
                        yes = !yes;
                        if (yes) {
                            tattrbar(scrwidth/2-slen-1,10,scrwidth/2+slen+1,10,color[col_info_selectbar]);
                            tattrbar(scrwidth/2-slen-1,11,scrwidth/2+slen+1,11,color[col_info_text]);
                        } else {
                            tattrbar(scrwidth/2-slen-1,10,scrwidth/2+slen+1,10,color[col_info_text]);
                            tattrbar(scrwidth/2-slen-1,11,scrwidth/2+slen+1,11,color[col_info_selectbar]);
                        }
                    }
            }
        } else give_timeslice();
    }

    if (yes)
    {
        nro = pkt->replies;
        while (nro >= 1)
        {
            pkt->read_reply(pkt, nro);
            if (reply.flags & flag_deleted)
                pkt->delete_reply(pkt, nro);
            nro--;
        }
    }

    old_scr(ox,oy,&oldscr);
}

int compare_reply_subj(const void *op1, const void *op2)
{
    unsigned short **p1 = (unsigned short **) op1;
    unsigned short **p2 = (unsigned short **) op2;

    char str[101];

    pkt->read_reply(pkt, (unsigned) *p1);
    tran(strcpy(str,reply.subj));
    pkt->read_reply(pkt, (unsigned) *p2);
    tran(reply.subj);

    return stricmp(str,reply.subj);
}

int compare_reply_area(const void *op1, const void *op2)
{
    unsigned short **p1 = (unsigned short **) op1;
    unsigned short **p2 = (unsigned short **) op2;

    char str[101], str2[101];
    int ret;

    if (fmt != format_bw)
    {
        pkt->read_reply(pkt, (unsigned) *p1);
        tran(strcpy(str,pkt->get_area_name(pkt, pkt->gettag(pkt, reply.area))));
        pkt->read_reply(pkt, (unsigned) *p2);
        tran(strcpy(str2, pkt->get_area_name(pkt, pkt->gettag(pkt, reply.area))));
    }
    else
    {
        pkt->read_reply(pkt, (unsigned) *p1);
        tran(strcpy(str,reply.area));
        pkt->read_reply(pkt, (unsigned) *p2);
        tran(strcpy(str2, reply.area));
    }

    ret = stricmp(str,str2);
    if (ret == 0)
    {
        tran(strcpy(str,reply.subj));
        pkt->read_reply(pkt, (unsigned) *p1);
        tran(reply.subj);

        return stricmp(reply.subj,str);
    }

    return ret;
}

int compare_reply_to(const void *op1, const void *op2)
{
    unsigned short **p1 = (unsigned short **) op1;
    unsigned short **p2 = (unsigned short **) op2;

    char str[36];
    int ret;

    pkt->read_reply(pkt, (unsigned) *p1);
    tran(strcpy(str,reply.mto));
    pkt->read_reply(pkt, (unsigned) *p2);
    tran(reply.mto);

    ret = stricmp(str,reply.mto);
    if (ret == 0) return compare_reply_subj(op1, op2);

    return ret;
}

void sort_replies(void)
{
    unsigned nro;

    replysort = (unsigned short *) malloc(sizeof(unsigned short)*pkt->replies);
    for (nro=0; nro<pkt->replies; nro++)
        replysort[nro] = (unsigned short) (nro+1);

    switch (opt.replysort)
    {
        case REPLYSORT_AREA:
            qsort(replysort,pkt->replies,sizeof(unsigned short),compare_reply_area);
            break;
        case REPLYSORT_SUBJ:
            qsort(replysort,pkt->replies,sizeof(unsigned short),compare_reply_subj);
            break;
        case REPLYSORT_TO:
            qsort(replysort,pkt->replies,sizeof(unsigned short),compare_reply_to);
            break;
    }
}

void read_replies(unsigned readnum)
{
    unsigned short ox,oy;
    char *oldscr;

    unsigned rr_ypos,rr_upy;
    unsigned replies,nro,max;

    char quit,ch;
    size_t slen;

    unsigned subjlen,arealen,len,oldclockcolor,old_justify;

    read_setup(NULL);

    read_table(1,inbound,opt.intable);
    read_table(0,outbound,opt.outtable);

    if (!try_open_reply()) return;
    save_scr(&ox,&oy,&oldscr);
    if (pkt->replies == 0)
    {
        slen = strlen(lang[104])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[104],color[col_warn_hilight]);
        try_key(2);
        old_scr(ox,oy,&oldscr);
        return;
    }

    sort_replies();

    draw_shaded_box(1,1,scrwidth,scrsize,color[col_list_frame],color[col_list_title],"Outbound mail");
    oldclockcolor = clockcolor;
    clockcolor = color[col_list_clock];
    draw_clock();

    draw_hline(1,scrwidth,3,color[col_list_frame]);
    cwritexy(3,2,lang[68],color[col_list_help]);
    subjlen = (scrwidth-15) / 2;
    if (subjlen*2 < scrwidth-15) subjlen++;

    arealen = subjlen/4;
    arealen += subjlen%4;
    len = (subjlen-arealen) / 2;
    cwritexy(4+arealen,2,lang[70],color[col_list_help]);
    cwritexy(5+arealen+len,2,lang[71],color[col_list_help]);
    cwritexy(6+arealen+len*2,2,lang[72],color[col_list_help]);

    rr_ypos = 1;
    if (readnum > 0)
    {
        for (nro=0; nro<pkt->replies; nro++)
        {
            if (replysort[nro] == readnum)
            {
                readnum = nro+1;
                break;
            }
        }

        rr_upy = readnum-1;
    }
    else
    {
        rr_upy = 0;
    }

    old_justify = setup.justify;
    setup.justify = JUSTIFY_NONE;
again:
    max = scrsize-4;
    if (pkt->replies-rr_upy < max) max = pkt->replies-rr_upy;
    for (nro=1; nro<=max; nro++)
        draw_replyline(nro+3,nro+rr_upy);

    tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
    if (readnum > 0) quit = 1; else quit = 0;
    replies = pkt->replies;
    readnum = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 27:
                    rr_ypos = 0; quit = 1;
                    break;
                case 13:
                    if (replies > 0) quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$': shell_dos(); break;
                        case 'S':
                            if (replies > 0) {
                                pkt->read_reply(pkt, replysort[rr_ypos+rr_upy-1]);
                                if (reply.flags & flag_deleted)
                                    pkt->toggle_deleted(pkt, replysort[rr_ypos+rr_upy-1],0);
                                else
                                    pkt->toggle_deleted(pkt, replysort[rr_ypos+rr_upy-1],1);
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                        case 'H':
                            if (rr_ypos+rr_upy > 1) {
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                if (rr_ypos == 1) {
                                    rr_upy--;
                                    scroll_down(2,4,scrwidth-1,scrsize-1);
                                    draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                } else rr_ypos--;
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                        case 'P':
                            if (rr_ypos+rr_upy < replies) {
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                if (rr_ypos == scrsize-4)
                                {
                                    rr_upy++;
                                    scroll_up(2,4,scrwidth-1,scrsize-1);
                                    draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                } else rr_ypos++;
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                        case 'G': /* Home */
                            if (rr_ypos+rr_upy > 1) {
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                rr_ypos = 1; rr_upy = 0;

                                if (pkt->replies-rr_upy < scrsize-4)
                                    max = pkt->replies-rr_upy;
                                else
                                    max = scrsize-4;

                                for (nro=1; nro<=max; nro++)
                                    draw_replyline(nro+3,nro+rr_upy);
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                        case 'O': /* End */
                            if (rr_ypos+rr_upy < replies) {
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                if (rr_upy+scrsize-4 < replies) {
                                    rr_ypos = scrsize-4;
                                    rr_upy = replies-rr_ypos;

                                    if (pkt->replies-rr_upy < scrsize-4)
                                        max = pkt->replies-rr_upy;
                                    else
                                        max = scrsize-4;

                                    for (nro=1; nro<=max; nro++)
                                        draw_replyline(nro+3,nro+rr_upy);
                                } else rr_ypos = replies-rr_upy;
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                        case 'I': /* PgUp */
                            if (rr_ypos+rr_upy > 1) {
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                if (rr_ypos == 1) {
                                    if (rr_upy > scrsize-5)
                                        rr_upy -= scrsize-5;
                                    else
                                        rr_upy = 0;

                                    if (pkt->replies-rr_upy < scrsize-4)
                                        max = pkt->replies-rr_upy;
                                    else
                                        max = scrsize-4;

                                    for (nro=1; nro<=max; nro++)
                                        draw_replyline(nro+3,nro);
                                } else rr_ypos = 1;
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                        case 'Q': /* PgDn */
                            if (rr_ypos+rr_upy < replies)
                            {
                                draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
                                if (rr_ypos == scrsize-4)
                                {
                                    rr_upy += scrsize-5;
                                    if (rr_ypos+rr_upy > replies)
                                        rr_upy = replies-rr_ypos;

                                    if (pkt->replies-rr_upy < scrsize-4)
                                        max = pkt->replies-rr_upy;
                                    else
                                        max = scrsize-4;

                                    for (nro=1; nro<=max; nro++)
                                        draw_replyline(nro+3,nro+rr_upy);
                                } else
                                    if (replies > scrsize-4)
                                        rr_ypos = scrsize-4;
                                    else
                                        rr_ypos = replies;
                                tattrbar(2,rr_ypos+3,scrwidth-1,rr_ypos+3,color[col_list_selectbar]);
                            }
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }

    if (rr_ypos > 0) {
        draw_replyline(rr_ypos+3,rr_ypos+rr_upy);
        if (!read_outbound(&rr_ypos,&rr_upy)) goto again;
    }
    free(replysort);
    clockcolor = oldclockcolor;
    setup.justify = old_justify;

    quit = 0;
    for (nro=1; nro<=replies; nro++) {
        pkt->read_reply(pkt, nro);
        if (reply.flags & flag_deleted) {
            quit = 1;
            break;
        }
    }
    old_scr(ox,oy,&oldscr);
    if (quit) delete_toggled();
    rr_ypos = 2;
}

void move_another(unsigned oldarea)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned num,max;
    unsigned _area;

    int ypos;
    unsigned upy;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    max = scrwidth-36; if (max > 60) max = 60;
    cwritexy(18+max,4,lang[100],color[col_area_help]);
    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    ypos = 1;
    if (oldarea > 0) upy = oldarea-1; else upy = 0;
    max = scrsize-7;
    if (pkt->areas-upy < max) max = pkt->areas-upy;
    for (num=1; num<=max; num++)
        draw_line_em(num+5,num+upy);

    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

    area_list_em(0,&ypos,&upy);
    _area = ypos+upy;
    if (ypos > 0)
    {
        num = pkt->area_type(pkt, _area);
        if (num & TYPE_NOPVT)
            reply.flags &= !flag_private;
        if (num & TYPE_NOPUB)
            reply.flags |= flag_private;
        strcpy(reply.area, pkt->get_area_tag(pkt, _area));
        if (fmt == format_soup)
        {
            if (num & TYPE_INET && (num & TYPE_NET) == 0)
            {
                reply.flags &= ~flag_email;
                strcpy(reply.mto, pkt->get_area_name(pkt, _area));
            }
            else
            {
                reply.flags |= flag_email;
                reply.mto[0] = '\0';
            }
        }
        pkt->edit_msg(pkt, replysort[rr_ypos+rr_upy-1]);
    }
    old_scr(cx,cy,&oldscr);
}

char read_outbound(unsigned *ypos, unsigned *upy)
{
    unsigned short ox,oy;
    char *oldscr;

    unsigned long typos;
    char ch,quit,totalquit;
    unsigned max,nro,num,oldreply,oldreplies,notext;

    char str[256],tmp[100],slen;


    rr_ypos = *ypos;
    rr_upy = *upy;
    save_scr(&ox,&oy,&oldscr);
    rot13 = 0;
drawmsg:
    pkt->read_reply(pkt, replysort[rr_ypos+rr_upy-1]);
    sprintf(str,"%s%s",setup.replypath,reply.fname);
    if (!pkt->init_replytext(pkt, str))
    {
        slen = strlen(lang[192])/2;
        draw_shaded_box(scrwidth/2-slen-2,9,scrwidth/2+slen+2,13,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(11,lang[192],color[col_warn_hilight]);
        try_key(2);
        old_scr(ox,oy,&oldscr);
        notext = 1;
        /*return 0;*/
    }
    else
        notext = 0;

    strcpy(areatag, reply.area);
    read_setup(areatag);

    read_table(1,inbound,opt.intable);
    read_table(0,outbound,opt.outtable);

    tbar(1,1,scrwidth,6,color[col_msg_frame]);
    _draw_hline(1,scrwidth,1,color[col_msg_frame]);
    _draw_hline(1,scrwidth,6,color[col_msg_frame]);
    clockcolor = color[col_msg_clock];
    draw_clock();
    num = pkt->gettag(pkt, areatag);
    if (num == 0)
    {
        ch = reply.mto[60]; reply.mto[75] = '\0';
        sprintf(str," %s ", reply.flags & flag_email ? "E-Mail" : reply.mto);
        reply.mto[60] = ch;
    }
    else
        sprintf(str," %s ",pkt->get_area_name(pkt, num));
    cmiddle(1,str,color[col_msg_title]);
    cwritexy(1,2,lang[193],color[col_msg_label]);
    cwritexy(1,3,lang[194],color[col_msg_label]);
    if (fmt == format_soup && (reply.flags & flag_email) == 0)
        cwritexy(1,4,lang[294],color[col_msg_label]);
    else
        cwritexy(1,4,lang[195],color[col_msg_label]);
    if ((reply.netflags & NET_FATTACH) || (reply.netflags & NET_FREQ))
        cwritexy(1,5,lang[196],color[col_msg_label]);
    else
        cwritexy(1,5,lang[197],color[col_msg_label]);
    cwritexy(50,4,lang[198],color[col_msg_label]);

    sprintf(str,"%s %4d",lang[81],pkt->txt_lines);
    slen = strlen(str);
    writechr(scrwidth-slen-2,6,'[',color[col_msg_frame]);
    writechr(scrwidth-1,6,']',color[col_msg_frame]);
    cwritexy(scrwidth-slen-1,6,str,color[col_msg_title]); /* Lines: xxxx */

    typos = 0;
    sprintf(str,"%u/%u",rr_ypos+rr_upy,pkt->replies);
    cwritexy(9,2,str,color[col_msg_msgnum]);
    cwritexy(60,4,reply.date,color[col_msg_date]);

    if (reply.flags & flag_deleted)
        cwritexy(54,3,"Deleted",color[col_msg_flags_on]);

    tmp[0] = 0;
    if (reply.flags & flag_private)
        strcat(tmp,"Pvt ");
    if ((reply.flags & flag_netmail) && ((reply.flags & flag_email) == 0))
    {
        if (reply.netflags & NET_DIRECT)
            strcat(tmp,"Direct ");
        if (reply.netflags & NET_CRASH)
            strcat(tmp,"Crash ");
        if (reply.netflags & NET_FATTACH)
            strcat(tmp,"w/File ");
        if (reply.netflags & NET_KILLSENT)
            strcat(tmp,"K/Sent ");
        if (reply.netflags & NET_HOLD)
            strcat(tmp,"Hold ");
        if (reply.netflags & NET_IMMEDIATE)
            strcat(tmp,"Imm ");
        if (reply.netflags & NET_FREQ)
            strcat(tmp,"F/Req ");
    }

    cwritexy(25,2,tmp,color[col_msg_status]);

redraw:
    cwritexy(9,3,tran(reply.mfrom),color[col_msg_from]);
    tran(strcpy(tmp,reply.mto));
    if (fmt != format_qwk)
    {
        num = pkt->area_type(pkt, pkt->gettag(pkt, reply.area));

        if ((num & TYPE_ECHO) && (num & TYPE_NET) && ((num & TYPE_INET) == 0)) {
            sprintf(str,", %u:%u/%u.%u",reply.destzone,reply.destnet,reply.destnode,reply.destpoint);
            strcat(tmp,str);
        }
    }
    tmp[44] = 0;
    cwritexy(9,4,tmp,color[col_msg_to]); slen = strlen(reply.subj);
    if (slen > (int) (scrwidth-7)) { ch = reply.subj[scrwidth-7]; reply.subj[scrwidth-7] = '\0'; }
    write_bolded(9,5,tran(reply.subj),color[col_msg_subj]);
    if (slen > (int) (scrwidth-7)) reply.subj[scrwidth-7] = ch;

    tbar(1,7,scrwidth-1,scrsize,color[col_text_normal]);
    if (!notext)
    {
        max = scrsize-6;
        if (max > pkt->txt_lines-typos) max = pkt->txt_lines-typos;
        for (nro=1; nro<=max; nro++)
            draw_textline(nro+6,pkt->read_replyline(pkt, str,nro+typos));
    }

    draw_scrollbar(typos);

    totalquit = 0;
    quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = toupper(sk_getch());
            switch(ch) {
                case 13:
                    if (rr_ypos+rr_upy < pkt->replies) {
                        if (rr_ypos == scrsize-4) rr_upy++; else rr_ypos++;
                        if (!notext) pkt->deinit_replytext(pkt);
                        goto drawmsg;
                    } else {
                        totalquit = 1;
                        quit = 1;
                    }
                    break;
                case 'T':
                case 'L':
                case 27: quit = 1; break;
                case 'S': save_msg(1); break;
                case 'R': rot13 = !rot13; goto redraw;
                case 'E':
                    if (!notext) pkt->deinit_replytext(pkt);
                    ch = rot13;
                    oldreplies = pkt->replies;
                    write_msg(replysort[rr_ypos+rr_upy-1],reply.area,reply.mto,reply.subj,(reply.flags & flag_private) > 0,2,0);
                    rot13 = ch;

                    /* New replies! Sort them again. */
                    if (pkt->replies != oldreplies) {
                        oldreply = replysort[rr_ypos+rr_upy-1];
                        free(replysort);
                        sort_replies();
                        for (num=0; num<pkt->replies; num++)
                            if (replysort[num] == oldreply) {
                                rr_ypos = 1;
                                rr_upy = num;
                                break;
                            }
                    }
                    goto drawmsg;
                case 'M': move_another(pkt->gettag(pkt, reply.area)); goto drawmsg;
                case 0:
                    ch = sk_getch();
                    switch(ch) {
                        case '$':
                            shell_dos();
                            break;
                        case 18:
                            write_msg(replysort[rr_ypos+rr_upy-1],reply.area,reply.mto,reply.subj,(reply.flags & flag_private) > 0,2,99);
                            goto drawmsg;
                        case 20:
                            transtable(NULL,inbound);
                            goto redraw;
                        case 24:
                            transtable(NULL,outbound);
                            break;
                        case 46:
                            /* Alt-C - Run setup */
                            run_setup();
                            read_setup(areatag);
                            read_table(1,inbound,opt.intable);
                            read_table(0,outbound,opt.outtable);
                            goto drawmsg;
                        case 96:
                            rot13 = !rot13;
                            goto redraw;
                        case 'S':
                            if (reply.flags & flag_deleted)
                            {
                                pkt->toggle_deleted(pkt, replysort[rr_ypos+rr_upy-1],0);
                                cwritexy(54,3,"       ",color[col_msg_frame]);
                                reply.flags &= ~flag_deleted;
                            }
                            else
                            {
                                pkt->toggle_deleted(pkt, replysort[rr_ypos+rr_upy-1],1);
                                cwritexy(54,3,"Deleted",color[col_msg_flags_on]);
                                reply.flags |= flag_deleted;
                            }
                            break;
                        case 'K':
                            if (rr_ypos+rr_upy > 1)
                            {
                                if (rr_ypos == 1) rr_upy--; else rr_ypos--;
                                if (!notext) pkt->deinit_replytext(pkt);
                                goto drawmsg;
                            }
                            break;
                        case 'M':
                            if (rr_ypos+rr_upy < pkt->replies)
                            {
                                if (rr_ypos == scrsize-4) rr_upy++; else rr_ypos++;
                                if (!notext) pkt->deinit_replytext(pkt);
                                goto drawmsg;
                            }
                            else
                            {
                                totalquit = 1;
                                quit = 1;
                            }
                            break;
                        case 'H':
                            if (typos > 0)
                            {
                                typos--;
                                scroll_down(1,7,scrwidth-1,scrsize);
                                draw_textline(7,pkt->read_replyline(pkt, str,typos+1));
                                draw_scrollbar(typos);
                            }
                            break;
                        case 'P':
                            if (!notext && (typos+scrsize-6 < pkt->txt_lines || (setup.misc_flags & MISC_SCROLL_DOWN && typos < pkt->txt_lines-1)))
                            {
                                typos++;
                                scroll_up(1,7,scrwidth-1,scrsize);
                                draw_textline(scrsize,pkt->read_replyline(pkt, str,typos+scrsize-6));
                                draw_scrollbar(typos);
                            }
                            break;
                        case 'Q':
                            if (typos+scrsize-6 < pkt->txt_lines)
                            {
                                typos += scrsize-7;
                                if (typos > pkt->txt_lines) typos = pkt->txt_lines;
                                goto redraw;
                            }
                            break;
                        case 'I':
                            if (typos > 0)
                            {
                                if (typos < scrsize-7) typos = 0; else typos -= scrsize-7;
                                goto redraw;
                            }
                            break;
                        case 'G':
                            if (typos > 0)
                            {
                                typos = 0;
                                goto redraw;
                            }
                            break;
                        case 'O':
                            if (typos+scrsize-6 < pkt->txt_lines)
                            {
                                typos = pkt->txt_lines-scrsize+6;
                                goto redraw;
                            }
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }

    if (!notext) pkt->deinit_replytext(pkt);

    clockcolor = color[col_list_clock];
    old_scr(ox,oy,&oldscr);

    *ypos = rr_ypos;
    *upy = rr_upy;
    return totalquit;
}
