#include <stdio.h>
#include <signal.h>
#include <stdlib.h>

#ifdef __NT__
#  include <windows.h>
extern HANDLE scrHandle;
#endif

#ifndef __linux__
#  include <process.h>
#endif

#ifdef __OS2__
#  define INCL_VIO
#  define INCL_KBD
#  include <os2.h>
#endif

#if !defined (__NT__) && !defined (__OS2__) && !defined (__386__) && !defined (__linux__)
#  include "swap.h"
#endif

extern char keep_video_mode;

#include "screen.h"
#include "files.h"
#include "vars.h"
#include "keyb.h"

int swapexec(char *path, char *args, int no_display)
{
    int retval;
    int oldfout, oldferr, fnul;

#ifndef __OS2__
    char cstart,cend;

    getcursorsize(&cstart,&cend);
#else
    VIOCURSORINFO vio_curs;

    VioGetCurType(&vio_curs,0);
#endif

#ifdef __linux__
    endwin();
#endif
#ifdef __NT__
    KbdDeInit();
    CloseHandle(scrHandle);
#endif

    if (no_display)
    {
        /* stdout & stderr -> nul */
        oldfout = dup(STDOUT_FILENO);
        oldferr = dup(STDERR_FILENO);
        fnul = open(DEV_NUL, O_WRONLY);
        dup2(fnul, STDOUT_FILENO);
        dup2(fnul, STDERR_FILENO);
    }
#ifdef __linux__
    else
    {
        printf("\x1b[0m\x1b[%d;%dH",wherey,wherex);
        fflush(stdout);
    }
    {
        char tmp[1024];
        if (args == NULL)
            strcpy(tmp, path);
        else
            sprintf(tmp,"%s %s",path,args);
        retval = system(tmp);
    }
#elif defined (__DOS__) && !defined (__386__)
    retval = swap(path, args);
#else
    retval = spawnlp(P_WAIT,path,path,args,NULL);
#endif

    /* Stdout back to console */
    if (no_display)
    {
        close(fnul);
        dup2(oldfout, STDOUT_FILENO);
        dup2(oldferr, STDERR_FILENO);
        close(oldfout); close(oldferr);
    }

#ifdef __linux__
    InitScreen();
#endif
#ifdef __NT__
    InitScreen();
    KbdInit();
#endif

    if (!keep_video_mode)
    {
        /* Set video mode */
#ifdef __OS2__
        VIOMODEINFO VioMode;
        VIOMODEINFO OldMode;

        OldMode.cb = sizeof(VIOMODEINFO);
        VioGetMode(&OldMode,0);

        memcpy(&VioMode,&OldMode,sizeof(VioMode));
        VioMode.col = setup.scrmode[setup.modenum-1].columns;
        VioMode.row = setup.scrmode[setup.modenum-1].rows;
        VioMode.hres = setup.scrmode[setup.modenum-1].hres;
        VioMode.vres = setup.scrmode[setup.modenum-1].vres;

        if (VioSetMode(&VioMode, 0))
        {
            scrsize = OldMode.row;
            scrwidth = OldMode.col;
            c_height = OldMode.vres / scrsize;
        }
        else
        {
            scrsize = VioMode.row;
            scrwidth = VioMode.col;
            c_height = setup.scrmode[setup.modenum-1].vres / scrsize;
        }
#elif defined (__NT__)
        COORD Coord;
        
        c_height = 16;
        Coord.X = setup.scrmode[setup.modenum-1].columns;
        Coord.Y = setup.scrmode[setup.modenum-1].rows;
        if (SetConsoleScreenBufferSize(scrHandle,Coord) == TRUE)
        {
            scrwidth = Coord.X;
            scrsize = Coord.Y;
        }
        else
        {
            scrwidth = 80;
            scrsize = 25;
        }
#elif !defined (__linux__)
        union REGS regs;
        
        if ((setup.scrmode[setup.modenum-1]._ax > 1) && (setup.scrmode[setup.modenum-1].columns >= 80))
        {
            regs.h.ah = 0x0f;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
            regs.w.ax = 0x1130;
            regs.w.bx = 0;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
            
            scrwidth = setup.scrmode[setup.modenum-1].columns;
            scrsize = setup.scrmode[setup.modenum-1].rows;
            
            regs.w.ax = setup.scrmode[setup.modenum-1]._ax;
            regs.w.bx = setup.scrmode[setup.modenum-1]._bx;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
        }
#endif
    }

    /* Disable Ctrl-C and Ctrl-Break */
#ifndef __linux__
    signal(SIGBREAK,SIG_IGN);
#endif
    signal(SIGINT,SIG_IGN);
    
#ifdef __OS2__
    /* Set keyboard to binary mode */
    KBDINFO kbstInfo;
    kbstInfo.cb = sizeof(kbstInfo);
    KbdGetStatus(&kbstInfo,0);
    kbstInfo.fsMask &= ~KEYBOARD_ASCII_MODE;
    kbstInfo.fsMask |= KEYBOARD_BINARY_MODE;
    KbdSetStatus(&kbstInfo,0);
#endif

#ifndef __OS2__
    cursorsize(cstart,cend);
#else
    VioSetCurType(&vio_curs,0);
#endif
    return retval;
}

void shell_dos(void)
{
    unsigned short ox,oy;
    char *oldscr;

#ifndef __NO_DRIVES__
    unsigned drive,drives;
#endif
    char oldpath[256];

#ifdef __linux__
    char *comspec = getenv("SHELL");
#else
    char *comspec = getenv("COMSPEC");
#endif

    /* Save cursor info */
#ifndef __OS2__
    char cstart,cend;
    getcursorsize(&cstart,&cend);
#else
    VIOCURSORINFO vio_curs;
    VioGetCurType(&vio_curs,0);
#endif

    /* Draw some nice texts :) */
    save_scr(&ox,&oy,&oldscr);
    tclrscr();
#ifdef __INSTALL__
#ifdef __linux__
    cwritexy(1,1,"Type EXIT to return SkyReader",14);
#else
    cwritexy(1,1,"Type EXIT  to return SkyReader",14);
#endif
#else
    cwritexy(1,1,lang[210],14);
#endif

#ifdef __linux__
    if (comspec == NULL)
        comspec = "bash";
#else
    if (comspec == NULL)
        comspec = "COMMAND";
#endif

    /* New cursor size and position */
    gotoxy(1,2);
    cursorsize(c_height-3,c_height-3);

    /* Save old drive and path */
#ifndef __NO_DRIVES__
    _dos_getdrive(&drive);
#endif
    getcwd(oldpath,sizeof(oldpath));

    /* Jump to OS */
#ifdef __linux__
    endwin();
    printf("\x1b[0m"); fflush(stdout);
    system(comspec);
    InitScreen();
#elif !defined (__OS2__) && !defined (__NT__) && !defined (__386__)
    swap(comspec,NULL);
#else
    spawnlp(P_WAIT,comspec,comspec,NULL);
#endif

    if (!keep_video_mode)
    {
        /* Set video mode */
#ifdef __OS2__
        VIOMODEINFO VioMode;
        VIOMODEINFO OldMode;
        OldMode.cb = sizeof(VIOMODEINFO);
        VioGetMode(&OldMode,0);
        
        memcpy(&VioMode,&OldMode,sizeof(VioMode));
        VioMode.col = setup.scrmode[setup.modenum-1].columns;
        VioMode.row = setup.scrmode[setup.modenum-1].rows;
        VioMode.hres = setup.scrmode[setup.modenum-1].hres;
        VioMode.vres = setup.scrmode[setup.modenum-1].vres;
        
        if (VioSetMode(&VioMode, 0)) {
            scrsize = OldMode.row;
            scrwidth = OldMode.col;
            c_height = OldMode.vres / scrsize;
        } else {
            scrsize = VioMode.row;
            scrwidth = VioMode.col;
            c_height = setup.scrmode[setup.modenum-1].vres / scrsize;
        }
#elif defined (__NT__)
        COORD Coord;
        
        c_height = 16;
        Coord.X = setup.scrmode[setup.modenum-1].columns;
        Coord.Y = setup.scrmode[setup.modenum-1].rows;
        if (SetConsoleScreenBufferSize(scrHandle,Coord) == TRUE) {
            scrwidth = Coord.X;
            scrsize = Coord.Y;
        } else {
            scrwidth = 80;
            scrsize = 25;
        }
#elif !defined (__linux__)
        union REGS regs;

        if ((setup.scrmode[setup.modenum-1]._ax > 1) && (setup.scrmode[setup.modenum-1].columns >= 80)) {
            regs.h.ah = 0x0f;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
            
            regs.w.ax = 0x1130;
            regs.w.bx = 0;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
            
            scrwidth = setup.scrmode[setup.modenum-1].columns;
            scrsize = setup.scrmode[setup.modenum-1].rows;
            
            regs.w.ax = setup.scrmode[setup.modenum-1]._ax;
            regs.w.bx = setup.scrmode[setup.modenum-1]._bx;
#ifdef __386__
            int386(0x10,&regs,&regs);
#else
            int86(0x10,&regs,&regs);
#endif
        }
#endif
    }

    /* Restore old drive and path */
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(oldpath);

    /* Disable Ctrl-C and Ctrl-Break */
#ifndef __linux__
    signal(SIGBREAK,SIG_IGN);
    signal(SIGINT,SIG_IGN);
#endif

#ifdef __OS2__
    /* Set keyboard to binary mode */
    KBDINFO kbstInfo;
    kbstInfo.cb = sizeof(kbstInfo);
    KbdGetStatus(&kbstInfo,0);
    kbstInfo.fsMask &= ~KEYBOARD_ASCII_MODE;
    kbstInfo.fsMask |= KEYBOARD_BINARY_MODE;
    KbdSetStatus(&kbstInfo,0);
#endif

    /* Cursor back */
#ifndef __OS2__
    cursorsize(cstart,cend);
#else
    VioSetCurType(&vio_curs,0);
#endif

    old_scr(ox,oy,&oldscr);
}
