#include <string.h>
#include <stdlib.h>

#include "general.h"
#include "scrsaver.h"
#include "screen.h"
#include "vars.h"
#include "keyb.h"

static char a_ansitab[8] = {0,4,2,6,1,5,3,7};
static char a_ansistr[256];
static int a_inansi,a_ansipos,a_textattr,a_wrap,a_nextline;
static unsigned a_ypos,a_xpos,a_scrolls,a_savex,a_savey,a_width,last_13;

static char ansi_write(char c)
{
    int num,params;
    int paramarr[50];
    char *sstr,*pstr;

    if (last_13)
    {
        last_13 = 0;
        if (c != 10) ansi_write(10);
    }

    if (a_inansi)
    {
        a_ansistr[a_ansipos] = c;
        a_ansipos++;
        if (a_ansipos == 1)
        {
            if (c != '[') a_inansi = 0;
            return 1;
        }
        if (((c >= '0') && (c <= '9')) || (c == '?') || (c == ';') || (c == '=')) return 1;

        memmove(a_ansistr,a_ansistr+1,a_ansipos-2); a_ansistr[a_ansipos-2] = 0;
        params = 0;
        pstr = a_ansistr;
        sstr = (char *) 1;
        while ((sstr != NULL) && (params < 50))
        {
            if ((sstr = strchr(pstr,';')) != NULL)
                *sstr = 0;
            if  ((*pstr == '=') || (*pstr == '?')) pstr++;
            if (sscanf(pstr,"%d",&paramarr[params]) == 1) params++;
            pstr = sstr+1;
        }

        switch (c)
        {
            case 'A':
                if (params == 0) num = 1; else num = paramarr[0];
                if (a_ypos-num < 1) a_ypos = 1; else a_ypos -= num;
                break;
            case 'B':
                if (a_ypos < scrsize)
                {
                    if (params == 0) num = 1; else num = paramarr[0];
                    if (a_ypos+num > scrsize) a_ypos = scrsize; else a_ypos += num;
                    a_nextline = 1;
                }
                break;
            case 'C':
                if (params == 0) num = 1; else num = paramarr[0];
                if (a_xpos+num > a_width) a_xpos = a_width; else a_xpos += num;
                break;
            case 'D':
                if (params == 0) num = 1; else num = paramarr[0];
                if (a_xpos-num < 1) a_xpos = 1; else a_xpos -= num;
                break;
            case 'H':
            case 'f':
                if (params == 0)
                {
                    a_xpos = 1;
                    a_ypos = 1;
                }
                else
                {
                    if (params == 1)
                    {
                        a_ypos = paramarr[0];
                        a_xpos = 1;
                    }
                    else
                    {
                        a_ypos = paramarr[0];
                        a_xpos = paramarr[1];
                    }
                    if (a_xpos < 1) a_xpos = 1;
                    if (a_xpos > a_width) a_xpos = a_width;
                    if (a_ypos < 1) a_ypos = 1;
                    if (a_ypos > scrsize) a_ypos = scrsize;
                }
                break;
            case 'm':
                for (num=0; num<params; num++)
                {
                    switch (paramarr[num])
                    {
                        case 0:
                            a_textattr = 7;
                            break;
                        case 1:
                            a_textattr |= 8;
                            break;
                        case 5:
                            a_textattr |= 128;
                            break;
                        case 7:
                            a_textattr = 7 << 4;
                            break;
                        case 8:
                            a_textattr = 0;
                            break;
                        case 30:
                        case 31:
                        case 32:
                        case 33:
                        case 34:
                        case 35:
                        case 36:
                        case 37:
                            a_textattr &= 248;
                            a_textattr |= a_ansitab[paramarr[num]-30];
                            break;
                        case 40:
                        case 41:
                        case 42:
                        case 43:
                        case 44:
                        case 45:
                        case 46:
                        case 47:
                            a_textattr &= 15+128;
                            a_textattr |= a_ansitab[paramarr[num]-40] << 4;
                            break;
                    }
                }
                break;
            case 'J':
                if ((params == 1) && (paramarr[0] == 2))
                {
                    a_ypos = 1; a_xpos = 1;
                    tclrscr();
                }
                break;
            case 'K':
                if (a_xpos < a_width) tbar(a_xpos,a_ypos,a_width,a_ypos,a_textattr);
                break;
            case 's':
                a_savex = a_xpos;
                a_savey = a_ypos;
                break;
            case 'u':
                a_xpos = a_savex;
                a_ypos = a_savey;
                break;
            case 'h':
                if ((params == 1) && (paramarr[0] == 7)) a_wrap = 1;
                break;
            case 'l':
                if ((params == 1) && (paramarr[0] == 7)) a_wrap = 0;
                break;
        }
        a_inansi = 0;
        return 1;
    }

    switch (c)
    {
        case 8:
            if (a_xpos > 1) a_xpos--;
            break;
        case 13:
            last_13 = 1;
            a_xpos = 1;
            break;
        case 10:
        __10:
            if (a_ypos < scrsize)
            {
                a_ypos++;
            }
            else
            {
                scroll_up(1,1,a_width,scrsize);
                tbar(1,scrsize,a_width,scrsize,a_textattr);
            }
            a_nextline = 1;
            break;
        case 27:
            a_inansi = 1;
            a_ansipos = 0;
            break;
        default:
            if (a_nextline)
            {
                a_nextline = 0;
                if (a_ypos == scrsize)
                {
                    if (a_scrolls >= scrsize-1)
                    {
                        tbar(1,scrsize,scrwidth,scrsize,1 << 4);
                        cmiddle(scrsize,lang[211],(1 << 4)+15);
                        switch (sk_getch())
                        {
                            case 0:
                                sk_getch();
                                break;
                            case 27:
                                return 0;
                        }
                        tbar(1,scrsize,a_width,scrsize,a_textattr);
                        if (scrwidth > a_width) tbar(a_width+1,scrsize,scrwidth,scrsize,7);
                        a_scrolls = 1;
                    }
                    else
                    {
                        a_scrolls++;
                    }
                }
            }
            writechr(a_xpos,a_ypos,c,(char) a_textattr);
            if (a_xpos < a_width)
            {
                a_xpos++;
            }
            else
            {
                if (a_wrap)
                {
                    a_xpos = 1;
                    goto __10;
                }
            }
    }
    return 1;
}

void show_ansi(char *fname)
{
    unsigned short cx,cy;
    char *oldscr;

    FILE *F;
    char buf[512];
    size_t readed;

    unsigned num;

    if (fname == NULL) return;

    F = FileOpen(fname,"rb");
    if (F == NULL) return;

    a_inansi = 0; a_wrap = 1; a_textattr = 7; a_nextline = 0; a_width = 80;
    save_scr(&cx,&cy,&oldscr);
    tclrscr(); a_xpos = 1; a_ypos = 1; a_scrolls = scrsize-1; a_savex = 1; a_savey = 1;

    last_13 = 0;
    while ((readed = fread(buf,1,sizeof(buf),F)) > 0)
    {
        for (num=0; num<readed; num++)
        {
            if (!ansi_write(buf[num]))
            {
                fclose(F);
                old_scr(cx,cy,&oldscr);
                return;
            }
        }
    }
    fclose(F);

    tbar(1,scrsize,scrwidth,scrsize,1 << 4);
    cmiddle(scrsize,lang[212],(1 << 4)+15);
    if (sk_getch() == 0) sk_getch();
    old_scr(cx,cy,&oldscr);
}

static void draw_line(int ypos, int pos)
{
    char *pstr;

    tbar(10,ypos,41,ypos,color[col_box_hilight]);
    if ((pstr = strrchr(pkt->ansi_name[pos],'.')) != NULL) *pstr = 0;
    cwritexy(11,ypos,pkt->ansi_name[pos],color[col_box_hilight]);
    if (pstr != NULL) *pstr = '.';
    if ((pstr = strrchr(pkt->ansi_name[pos],'.')) != NULL)
        cwritexy(19,ypos,pstr++,color[col_box_hilight]);
    cwritexy(25,ypos,pkt->ansi_time[pos],color[col_box_text]);
}

void show_ansis(void)
{
    unsigned short cx,cy;
    char *oldscr,tmp[256];

    char quit,ch;
    int max_ansis,num,max,ypos,upy,slen;


    max_ansis = 3;
    save_scr(&cx,&cy,&oldscr);
    if (pkt->ansi_files == 0) {
        slen = strlen(lang[213])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_info_frame],color[col_info_title],NULL);
        cmiddle(12,lang[213],color[col_info_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return;
    }

    tattrbar(40,4,72,12,color[col_box_text]);
    draw_shaded_box(9,14,42,15+max_ansis,color[col_box_frame],color[col_box_title],NULL);

    if (pkt->ansi_files > max_ansis) max = max_ansis; else max = pkt->ansi_files;
    for (num=0; num<max; num++)
        draw_line(15+num,num);

    ypos = 0; upy = 0;
    tattrbar(10,15+ypos,41,15+ypos,color[col_box_select]);

    quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = sk_getch();
            switch (ch) {
                case 13:
                    show_ansi(strcat(strcpy(tmp,setup.workpath),pkt->ansi_name[ypos+upy]));
                    break;
                case 27:
                    quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case 'H':
                            if (ypos+upy > 0) {
                                draw_line(15+ypos,ypos+upy);
                                if (ypos == 0) {
                                    upy--;
                                    scroll_down(10,15,41,14+max_ansis);
                                    draw_line(15+ypos,ypos+upy);
                                } else ypos--;
                                tattrbar(10,15+ypos,41,15+ypos,color[col_box_select]);
                            }
                            break;
                        case 'P':
                            if (ypos+upy < pkt->ansi_files-1) {
                                draw_line(15+ypos,ypos+upy);
                                if (ypos == max_ansis-1) {
                                    upy++;
                                    scroll_up(10,15,41,14+max_ansis);
                                    draw_line(15+ypos,ypos+upy);
                                } else ypos++;
                                tattrbar(10,15+ypos,41,15+ypos,color[col_box_select]);
                            }
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }

    old_scr(cx,cy,&oldscr);
}
