#include <stdio.h>

int main(int argc, char *argv[])
{
    FILE *Fp, *Fo;
    unsigned long fpos;
    char ch[2],ch2;

    if (argc != 3)
    {
        printf("Usage: spatch <orig file> <patch file>\n");
        return 0;
    }

    Fo = fopen(argv[1], "r+b");
    if (Fo == NULL)
    {
        printf("Can't open %s\n", argv[1]);
        return 1;
    }
    Fp = fopen(argv[2], "rb");
    if (Fp == NULL)
    {
        printf("Can't open %s\n", argv[2]);
        return 1;
    }

    for (;;)
    {
        if (!fread(&fpos, 4, 1, Fp)) break;
        if (!fread(ch, 2, 1, Fp))
        {
            printf("Error in patch file!!\n");
            break;
        }
        fseek(Fo, fpos, SEEK_SET);
        fread(&ch2, 1, 1, Fo);
        if (ch2 != ch[0])
        {
            printf("Error in original file %d <-> %d!\n", ch2, ch[0]);
            break;
        }
        fseek(Fo, fpos, SEEK_SET);
        if (!fwrite(&ch[1], 1, 1, Fo))
        {
            printf("Can't write to file!\n");
            break;
        }
    }

    fclose(Fo);
    fclose(Fp);

    printf("Patch ok.\n");

    return 0;
}
