#include <stdio.h>
#include <ctype.h>

#include "screen.h"
#include "scrsaver.h"
#include "general.h"
#include "keyb.h"
#include "vars.h"

#define KEYS 63

#ifdef __linux__
#  define READMSG_KBD "~/.skyreader/readmsg.kbd"
#else
#  define READMSG_KBD "readmsg.kbd"
#endif

char *keydesc[KEYS] =
{
    "Line up",
    "Line down",
    "Page up",
    "Page down",
    "To the start of the message",
    "To the end of the message",
    "Next message",
    "Previous message",
    "See next message in thread",
    "See previous message in thread",
    "Go to next thread",
    "Go to previous thread",
    "Go to first message",
    "Go to last message",
    "Jump to message #xxxx",
    "Quit",
    "Reply message",
    "Reply to another area",
    "Reply to e-mail/netmail",
    "Reply to original sender",
    "Reply to original sender in another area",
    "Enter message",
    "Enter message to another area",
    "Forward message",
    "Select inbound translation table",
    "Select outbound translation table",
    "Save message",
    "Jump to title scan",
    "Steal tagline",
    "Steal and edit tagline",
    "Display hidden message information",
    "Zip to reply",
    "View and manage outbound mail",
    "Display ANSI message",
    "Show address book",
    "Adopt info to address book",
    "Toggle 'Reply' mark",
    "Toggle 'Save' mark",
    "Toggle 'Print' mark",
    "Toggle 'Del' mark",
    "Toggle 'Read' flag",
    "Toggle 'Replied' flag",
    "Toggle 'Saved' flag",
    "Toggle 'Printed' flag",
    "Jump to OS-shell",
    "Jump to configuration",
    "Display online help (DOESN'T WORK YET!)",
    "ROT13 crypting on/off",
    "Keyword search message",
    "PGP: Add new key to keyring",
    "Toggle message reformatting on/off",
    "OMEN: Delete message in BBS.",
    "OMEN: Toggle private/public",
    "OMEN: Move message",
    "Run external program #1",
    "Run external program #2",
    "Run external program #3",
    "Run external program #4",
    "Run external program #5",
    "Run external program #6",
    "Run external program #7",
    "Run external program #8",
    "Run external program #9"
};

typedef struct
{
    unsigned char key1,key2;
    char cmd;
}
KeyRec;

char *getkey(unsigned char key, char *str)
{
    if ((key >= 16) && (key <= 25))
        sprintf(str,"Alt-%c",table[key-16]);
    else if ((key >= 30) && (key <= 38))
        sprintf(str,"Alt-%c",table[key-20]);
    else if ((key >= 44) && (key <= 50))
        sprintf(str,"Alt-%c",table[key-25]);
    else if ((key >= 59) && (key <= 68))
        sprintf(str,"F%i",key-58);
    else if ((key >= 84) && (key <= 93))
        sprintf(str,"Shift-F%i",key-83);
    else if ((key >= 94) && (key <= 103))
        sprintf(str,"Ctrl-F%i",key-93);
    else if ((key >= 104) && (key <= 113))
        sprintf(str,"Alt-F%i",key-103);
    else if ((key >= 120) && (key <= 128))
        sprintf(str,"Alt-%i",key-119);
    else
    {
        switch (key)
        {
            case 14: strcpy(str,"Alt-Backspace"); break;
            case 15: strcpy(str,"Shift-Tab"); break;
            case 28: strcpy(str,"Alt-Enter"); break;
            case 'H': strcpy(str,"Up"); break;
            case 'P': strcpy(str,"Down"); break;
            case 'K': strcpy(str,"Left"); break;
            case 'M': strcpy(str,"Right"); break;
            case 'G': strcpy(str,"Home"); break;
            case 'O': strcpy(str,"End"); break;
            case 'I': strcpy(str,"PgUp"); break;
            case 'Q': strcpy(str,"PgDn"); break;
            case 'R': strcpy(str,"Insert"); break;
            case 'S': strcpy(str,"Delete"); break;
            case 's': strcpy(str,"Ctrl-Left"); break;
            case 't': strcpy(str,"Ctrl-Right"); break;
            case 'w': strcpy(str,"Ctrl-Home"); break;
            case 'u': strcpy(str,"Ctrl-End"); break;
            case 118: strcpy(str,"Ctrl-PgDn"); break;
            case 129: strcpy(str,"Alt-0"); break;
            case 132: strcpy(str,"Ctrl-PgUp"); break;
            case 133: strcpy(str,"F11"); break;
            case 134: strcpy(str,"F12"); break;
            case 135: strcpy(str,"Shift-F11"); break;
            case 136: strcpy(str,"Shift-F12"); break;
            case 137: strcpy(str,"Ctrl-F11"); break;
            case 138: strcpy(str,"Ctrl-F12"); break;
            case 139: strcpy(str,"Alt-F11"); break;
            case 140: strcpy(str,"Alt-F12"); break;
            case 141: strcpy(str,"Ctrl-Up"); break;
            case 145: strcpy(str,"Ctrl-Down"); break;
            case 146: strcpy(str,"Ctrl-Insert"); break;
            case 147: strcpy(str,"Ctrl-Delete"); break;
            case 148: strcpy(str,"Ctrl-Tab"); break;
            case 152: strcpy(str,"Alt-Up"); break;
            case 153: strcpy(str,"Alt-PgUp"); break;
            case 155: strcpy(str,"Alt-Left"); break;
            case 157: strcpy(str,"Alt-Right"); break;
            case 159: strcpy(str,"Alt-End"); break;
            case 160: strcpy(str,"Alt-Down"); break;
            case 161: strcpy(str,"Alt-PgDn"); break;
            case 162: strcpy(str,"Alt-Insert"); break;
            case 163: strcpy(str,"Alt-Delete"); break;
            case 165: strcpy(str,"Alt-Tab"); break;
            case 166: strcpy(str,"Alt-Enter"); break;
            default: sprintf(str,"#0#%i",key); break;
        }
    }
    return str;
}

void draw_key(int ypos, int num, KeyRec *keyarr)
{
    char tmp[81];

    tbar(2,ypos,79,ypos,(1<<4)+11);

    if (keyarr[num].key1 == 0)
    {
        cwritexy(2,ypos,getkey(keyarr[num].key2,tmp),(1<<4)+15);
    }
    else
    {
        switch (keyarr[num].key1)
        {
            case 8:
                cwritexy(2,ypos,"Backspace",(1<<4)+15);
                break;
            case 9:
                cwritexy(2,ypos,"Tab",(1<<4)+15);
                break;
            case 13:
                cwritexy(2,ypos,"Enter",(1<<4)+15);
                break;
            case 27:
                cwritexy(2,ypos,"ESC",(1<<4)+15);
                break;
            default:
                if (keyarr[num].key1 < 27) {
                    sprintf(tmp,"Ctrl-%c",keyarr[num].key1+64);
                    cwritexy(2,ypos,tmp,(1<<4)+15);
                } else
                    writechr(2,ypos,toupper(keyarr[num].key1),(1<<4)+15);
                break;
        }
    }

    if ((keyarr[num].cmd > KEYS) || (keyarr[num].cmd == 0))
    {
        sprintf(tmp,"Unknown type %d",keyarr[num].cmd);
        cwritexy(20,ypos,tmp,(1<<4)+11);
    }
    else
    {
        cwritexy(20,ypos,keydesc[keyarr[num].cmd-1],(1<<4)+11);
    }
}

void select_new_key(int ypos, int num, KeyRec *keyarr)
{
    tbar(2,ypos,19,ypos,(1<<4)+11);
    keyarr[num].key1 = sk_getch();
    if (keyarr[num].key1 == 0)
    {
        keyarr[num].key1 = 0;
        keyarr[num].key2 = sk_getch();
    }
    draw_key(ypos,num,keyarr);
    tattrbar(2,ypos,19,ypos,7<<4);
}

void select_new_job(int drawpos, int pos, KeyRec *keyarr)
{
    unsigned short cx,cy;
    char *oldscr;
    unsigned char ypos,quit,ch;
    int upy,max,num;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-30,5,scrwidth/2+30,scrsize-5,(3<<4)+11,0,NULL);

    ypos = 1; upy = keyarr[pos].cmd-1;
    if (upy >= KEYS || upy < 0) upy = 0;

    max = scrsize-11;
    if (max > KEYS-upy) max = KEYS-upy;

    for (num=0; num<max; num++)
        cmiddle(6+num,keydesc[num+upy],3<<4);

    tattrbar(scrwidth/2-29,ypos+5,scrwidth/2+29,ypos+5,7<<4);
    quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    keyarr[pos].cmd = (char) (ypos+upy);
                    quit = 1;
                    break;
                case 27:
                    quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case 'P':
                            /* Down */
                            if (ypos+upy < KEYS)
                            {
                                tattrbar(scrwidth/2-29,ypos+5,scrwidth/2+29,ypos+5,3<<4);
                                if (ypos == scrsize-11)
                                {
                                    upy++;
                                    scroll_up(scrwidth/2-29,6,scrwidth/2+29,scrsize-6);
                                    tbar(scrwidth/2-29,5+ypos,scrwidth/2+29,5+ypos,3<<4);
                                    cmiddle(5+ypos,keydesc[ypos+upy-1],3<<4);
                                }
                                else
                                    ypos++;
                                tattrbar(scrwidth/2-29,ypos+5,scrwidth/2+29,ypos+5,7<<4);
                            }
                            break;
                        case 'H':
                            /* Up */
                            if (ypos+upy > 1)
                            {
                                tattrbar(scrwidth/2-29,ypos+5,scrwidth/2+29,ypos+5,3<<4);
                                if (ypos == 1)
                                {
                                    upy--;
                                    scroll_down(scrwidth/2-29,6,scrwidth/2+29,scrsize-6);
                                    tbar(scrwidth/2-29,5+ypos,scrwidth/2+29,5+ypos,3<<4);
                                    cmiddle(5+ypos,keydesc[ypos+upy-1],3<<4);
                                }
                                else
                                    ypos--;
                                tattrbar(scrwidth/2-29,ypos+5,scrwidth/2+29,ypos+5,7<<4);
                            }
                            break;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }

    old_scr(cx,cy,&oldscr);

    draw_key(drawpos,pos,keyarr);
    tattrbar(20,drawpos,79,drawpos,7<<4);
}

void keyboard_config(void)
{
    unsigned short cx,cy;
    char *oldscr;

    FILE *Fkbd;
    unsigned char quit,ch,xpos,ypos;
    int num,max,keys,upy;
    KeyRec keyarr[512];

    save_scr(&cx,&cy,&oldscr);

    Fkbd = FileOpen(READMSG_KBD,"r+b");
    if (Fkbd == NULL)
    {
        Fkbd = FileOpen(READMSG_KBD,"w+b");
        if (Fkbd == NULL)
        {
            draw_shaded_box(scrwidth/2-18,10,scrwidth/2+18,14,color[col_warn_frame],0,NULL);
            cmiddle(12,"Can't create '"READMSG_KBD"' file!",color[col_warn_hilight]);
            try_key(5);
            old_scr(cx,cy,&oldscr);
            return;
        }
        keys = 0;
    } else
        keys = fread(keyarr,sizeof(keyarr[0]),sizeof(keyarr)/sizeof(keyarr[0]),Fkbd);

__again:
    draw_shaded_box(1,1,80,scrsize,(1<<4)+9,(1<<4)+15,"Keyboard configuration");
    draw_clock();

    max = scrsize-2;
    if (keys < max) max = keys;

    for (num=0; num<max; num++)
        draw_key(2+num,num,keyarr);

    ypos = 1; upy = 0;
    xpos = 0;
    tattrbar(2,ypos+1,19,ypos+1,7<<4);

    quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    if (xpos)
                        select_new_job(ypos+1,ypos+upy-1,keyarr);
                    else
                        select_new_key(ypos+1,ypos+upy-1,keyarr);
                    break;
                case 27:
                    quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case 'M':
                        case 'K':
                            draw_key(ypos+1,ypos+upy-1,keyarr);
                            xpos ^= 1;
                            if (xpos)
                                tattrbar(20,ypos+1,79,ypos+1,7<<4);
                            else
                                tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            break;
                        case 'R':
                            keys++;
                            break;
                        case 'S':
                            memmove(&keyarr[ypos+upy-1],&keyarr[ypos+upy],sizeof(keyarr)/sizeof(keyarr[0])-1);
                            keys--;
                            goto __again;
                        case 'P':
                            /* Down */
                            if (ypos+upy < keys)
                            {
                                draw_key(ypos+1,ypos+upy-1,keyarr);
                                if (ypos == scrsize-2)
                                {
                                    upy++;
                                    scroll_up(2,2,79,scrsize-1);
                                    draw_key(ypos+1,ypos+upy-1,keyarr);
                                } else ypos++;
                                if (xpos)
                                    tattrbar(20,ypos+1,79,ypos+1,7<<4);
                                else
                                    tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            }
                            break;
                        case 'H':
                            /* Up */
                            if (ypos+upy > 1)
                            {
                                draw_key(ypos+1,ypos+upy-1,keyarr);
                                if (ypos == 1)
                                {
                                    upy--;
                                    scroll_down(2,2,79,scrsize-1);
                                    draw_key(ypos+1,ypos+upy-1,keyarr);
                                } else ypos--;
                                if (xpos)
                                    tattrbar(20,ypos+1,79,ypos+1,7<<4);
                                else
                                    tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            }
                            break;
                        case 'I':
                            /* PgUp */
                            if (ypos+upy > 1)
                            {
                                draw_key(ypos+1,ypos+upy-1,keyarr);
                                if (ypos != 1)
                                    ypos = 1;
                                else
                                {
                                    if (upy < (int) (scrsize-3)) upy = 0; else upy -= scrsize-3;
                                    for (num=0; num<max; num++)
                                        draw_key(2+num,upy+num,keyarr);
                                }
                                if (xpos)
                                    tattrbar(20,ypos+1,79,ypos+1,7<<4);
                                else
                                    tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            }
                            break;
                        case 'Q':
                            /* PgDn */
                            if (ypos+upy < keys)
                            {
                                draw_key(ypos+1,ypos+upy-1,keyarr);
                                if (ypos != scrsize-2)
                                    ypos = scrsize-2;
                                else
                                {
                                    upy += scrsize-3;
                                    for (num=0; num<max; num++)
                                    {
                                        if (upy+num >= keys)
                                            tbar(2,2+num,79,2+num,(1<<4)+11);
                                        else
                                            draw_key(2+num,upy+num,keyarr);
                                    }
                                    if (ypos+upy > keys) ypos = keys-upy;
                                }
                                if (xpos)
                                    tattrbar(20,ypos+1,79,ypos+1,7<<4);
                                else
                                    tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            }
                            break;
                        case 'G':
                            /* Home */
                            if (ypos+upy > 1)
                            {
                                draw_key(ypos+1,ypos+upy-1,keyarr);
                                if (upy != 0)
                                {
                                    upy = 0;
                                    for (num=0; num<max; num++)
                                        draw_key(2+num,upy+num,keyarr);
                                }
                                ypos = 1;
                                if (xpos)
                                    tattrbar(20,ypos+1,79,ypos+1,7<<4);
                                else
                                    tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            }
                            break;
                        case 'O':
                            /* End */
                            if (ypos+upy < keys)
                            {
                                draw_key(ypos+1,ypos+upy-1,keyarr);
                                if (keys-upy < (int) (scrsize-2))
                                    ypos = keys-upy;
                                else
                                {
                                    ypos = scrsize-2;
                                    upy = keys-ypos;
                                    for (num=0; num<max; num++)
                                        draw_key(2+num,upy+num,keyarr);
                                }
                                if (xpos)
                                    tattrbar(20,ypos+1,79,ypos+1,7<<4);
                                else
                                    tattrbar(2,ypos+1,19,ypos+1,7<<4);
                            }
                            break;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }

    ftrunc(Fkbd,0);

    fseek(Fkbd,0,SEEK_SET);
    fwrite(keyarr,sizeof(keyarr[0]),keys,Fkbd);
    fclose(Fkbd);

    old_scr(cx,cy,&oldscr);
}
