#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "offcfg.h"
#include "screen.h"
#include "general.h"
#include "shell.h"
#include "scrsaver.h"
#include "readmail.h"
#include "keyb.h"
#include "vars.h"

#ifdef __linux__
#  define CHECK 'x'
#else
#  define CHECK ''
#endif

#define BUFSIZE 1024

BW_OFFCFG_REC bw_extcfg;

typedef char subjtype[73];

static char *areabuf;
static unsigned long areastart,areaend;

static unsigned ypos;
static unsigned upy;
static FILE *Farea; /* 0 = no change, 1 = + / All, 2 = - / None, 3 = P. only, 4 = P+All */

static subjtype *subjs,*subj2;

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != 0)
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

static int area_stat(unsigned area)
{
    if ((areastart > area) || (areaend < area))
    {
        fseek(Farea,area-1,SEEK_SET);
        areastart = area;
        areaend = area+fread(areabuf,1,BUFSIZE,Farea)-1;
    }
    return areabuf[area-areastart];
}

static void draw_line(unsigned dypos, unsigned darea)
{
    char *pstr,str[80];
    int num;

    tbar(4,dypos,scrwidth-3,dypos,color[col_area_number]);
    if (area_stat(darea) == 1)
        cwritexy(5,dypos,lang[327],color[col_area_tagged]);
    else if (area_stat(darea) == 2)
        cwritexy(5,dypos,lang[328],color[col_area_tagged]);
    else if (area_stat(darea) == 3 || pkt->area_selected(darea) == 2)
        cwritexy(5,dypos,lang[329],color[col_area_tagged]);
    else if (area_stat(darea) == 4 || pkt->area_selected(darea) == 3)
        cwritexy(5,dypos,lang[330],color[col_area_tagged]);
    else if (pkt->area_selected(darea))
        cwritexy(5,dypos,lang[331],color[col_area_tagged]);

    pstr = pkt->get_area_number(darea);
    cwritexy(16-strlen(pstr),dypos,pstr,color[col_area_number]);

    if (fmt == format_qwk)
        cwritexy(17,dypos,"QWK",color[col_area_type]);
    else if ((fmt == format_hippo) && (!pkt->hippoinf))
        cwritexy(17,dypos,"Hippo",color[col_area_type]);
    else
    {
        num = pkt->area_type(darea);
        if ((num & TYPE_ECHO) && (num & TYPE_NET))
            cwritexy(17,dypos,"Net",color[col_area_type]);
        else if (num & TYPE_ECHO)
            cwritexy(17,dypos,"Echo",color[col_area_type]);
        else if (fmt == format_omen)
            cwritexy(17,dypos,"OMEN",color[col_area_type]);
        else
            cwritexy(17,dypos,"Local",color[col_area_type]);
    }

    tran(strcpy(str,pkt->get_area_name(darea))); str[37] = 0;
    cwritexy(24,dypos,str,color[col_area_name]);
    tran(strcpy(str,pkt->get_area_tag(darea))); str[15] = 0;
    cwritexy(62,dypos,str,color[col_area_tagname]);
    refresh();
}

static void set_area(unsigned area, char flag)
{
    if (areastart <= area && areaend >= area)
        areabuf[area-areastart] = flag;

    fseek(Farea,area-1,SEEK_SET);
    fwrite(&flag,1,1,Farea);
}

static void clropt(unsigned ypos, unsigned slen)
{
    tattrbar(6,ypos+14,8+slen,ypos+14,color[col_box_text]);
    writechr(7+keypos[ypos-1]-1,ypos+14,keys[ypos-1],color[col_box_hilight]);
}

int get_area(int num, char *tag)
{
    unsigned short cx,cy;
    char *oldscr;
    char ch;
    int n, ret;

    if (num == 2) num = 0; else if (num > 2) num--;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-20, scrsize/2-2, scrwidth/2+20, scrsize/2+3, color[col_box_frame], color[col_box_title], tag);
    keys[0] = highwrite(scrwidth/2-18, scrsize/2-1, lang[323], NULL);
    keys[1] = highwrite(scrwidth/2-18, scrsize/2, lang[324], NULL);
    keys[2] = highwrite(scrwidth/2-18, scrsize/2+1, lang[325], NULL);
    keys[3] = highwrite(scrwidth/2-18, scrsize/2+2, lang[326], NULL);
    ret = num;
    writechr(scrwidth/2-17, scrsize/2-1+ret, CHECK, color[col_box_hilight]);
    for (;;)
    {
        ch = toupper(sk_getch());
        if (ch == 27)
        {
            ret = num;
            break;
        }
        if (ch == 13) break;
        if (ch == 0) ch = find_key(sk_getch());
        for (n=0; n<4; n++)
        {
            if (ch == keys[n])
            {
                writechr(scrwidth/2-17, scrsize/2-1+ret, ' ', color[col_box_hilight]);
                writechr(scrwidth/2-17, scrsize/2-1+n, CHECK, color[col_box_hilight]);
                ret = n;
                break;
            }
        }
    }
    old_scr(cx,cy,&oldscr);
    return ret;
}

static void area_list(void)
{
    unsigned num;
    char quit,ch,dir;

    quit = 0; dir = 1;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos(); break;
                        case 'R':
                            if (area_stat(ypos+upy) == 2)
                                set_area(ypos+upy,0);
                            else
                                if (area_stat(ypos+upy) != 1 && (!pkt->know_areas || !pkt->area_selected(ypos+upy)))
                                    set_area(ypos+upy,1);
                            draw_line(ypos+5,ypos+upy);
                            tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            break;
                        case 'S':
                            if (area_stat(ypos+upy) == 1 || area_stat(ypos+upy) > 2)
                                set_area(ypos+upy,0);
                            else
                                if ((area_stat(ypos+upy) != 2) && ((!pkt->know_areas) || (pkt->area_selected(ypos+upy))))
                                    set_area(ypos+upy,2);
                            draw_line(ypos+5,ypos+upy);
                            tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            break;
                        case 'G':
                            if (ypos+upy > 1)
                            {
                                draw_line(ypos+5,ypos+upy);
                                ypos = 1;
                                if (upy > 0)
                                {
                                    upy = 0;
                                    for (num=1; num<=scrsize-7; num++)
                                        draw_line(num+5,num);
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'O':
                            if (ypos+upy < pkt->areas)
                            {
                                draw_line(ypos+5,ypos+upy);
                                if (pkt->areas < scrsize-7)
                                    ypos = pkt->areas;
                                else
                                {
                                    ypos = scrsize-7;
                                    if (pkt->areas-ypos > upy) {
                                        upy = pkt->areas-ypos;
                                        for (num=1; num<=scrsize-7; num++)
                                            draw_line(num+5,num+upy);
                                    }
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'Q':
                            if (ypos+upy < pkt->areas) {
                                draw_line(ypos+5,ypos+upy);
                                if (pkt->areas < scrsize-7)
                                    ypos = pkt->areas;
                                else {
                                    if (ypos < scrsize-7)
                                        ypos = scrsize-7;
                                    else {
                                        upy += scrsize-8;
                                        if (pkt->areas < ypos+upy)
                                            upy = pkt->areas-(scrsize-7);
                                        for (num=1; num<=scrsize-7; num++)
                                            draw_line(num+5,num+upy);
                                    }
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'I':
                            if (ypos+upy > 1) {
                                draw_line(ypos+5,ypos+upy);
                                if (ypos > 1)
                                    ypos = 1;
                                else {
                                    if (upy <= scrsize-8)
                                        upy = 0;
                                    else
                                        upy -= scrsize-8;
                                    for (num=1; num<=scrsize-7; num++)
                                        draw_line(num+5,num+upy);
                                }
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'H':
                        __up:
                            dir = 0;
                            if (ypos+upy > 1) {
                                draw_line(ypos+5,ypos+upy);
                                if (ypos == 1) {
                                    upy--;
                                    scroll_down(4,6,scrwidth-3,scrsize-2);
                                    draw_line(ypos+5,ypos+upy);
                                } else ypos--;
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                        case 'P':
                        __down:
                            dir = 1;
                            if (ypos+upy < pkt->areas) {
                                draw_line(ypos+5,ypos+upy);
                                if (ypos == scrsize-7) {
                                    upy++;
                                    scroll_up(4,6,scrwidth-3,scrsize-2);
                                    draw_line(ypos+5,ypos+upy);
                                } else ypos++;
                                tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                            }
                            break;
                    }
                    break;
                case 'P':
                case 'p':
                    set_area(ypos+upy,3);
                    break;
                case 'A':
                case 'a':
                    set_area(ypos+upy,4);
                    break;
                case '+':
                    if (area_stat(ypos+upy) == 2)
                        set_area(ypos+upy,0);
                    else
                        if (area_stat(ypos+upy) != 1 && (area_stat(ypos+upy) != 0 || pkt->area_selected(ypos+upy) == 0)) set_area(ypos+upy,1);
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                    break;
                case ' ':
                    if (area_stat(ypos+upy) != 0)
                        set_area(ypos+upy,0);
                    else
                        set_area(ypos+upy, pkt->area_selected(ypos+upy) ? 2 : 1);
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                    if (dir) goto __down; else goto __up;
                case '-':
                    if (area_stat(ypos+upy) == 1)
                        set_area(ypos+upy,0);
                    else
                        if (area_stat(ypos+upy) != 2) set_area(ypos+upy,2);
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                    break;
                case 13:
                    if (pkt->info.ver < 3 || pkt->info.ver >= 250) break;
                    num = area_stat(ypos+upy);
                    if (num == 0)
                    {
                        num = pkt->area_selected(ypos+upy);
                        if (num > 1) num++;
                    }
                    num = get_area(num, pkt->get_area_tag(ypos+upy));
                    if (num == 0)
                    {
                        if (pkt->area_selected(ypos+upy) == 0)
                            num = 0;
                        else
                            num = 2;
                    }
                    else if (num == 1)
                    {
                        if (pkt->area_selected(ypos+upy) == 1) num = 0;
                    }
                    else if (num == 2)
                    {
                        if (pkt->area_selected(ypos+upy) == 2)
                            num = 0;
                        else
                            num = 3;
                    }
                    else if (num == 3)
                    {
                        if (pkt->area_selected(ypos+upy) == 3)
                            num = 0;
                        else
                            num = 4;
                    }
                    set_area(ypos+upy, num);
                    draw_line(ypos+5,ypos+upy);
                    tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_area_selectbar]);
                    break;
                case 27:
                    quit = 1;
                    break;
            }
        } else give_timeslice();
    }
}

static void area_config(void)
{
    unsigned short ox,oy;
    char *oldscr;

    char tmp[256];
    unsigned num,slen,max;

    if (!pkt->offline_config)
    {
        save_scr(&ox,&oy,&oldscr);
        slen = strlen(lang[215])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_info_frame],color[col_info_title],NULL);
        cmiddle(12,lang[215],color[col_info_hilight]);
        try_key(2);
        old_scr(ox,oy,&oldscr);
        return;
    }

    save_scr(&ox,&oy,&oldscr);
    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    cwritexy(63,4,lang[100],color[col_area_help]);
    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    if (fmt != format_bw)
    {
        /* Open temp file */
        sprintf(tmp,"%sOFFLINE.TMP",setup.workpath);
        Farea = FileOpen(tmp,"w+b");
        if (Farea == NULL)
        {
            old_scr(ox,oy,&oldscr);
            return;
        }

        /* Get memory for area buffer */
        if ((areabuf = (char *) malloc(BUFSIZE)) == NULL)
        {
            old_scr(ox,oy,&oldscr);
            return;
        }

        /* Fill with nuls */
        memset(areabuf,0,BUFSIZE);
        for (num=1; num<=pkt->areas/BUFSIZE; num++)
            fwrite(areabuf,1,BUFSIZE,Farea);
        fwrite(areabuf,1,pkt->areas % BUFSIZE,Farea);

        /* Read area list */
        pkt->read_arealist(Farea);
    }
    areastart = 0;
    areaend = 0;

    max = scrsize-7;
    if (pkt->areas < max) max = pkt->areas;
    for (num=1; num<=max; num++) draw_line(num+5,num);
    ypos = 1; upy = 0;
    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

    area_list();

    if (fmt != format_qwk) pkt->arealist = 1;
    if (fmt != format_bw)
    {
        pkt->write_arealist(Farea);
        fclose(Farea);
        free(areabuf);
    }
    old_scr(ox,oy,&oldscr);
    ypos = 1;
}

void make_pdq(PDQ_HEADER *pdqhdr)
{
    int ch;

    memset(pdqhdr,0,sizeof(PDQ_HEADER));
    memcpy(pdqhdr->keywords,pkt->info.keywords,sizeof(pkt->info.keywords));
    memcpy(pdqhdr->filters,pkt->info.filters,sizeof(pkt->info.filters));
    memcpy(pdqhdr->macros,pkt->info.macros,sizeof(pkt->info.macros));
    ch = 0;
    while (pkt->info.password[ch]) {
        pdqhdr->password[ch] = (char) ((unsigned char) pkt->info.password[ch]-10);
        ch++;
    }
    pdqhdr->password[ch] = 0;
    pdqhdr->passtype = pkt->info.passtype;
    pdqhdr->flags = pkt->info.uflags;
}

void keyword_config(char filter)
{
    unsigned short cx,cy;
    char *oldscr;

    char info,ypos,quit;
    char keyword[10][21],tmp[256];

    FILE *Fpdq;
    PDQ_HEADER pdqhdr;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(29,4,52,15,color[col_box_frame],color[col_box_title],NULL);
    quit = 0;
    sprintf(tmp, "%s%s.pdq", setup.replypath, pktname);
    if ((Fpdq = fopen_ign(tmp,"rb")) != NULL)
    {
        fread(&pdqhdr,sizeof(PDQ_HEADER),1,Fpdq);
        fclose(Fpdq);

        for (ypos=0; ypos<10; ypos++)
        {
            if (filter)
                strcpy(keyword[ypos],(char *) pdqhdr.filters[ypos]);
            else
                strcpy(keyword[ypos],(char *) pdqhdr.keywords[ypos]);
            cwritexy(31,ypos+5,keyword[ypos],color[col_box_text]);
        }
    }
    else
    {
        for (ypos=0; ypos<10; ypos++)
        {
            if (filter)
                strcpy(keyword[ypos],(char *) pkt->info.filters[ypos]);
            else
                strcpy(keyword[ypos],(char *) pkt->info.keywords[ypos]);
            cwritexy(31,ypos+5,keyword[ypos],color[col_box_text]);
        }
    }

    ypos = 1;
    do
    {
        info = get_string(31,ypos+4,20,20,keyword[ypos-1],4+8,color[col_box_hilight],
                          color[col_box_text],color[col_box_text]);
        switch (info)
        {
            case 0:
            case 1:
                if (ypos < 10) ypos++;
                break;
            case 2:
                if (ypos > 1) ypos--;
                break;
        }
    } while (info != 5);

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) == NULL)
    {
        Fpdq = FileOpen(tmp,"w+b");
        make_pdq(&pdqhdr);
    }

    if (filter)
        for (ypos=0; ypos<10; ypos++)
            strcpy((char *) pdqhdr.filters[ypos],keyword[ypos]);
    else
        for (ypos=0; ypos<10; ypos++)
            strcpy((char *) pdqhdr.keywords[ypos],keyword[ypos]);

   fwrite(&pdqhdr,sizeof(pdqhdr),1,Fpdq);
   fclose(Fpdq);

   old_scr(cx,cy,&oldscr);
}

void macro_config(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char info,ypos,quit;
    char macro[3][80],tmp[256];

    FILE *Fpdq;
    PDQ_HEADER pdqhdr;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(1,4,80,8,color[col_box_frame],color[col_box_title],NULL);
    quit = 0;

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) != NULL)
    {
        fread(&pdqhdr,sizeof(PDQ_HEADER),1,Fpdq);
        fclose(Fpdq);
        for (ypos=0; ypos<3; ypos++)
        {
            strcpy(macro[ypos],(char *) pdqhdr.macros[ypos]);
            cwritexy(2,ypos+5,macro[ypos],color[col_box_text]);
        }
    }
    else
    {
        for (ypos=0; ypos<3; ypos++)
        {
            strcpy(macro[ypos],(char *) pkt->info.macros[ypos]);
            cwritexy(2,ypos+5,macro[ypos],color[col_box_text]);
        }
    }

    ypos = 0;
    do {
        info = get_string(2,ypos+5,78,78,macro[ypos],5+8,color[col_box_hilight],
                          color[col_box_text],color[col_box_text]);
        switch (info)
        {
            case 0:
            case 1:
                if (ypos < 2) ypos++;
                break;
            case 2:
                if (ypos > 0) ypos--;
                break;
        }
    } while (info != 5);

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) == NULL)
    {
        Fpdq = FileOpen(tmp,"w+b");
        make_pdq(&pdqhdr);
    }

    for (ypos=0; ypos<3; ypos++)
        strcpy((char *) pdqhdr.macros[ypos],macro[ypos]);

    fwrite(&pdqhdr,sizeof(pdqhdr),1,Fpdq);
    fclose(Fpdq);

    old_scr(cx,cy,&oldscr);
}

static void clropt_door(unsigned ypos, unsigned slen)
{
    tattrbar(26,9+ypos,26+slen,9+ypos,color[col_box_text]);
    writechr(27+keypos[ypos-1]-1,ypos+9,keys[ypos-1],color[col_box_hilight]);
}

static char *yesno[2] = { "No ","Yes" };

void ask_password(char *password)
{
    unsigned short cx,cy;
    char *oldscr;

    char info,str[21],str2[21];
    int ypos,slen;

    slen = get_max_langtext_len(216,218)/2;
    if (slen < 10) slen = 10;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-slen-3,6,scrwidth/2+slen+3,16,color[col_warn_frame],color[col_warn_title],NULL);
    if (password[0] != 0)
    {
        cmiddle(7,lang[216],color[col_warn_hilight]);
        str[0] = 0;
        info = get_string(scrwidth/2-10,8,20,20,str,1+4+32,color[col_warn_hilight],color[col_warn_text],0);
        if (info == 5)
        {
            old_scr(cx,cy,&oldscr);
            return;
        }
        if (stricmp(str,password) != 0)
        {
            slen = strlen(lang[219])/2;
            draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(12,lang[219],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return;
        }
        ypos = 10;
    } else ypos = 7;
    cmiddle(ypos,lang[217],color[col_warn_hilight]);
    str[0] = 0;
    info = get_string(scrwidth/2-10,ypos+1,20,20,str,1+4+32,color[col_warn_hilight],color[col_warn_text],0);
    if ((str[0] == 0) || (info == 5))
    {
        if (info != 5) password[0] = 0;
        old_scr(cx,cy,&oldscr);
        return;
    }
    cmiddle(ypos+3,lang[218],color[col_warn_hilight]);
    str2[0] = 0;
    info = get_string(scrwidth/2-10,ypos+4,20,20,str2,1+4+32,color[col_warn_hilight],color[col_warn_text],0);
    if (info == 5) {
        old_scr(cx,cy,&oldscr);
        return;
    }
    if (strcmp(str,str2) != 0)
    {
        slen = strlen(lang[220])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[220],color[col_warn_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return;
    }
    strcpy(password,str);
    old_scr(cx,cy,&oldscr);
}

void door_config(void)
{
    char *passw[4] =
    {
        "None  ","Door  ","Reader","Both  "
    };

    unsigned short cx,cy;
    char *oldscr;

    char quit,ch;
    int ypos,slen,len;

    FILE *Fpdq;
    PDQ_HEADER pdqhdr;

    unsigned short uflags;
    char password[21],passtype,tmp[256];

    save_scr(&cx,&cy,&oldscr);
    len = get_max_langtext_len(221,226);
    slen = len+7;
    draw_shaded_box(25,9,29+slen,17,color[col_box_frame],color[col_box_title],NULL);

    keys[0] = toupper(highwrite(27,10,lang[221],&keypos[0]));
    keys[1] = toupper(highwrite(27,11,lang[222],&keypos[1]));
    keys[2] = toupper(highwrite(27,12,lang[223],&keypos[2]));
    keys[3] = toupper(highwrite(27,13,lang[224],&keypos[3]));
    keys[4] = 0;
    keys[5] = toupper(highwrite(27,15,lang[225],&keypos[5]));
    keys[6] = toupper(highwrite(27,16,lang[226],&keypos[6]));

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) != NULL)
    {
        fread(&pdqhdr,sizeof(PDQ_HEADER),1,Fpdq);
        fclose(Fpdq);

        uflags = pdqhdr.flags;

        passtype = pdqhdr.passtype;
        strcpy(password,(char *) pdqhdr.password);
    } else {
        uflags = pkt->info.uflags;
        passtype = pkt->info.passtype;
        ch = 0;
        while (pkt->info.password[ch]) {
            password[ch] = (char) ((unsigned char) pkt->info.password[ch]-10);
            ch++;
        }
        password[ch] = 0;
    }

    cwritexy(28+len,10,yesno[(uflags & INF_HOTKEYS) > 0],color[col_box_hilight]);
    cwritexy(28+len,11,yesno[(uflags & INF_XPERT) > 0],color[col_box_hilight]);
    cwritexy(28+len,12,yesno[(uflags & INF_GRAPHICS) > 0],color[col_box_hilight]);
    cwritexy(28+len,13,yesno[(uflags & INF_NOT_MY_MAIL) == 0],color[col_box_hilight]);

    cwritexy(28+len,15,"******",color[col_box_hilight]);
    cwritexy(28+len,16,passw[passtype],color[col_box_hilight]);

    ypos = 1;
    tattrbar(26,10,26+len,10,color[col_box_select]);
__again:
    quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = (char) toupper(sk_getch());
            if (ch == toupper(keys[0])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 1;
                tattrbar(26,10,26+len,10,color[col_box_select]);
            } else
            if (ch == toupper(keys[1])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 2;
                tattrbar(26,11,26+len,11,color[col_box_select]);
            } else
            if (ch == toupper(keys[2])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 3;
                tattrbar(26,12,26+len,12,color[col_box_select]);
            } else
            if (ch == toupper(keys[3])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 4;
                tattrbar(26,13,26+len,13,color[col_box_select]);
            } else
            if (ch == toupper(keys[5])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 6;
                tattrbar(26,15,26+len,15,color[col_box_select]);
            } else
            if (ch == toupper(keys[6])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 7;
                tattrbar(26,16,26+len,16,color[col_box_select]);
            } else
                switch (ch) {
                    case 27:
                        ypos = 0; quit = 1; break;
                    case 13:
                        quit = 1; break;
                    case 0:
                        ch = sk_getch();
                        switch (ch) {
                            case '$':
                                shell_dos(); break;
                            case 'H':
                                clropt_door(ypos,len);
                                ypos--;
                                if (ypos == 5) ypos = 4;
                                if (ypos == 0) ypos = 7;
                                tattrbar(26,9+ypos,26+len,9+ypos,color[col_box_select]);
                                break;
                            case 'P':
                                clropt_door(ypos,len);
                                ypos++;
                                if (ypos == 5) ypos = 6;
                                if (ypos == 8) ypos = 1;
                                tattrbar(26,9+ypos,26+len,9+ypos,color[col_box_select]);
                                break;
                        }
                        break;
                }
        } else give_timeslice();
    }

    switch (ypos) {
        case 1:
            uflags ^= INF_HOTKEYS;
            cwritexy(28+len,10,yesno[(uflags & INF_HOTKEYS) > 0],color[col_box_hilight]);
            goto __again;
        case 2:
            uflags ^= INF_XPERT;
            cwritexy(28+len,11,yesno[(uflags & INF_XPERT) > 0],color[col_box_hilight]);
            goto __again;
        case 3:
            uflags ^= INF_GRAPHICS;
            cwritexy(28+len,12,yesno[(uflags & INF_GRAPHICS) > 0],color[col_box_hilight]);
            goto __again;
        case 4:
            uflags ^= INF_NOT_MY_MAIL;
            cwritexy(28+len,13,yesno[(uflags & INF_NOT_MY_MAIL) == 0],color[col_box_hilight]);
            goto __again;
        case 6:
            ask_password(password);
            goto __again;
        case 7:
            if (passtype == 3) passtype = 0; else passtype++;
            cwritexy(28+len,16,passw[passtype],color[col_box_hilight]);
            goto __again;
    }

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) == NULL)
    {
        Fpdq = FileOpen(tmp,"w+b");
        make_pdq(&pdqhdr);
    }

    pdqhdr.flags = uflags;

    pdqhdr.passtype = passtype;
    /*ch = 0;
    for (ch = 0; password[ch] != 0; ch++) {
        pdqhdr.password[ch] = (char) ((unsigned char) password[ch]+10);
    pdqhdr.password[ch] = 0;*/
    strcpy((char *) pdqhdr.password, password);

    fwrite(&pdqhdr,sizeof(pdqhdr),1,Fpdq);
    fclose(Fpdq);

    old_scr(cx,cy,&oldscr);
}

void advanced_config(void)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned short uflags;
    char ypos,quit,ch;
    int len, slen;

    FILE *Fpdq;
    PDQ_HEADER pdqhdr;

    char tmp[256];

    char *newf[3] =
    {
        "None ","Text ","Color"
    };

    len = get_max_langtext_len(314,320);

    save_scr(&cx,&cy,&oldscr);
    slen = len+7;
    draw_shaded_box(25,9,29+slen,18,color[col_box_frame],color[col_box_title],NULL);

    keys[0] = toupper(highwrite(27,10,lang[314],&keypos[0]));
    keys[1] = toupper(highwrite(27,11,lang[315],&keypos[1]));
    keys[2] = toupper(highwrite(27,12,lang[316],&keypos[2]));
    keys[3] = toupper(highwrite(27,13,lang[317],&keypos[3]));
    keys[4] = 0;
    keys[5] = toupper(highwrite(27,15,lang[318],&keypos[5]));
    keys[6] = toupper(highwrite(27,16,lang[319],&keypos[6]));
    keys[7] = toupper(highwrite(27,17,lang[320],&keypos[7]));

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) != NULL)
    {
        fread(&pdqhdr,sizeof(PDQ_HEADER),1,Fpdq);
        fclose(Fpdq);

        uflags = pdqhdr.flags;
    } else
        uflags = pkt->info.uflags;

    cwritexy(28+len,10,newf[bw_extcfg.newfiles],color[col_box_hilight]);
    cwritexy(28+len,11,yesno[(uflags & INF_EXT_INFO) > 0],color[col_box_hilight]);
    cwritexy(28+len,12,yesno[(uflags & INF_NUMERIC_EXT) > 0],color[col_box_hilight]);

    sprintf(tmp, "%u", bw_extcfg.maxsize);
    cwritexy(28+len,13,tmp,color[col_box_hilight]);

    cwritexy(28+len,15,yesno[(bw_extcfg.automacro[0]) > 0],color[col_box_hilight]);
    cwritexy(28+len,16,yesno[(bw_extcfg.automacro[1]) > 0],color[col_box_hilight]);
    cwritexy(28+len,17,yesno[(bw_extcfg.automacro[2]) > 0],color[col_box_hilight]);

    tattrbar(26,10,26+len,10,color[col_box_select]);
    ypos = 1;
__again:
    quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            if (ch == toupper(keys[0])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 1;
                tattrbar(26,10,26+len,10,color[col_box_select]);
            } else
            if (ch == toupper(keys[1])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 2;
                tattrbar(26,11,26+len,11,color[col_box_select]);
            } else
            if (ch == toupper(keys[2])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 3;
                tattrbar(26,12,26+len,12,color[col_box_select]);
            } else
            if (ch == toupper(keys[3])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 4;
                tattrbar(26,13,26+len,13,color[col_box_select]);
            } else
            if (ch == toupper(keys[5])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 6;
                tattrbar(26,15,26+len,15,color[col_box_select]);
            } else
            if (ch == toupper(keys[6])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 7;
                tattrbar(26,16,26+len,16,color[col_box_select]);
            } else
            if (ch == toupper(keys[7])) {
                clropt_door(ypos,len);
                quit = 1;
                ypos = 8;
                tattrbar(26,16,26+len,16,color[col_box_select]);
            } else
            switch (ch)
            {
                case 27:
                    ypos = 0; quit = 1; break;
                case 13:
                    quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos(); break;
                        case 'H':
                            clropt_door(ypos,len);
                            ypos--;
                            if (ypos == 5) ypos = 4;
                            if (ypos == 0) ypos = 8;
                            tattrbar(26,9+ypos,26+len,9+ypos,color[col_box_select]);
                            break;
                        case 'P':
                            clropt_door(ypos,len);
                            ypos++;
                            if (ypos == 5) ypos = 6;
                            if (ypos == 9) ypos = 1;
                            tattrbar(26,9+ypos,26+len,9+ypos,color[col_box_select]);
                            break;
                    }
            }
        }
    }
    switch (ypos)
    {
        case 1:
            if (bw_extcfg.newfiles == 2) bw_extcfg.newfiles = 0; else bw_extcfg.newfiles++;
            cwritexy(28+len,10,newf[bw_extcfg.newfiles],color[col_box_hilight]);
            goto __again;
        case 2:
            uflags ^= INF_EXT_INFO;
            cwritexy(28+len,11,yesno[(uflags & INF_EXT_INFO) > 0],color[col_box_hilight]);
            goto __again;
        case 3:
            uflags ^= INF_NUMERIC_EXT;
            cwritexy(28+len,12,yesno[(uflags & INF_NUMERIC_EXT) > 0],color[col_box_hilight]);
            goto __again;
        case 4:
            sprintf(tmp, "%u", bw_extcfg.maxsize);
            get_string(28+len,13,5,5,tmp,2+4,color[col_box_hilight],
                              color[col_box_text],color[col_box_text]);
            if (sscanf(tmp, "%u", &bw_extcfg.maxsize) != 1 || bw_extcfg.maxsize > 65535)
                bw_extcfg.maxsize = 0;

            sprintf(tmp, "%u", bw_extcfg.maxsize);
            tbar(28+len,13,28+len+5,13,color[col_box_hilight]);
            cwritexy(28+len,13,tmp,color[col_box_hilight]);
            goto __again;
        case 6:
        case 7:
        case 8:
            bw_extcfg.automacro[ypos-6] = !bw_extcfg.automacro[ypos-6];
            cwritexy(28+len,9+ypos,yesno[(bw_extcfg.automacro[ypos-6]) > 0],color[col_box_hilight]);
            goto __again;
    }

    if ((Fpdq = fopen_ign(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"),"r+b")) == NULL)
    {
        Fpdq = FileOpen(tmp,"w+b");
        make_pdq(&pdqhdr);
    }

    pdqhdr.flags = uflags;

    fwrite(&pdqhdr,sizeof(pdqhdr),1,Fpdq);
    fclose(Fpdq);

    old_scr(cx,cy,&oldscr);
}

char ask_question(char *txt)
{
    unsigned short cx,cy;
    char *oldscr;

    char ch,tmp[81];
    int slen;

    save_scr(&cx,&cy,&oldscr);
    cursorsize(c_height-3,c_height-2);
    slen = strlen(txt);
    draw_shaded_box(scrwidth/2-slen/2-2-(slen & 1),12,scrwidth/2+slen/2+3,16,color[col_info_frame],color[col_info_title],NULL);
    sprintf(tmp,"%s  ",txt);
    cmiddle(14,tmp,color[col_info_hilight]);
    writechr(scrwidth/2+slen/2+1,14,lang[243][0],color[col_info_text]);
    gotoxy(scrwidth/2+slen/2+1,14);
    for (;;) {
        ch = (char) toupper(sk_getch());
        if ((ch == 13) || (ch == lang[243][0])) {
            nocursor();
            old_scr(cx,cy,&oldscr);
            return 1;
        }
        if ((ch == 27) || (ch == lang[243][1])) {
            nocursor();
            old_scr(cx,cy,&oldscr);
            return 0;
        }            
    }
}

void bw_config(int x1, int y1, int x2, int y2)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned num;
    char ypos,quit,ch,tmp[256],tmp2[256],slen,keep_files;

    if ((areabuf = (char *) malloc(BUFSIZE)) == NULL) return;
    memset(areabuf,0,BUFSIZE);

    if ((Farea = FileOpen(strcat(strcpy(tmp,setup.workpath),"OFFLINE.TMP"),"w+b")) == NULL)
    {
        free(areabuf);
        return;
    }
    for (num=1; num<=pkt->areas/BUFSIZE; num++)
        fwrite(areabuf,1,BUFSIZE,Farea);
    fwrite(areabuf,1,pkt->areas % BUFSIZE,Farea);

    sprintf(tmp,"%s%s.olc",setup.replypath,pktname);
    ch = exists(tmp);
    if (!ch)
    {
        sprintf(tmp,"%s%s.pdq",setup.replypath,pktname);
        ch = exists(tmp);
    }

    keep_files = 0;
    if (ch)
    {
        if (ask_question(lang[241]) == 0)
        {
            sprintf(tmp,"%s%s.olc",setup.replypath,pktname);
            FileRemove(tmp);
            sprintf(tmp,"%s%s.pdq",setup.replypath,pktname);
            FileRemove(tmp);
        } else
            keep_files = 1;
    }

    pkt->read_arealist(Farea);
    pkt->write_arealist(Farea);
    sprintf(tmp,"%s%s.olc",setup.replypath,pktname);
    sprintf(tmp2,"%s%s.ol~",setup.replypath,pktname);
    FileRemove(tmp2);
    FileRename(tmp,tmp2);

    save_scr(&cx,&cy,&oldscr);
    tattrbar(x1,y1,x2,y2,color[col_box_text]);
    slen = get_max_langtext_len(227,232);
    draw_shaded_box(5,14,9+slen,21,color[col_box_frame],color[col_box_title],NULL);

    ypos = 1;
    do {
        keys[0] = toupper(highwrite(7,15,lang[227],&keypos[0]));
        keys[1] = toupper(highwrite(7,16,lang[228],&keypos[1]));
        keys[2] = toupper(highwrite(7,17,lang[229],&keypos[2]));
        keys[3] = toupper(highwrite(7,18,lang[230],&keypos[3]));
        keys[4] = toupper(highwrite(7,19,lang[231],&keypos[4]));
        keys[5] = toupper(highwrite(7,20,lang[232],&keypos[5]));

        tattrbar(6,14+ypos,8+slen,14+ypos,color[col_box_select]);

        quit = 0;
        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = (char) toupper(sk_getch());
                if (ch == toupper(keys[0]))
                {
                    clropt(ypos,slen);
                    quit = 1;
                    ypos = 1;
                    tattrbar(6,15,8+slen,15,color[col_box_select]);
                }
                else if (ch == toupper(keys[1]))
                {
                    clropt(ypos,slen);
                    quit = 1;
                    ypos = 2;
                    tattrbar(6,16,8+slen,16,color[col_box_select]);
                }
                else if (ch == toupper(keys[2]))
                {
                    clropt(ypos,slen);
                    quit = 1;
                    ypos = 3;
                    tattrbar(6,17,8+slen,17,color[col_box_select]);
                }
                else if (ch == toupper(keys[3]))
                {
                    clropt(ypos,slen);
                    quit = 1;
                    ypos = 4;
                    tattrbar(6,18,8+slen,18,color[col_box_select]);
                }
                else if (ch == toupper(keys[4]))
                {
                    clropt(ypos,slen);
                    quit = 1;
                    ypos = 5;
                    tattrbar(6,19,8+slen,19,color[col_box_select]);
                }
                else if (ch == toupper(keys[5]))
                {
                    clropt(ypos,slen);
                    quit = 1;
                    ypos = 6;
                    tattrbar(6,20,8+slen,20,color[col_box_select]);
                }
                else switch (ch)
                {
                    case 27:
                        ypos = 0; quit = 1; break;
                    case 13:
                        quit = 1; break;
                    case 0:
                        ch = sk_getch();
                        switch (ch)
                        {
                            case '$':
                                shell_dos(); break;
                            case 'H':
                                clropt(ypos,slen);
                                if (ypos == 1) ypos = 6; else ypos--;
                                tattrbar(6,14+ypos,8+slen,14+ypos,color[col_box_select]);
                                break;
                            case 'P':
                                clropt(ypos,slen);
                                if (ypos == 6) ypos = 1; else ypos++;
                                tattrbar(6,14+ypos,8+slen,14+ypos,color[col_box_select]);
                                break;
                        }
                        break;
                }
            } else give_timeslice();
        }

        switch (ypos)
        {
            case 1:
                area_config();
                break;
            case 2:
                keyword_config(0);
                break;
            case 3:
                keyword_config(1);
                break;
            case 4:
                macro_config();
                break;
            case 5:
                door_config();
                break;
            case 6:
                advanced_config();
                break;
        }
    } while (ypos > 0);

    pkt->write_arealist(Farea);

    if (cmpfile(tmp,tmp2) == 0)
    {
        if (ask_question(lang[242]) == 0)
        {
            FileRemove(tmp);
            sprintf(tmp,"%s%s.pdq",setup.replypath,pktname);
            FileRemove(tmp);
            pkt->arealist = 0;
        }
    }
    else
    {
        if (!keep_files)
        {
            FileRemove(tmp);
            sprintf(tmp,"%s%s.pdq",setup.replypath,pktname);
            FileRemove(tmp);
        }
    }
    FileRemove(tmp2);

    fclose(Farea);
    free(areabuf);

    old_scr(cx,cy,&oldscr);
}

void ask_names(char *title, int len, unsigned max)
{
    unsigned short cx,cy;
    char *oldscr,info;
    unsigned ypos,upy;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-37,3,scrwidth/2+38,scrsize-3,color[col_box_frame],color[col_box_title],title);

    for (ypos=0; ypos<scrsize-7; ypos++)
        cwritexy(scrwidth/2-35,ypos+4,subjs[ypos],color[col_box_text]);

    ypos = 1; upy = 0;
    do
    {
        info = get_string(scrwidth/2-35,ypos+3,len,len,subjs[ypos+upy-1],4+8,color[col_box_hilight],
                          color[col_box_text],color[col_box_text]);
        switch (info)
        {
            case 0:
            case 1:
                if (ypos+upy < max)
                {
                    if (ypos < scrsize-7)
                        ypos++;
                    else {
                        scroll_up(scrwidth/2-36,4,scrwidth/2+37,scrsize-4);
                        tbar(scrwidth/2-36,scrsize-4,scrwidth/2+37,scrsize-4,color[col_box_text]);
                        upy++;
                    }
                }
                break;
            case 2:
                if (ypos > 1)
                    ypos--;
                else
                    if (upy > 0) {
                        scroll_down(scrwidth/2-36,4,scrwidth/2+37,scrsize-4);
                        tbar(scrwidth/2-36,4,scrwidth/2+37,4,color[col_box_text]);
                        upy--;
                    }
                break;
        }
    }
    while (info != 5);
    old_scr(cx,cy,&oldscr);
}

void subj_skip(void)
{
    FILE *Fsubj,*Fdat;
    char str[73],tmp[256];

    subjs = (subjtype *) malloc(sizeof(subjtype)*100);
    memset(subjs,0,100*73);

    sprintf(tmp,"%sskip%s.pst",setup.replypath,omentag);
    if ((Fsubj = fopen_ign(tmp,"rb")) != NULL)
    {
        fread(subjs,73,100,Fsubj);
        fclose(Fsubj);
    }
    else if ((Fdat = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".dat"),"rb")) != NULL)
    {
        fread(subjs,73,100,Fdat);
        fclose(Fdat);
    }

    ask_names(lang[233],72,100);

    if ((Fdat = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".dat"),"r+b")) == NULL)
        Fdat = FileOpen(tmp,"w+b");

    upy = 0;
    sprintf(tmp,"%sskip%s.pst",setup.replypath,omentag);
    if ((Fsubj = FileOpen(tmp,"w+b")) != NULL)
    {
        for (ypos=0; ypos<100; ypos++)
        {
            if (subjs[ypos][0] != 0)
            {
                fwrite(subjs[ypos],73,1,Fdat);
                fwrite(subjs[ypos],73,1,Fsubj);
                upy++;
            }
        }
        fclose(Fsubj);
        if (upy == 0) FileRemove(tmp); else pkt->arealist = 1;
    }

    /* Fill rest with nuls */
    memset(str,0,sizeof(str));
    for (ypos=upy; ypos<100; ypos++)
    {
        fwrite(str,73,1,Fdat);
    }
    fclose(Fdat);
    free(subjs);
}

void keyword_skip(void)
{
    FILE *Fsubj;
    FILE *F,*Fdat;
    char subjects,str[73],tmp[256];


    subjs = (subjtype *) malloc(sizeof(subjtype)*100);
    memset(subjs,0,100*73);

    if ((Fsubj = fopen_ign(strcat(strcpy(tmp,setup.replypath),"wordskip.pst"),"r+t")) != NULL)
    {
        subjects = 0;
        while ((_fgets(subjs[subjects],73,Fsubj) != NULL) && (subjects < 100))
            subjects++;
        fclose(Fsubj);
    }
    else if ((Fdat = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".dat"),"r+b")) != NULL)
    {
        fseek(Fdat,100*73,SEEK_SET);
        fread(subjs,73,100,Fdat);
        fclose(Fdat);
    }

    ask_names(lang[234],72,100);

    if ((Fdat = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".dat"),"r+b")) == NULL)
    {
        subj2 = (subjtype *) malloc(sizeof(subjtype)*100);
        memset(subj2,0,100*73);
        if ((Fdat = FileOpen(tmp,"w+b")) != NULL)
        {
            sprintf(tmp,"%sskip%s.pst",setup.replypath,omentag);
            if ((F = fopen_ign(tmp,"r+b")) != NULL)
            {
                fread(subj2,73,100,F);
                fclose(F);
            }
            fwrite(subj2,73,100,Fdat);
        }
        free(subj2);
    } else
        fseek(Fdat,100*73,SEEK_SET);

    upy = 0;
    if ((Fsubj = FileOpen(strcat(strcpy(tmp,setup.replypath),"wordskip.pst"),"w+b")) != NULL)
    {
        for (ypos=0; ypos<100; ypos++)
        {
            if (subjs[ypos][0] != '\0')
            {
                fprintf(Fsubj,"%s\r\n",subjs[ypos]);
                fwrite(subjs[ypos],73,1,Fdat);
                upy++;
            }
        }
        fclose(Fsubj);
        if (upy == 0) FileRemove(tmp); else pkt->arealist = 1;
    }

    /* Fill rest with nuls */
    memset(str,0,sizeof(str));
    for (ypos=upy; ypos<100; ypos++)
    {
        fwrite(str,73,1,Fdat);
    }
    fclose(Fdat);

    free(subjs);
}

void user_skip(void)
{
    FILE *Fuser;
    FILE *F,*Fdat;
    char users,str[73],tmp[256];


    subjs = (subjtype *) malloc(sizeof(subjtype)*100);
    memset(subjs,0,100*73);

    sprintf(tmp,"%strash%s.pst",setup.replypath,omentag);
    if ((Fuser = fopen_ign(tmp,"r+t")) != NULL)
    {
        users = 0;
        while ((_fgets(subjs[users],40,Fuser) != NULL) && (users < 100))
            users++;
        fclose(Fuser);
    }
    else if ((Fdat = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".dat"),"r+b")) != NULL)
    {
        fseek(Fdat,100*73*2,SEEK_SET);
        fread(subjs,40,50,Fdat);
        fclose(Fdat);
    }

    ask_names(lang[235],40,50);

    if ((Fdat = fopen_ign(strcat(strcat(strcpy(tmp,setup.datapath),omentag),".dat"),"r+b")) == NULL)
    {
        subj2 = (subjtype *) malloc(sizeof(subjtype)*100);
        memset(subj2,0,100*73);
        if ((Fdat = FileOpen(tmp,"w+b")) != NULL)
        {
            sprintf(tmp,"%sskip%s.pst",setup.replypath,omentag);
            if ((F = fopen_ign(tmp,"r+b")) != NULL)
            {
                fread(subj2,73,100,F);
                fclose(F);
            }
            fwrite(subj2,73,100,Fdat);

            if ((F = fopen_ign(strcat(strcpy(tmp,setup.replypath),"wordskip.pst"),"rt")) != NULL)
            {
                users = 0;
                while ((_fgets(subjs[users],73,F) != NULL) && (users < 100))
                    users++;
                fclose(F);
            }
            fwrite(subj2,73,100,Fdat);
        }
        free(subj2);
    } else
        fseek(Fdat,100*73*2,SEEK_SET);

    upy = 0;
    sprintf(tmp,"%strash%s.pst",setup.replypath,omentag);
    if ((Fuser = FileOpen(tmp,"w+t")) != NULL)
    {
        for (ypos=0; ypos<50; ypos++)
        {
            if (subjs[ypos][0] != 0)
            {
                fprintf(Fuser,"%s\r\n",subjs[ypos]);
                fwrite(subjs[ypos],73,1,Fdat);
                upy++;
            }
        }
        fclose(Fuser);
        if (upy == 0) FileRemove(tmp); else pkt->arealist = 1;
    }

    memset(str,0,sizeof(str));
    for (ypos=upy; ypos<50; ypos++)
        fwrite(str,73,1,Fdat);
    fclose(Fdat);

    free(subjs);
}

void omen_config(int x1, int y1, int x2, int y2)
{
    unsigned short cx,cy;
    char *oldscr;

    char quit,ch,ypos,slen;

    save_scr(&cx,&cy,&oldscr);
    tattrbar(x1,y1,x2,y2,color[col_box_text]);

    slen = get_max_langtext_len(236,239);

    draw_shaded_box(5,14,9+slen,19,color[col_box_frame],color[col_box_title],NULL);

    keys[0] = toupper(highwrite(7,15,lang[236],&keypos[0]));
    keys[1] = toupper(highwrite(7,16,lang[237],&keypos[1]));
    keys[2] = toupper(highwrite(7,17,lang[238],&keypos[2]));
    keys[3] = toupper(highwrite(7,18,lang[239],&keypos[3]));

    ypos = 1;
    tattrbar(6,15,8+slen,15,color[col_box_select]);
    while (ypos > 0)
    {
        quit = 0;
        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = (char) toupper(sk_getch());
                if (ch == toupper(keys[0]))
                {
                    clropt(ypos,slen);
                    quit = 1; ypos = 1;
                    tattrbar(6,15,8+slen,15,color[col_box_select]);
                }
                else if (ch == toupper(keys[1]))
                {
                    clropt(ypos,slen);
                    quit = 1; ypos = 2;
                    tattrbar(6,16,8+slen,16,color[col_box_select]);
                }
                else if (ch == toupper(keys[2]))
                {
                    clropt(ypos,slen);
                    quit = 1; ypos = 3;
                    tattrbar(6,17,8+slen,17,color[col_box_select]);
                }
                else if (ch == toupper(keys[3]))
                {
                    clropt(ypos,slen);
                    quit = 1; ypos = 4;
                    tattrbar(6,18,8+slen,18,color[col_box_select]);
                }
                else
                    switch (ch)
                    {
                        case 27:
                            quit = 1; ypos = 0;
                            break;
                        case 13:
                            quit = 1;
                            break;
                        case 0:
                            ch = sk_getch();
                            switch (ch)
                            {
                                case '$':
                                    shell_dos();
                                    break;
                                case 'H':
                                    clropt(ypos,slen);
                                    if (ypos == 1) ypos = 4; else ypos--;
                                    tattrbar(6,14+ypos,8+slen,14+ypos,color[col_box_select]);
                                    break;
                                case 'P':
                                    clropt(ypos,slen);
                                    if (ypos == 4) ypos = 1; else ypos++;
                                    tattrbar(6,14+ypos,8+slen,14+ypos,color[col_box_select]);
                                    break;
                            }
                            break;
                    }
            }
            else
                give_timeslice();
        }

        switch (ypos)
        {
            case 1:
                subj_skip();
                break;
            case 2:
                keyword_skip();
                break;
            case 3:
                user_skip();
                break;
            case 4:
                area_config();
                break;
        }
    }
    old_scr(cx,cy,&oldscr);
}

void offline_config(int x1, int y1, int x2, int y2)
{
    char tmp[256];

    if (!try_open_reply()) return;

    switch (fmt)
    {
        case format_bw:
            bw_config(x1,y1,x2,y2);
            break;
        case format_qwk:
            area_config();
            break;
        case format_hippo:
            area_config();
            break;
        case format_omen:
            omen_config(x1,y1,x2,y2);
            break;
    }

    sprintf(tmp, "%sOFFLINE.TMP", setup.workpath);
    FileRemove(tmp);
}
