#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <sys/stat.h>

#include "crc.h"
#include "vars.h"
#include "keyb.h"
#include "files.h"
#include "screen.h"
#include "general.h"
#include "version.h"
#include "pkt_jam.h"
#include "pkt_bw.h"
#include "pkt_obj.h"

typedef struct
{
    unsigned short zone,net,node,point;
}
ADDR_REC;

static long last_read;

static int addresses;
static ADDR_REC addr_rec[50];
static char jam_origin_line[256];

char jam_base::open_packet(char *str)
{
    FILE *Fini;
    char tmp[256],tag[9],path[256],type;
    unsigned addr_num;
    unsigned long fpos,line;
    INF_AREA_INFO infarea;
    PATH_REC *prev, *_path;
    struct stat statbuf;

    first_linerec = NULL;
    first_path = NULL;
    Fini = FileOpen(str,"rt");
    if (Fini == NULL) return 1;

    if ((Finfo = FileOpen(strcat(strcat(strcpy(tmp,setup.datapath),pktname),".inf"),"w+b")) == NULL)
    {
        fclose(Fini);
        return 1;
    }

    allow_forwarding = 1;
    strcpy(username,setup.UsrName);
    strcpy(useralias,opt.alias);

    UserCRC = crc32(strlwr(username));
    strcpy(username,setup.UsrName);

    memset(&info,0,sizeof(info));
    fwrite(&info,sizeof(info),1,Finfo);

    from_to_len = 35;
    subj_len = 71;

    inf_header_slen = sizeof(INF_HEADER);
    inf_area_slen = sizeof(INF_AREA_INFO);

    path_rec = NULL;
    areas = 0;
    sysop_name[0] = '\0';
    board_name[0] = '\0';
    tag[0] = 0;
    fpos = 0;
    addresses = 0;
    line = 0;
    jam_origin_line[0] = '\0';
    while (_fgets(tmp,sizeof(tmp),Fini) != NULL)
    {
        line++;
        if (strnicmp(tmp,"BBS",3) == 0)
            strcpy(board_name,tmp+4);
        else if (strnicmp(tmp,"SYSOP",5) == 0)
            strcpy(sysop_name,tmp+6);
        else if (strnicmp(tmp,"TAG",3) == 0)
            strcpy(tag,tmp+4);
        else if (strnicmp(tmp,"ORIGIN",6) == 0)
            strcpy(jam_origin_line,tmp+7);
        else if (strnicmp(tmp,"ADDRESS",7) == 0)
        {
            str2addr(tmp+8,&addr_rec[addresses].zone,&addr_rec[addresses].net,
                    &addr_rec[addresses].node,&addr_rec[addresses].point);
            addresses++;
        }
        else if (strnicmp(tmp,"AREAS.BBS",9) == 0)
        {
            fpos = ftell(Fini);
            while (_fgets(tmp,sizeof(tmp),Fini) != NULL)
            {
                line++;
                if (tmp[0] == ';' || tmp[0] == '\0')
                {
                    fpos = ftell(Fini);
                    continue;
                }

                memset(&infarea,0,sizeof(infarea));
                addr_num = (unsigned) -1;
                if (sscanf(tmp,"%s %s %c %u",(char *) infarea.title, path, &type, &addr_num) < 3)
                {
                    sprintf(tmp,"Error in configuration file line %lu",line);
                    err_box(tmp);
                    fpos = ftell(Fini);
                    continue;
                }

                /* Create INF_AREA_INFO record */
                areas++;
                sprintf((char *) infarea.areanum,"%u",areas);
                strcpy((char *) infarea.echotag, (char *) infarea.areanum);
                infarea.area_flags = INF_POST | INF_ANY_NAME;
                if (toupper(type) == 'E') infarea.area_flags |= INF_ECHO;
                if (toupper(type) == 'N') infarea.area_flags |= INF_ECHO | INF_NETMAIL;
                if (fwrite(&infarea,sizeof(infarea),1,Finfo) == 0) return 5;

                /* Create path object */
                prev = path_rec;
                _path = (PATH_REC *) malloc(sizeof(PATH_REC));
                if (path_rec == NULL)
                {
                    first_path = _path;
                }
                else
                {
                    path_rec->next = _path;
                }
                path_rec = _path;
                path_rec->prev = prev;
                path_rec->next = NULL;
                strcpy(path_rec->msgbase,path);
                strcpy(tmp,path);

                /* Read lastread pointers */
                if (FileStat(strcat(path,".jdx"),&statbuf) == 0)
                {
                    Fjlr = FileOpen(strcat(tmp,".jlr"),"rb");
                    path_rec->messages = statbuf.st_size/sizeof(jamidx);
                    path_rec->unread = read_lastread();
                    if (path_rec->messages > path_rec->unread)
                        path_rec->unread = path_rec->messages-path_rec->unread;
                    else
                        path_rec->unread = 0;
                    fclose(Fjlr);
                }
                else
                {
                    path_rec->messages = 0;
                    path_rec->unread = 0;
                }

                if (addr_num != (unsigned) -1)
                {
                    addr_num--;
                    path_rec->zone = addr_rec[addr_num].zone;
                    path_rec->net = addr_rec[addr_num].net;
                    path_rec->node = addr_rec[addr_num].node;
                    path_rec->point = addr_rec[addr_num].point;
                }

                fpos = ftell(Fini);
            }
        }
    }
    pathpos = 1;
    path_rec = first_path;

    if (areas < MAX_AREAS)
        abufsize = areas;
    else
        abufsize = MAX_AREAS;

    if ((area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*abufsize)) == NULL) return 2;

    dat_start = 1; dat_end = 0;
    lastarea[0] = 0;
    if ((txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;

    if (tag[0] == 0) return 1;

    /* Create INF_HEADER */
    memset(&info,0,sizeof(info));
    info.mashtype = 0;
    info.ver = 250;
    strcpy((char *) info.loginname,setup.UsrName);
    strcpy((char *) info.aliasname,opt.alias);
    strcpy((char *) info.sysop,sysop_name);
    strcpy((char *) info.systemname,board_name);
    info.inf_header_len = sizeof(INF_HEADER);
    info.inf_areainfo_len = sizeof(INF_AREA_INFO);
    info.mix_structlen = sizeof(MIX_REC);
    info.fti_structlen = sizeof(FTI_REC);
    info.uses_upl_file = 1;
    info.from_to_len = 35;
    info.subject_len = 71;
    strcpy((char *) info.packet_id,tag);

    /* Write INF_HEADER */
    fseek(Finfo,0,SEEK_SET);
    fwrite(&info,sizeof(INF_HEADER),1,Finfo);
    setbuf(Finfo,NULL);

    replies = 0;

    curarea = 0;
    if (setup.left_margin == 0) setup.left_margin = 1;
    if ((setup.right_margin > scrwidth-1) || (setup.right_margin == 0))
        txt_length = (char) ((scrwidth-1)-setup.left_margin+1);
    else
        txt_length = (char) (setup.right_margin-setup.left_margin+1);

    Fjhr = NULL;
    return 0;
}

void jam_base::close_packet(void)
{
    free(area_buf);
    free(txt_buf);

    if (Fjhr != NULL)
    {
        fclose(Fjhr);
        fclose(Fjlr);
        fclose(Fjdx);
        fclose(Fdat);
    }

    while (first_path != NULL)
    {
        path_rec = first_path;
        first_path = first_path->next;
        free(path_rec);
    }
}

char jam_base::open_area(char *area)
{
    int anum;

    last_msg = 0;
    last_read = -1;
    if (Fjhr != NULL)
    {
        fclose(Fjhr);
        fclose(Fjdx);
        fclose(Fjlr);
        fclose(Fdat);
        Fjhr = NULL;
    }

    msgbase_opened = 0;
    anum = getarea(area);
    while (anum < pathpos)
    {
        path_rec = path_rec->prev;
        if (path_rec == NULL)
        {
            pathpos = 0;
            return 0;
        }
        pathpos--;
    }
    while (anum > pathpos)
    {
        path_rec = path_rec->next;
        if (path_rec == NULL)
        {
            pathpos = 0;
            return 0;
        }
        pathpos++;
    }
    strcpy(msgbase,path_rec->msgbase);

    return 1;
}

unsigned jam_base::get_msgs(char *areanum)
{
    int anum;

    anum = atol(areanum);
    while (anum < pathpos)
    {
        path_rec = path_rec->prev;
        if (path_rec == NULL)
        {
            pathpos = 0;
            return 0;
        }
        pathpos--;
    }
    while (anum > pathpos)
    {
        path_rec = path_rec->next;
        if (path_rec == NULL)
        {
            pathpos = 0;
            return 0;
        }
        pathpos++;
    }
    return path_rec->messages;
}

unsigned jam_base::get_personal_msgs(char * /*areanum*/ )
{
    return 0;
}

unsigned jam_base::get_unread_msgs(char *areanum)
{
    int anum;

    anum = atol(areanum);
    while (anum < pathpos)
    {
        path_rec = path_rec->prev;
        if (path_rec == NULL)
        {
            pathpos = 0;
            return 0;
        }
        pathpos--;
    }
    while (anum > pathpos)
    {
        path_rec = path_rec->next;
        if (path_rec == NULL)
        {
            pathpos = 0;
            return 0;
        }
        pathpos++;
    }
    return path_rec->unread;
}

unsigned jam_base::getarea(char *area)
{
    return atol(area);
}

unsigned jam_base::read_lastread(void)
{
    JAMLREAD jamlr;

    fseek(Fjlr,0,SEEK_SET);
    while (fread(&jamlr,sizeof(jamlr),1,Fjlr))
    {
        if (jamlr.UserCRC == UserCRC)
        {
            return jamlr.LastReadMsg;
        }
    }

    return 0;
}

int jam_base::open_msgbase(void)
{
    char tmp[256];

    sprintf(tmp,"%s.jhr",msgbase); Fjhr = FileOpen(tmp,"r+b");
    sprintf(tmp,"%s.jdx",msgbase); Fjdx = FileOpen(tmp,"r+b");
    sprintf(tmp,"%s.jlr",msgbase); Fjlr = FileOpen(tmp,"r+b");
    sprintf(tmp,"%s.jdt",msgbase); Fdat = FileOpen(tmp,"r+b");

    if (Fjhr == NULL || Fjdx == NULL || Fdat == NULL || Fjlr == NULL)
    {
        fclose(Fjhr);
        fclose(Fjdx);
        fclose(Fjlr);
        fclose(Fdat);
        return 0;
    }
    fseek(Fjdx,0,SEEK_END);
    path_rec->messages = ftell(Fjdx)/sizeof(jamidx);
    path_rec->unread = read_lastread();
    if (path_rec->messages > path_rec->unread)
        path_rec->unread = path_rec->messages-path_rec->unread;
    else
        path_rec->unread = 0;
    msgbase_opened = 1;
    return 1;
}

char jam_base::read_msg(unsigned msgnum)
{
    JAMBINSUBFIELD subfield;
    unsigned long sublen,fpos;
    struct tm *tim;
    unsigned len;

    if (last_msg == msgnum) return 1;
    last_msg = msgnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        msgtxtptr = msg.blockpos;
        msgtxtsize = msg.txtblocks;
        return 1;
    }

    if (!msgbase_opened) open_msgbase();
    memset(&msg,0,sizeof(msg));

    /* Read .JHR file position from .HDX file */
    fseek(Fjdx,(msgnum-1)*sizeof(jamidx),SEEK_SET);
    if (fread(&jamidx,sizeof(jamidx),1,Fjdx) == 0) return 0;

    /* Read message record from .JHR file */
    fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
    if (fread(&msgrec,sizeof(msgrec),1,Fjhr) == 0) return 0;

    if (strcmp(msgrec.Signature,HEADERSIGNATURE) != 0) return 0;
    if (msgrec.Revision != CURRENTREVLEV) return 0;

    msg.mnum = msgrec.MsgNum;
    msgtxtptr = msgrec.TxtOffset;
    msgtxtsize = msgrec.TxtLen;

    msg.blockpos = msgtxtptr;
    msg.txtblocks = msgtxtsize;

    tim = localtime((time_t *) &msgrec.DateWritten);
    sprintf(msg.date,"%02d %s %02d %02d:%02d:%02d",
            tim->tm_mday,month[tim->tm_mon],tim->tm_year%100,
            tim->tm_hour,tim->tm_min,tim->tm_sec);

    msgid_kludge[0] = '\0';

    /* Read subfields */
    sublen = 0;
    while (sublen < msgrec.SubfieldLen)
    {
        /* Read subfield */
        fread(&subfield,sizeof(subfield),1,Fjhr);
        sublen += sizeof(subfield)+subfield.DatLen;

        fpos = ftell(Fjhr);
        len = subfield.DatLen;
        switch (subfield.LoID)
        {
            case JAMSFLD_SENDERNAME:
                if (len > sizeof(msg.mfrom)-1) len = sizeof(msg.mfrom)-1;
                msg.mfrom[fread(msg.mfrom,1,len,Fjhr)] = '\0';
                break;
            case JAMSFLD_RECVRNAME:
                if (len > sizeof(msg.mto)-1) len = sizeof(msg.mto)-1;
                msg.mto[fread(msg.mto,1,len,Fjhr)] = '\0';
                break;
            case JAMSFLD_SUBJECT:
                if (len > sizeof(msg.subj)-1) len = sizeof(msg.subj)-1;
                msg.subj[fread(msg.subj,1,len,Fjhr)] = '\0';
                break;
            case JAMSFLD_MSGID:
                if (len > sizeof(msgid_kludge)-1) len = sizeof(msgid_kludge)-1;
                msgid_kludge[fread(msgid_kludge,1,len,Fjhr)] = '\0';
                break;
            default:
                break;
        }
        fseek(Fjhr,fpos+subfield.DatLen,SEEK_SET);
    }

    return 1;
}

long jam_base::read_num(unsigned msgnum)
{
    if (last_msg == msgnum) return 1;
    last_msg = msgnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mnum;
    }

    if (!msgbase_opened) open_msgbase();

    /* Read .JHR file position from .HDX file */
    fseek(Fjdx,(msgnum-1)*sizeof(jamidx),SEEK_SET);
    if (fread(&jamidx,sizeof(jamidx),1,Fjdx) == 0) return 0;

    /* Read message record from .JHR file */
    fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
    if (fread(&msgrec,sizeof(msgrec),1,Fjhr) == 0) return 0;

    if (strcmp(msgrec.Signature,HEADERSIGNATURE) != 0) return 0;
    if (msgrec.Revision != CURRENTREVLEV) return 0;

    return msgrec.MsgNum;
}

char *jam_base::read_from(unsigned msgnum)
{
    JAMBINSUBFIELD subfield;
    unsigned long sublen,fpos;
    unsigned len;

    if (last_msg == msgnum) return msg.mfrom;
    last_msg = msgnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mfrom;
    }

    if (!msgbase_opened) open_msgbase();
    memset(&msg,0,sizeof(msg));

    /* Read .JHR file position from .HDX file */
    fseek(Fjdx,(msgnum-1)*sizeof(jamidx),SEEK_SET);
    if (fread(&jamidx,sizeof(jamidx),1,Fjdx) == 0) return msg.mfrom;

    /* Read message record from .JHR file */
    fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
    if (fread(&msgrec,sizeof(msgrec),1,Fjhr) == 0) return msg.mfrom;

    if (strcmp(msgrec.Signature,HEADERSIGNATURE) != 0) return msg.mfrom;
    if (msgrec.Revision != CURRENTREVLEV) return msg.mfrom;

    msg.mnum = msgrec.MsgNum;

    /* Read subfields */
    sublen = 0;
    while (sublen < msgrec.SubfieldLen)
    {
        /* Read subfield */
        fread(&subfield,sizeof(subfield),1,Fjhr);
        sublen += sizeof(subfield)+subfield.DatLen;

        fpos = ftell(Fjhr);
        len = subfield.DatLen;
        switch (subfield.LoID)
        {
            case JAMSFLD_SENDERNAME:
                if (len > sizeof(msg.mfrom)-1) len = sizeof(msg.mfrom)-1;
                msg.mfrom[fread(msg.mfrom,1,len,Fjhr)] = '\0';
                break;
        }
        fseek(Fjhr,fpos+subfield.DatLen,SEEK_SET);
    }

    return msg.mfrom;
}

char *jam_base::read_to(unsigned msgnum)
{
    JAMBINSUBFIELD subfield;
    unsigned long sublen,fpos;
    unsigned len;

    if (last_msg == msgnum) return msg.mto;
    last_msg = msgnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mto;
    }

    if (!msgbase_opened) open_msgbase();
    memset(&msg,0,sizeof(msg));

    /* Read .JHR file position from .HDX file */
    fseek(Fjdx,(msgnum-1)*sizeof(jamidx),SEEK_SET);
    if (fread(&jamidx,sizeof(jamidx),1,Fjdx) == 0) return msg.mto;

    /* Read message record from .JHR file */
    fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
    if (fread(&msgrec,sizeof(msgrec),1,Fjhr) == 0) return msg.mto;

    if (strcmp(msgrec.Signature,HEADERSIGNATURE) != 0) return msg.mto;
    if (msgrec.Revision != CURRENTREVLEV) return msg.mto;

    msg.mnum = msgrec.MsgNum;

    /* Read subfields */
    sublen = 0;
    while (sublen < msgrec.SubfieldLen)
    {
        /* Read subfield */
        fread(&subfield,sizeof(subfield),1,Fjhr);
        sublen += sizeof(subfield)+subfield.DatLen;

        fpos = ftell(Fjhr);
        len = subfield.DatLen;
        switch (subfield.LoID)
        {
            case JAMSFLD_RECVRNAME:
                if (len > sizeof(msg.mto)-1) len = sizeof(msg.mto)-1;
                msg.mto[fread(msg.mto,1,len,Fjhr)] = '\0';
                break;
        }
        fseek(Fjhr,fpos+subfield.DatLen,SEEK_SET);
    }

    return msg.mto;
}

char *jam_base::read_subj(unsigned msgnum)
{
    JAMBINSUBFIELD subfield;
    unsigned long sublen,fpos;
    unsigned len;

    if (last_msg == msgnum) return msg.subj;
    last_msg = msgnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.subj;
    }

    if (!msgbase_opened) open_msgbase();
    memset(&msg,0,sizeof(msg));

    /* Read .JHR file position from .HDX file */
    fseek(Fjdx,(msgnum-1)*sizeof(jamidx),SEEK_SET);
    if (fread(&jamidx,sizeof(jamidx),1,Fjdx) == 0) return msg.subj;

    /* Read message record from .JHR file */
    fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
    if (fread(&msgrec,sizeof(msgrec),1,Fjhr) == 0) return msg.subj;

    if (strcmp(msgrec.Signature,HEADERSIGNATURE) != 0) return msg.subj;
    if (msgrec.Revision != CURRENTREVLEV) return msg.subj;

    msg.mnum = msgrec.MsgNum;

    /* Read subfields */
    sublen = 0;
    while (sublen < msgrec.SubfieldLen)
    {
        /* Read subfield */
        fread(&subfield,sizeof(subfield),1,Fjhr);
        sublen += sizeof(subfield)+subfield.DatLen;

        fpos = ftell(Fjhr);
        len = subfield.DatLen;
        switch (subfield.LoID)
        {
            case JAMSFLD_SUBJECT:
                if (len > sizeof(msg.subj)-1) len = sizeof(msg.subj)-1;
                msg.subj[fread(msg.subj,1,len,Fjhr)] = '\0';
                break;
        }
        fseek(Fjhr,fpos+subfield.DatLen,SEEK_SET);
    }

    return msg.subj;
}

void jam_base::area_flags(unsigned num, XTI_REC *xti)
{
    memset(xti,0,sizeof(XTI_REC));
    if (num <= path_rec->messages-path_rec->unread) xti->flags |= XTI_HAS_READ;

    if (last_msg != num)
    {
        if (!msgbase_opened) open_msgbase();

        fseek(Fjdx,(num-1)*sizeof(jamidx),SEEK_SET);
        if (fread(&jamidx,sizeof(jamidx),1,Fjdx))
        {
            /* Read message record from .JHR file */
            fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
            fread(&msgrec,sizeof(msgrec),1,Fjhr);
        }
    }

    if (UserCRC == jamidx.UserCRC) xti->flags |= XTI_IS_PERSONAL;
    if (msgrec.Attribute & MSG_SENT) xti->flags |= XTI_HAS_SAVED;
    if (msgrec.Attribute & MSG_DELETED) xti->flags |= XTI_MARK_DELETE;
}

void jam_base::save_area_flags(unsigned num, XTI_REC *xti)
{
    last_read = num;

    fseek(Fjdx,(num-1)*sizeof(jamidx),SEEK_SET);
    if (fread(&jamidx,sizeof(jamidx),1,Fjdx))
    {
        /* Read message record from .JHR file */
        fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
        if (fread(&msgrec,sizeof(msgrec),1,Fjhr))
        {
            fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
            msgrec.Attribute &= ~MSG_SENT;
            if (xti->flags & XTI_HAS_SAVED) msgrec.Attribute |= MSG_SENT;
            fwrite(&msgrec,sizeof(msgrec),1,Fjhr);
        }
    }
}

void jam_base::update_area_flags(void)
{
    JAMLREAD jamlr;

    if (last_read < 0) return;

    fseek(Fjlr,0,SEEK_SET);
    while (fread(&jamlr,sizeof(jamlr),1,Fjlr))
    {
        if (jamlr.UserCRC == UserCRC)
        {
            fseek(Fjlr,-sizeof(jamlr),SEEK_CUR);
            jamlr.LastReadMsg = last_read;
            jamlr.HighReadMsg = last_read;
            fwrite(&jamlr,sizeof(jamlr),1,Fjlr);
            path_rec->unread = path_rec->messages-last_read;
            break;
        }
    }
}

int jam_base::lock_msgbase(void)
{
    int tries;

    tries = 10;
#ifdef __linux__
    while (lockf(fileno(Fjhr),F_LOCK,1) != 0)
#else
    while (lock(fileno(Fjhr),0,1) != 0)
#endif
    {
        if (tries == 0) return 0;
        tries--;
    }

    return 1;
}

void jam_base::unlock_msgbase(void)
{
#ifdef __linux__
    lockf(fileno(Fjhr),F_ULOCK,1);
#else
    unlock(fileno(Fjhr),0,1);
#endif
}

#define TMP_BUF_SIZE 4096

void jam_base::add_subfield(char *subdata, char *fielddata, unsigned subtype)
{
    JAMBINSUBFIELD subrec;

    if (fielddata[0] == '\0') return;

    subrec.LoID = (unsigned short) subtype;
    subrec.HiID = 0;
    subrec.DatLen = strlen(fielddata);

    memcpy(subdata,&subrec,sizeof(subrec));
    memcpy(subdata+sizeof(subrec),fielddata,subrec.DatLen);
    msgrec.SubfieldLen += subrec.DatLen+sizeof(subrec);
}

unsigned jam_base::get_own_address(unsigned zone, unsigned net, unsigned node, unsigned point)
{
    int num,closest,closest_num;

    closest = 0;
    closest_num = 0;
    for (num=0; num<addresses; num++)
    {
        if (zone == addr_rec[num].zone)
        {
            if (net != addr_rec[num].net)
                if (closest < 1) { closest = 1; closest_num = num; } else ;
            else
            {
                if (node != addr_rec[num].node)
                    if (closest < 2) { closest = 2; closest_num = num; } else ;
                {
                    if (point == addr_rec[num].point)
                        if (closest < 3) { closest = 2; closest_num = num; } else ;
                    {
                        return num;
                    }
                }
            }
        }
    }

    return closest_num;
}


void jam_base::enter_msg(void)
{
    FILE *Ftxt;
    size_t readed;
    unsigned long fjhr_pos,msgnum;
    char *subbuf,*buffer,tmp[256],orig_net[30],dest_net[30];
    unsigned addr,type;

    subbuf = (char *) malloc(4096);
    if (subbuf == NULL) return;

    /* Lock message base */
    if (lock_msgbase() == 0)
    {
        free(subbuf);
        return;
    }

    /* Read message base header */
    fseek(Fjhr,0,SEEK_SET);
    if (fread(&jamhdr,sizeof(jamhdr),1,Fjhr) == 0)
    {
        unlock_msgbase();
        free(subbuf);
        return;
    }

    /* Read message number of previous message */
    fseek(Fjdx,0,SEEK_END);
    if (ftell(Fjdx) == 0)
    {
        /* No messages in message base */
        fseek(Fjhr,0,SEEK_END);
        jamidx.HdrOffset = ftell(Fjhr);
    }
    else
    {
        do {
            fseek(Fjdx,-sizeof(jamidx),SEEK_CUR);
            if (fread(&jamidx,sizeof(jamidx),1,Fjdx) == 0)
            {
                fseek(Fjhr,0,SEEK_END);
                jamidx.HdrOffset = ftell(Fjhr);
                break;
            }
            fseek(Fjdx,-sizeof(jamidx),SEEK_CUR);
            if (ftell(Fjdx) == 0 && jamidx.HdrOffset == 0xffffffff)
            {
                /* No messages in message base */
                fseek(Fjhr,0,SEEK_END);
                jamidx.HdrOffset = ftell(Fjhr);
                break;
            }
        } while (jamidx.HdrOffset == 0xffffffff);
    }

    fseek(Fjhr,jamidx.HdrOffset,SEEK_SET);
    if (fread(&msgrec,sizeof(msgrec),1,Fjhr) == 0) msgrec.MsgNum = 0;

    type = area_type(gettag(reply.area));
    if (type & TYPE_ECHO && (type & TYPE_NET) == 0)
    {
        /* Add tear & origin */
        Ftxt = FileOpen(strcat(strcpy(tmp,setup.replypath),reply.fname),"a+b");
        fprintf(Ftxt,"\r--- "Reader_Name" v"version"\r");
        sprintf(tmp,"%u:%u/%u",path_rec->zone,path_rec->net,path_rec->node);
        if (path_rec->point != 0) sprintf(tmp+strlen(tmp),".%u",path_rec->point);
        fprintf(Ftxt," * Origin: %s (%s)\r",jam_origin_line,tmp);
        fclose(Ftxt);
    }

    /* Open message text */
    Ftxt = FileOpen(strcat(strcpy(tmp,setup.replypath),reply.fname),"rb");
    if (Ftxt == NULL)
    {
        unlock_msgbase();
        free(subbuf);
        return;
    }

    msgnum = msgrec.MsgNum+1;

    /* Create message header */
    memset(&msgrec,0,sizeof(msgrec));
    strcpy(msgrec.Signature,HEADERSIGNATURE);
    msgrec.Revision = CURRENTREVLEV;
    msgrec.DateWritten = time(NULL);
    msgrec.MsgNum = msgnum;
    msgrec.PasswordCRC = 0xffffffffL;
    msgrec.Attribute = MSG_LOCAL;
    if (reply.flags & flag_private) msgrec.Attribute |= MSG_PRIVATE;
    msgrec.ReplyTo = reply.replyto;

    fseek(Fdat,0,SEEK_END);
    fseek(Ftxt,0,SEEK_END);
    msgrec.TxtOffset = ftell(Fdat);
    msgrec.TxtLen = ftell(Ftxt);

    strcpy(tmp,msgid_kludge); /* REPLY kludge */
    if (reply.flags & flag_netmail)
    {
        /* Netmail message */
        addr = get_own_address(reply.destzone,reply.destnet,reply.destnode,reply.destpoint);
        sprintf(orig_net,"%u:%u/%u.%u",
                addr_rec[addr].zone,addr_rec[addr].net,addr_rec[addr].node,addr_rec[addr].point);
        sprintf(dest_net,"%u:%u/%u.%u",
                reply.destzone,reply.destnet,reply.destnode,reply.destpoint);

        /* Create MSGID kludge */
        sprintf(msgid_kludge,"%s %08lx",orig_net,time(NULL));
    }
    else
    {
        /* Create MSGID kludge */
        sprintf(msgid_kludge,"%u:%u/%u.%u %08lx",
                path_rec->zone,path_rec->net,path_rec->node,path_rec->point,time(NULL));

        orig_net[0] = '\0';
        dest_net[0] = '\0';
    }

    /* Create subfields */
    add_subfield(subbuf+msgrec.SubfieldLen,reply.mfrom,JAMSFLD_SENDERNAME);
    add_subfield(subbuf+msgrec.SubfieldLen,orig_net,JAMSFLD_OADDRESS);
    add_subfield(subbuf+msgrec.SubfieldLen,reply.mto,JAMSFLD_RECVRNAME);
    add_subfield(subbuf+msgrec.SubfieldLen,dest_net,JAMSFLD_DADDRESS);
    add_subfield(subbuf+msgrec.SubfieldLen,reply.subj,JAMSFLD_SUBJECT);
    add_subfield(subbuf+msgrec.SubfieldLen,msgid_kludge,JAMSFLD_MSGID);
    add_subfield(subbuf+msgrec.SubfieldLen,tmp,JAMSFLD_REPLYID);

    /* Write message header */
    fseek(Fjhr,0,SEEK_END);
    fjhr_pos = ftell(Fjhr);

    if (fwrite(&msgrec,sizeof(msgrec),1,Fjhr) == 0)
    {
        unlock_msgbase();
        free(subbuf);
        return;
    }

    /* Write subfields */
    if (fwrite(subbuf,msgrec.SubfieldLen,1,Fjhr) == 0)
    {
        unlock_msgbase();
        free(subbuf);
        return;
    }
    free(subbuf);

    /* Update .JDX file */
    fseek(Fjdx,0,SEEK_END);
    jamidx.UserCRC = crc32(reply.mto);
    jamidx.HdrOffset = fjhr_pos;
    if (fwrite(&jamidx,sizeof(jamidx),1,Fjdx) == 0)
    {
        unlock_msgbase();
        return;
    }

    /* Update .JDT file */
    buffer = (char *) malloc(TMP_BUF_SIZE);
    if (buffer != NULL)
    {
        fseek(Ftxt,0,SEEK_SET);
        fseek(Fdat,msgrec.TxtOffset,SEEK_SET);
        while ((readed = fread(buffer,1,TMP_BUF_SIZE,Ftxt)) > 0)
        {
            if (fwrite(buffer,1,readed,Fdat) != readed)
            {
                free(buffer);
                unlock_msgbase();
                return;
            }
        }
        free(buffer);
    }
    fclose(Ftxt);

    /* Update ModCounter */
    jamhdr.ModCounter++;
    fseek(Fjhr,0,SEEK_SET);
    fwrite(&jamhdr,sizeof(jamhdr),1,Fjhr);

    fflush(Fjdx);
    fflush(Fjhr);
    fflush(Fdat);

    /* Unlock message base */
    unlock_msgbase();

    fseek(Fjdx,0,SEEK_END);
    path_rec->messages = ftell(Fjdx)/sizeof(jamidx);

    return;
}
