#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "pkt_obj.h"
#include "screen.h"
#include "files.h"
#include "keyb.h"
#include "shell.h"
#include "vars.h"
#include "general.h"
#include "readsets.h"

static char open_inited;

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != '\0')
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

char offline_packet::open_packet(char *str)
{
    char *oldscr;
    unsigned short ox, oy;
    char tmp[256],*anum,defalias[36];
    char *pstr;
    unsigned n1,n2,msgs;
    XTI_REC xti;

    if (fmt == format_omen) strcpy(pktname, omentag);
    read_setup(NULL); /* To get opt.alias work right.. */
    if (opt.alias[0] != '\0') strcpy(useralias, opt.alias);
    strcpy(defalias, useralias);

    txt_buf = NULL; mix_buf = NULL; xti_buf = NULL;
    open_inited = 1; lastareanum = 0;

    first_linerec = NULL;
    if (fmt != format_qwk) mixedcase = 1;
    dat_start = 1; dat_end = 0;
    lastarea[0] = '\0';
    if ((txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;
    if ((xti_buf = (XTI_REC *) malloc(sizeof(XTI_REC)*XTI_SIZE)) == NULL) return 2;
    mix_start = 1; mix_end = 0;
    if ((mix_buf = (MIX_REC *) malloc(sizeof(MIX_REC)*MAX_MIXES)) == NULL) return 2;
    fseek(Fmix,0,SEEK_END);
    total_mixes = ftell(Fmix)/sizeof(MIX_REC);

    replyopen = 0;
    replies = 0;
    fupl_opened = 0;
    arealist = 0;

    curarea = 0;
    if (setup.left_margin == 0) setup.left_margin = 1;
    if ((setup.right_margin > scrwidth-1) || (setup.right_margin == 0))
        txt_length = (char) ((scrwidth-1)-setup.left_margin+1);
    else
        txt_length = (char) (setup.right_margin-setup.left_margin+1);

    if (fmt != format_bw)
    {
        allow_crash = 0;
        allow_direct = 0;
        allow_immediate = 0;
        allow_hold = 0;
        allow_killsent = 0;
        allow_fattach = 0;
        allow_net_freq = 0;
        ansi_newfiles = 0;
        max_freqs = 0;
        allow_freq = 0;
    }

    if (packet.open)
    {
        /* Packet already open, save old .xti file */
        strcat(strcpy(xti_path,setup.packetpath),xtiname);
        strcat(strcpy(tmp,setup.workpath),xtiname);
        copyfile(xti_path,tmp);
    }
    else
    {
        if ((setup.packet_flags & PKT_SAVE_UNPACKED) && (fmt == format_hippo))
        {
            /* Keep packets unpacked */
            sprintf(xti_path,"%s%s.",setup.packetpath,pktname);
            adder(xti_path);

            sprintf(pktidx.oldname,"%s.xti",pktname);
            if ((pstr = strrchr(xti_path,SLASH)) == NULL) pstr = xti_path; else pstr++;
            strcpy(pktidx.idxname,pstr);
            pktidx.packet = (char) first;
            if (fwrite(&pktidx,sizeof(pktidx),1,Fpktidx) == 0) return 5;
        }
        else
        {
            sprintf(xti_path,"%sxti",str);
        }
    }

    /* Open .xti file */
    Fxti = fopen_ign(xti_path,"r+b");

    if (Fxti == NULL)
    {
        int slen;

        /* Not found, create it */
        Fxti = FileOpen(xti_path,"w+b");
        if (Fxti == NULL) return 4;

        save_scr(&ox, &oy, &oldscr);
        slen = strlen(lang[332]);
        draw_shaded_box(scrwidth/2-slen/2-2, scrsize/2-2, scrwidth/2+slen/2+2, scrsize/2+2, color[col_box_frame], color[col_box_title], NULL);
        cmiddle(scrsize/2, lang[332], color[col_box_hilight]);
        refresh();

        memset(&xti,0,sizeof(xti));
        for (n1=1; n1<=areas; n1++)
        {
            /* Open area */
            anum = get_area_number(n1);
            read_setup(pkt->get_area_tag(n1)); /* To get alias from area override */
            if (opt.alias[0] != '\0')
                strcpy(useralias, opt.alias);
            else
                strcpy(useralias, defalias);

            read_table(1,inbound,opt.intable);

            msgs = get_msgs(anum);
            if (msgs > 0 && open_area(anum))
            {
                /* Get number of messages */
                for (n2=1; n2<=msgs; n2++)
                {
                    /* Read message */
                    read_msg(n2); tran(msg.mto);
                    if (stricmp(username,msg.mto) == 0 || stricmp(useralias,msg.mto) == 0)
                    {
                        /* Message is personal */
                        xti.flags = XTI_IS_PERSONAL;
                    }
                    else
                    {
                        xti.flags = 0;
                    }

                    if (fwrite(&xti,sizeof(xti),1,Fxti) == 0) return 5;
                }
            }
        }
        old_scr(ox, oy, &oldscr);

        /* Reopen .xti file to make sure it is saved to disk */
        fclose(Fxti);
        Fxti = FileOpen(xti_path,"r+b");
    }

    /* No .xti file buffering */
    //setbuf(Fxti,NULL);

    xti_start = 65535;
    xti_end = 0;

    references = NULL;
    message_id = NULL;
    newsgroups = NULL;
    if ((setup.packet_flags & PKT_SAVE_UNPACKED) && (fmt == format_hippo) && (!packet.open))
        fclose(Fpktidx);
    return 0;
}

void offline_packet::close_packet(void)
{
    if (!open_inited) return;

    if (references != NULL) free(references);
    if (message_id != NULL) free(message_id);
    if (newsgroups != NULL) free(newsgroups);

    free(mix_buf);
    free(txt_buf);
    free(xti_buf);
    fclose(Fxti);
    open_inited = 0;
}

char offline_packet::save_info(char * /*path*/ )
{
    return 0;
}

/* Read record from .inf file */
void offline_packet::read_inf_area(unsigned area)
{
    if (area_start > area || area_end < area)
    {
        fseek(Finfo,inf_header_slen+(area-1)*inf_area_slen,SEEK_SET);
        area_start = area;
        area_end = area_start+fread(area_buf,inf_area_slen,abufsize,Finfo)-1;
    }
}

/* Read record from .mix file */
void offline_packet::read_mix(unsigned area)
{
    long lnum;
    size_t readed;

    if (area > total_mixes) return;

    if (mix_end < area || mix_start > area)
    {
        lnum = (long) area - (MAX_MIXES / 2);
        if (lnum < 1) lnum = 1;
        mix_start = mix_end = lnum = area;
        fseek(Fmix,(lnum-1)*sizeof(MIX_REC),SEEK_SET);
        readed = fread(mix_buf,sizeof(MIX_REC),MAX_MIXES,Fmix);
        if (readed)
        {
            mix_start = lnum;
            mix_end = mix_start-1+readed;
        }
    }
}

/* Write record to .mix file */
void offline_packet::write_mix(unsigned area, MIX_REC *mix)
{
    if (area > total_mixes) return;

    fseek(Fmix, (area-1)*sizeof(MIX_REC), SEEK_SET);
    fwrite(mix, sizeof(MIX_REC), 1, Fmix);

    /*if (mix_end >= area && mix_start <= area)
        mix_start = area+1;
        memcpy(&mix_buf[area-mix_start], mix, sizeof(MIX_REC));*/
    mix_start = 65535; mix_end = 0;
}

/* Delete .mix record */
void offline_packet::delete_mix(unsigned area)
{
    unsigned long fsize;

    if (area > total_mixes) return;

    fseek(Fmix, 0, SEEK_END); fsize = ftell(Fmix);
    delete_space(Fmix, (area-1)*sizeof(MIX_REC), sizeof(MIX_REC), fsize);
    ftrunc(Fmix, fsize-sizeof(MIX_REC));

    mix_start = 65535; mix_end = 0; curarea = 0; lastarea[0] = '\0';
}

char offline_packet::area_selected(unsigned area)
{
    read_inf_area(area);
    if ((area_buf[area-area_start].area_flags & INF_SCANNING) == 0) return 0;
    if (area_buf[area-area_start].area_flags & INF_TO_ALL) return 3;
    if (area_buf[area-area_start].area_flags & INF_PERSONAL) return 2;
    return 1;
}

/* Get area name */
char *offline_packet::get_area_name(unsigned area)
{
    read_inf_area(area);
    return (char *) area_buf[area-area_start].title;
}

/* Get area number */
char *offline_packet::get_area_number(unsigned area)
{
    read_inf_area(area);
    return (char *) area_buf[area-area_start].areanum;
}

/* Get area tag */
char *offline_packet::get_area_tag(unsigned area)
{
    read_inf_area(area);
    return (char *) area_buf[area-area_start].echotag;
}

/* Get "real" area number */
unsigned offline_packet::getarea(char *areanum)
{
    unsigned arean, first, last;

    if (strcmp(lastarea,areanum) == 0 && mix_start < mix_end) return lastareanum;

    strcpy(lastarea,areanum);
    first = lastareanum == 0 || lastareanum > total_mixes ? 1 : lastareanum+1;
    last = total_mixes;
    for (arean=first; arean<=last || first != 1; arean++)
    {
        if (arean > total_mixes)
        {
            first = 1;
            arean = 1;
            last = lastareanum;
        }
        read_mix(arean);
        if (arean > mix_end) break;

        if (strcmp((char *) mix_buf[arean-mix_start].areanum,areanum) == 0)
        {
            lastareanum = arean;
            return arean;
        }
    }
    lastareanum = 0;
    return 0;
}

/* Search area with name */
unsigned offline_packet::getaname(char *area)
{
    unsigned arean;

    for (arean=1; arean<=areas; arean++)
    {
        read_inf_area(arean);
        if (strcmp((char *) area_buf[arean-area_start].title,area) == 0) return arean;
    }
    return 0;
}

/* Search area with tag */
unsigned offline_packet::gettag(char *tag)
{
    unsigned area;

    for (area=1; area<=areas; area++)
    {
        read_inf_area(area);
        if (strcmp((char *) area_buf[area-area_start].echotag,tag) == 0) return area;
    }
    return 0;
}

/* Get number of messages in area */
unsigned offline_packet::get_msgs(char *areanum)
{
    unsigned area;

    area = getarea(areanum);
    if (area == 0) return 0;

    return mix_buf[area-mix_start].totmsgs;
}

/* Get number of personal messages in area */
unsigned offline_packet::get_personal_msgs(char *areanum)
{
    unsigned area;

    area = getarea(areanum);
    if (area == 0) return 0;

    return mix_buf[area-mix_start].numpers;
}

/* Get number of unread messages in area */
unsigned offline_packet::get_unread_msgs(char *areanum)
{
    size_t readed;
    unsigned unread,max,num;

    open_area(areanum);

    num = msgptr+1;
    max = get_msgs(areanum)+num;
    unread = 0;
    while (num < max)
    {
        if ((xti_start > num) || (xti_end < num))
        {
            /* Read .xti file */
            fseek(Fxti,(num-1)*sizeof(XTI_REC),SEEK_SET);
            readed = fread(xti_buf,sizeof(XTI_REC),XTI_SIZE,Fxti);
            xti_start = num;
            xti_end = xti_start+readed-1;
            if (readed == 0) break;
        }

        if ((xti_buf[num-xti_start].flags & XTI_HAS_READ) == 0) unread++;
        num++;
    }

    return unread;
}

char offline_packet::open_area(char *area)
{
    unsigned num;

    num = getarea(area);
    if (curarea == num) return 1;

    idxstart = 65535;
    idxend = 0;

    if (num > 0)
    {
        curarea = num;
        msgptr = mix_buf[num-mix_start].msghptr;
        if (fmt == format_bw) msgptr /= sizeof(FTI_REC);
        return 1;
    }
    return 0;
}

char offline_packet::read_msg(unsigned /*msgnum*/ )
{
    if (opt.rflags & STRIP_RE)
    {
        /* Remove 'RE:' */
        if (strnicmp(msg.subj,"RE:",3) == 0)
        {
            if (msg.subj[3] == ' ')
            {
                memmove(msg.subj,msg.subj+4,strlen(msg.subj)-3);
            }
            else
            {
                memmove(msg.subj,msg.subj+3,strlen(msg.subj)-2);
            }
        }
    }

    msgid_kludge[0] = '\0';
    return 1;
}

void offline_packet::write_msg(unsigned )
{
}

void offline_packet::delete_msg(unsigned )
{
}

long offline_packet::read_num(unsigned /*msgnum*/ )
{
    return 0;
}

char *offline_packet::read_from(unsigned /*msgnum*/ )
{
    return 0;
}

char *offline_packet::read_to(unsigned /*msgnum*/ )
{
    return 0;
}

char *offline_packet::read_subj(unsigned /*msgnum*/ )
{
    if (opt.rflags & STRIP_RE)
    {
        /* Remove 'RE:' */
        if (strnicmp(msg.subj,"RE:",3) == 0)
        {
            if (msg.subj[3] == ' ')
            {
                memmove(msg.subj,msg.subj+4,strlen(msg.subj)-3);
            }
            else
            {
                memmove(msg.subj,msg.subj+3,strlen(msg.subj)-2);
            }
        }
    }

    return msg.subj;
}

static int soup_firstlen;
int reply_email;
char reply_email_addr[100];

char *get_email_addr(char *orig, char *dest)
{
    char *strp;
    int n;

    strp = strchr(orig, '<');
    if (strp != NULL)
    {
        /* user name <email@addr> */
        orig = strp+1;
        strcpy(dest, orig);
        strp = strchr(dest, '>');
        if (strp != NULL) *strp = '\0';
        return dest;
    }

    strp = strchr(orig, '(');
    if (strp == NULL)
    {
        strcpy(dest, orig);
        return dest;
    }
    while (*(strp-1) == ' ') strp--;
    n = (int) (strp-orig);
    strncpy(dest, orig, n); dest[n] = '\0';

    return dest;
}

char offline_packet::init_text(void)
{
    unsigned long last_line,totalread;
    size_t readed;

    unsigned pos,ptr_pos,num;

    char buf[256],tmp[11],*strp,mtype, *save_line, *saveto, **savein;
    int spos,origin,seenby,reformat,no_quote,start,soup_first,soup_header;
    unsigned chars,tens;

    LINE_REC *linep;

    /* If old reply is still in memory, delete it */
    if (first_linerec != NULL) deinit_msgtext();

    txt_lines = 0; last_line = 0; tens = 0; chars = 0; spos = 0; seenby = 0;
    chrs_kludge[0] = '\0'; fmpt = '\0'; intl_kludge[0] = '\0'; origin_line[0] = '\0';

    /* Init first line */
    linerec = (LINE_REC *) malloc(sizeof(LINE_REC));
    linerec->prev = NULL;
    linerec->next = NULL;
    linerec->line_type = fmt == format_soup ? LINE_TYPE_KLUDGE : LINE_TYPE_NORMAL;
    linerec->ptr = msgtxtptr;
    if (fmt == format_bw) linerec->ptr++;
    linerec->len = 0;

    if (references != NULL) { free(references); references = NULL; }
    if (message_id != NULL) { free(message_id); message_id = NULL; }
    if (newsgroups != NULL) { free(newsgroups); newsgroups = NULL; }

    first_linerec = linerec;

    if (fmt == format_soup)
    {
        mtype = *(get_area_tag(curarea)+20);
        soup_first = mtype == 'u' || mtype == 'm';
        soup_header = 1;
    }
    else
    {
        mtype = 0; soup_first = 0;
        soup_header = 0;
    }

    save_line = (char *) malloc(10000); saveto = NULL; savein = NULL;

    totalread = 0; readed = 0; soup_firstlen = 0; reply_email = 0;
    start = 1; origin = 0; seenby = 0; reformat = (setup.justify != JUSTIFY_NONE) && !soup_header; no_quote = 0;
    while (totalread+readed+1 < msgtxtsize)
    {
        totalread += readed;

        /* How much to read? */
        if (msgtxtsize+(fmt == format_soup ? 80:0)-totalread < BUF_SIZE)
            readed = msgtxtsize+(fmt == format_soup ? 80:0)-totalread;
        else
            readed = BUF_SIZE;

        if ((dat_start > msgtxtptr+totalread) || (dat_end < msgtxtptr+readed-1+totalread))
        {
            /* Read text from file */
            fseek(Fdat,msgtxtptr+totalread,SEEK_SET);
            dat_start = ftell(Fdat);
            readed = fread(txt_buf,1,readed,Fdat);
            dat_end = dat_start+readed-1;
        }
        else
        {
            /* Text already in memory */
            readed = dat_end-msgtxtptr+1-totalread;
        }

        if (fmt != format_soup && readed >= msgtxtsize-totalread) readed = msgtxtsize-totalread;

        if (totalread == 0 && fmt == format_bw)
        {
            /* Strip first ' ' character from Blue Wave messages */
            if (txt_buf[msgtxtptr-dat_start] != ' ') return 0;
            pos = msgtxtptr-dat_start+1;
            ptr_pos = 0;
        }
        else
        {
            pos = msgtxtptr+totalread-dat_start;
            ptr_pos = (unsigned) -1;
        }

        for (; pos<readed+(msgtxtptr+totalread-dat_start); pos++)
        {
            if (fmt == format_soup && pos >= msgtxtsize-totalread+soup_firstlen) break;

            ptr_pos++;
            switch (txt_buf[pos])
            {
                case 10:
                    if (fmt == format_soup)
                    {
                        if (soup_first)
                        {
                            /* Skip first line */
                            soup_firstlen = chars+tens+1;
                            linerec->ptr = msgtxtptr+totalread+ptr_pos+1;
                            chars = 0; tens = 0; spos = 0; start = 1; soup_first = 0;
                            break;
                        }
                        goto __cr;
                    }
                __lf:
                    /* Do nothing to LFs */
                    tens++;
                    break;
                case 227:
                    /* "CR" with QWK format */
                    if (fmt != format_qwk) goto __write_chr;
                case 13:
                    if (fmt == format_soup) goto __lf;
                __cr:
                    /* CR found */
                    if (saveto != NULL)
                    {
                        *saveto = '\0';
                        saveto = NULL;
                        *savein = (char *) malloc(strlen(save_line)+1);
                        strcpy(*savein, save_line);
                    }

                    /* Check kludges and spaces and CR */
                    if (reformat && spos > 0)
                    {
                        /* Copy next 10 characters to 'tmp' */
                        if (pos+13 < BUF_SIZE)
                        {
                            /* They're in memory, great. */
                            if (txt_buf[pos+1] == 10)
                                memcpy(tmp,txt_buf+pos+2,10);
                            else
                                memcpy(tmp,txt_buf+pos+1,10);
                            tmp[10] = '\0';
                        }
                        else
                        {
                            /* Gotta read them from file. */
                            fseek(Fdat,msgtxtptr+totalread+pos+1,SEEK_SET);
                            if (fread(tmp,1,1,Fdat) == 0)
                            {
                                tmp[0] = '\0';
                            }
                            else
                            {
                                if (tmp[0] == 10)
                                    tmp[fread(tmp,1,11,Fdat)] = '\0';
                                else
                                    tmp[fread(tmp+1,1,10,Fdat)+1] = '\0';
                            }
                            num = totalread+pos+1;
                            if (num >= msgtxtsize)
                            {
                                /* It's next message text in here already.. */
                                tmp[0] = '\0';
                            }
                            else if (num+10 > msgtxtsize)
                            {
                                tmp[msgtxtsize-num] = '\0';
                            }
                        }

                        if (tmp[0] != 1 && tmp[0] != ' ' && (tmp[0] != 13 || (fmt == format_soup && tmp[0] != 10)) && ((unsigned char) tmp[0] != 227 || fmt != format_qwk))
                        {
                            /* Check quoting */
                            for (num=0; num<QUOTE_MAX && tmp[num] != '\0'; num++)
                            {
                                if ((tmp[num] == '"') || (tmp[num] == '\'') || (tmp[num] == '<')) break;
                                if (tmp[num] == '>' || (num == 0 && tmp[num] == ':' && tmp[num+1] != ')' && tmp[num+1] != '(' && tmp[num+1] != '-'))
                                {
                                    num = 0;
                                    break;
                                }
                            }

                            if (num)
                            {
                                /* Origin, tagline, etc. */
                                if ((strncmp(tmp," * Origin:",10)) && (strncmp(tmp,"--- ",4)) && (strncmp(tmp,"... ",4)) && (strncmp(tmp,"~~~",3)) && (strncmp(tmp,"\xff@SUBJECT:",10)))
                                {
                                    if ((!origin) || (strncmp(tmp,"SEEN-BY:",8)))
                                    {
                                        buf[spos] = ' ';
                                        chars++; spos++;
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    if (chars == 0) soup_header = 0; /* Empty line terminates SOUP header */
                    reformat = (setup.justify != JUSTIFY_NONE) && !soup_header;
                    no_quote = 0;

                    /* Remove trailing spaces */
                    while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;
                    buf[spos] = '\0';

                    if (spos == 3 && start && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
                    {
                        /* Update line type */
                        linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }

                    if (linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                    {
                        /* Not a kludge, or displaying kludges is set on, */
                        /* so add line to linked list */

                        if (chars > 0) last_line = txt_lines;
                        txt_lines++;

                        /* Allocate memory for new line */
                        linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                        /* Set last line length and pointer to next line */
                        linerec->len = (char) (chars+tens);
                        linerec->next = linep;

                        if (linep == NULL) goto __end; /* Out of memory! */

                        linep->prev = linerec;
                        linep->next = NULL;
                        linep->len = 0;
                        linerec = linep;
                    }

                    if (origin && start && strncmp(buf," * Origin:",10) == 0)
                    {
                        /* This was origin line, save it for later use */
                        strcpy(origin_line, buf);
                    }

                    if (fmt == format_qwk && start && strncmp(buf, "\xff@SUBJECT:",10) == 0)
                    {
                        strncpy(msg.subj, buf+10, 60); msg.subj[60] = '\0';
                        spos = strlen(msg.subj);
                        while (msg.subj[spos-1] == ' ') spos--;
                        msg.subj[spos] = '\0';
                    }

                    if (start && strncmp(buf, "\x01REPLYADDR", 10) == 0)
                    {
                        reply_email = 1;
                        strcpy(reply_email_addr, buf+11);
                    }

                    if (!reply_email && start && (strncmp(buf, "From:", 5) == 0 && strchr(buf+5, '@') != NULL))
                    {
                        reply_email = 1;
                        get_email_addr(buf+6, reply_email_addr);
                    }

                    if (buf[0] == 1 && start)
                    {
                        /* Kludge */
                        if (strncmp(buf+1,"MSGID:",6) == 0)
                            strcpy(msgid_kludge,buf+8);
                        else if (strncmp(buf+1,"CHRS:",5) == 0)
                            strcpy(chrs_kludge,buf+7);
                        else if (strncmp(buf+1,"CHARSET:",8) == 0)
                            strcpy(chrs_kludge,buf+10);
                        else if (strncmp(buf+1,"INTL",4) == 0)
                            strcpy(intl_kludge,buf+6);
                        else if (strncmp(buf+1,"FMPT",4) == 0)
                            fmpt = atol(buf+6);
                    }

                    linerec->line_type = soup_header ? LINE_TYPE_KLUDGE : LINE_TYPE_NORMAL;
                    linerec->ptr = msgtxtptr+totalread+ptr_pos+1;
                    chars = 0; tens = 0; spos = 0; seenby = 0; start = 1;
                    break;
                case 141:
                    if ((opt.rflags & TREAT_I_NORMAL) == 0)
                    {
                        /* Soft-CR */
                        tens++;
                        break;
                    }
                default:
                __write_chr:
                    if (saveto != NULL) *saveto++ = txt_buf[pos];

                    /* Normal character */
                    if ((chars >= txt_length && reformat) || chars+1 >= scrwidth)
                    {
                        /* Too long line, split it */
                        if (txt_buf[pos] == ' ')
                        {
                            /* Great, we can split it right here! */
                            spos = 0;

                            if (linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                            {
                                /* Remove trailing spaces */
                                while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;

                                if (chars > 0) last_line = txt_lines;
                                txt_lines++;

                                /* Allocate memory for new line */
                                linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                                /* Set last line length and pointer to next line */
                                linerec->len = (char) (chars+tens);
                                linerec->next = linep;

                                if (linep == NULL) goto __end; /* Out of memory! */

                                linep->prev = linerec;
                                linep->next = NULL;
                                linep->line_type = linerec->line_type == LINE_TYPE_SPECIAL ? LINE_TYPE_NORMAL : linerec->line_type;
                                linep->len = 0;
                                linerec = linep;
                            }

                            linerec->ptr = msgtxtptr+totalread+ptr_pos+1;
                            chars = 0; tens = 0; start = 0;
                            continue;
                        }

                        /* Search split position */
                        num = spos-1;
                        while (num > 0 && buf[num] != ' ') num--;

                        if (num > 0)
                        {
                            /* Found split character */
                            chars = num;

                            if (linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                            {
                                /* Remove trailing spaces */
                                while (chars > 0 && buf[chars-1] == ' ') chars--;

                                if (chars > 0) last_line = txt_lines;
                                txt_lines++;

                                /* Allocate memory for new line */
                                linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                                /* Set last line length and pointer to next line */
                                linerec->next = linep;
                                linerec->len = (char) (chars+tens);

                                if (linep == NULL) goto __end; /* Out of memory! */

                                linep->prev = linerec;
                                linep->next = NULL;
                                linep->line_type = linerec->line_type == LINE_TYPE_SPECIAL ? LINE_TYPE_NORMAL : linerec->line_type;
                                linep->len = 0;
                                linerec = linep;
                            }

                            linerec->ptr = msgtxtptr+totalread+ptr_pos+2-(spos-num+1);
                            chars = 0; tens = 0; start = 0;

                            memmove(buf,buf+num+1,spos-num); spos -= num+1;
                            chars = spos;
                        }
                        else
                        {
                            /* Couldn't find split pos so just split somewhere */
                            spos = 0;

                            if (linerec->line_type != LINE_TYPE_KLUDGE || show_kludges)
                            {
                                /* Remove trailing spaces */
                                while (chars > 0 && buf[chars-1] == ' ') chars--;

                                if (chars>0) last_line = txt_lines;
                                txt_lines++;

                                /* Allocate memory for new line */
                                linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                                /* Set last line length and pointer to next line */
                                linerec->next = linep;
                                linerec->len = (char) (chars+tens);

                                if (linep == NULL) goto __end; /* Out of memory! */

                                linep->prev = linerec;
                                linep->next = NULL;
                                linep->line_type = linerec->line_type == LINE_TYPE_SPECIAL ? LINE_TYPE_NORMAL : linerec->line_type;
                                linep->len = 0;
                                linerec = linep;
                            }

                            linerec->ptr = msgtxtptr+totalread+ptr_pos;
                            chars = 0; tens = 0; start = 0;
                        }
                    }

                    /* Add to buffer */
                    buf[spos++] = txt_buf[pos];
                    chars++;

                    /* Check if line should be saved */
                    if (fmt == format_soup && spos == 12 && start && soup_header && saveto == NULL)
                    {
                        if (strncmp(buf,"Newsgroups: ", 12) == 0)
                        {
                            savein = &newsgroups; saveto = save_line;
                        }
                        else if (strncmp(buf,"Message-ID: ", 12) == 0)
                        {
                            savein = &message_id; saveto = save_line;
                        }
                        else if (strncmp(buf,"References: ", 12) == 0)
                        {
                            savein = &references; saveto = save_line;
                        }
                    }

                    if (linerec->line_type != LINE_TYPE_NORMAL && linerec->line_type != LINE_TYPE_SPECIAL) break;

                    if (spos == 8 && start)
                    {
                        /* Check if this is a SEEN-BY line */
                        if (origin)
                        {
                            seenby = strncmp(buf,"SEEN-BY:",8) == 0;
                            if (seenby) linerec->line_type = LINE_TYPE_KLUDGE;
                            reformat = 0;
                        }
                    }

                    /* Check QWK long subject */
                    if (spos == 10 && start && fmt == format_qwk && strncmp(buf,"\xff@SUBJECT:", 10) == 0)
                    {
                        linerec->line_type = LINE_TYPE_KLUDGE;
                        reformat = 0;
                    }

                    /* Check origin */
                    if (spos == 10 && start && strncmp(buf," * Origin:",10) == 0)
                    {
                        linerec->line_type = LINE_TYPE_ORIGIN;
                        origin = 1;
                        reformat = 0;
                    }

                    if (spos == 1 && start && (txt_buf[pos] == 1 || txt_buf[pos] == ' '))
                    {
                        /* Line starts with space or is a kludge, don't
                         reformat this line */
                        reformat = 0;
                        if (txt_buf[pos] == 1) linerec->line_type = LINE_TYPE_KLUDGE;
                    }
                    if (spos == 4 && start && (strncmp(buf,"--- ",4) == 0 || strncmp(buf,"... ",4) == 0 || strncmp(buf,"~~~ ",4) == 0))
                    {
                        /* Tear or tag, don't reformat this line */
                        reformat = 0;
                        linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }
                    if (txt_buf[pos] == '_' || txt_buf[pos] == '*')
                    {
                        linerec->line_type = LINE_TYPE_SPECIAL;
                    }
                    if (spos < QUOTE_MAX && !no_quote && start)
                    {
                        if (txt_buf[pos] == '"' || txt_buf[pos] == '\'' || txt_buf[pos] == '<') no_quote = 1;
                        if (txt_buf[pos] == '>' || (spos == 1 && txt_buf[pos] == ':' && txt_buf[pos+1] != ')' && txt_buf[pos+1] != '(' && txt_buf[pos+1] != '-'))
                        {
                            /* Quoted line, don't reformat */
                            reformat = 0;
                            linerec->line_type = LINE_TYPE_QUOTE;
                        }
                    }
                    break;
            }
        }
    }
    free(save_line);

    /* Remove trailing spaces */
    while (chars > 0 && buf[chars-1] == ' ') chars--;

    if ((buf[0] != 1 && !seenby) || show_kludges || !start)
    {
        /* OK to display this line. */
        if (chars > 0) last_line = txt_lines;
        linerec->len = (char) (chars+tens);
        txt_lines++;
    }

    if (spos == 3 && start && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
    {
        /* Update line type */
        linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
    }

    if (buf[0] == 1 && start)
    {
        /* Kludge, save it */
        buf[spos] = '\0';
        if (strncmp(buf+1,"MSGID:",6) == 0)
            strcpy(msgid_kludge,buf+8);
        else if (strncmp(buf+1,"CHRS:",5) == 0)
            strcpy(chrs_kludge,buf+7);
        else if (strncmp(buf+1,"CHARSET:",8) == 0)
            strcpy(chrs_kludge,buf+10);
        else if (strncmp(buf+1,"INTL",4) == 0)
            strcpy(intl_kludge,buf+6);
        else if (strncmp(buf+1,"FMPT",4) == 0)
            fmpt = atol(buf+6);
    }

    /* Cut CHARSET-kludge from first space */
    strp = strchr(chrs_kludge,' ');
    if (strp != NULL) *strp = '\0';
__end:
    txt_lines = last_line+1;

    linerec = first_linerec;
    current_line = 1;
    return 1;
}

void offline_packet::deinit_msgtext(void)
{
    while (first_linerec != NULL)
    {
        linerec = first_linerec->next;
        free(first_linerec);
        first_linerec = linerec;
    }
}

char *offline_packet::read_line(char *str, unsigned line)
{
    int nro,slen;
    long maxsize;

    /* Go to right position */
    while (line < current_line)
    {
        if (linerec->prev == NULL)
        {
            str[0] = '\0';
            return str;
        }
        linerec = linerec->prev;
        current_line--;
    }

    while (line > current_line)
    {
        if (linerec->next == NULL)
        {
            str[0] = '\0';
            return str;
        }
        linerec = linerec->next;
        current_line++;
    }

    if (str == NULL) return NULL;

    /* Read from file */
    if ((dat_start > linerec->ptr) || (dat_end < linerec->ptr+linerec->len))
    {
        fseek(Fdat,linerec->ptr,SEEK_SET);
        dat_start = linerec->ptr;
        if (BUF_SIZE > msgtxtsize+soup_firstlen)
            maxsize = msgtxtsize+soup_firstlen;
        else
            maxsize = BUF_SIZE;
        dat_end = dat_start+fread(txt_buf,1,maxsize,Fdat)-1;
    }
    memcpy(str,txt_buf+linerec->ptr-dat_start,linerec->len);
    str[linerec->len] = '\0';

    nro = 0;
    slen = linerec->len;

    /* Remove LFs, change CRs to spaces */
    while (nro < slen)
    {
        switch ((unsigned char) str[nro])
        {
            case 227:
                if (fmt != format_qwk) break;
            case 13:
            __cr:
                str[nro] = ' ';
                break;
            case 141:
                if (opt.rflags & TREAT_I_NORMAL) break;
            case 10:
                if (fmt == format_soup) goto __cr;
                memmove(str+nro,str+nro+1,slen-nro-1);
                slen--;
                nro--;
                break;
        }
        nro++;
    }

    /* Remove trailing spaces */
    while (slen > 0 && str[slen-1] == ' ') slen--;
    str[slen] = '\0';

    /* Rot13 convertion */
    if (rot13)
    {
        nro = 1;
        if (str[0] == 1)
            nro = 0;
        else if ((slen > 4) && (strncmp(str,"--- ",4) == 0))
            nro = 0;
        else if ((slen >= 10) && (strncmp(str," * Origin:",10) == 0))
            nro = 0;

        if (nro)
        {
            nro = 0;
            while (nro < slen)
            {
                if ((str[nro] >= 'A') && (str[nro] <= 'Z'))
                {
                    if (str[nro] >= 'A'+13) str[nro] -= 13; else str[nro] += 13;
                }
                else
                {
                    if ((str[nro] >= 'a') && (str[nro] <= 'z'))
                    {
                        if (str[nro] >= 'a'+13) str[nro] -= 13; else str[nro] += 13;
                    }
                }
                nro++;
            }
        }
    }

    return str;
}

void offline_packet::area_flags(unsigned num, XTI_REC *xti)
{
    size_t readed;

    if ((xti_start>msgptr+num) || (xti_end<msgptr+num))
    {
        fseek(Fxti,(msgptr+num-1)*sizeof(XTI_REC),SEEK_SET);
        readed = fread(xti_buf,sizeof(XTI_REC),XTI_SIZE,Fxti);
        xti_start = msgptr+num;
        xti_end = xti_start+readed-1;
        if (readed == 0)
        {
            memset(xti,0,sizeof(XTI_REC));
            return;
        }
    }
    memcpy(xti,&xti_buf[msgptr+num-xti_start],sizeof(XTI_REC));
}

extern int packet_modified;

void offline_packet::save_area_flags(unsigned num, XTI_REC *xti)
{
    if (!((xti_start>msgptr+num) || (xti_end<msgptr+num)))
      memcpy(&xti_buf[msgptr+num-xti_start],xti,sizeof(XTI_REC));

    fseek(Fxti,(msgptr+num-1)*sizeof(XTI_REC),SEEK_SET);
    fwrite(xti,sizeof(XTI_REC),1,Fxti);

    packet_modified = 1;
}

void offline_packet::update_area_flags(void)
{
    fclose(Fxti);
    Fxti = FileOpen(xti_path,"r+b");
    //setbuf(Fxti,NULL);
}

void offline_packet::delete_xti(unsigned num)
{
    unsigned long fsize;

    fseek(Fxti, 0, SEEK_END); fsize = ftell(Fxti);
    delete_space(Fxti, (msgptr+num-1)*sizeof(XTI_REC), sizeof(XTI_REC), fsize);
    ftrunc(Fxti, fsize-sizeof(XTI_REC));

    xti_start = 65535; xti_end = 0;
}

void offline_packet::open_replypacket(void)
{
}

void offline_packet::close_replypacket(void)
{
}

char offline_packet::read_reply(unsigned num)
{
    struct tm *tim;

    fseek(Fupl,sizeof(UPL_HEADER)+(num-1)*sizeof(UPL_REC),SEEK_SET);
    fread(&uplrec,sizeof(UPL_REC),1,Fupl);

    strcpy(reply.mfrom,(char *) uplrec.from);
    if (uplrec.network_type == INF_NET_INTERNET)
        strcpy(reply.mto,(char *) uplrec.net_dest);
    else
        strcpy(reply.mto,(char *) uplrec.to);
    strcpy(reply.subj,(char *) uplrec.subj);
    if (uplrec.unix_date == 0)
    {
        strcpy(reply.date,"<unknown>");
    }
    else
    {
        tim = localtime((time_t *) &uplrec.unix_date);
        sprintf(reply.date,"%02d %s %02d %02d:%02d:%02d",
                tim->tm_mday,month[tim->tm_mon],tim->tm_year%100,
                tim->tm_hour,tim->tm_min,tim->tm_sec);
    }

    reply.replyto = uplrec.replyto;
    reply.destzone = uplrec.destzone;
    reply.destnet = uplrec.destnet;
    reply.destnode = uplrec.destnode;
    reply.destpoint = uplrec.destpoint;

    strcpy(reply.area,(char *) uplrec.echotag);
    strcpy(reply.fname,(char *) uplrec.filename);

    reply.flags = 0;
    reply.netflags = 0;
    if (uplrec.msg_attr & UPL_INACTIVE) reply.flags |= flag_deleted;
    if (uplrec.msg_attr & UPL_PRIVATE) reply.flags |= flag_private;
    if (uplrec.msg_attr & UPL_NETMAIL)
    {
        reply.flags |= flag_netmail;
        if (uplrec.netmail_attr & UPL_NETCRASH) reply.netflags |= NET_CRASH;
        if (uplrec.netmail_attr & UPL_NETDIRECT) reply.netflags |= NET_DIRECT;
        if (uplrec.netmail_attr & UPL_NETIMMEDIATE) reply.netflags |= NET_IMMEDIATE;
        if (uplrec.netmail_attr & UPL_NETHOLD) reply.netflags |= NET_HOLD;
        if (uplrec.netmail_attr & UPL_NETKILL) reply.netflags |= NET_KILLSENT;
        if (uplrec.netmail_attr & UPL_NETFILE) reply.netflags |= NET_FATTACH;
        if (uplrec.netmail_attr & UPL_NETFRQ) reply.netflags |= NET_FREQ;
    }

    dat_start = 1; dat_end = 0;
    return 1;
}

char offline_packet::init_replytext(char *fname)
{
    unsigned long last_line,totalread;
    size_t readed;

    unsigned pos,ptr_pos,num;

    char buf[256];
    int spos,no_quote;
    unsigned chars,tens;

    LINE_REC *linep;

    /* If old reply is still in memory, delete it */
    if (first_linerec != NULL) deinit_replytext();

    /* Open reply file */
    Freply = FileOpen(fname,"rb");
    if (Freply == NULL)
    {
        /* Didn't find it. */
        replyopen = 0; txt_lines = 0;
        return 0;
    }
    replyopen = 1;
    dat_start = 1; dat_end = 0;

    /* Get size of reply */
    fseek(Freply,0,SEEK_END);
    msgtxtsize = ftell(Freply);
    fseek(Freply,0,SEEK_SET);

    txt_lines = 0; last_line = 0; tens = 0; chars = 0; spos = 0; no_quote = 0;

    /* Init first line */
    linerec = (LINE_REC *) malloc(sizeof(LINE_REC));
    linerec->prev = NULL;
    linerec->next = NULL;
    linerec->line_type = LINE_TYPE_NORMAL;
    linerec->ptr = 0;
    linerec->len = 0;

    first_linerec = linerec;

    totalread = 0; readed = 0;
    while (totalread+readed+1 < msgtxtsize)
    {
        totalread += readed;

        /* How much to read? */
        if (msgtxtsize-totalread < BUF_SIZE)
            readed = msgtxtsize-totalread;
        else
            readed = BUF_SIZE;

        if (dat_start > totalread || dat_end < readed-1+totalread)
        {
            /* Read text from file */
            fseek(Freply,totalread,SEEK_SET);
            dat_start = ftell(Freply);
            readed = fread(txt_buf,1,readed,Freply);
            dat_end = dat_start+readed-1;
        }
        else
        {
            /* Text already in memory */
            readed = dat_end+1-totalread;
            //readed = dat_end-1-totalread;
        }

        if (readed >= msgtxtsize-totalread) readed = msgtxtsize-totalread;

        pos = totalread-dat_start;
        ptr_pos = (unsigned) -1;

        for (; pos<readed+totalread-dat_start; pos++)
        {
            ptr_pos++;
            switch (txt_buf[pos])
            {
                case 10:
                    if (fmt == format_soup) goto __cr;
                    /* Do nothing to LFs */
                    tens++;
                    break;
                case 227:
                    /* "CR" with QWK format */
                    if (fmt != format_qwk) goto __write_chr;
                case 13:
                __cr:
                    /* CR found */

                    no_quote = 0;

                    /* Remove trailing spaces */
                    while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;
                    buf[spos] = '\0';

                    if (spos == 3 && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
                    {
                        /* Update line type */
                        linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }

                    if (buf[0] != 1 || show_kludges)
                    {
                        /* Not a kludge, or displaying kludges is set on, */
                        /* so add line to linked list */

                        if (chars > 0) last_line = txt_lines;
                        txt_lines++;

                        /* Allocate memory for new line */
                        linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                        /* Set last line length and pointer to next line */
                        linerec->len = (char) (chars+tens);
                        linerec->next = linep;

                        if (linep == NULL) goto __end; /* Out of memory! */

                        linep->prev = linerec;
                        linep->next = NULL;
                        linep->len = 0;
                        linerec = linep;
                    }

                    linerec->line_type = LINE_TYPE_NORMAL;
                    linerec->ptr = totalread+ptr_pos+1;
                    chars = 0; tens = 0; spos = 0;
                    break;
                case 141:
                    if ((opt.rflags & TREAT_I_NORMAL) == 0)
                    {
                        /* Soft-CR */
                        tens++;
                        break;
                    }
                default:
                __write_chr:
                    /* Normal character */
                    if (chars+1 >= scrwidth)
                    {
                        /* Too long line, split it */
                        if (txt_buf[pos] == ' ')
                        {
                            /* Great, we can split it right here! */
                            spos = 0;

                            /* Remove trailing spaces */
                            while (chars > 0 && (buf[chars-1] == ' ' || buf[chars-1] == 0)) chars--;

                            if (chars > 0) last_line = txt_lines;
                            txt_lines++;

                            /* Allocate memory for new line */
                            linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                            /* Set last line length and pointer to next line */
                            linerec->len = (char) (chars+tens);
                            linerec->next = linep;

                            if (linep == NULL) goto __end; /* Out of memory! */

                            linep->prev = linerec;
                            linep->next = NULL;
                            linep->line_type = LINE_TYPE_NORMAL;
                            linep->len = 0;
                            linerec = linep;

                            linerec->ptr = totalread+ptr_pos+1;
                            chars = 0; tens = 0;
                            continue;
                        }

                        /* Search split position */
                        num = spos-1;
                        while (num > 0 && buf[num] != ' ') num--;

                        if (num > 0)
                        {
                            /* Found split character */
                            chars = num;

                            /* Remove trailing spaces */
                            while (chars > 0 && buf[chars-1] == ' ') chars--;

                            if (chars > 0) last_line = txt_lines;
                            txt_lines++;

                            /* Allocate memory for new line */
                            linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                            /* Set last line length and pointer to next line */
                            linerec->next = linep;
                            linerec->len = (char) (chars+tens);

                            if (linep == NULL) goto __end; /* Out of memory! */

                            linep->prev = linerec;
                            linep->next = NULL;
                            linep->line_type = LINE_TYPE_NORMAL;
                            linep->len = 0;
                            linerec = linep;

                            linerec->ptr = totalread+ptr_pos+2-(spos-num+1);
                            chars = 0; tens = 0;

                            memmove(buf,buf+num+1,spos-num); spos -= num+1;
                            chars = spos;
                        }
                        else
                        {
                            /* Couldn't find split pos so just split somewhere */
                            spos = 0;

                            /* Remove trailing spaces */
                            while (chars > 0 && buf[chars-1] == ' ') chars--;

                            if (chars>0) last_line = txt_lines;
                            txt_lines++;

                            /* Allocate memory for new line */
                            linep = (LINE_REC *) malloc(sizeof(LINE_REC));

                            /* Set last line length and pointer to next line */
                            linerec->next = linep;
                            linerec->len = (char) (chars+tens);

                            if (linep == NULL) goto __end; /* Out of memory! */

                            linep->prev = linerec;
                            linep->next = NULL;
                            linep->line_type = LINE_TYPE_NORMAL;
                            linep->len = 0;
                            linerec = linep;

                            linerec->ptr = totalread+ptr_pos;
                            chars = 0; tens = 0;
                        }
                    }

                    /* Add to buffer */
                    buf[spos++] = txt_buf[pos];
                    chars++;

                    if (linerec->line_type != LINE_TYPE_NORMAL && linerec->line_type != LINE_TYPE_SPECIAL) break;

                    if (spos == 1 && txt_buf[pos] == 1)
                    {
                        /* Kludge line */
                        linerec->line_type = LINE_TYPE_KLUDGE;
                    }
                    if (spos == 4 && (strncmp(buf,"--- ",4) == 0 || strncmp(buf,"... ",4) == 0 || strncmp(buf,"~~~ ",4) == 0))
                    {
                        /* Tear or tag */
                        linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
                    }
                    if (txt_buf[pos] == '_' || txt_buf[pos] == '*')
                    {
                        linerec->line_type = LINE_TYPE_SPECIAL;
                    }
                    if (spos < QUOTE_MAX && !no_quote)
                    {
                        if (txt_buf[pos] == '"' || txt_buf[pos] == '\'' || txt_buf[pos] == '<') no_quote = 1;
                        if (txt_buf[pos] == '>' || (spos == 1 && txt_buf[pos] == ':' && txt_buf[pos+1] != ')' && txt_buf[pos+1] != '(' && txt_buf[pos+1] != '-'))
                        {
                            /* Quoted line */
                            linerec->line_type = LINE_TYPE_QUOTE;
                        }
                    }
            }
        }
    }

    /* Remove trailing spaces */
    while (chars > 0 && buf[chars-1] == ' ') chars--;

    if (buf[0] != 1 || show_kludges)
    {
        /* OK to display this line. */
        if (chars > 0) last_line = txt_lines;
        linerec->len = (char) (chars+tens);
        txt_lines++;
    }

    if (spos == 3 && (strcmp(buf,"---") == 0 || strcmp(buf,"...") == 0 || strcmp(buf,"~~~") == 0))
    {
        /* Update line type */
        linerec->line_type = buf[0] == '.' ? LINE_TYPE_TAG : LINE_TYPE_TEAR;
    }

__end:
    txt_lines = last_line+1;

    linerec = first_linerec;
    current_line = 1;
    return 1;
}

char *offline_packet::read_replyline(char *str, unsigned line)
{
    int nro,slen;

    /* Go to right position */
    while (line < current_line)
    {
        if (linerec->prev == NULL)
        {
            str[0] = '\0';
            return str;
        }
        linerec = linerec->prev;
        current_line--;
    }

    while (line > current_line)
    {
        if (linerec->next == NULL)
        {
            str[0] = '\0';
            return str;
        }
        linerec = linerec->next;
        current_line++;
    }

    /* Read from file */
    if ((dat_start > linerec->ptr) || (dat_end < linerec->ptr+linerec->len))
    {
        fseek(Freply,linerec->ptr,SEEK_SET);
        dat_start = linerec->ptr;
        dat_end = dat_start+fread(txt_buf,1,BUF_SIZE,Freply)-1;
    }
    memcpy(str,txt_buf+linerec->ptr-dat_start,linerec->len);
    str[linerec->len] = '\0';

    nro = 0;
    slen = linerec->len;

    while (nro < slen)
    {
        switch ((unsigned char) str[nro])
        {
            case 13:
                str[nro] = 32;
                break;
            case 141:
                if (opt.rflags & TREAT_I_NORMAL) break;
            case 10:
                memmove(str+nro,str+nro+1,slen-nro-1);
                slen--;
                nro--;
                break;
        }
        nro++;
    }
    while ((slen > 0) && (str[slen-1] == 32)) slen--;
    str[slen] = '\0';

    if (rot13)
    {
        nro = 1;
        if (str[0] == 1)
            nro = 0;
        else if ((slen > 4) && (strncmp(str,"--- ",4) == 0))
            nro = 0;
        else if ((slen >= 10) && (strncmp(str," * Origin:",10) == 0))
            nro = 0;

        if (nro)
        {
            nro = 0;
            while (nro < slen)
            {
                if ((str[nro] >= 'A') && (str[nro] <= 'Z'))
                {
                    if (str[nro] >= 'A'+13) str[nro] -= 13; else str[nro] += 13;
                }
                else
                {
                    if ((str[nro] >= 'a') && (str[nro] <= 'z'))
                    {
                        if (str[nro] >= 'a'+13) str[nro] -= 13; else str[nro] += 13;
                    }
                }
                nro++;
            }
        }
    }

    return str;
}

void offline_packet::export_reply(unsigned /*num*/, char * /*name*/ )
{
}

void offline_packet::deinit_replytext(void)
{
    if (Freply != 0)
    {
        fclose(Freply);
        Freply = 0;
    }
    replyopen = 0;
    dat_start = 1; dat_end = 0;

    while (first_linerec != NULL)
    {
        linerec = first_linerec->next;
        free(first_linerec);
        first_linerec = linerec;
    }
}

unsigned offline_packet::area_type(unsigned area)
{
    int flags;
    unsigned aflags;

    read_inf_area(area);
    flags = 0;
    aflags = area_buf[area-area_start].area_flags;
    if (area_buf[area-area_start].network_type == INF_NET_INTERNET) flags = TYPE_INET;
    if (aflags & INF_ALIAS_NAME) flags |= TYPE_ALIAS;
    if (aflags & INF_ANY_NAME) flags |= TYPE_ANYNAME;
    if (aflags & INF_ECHO) flags |= TYPE_ECHO;
    if (aflags & INF_NETMAIL) flags |= TYPE_NET;
    if (aflags & INF_NO_PRIVATE) flags |= TYPE_NOPVT;
    if (aflags & INF_NO_PUBLIC) flags |= TYPE_NOPUB;
    if ((aflags & INF_POST) == 0) flags |= TYPE_NORIGHTS;
    if (aflags & INF_NO_TAGLINE) flags |= TYPE_NOTAGS;
    return flags;
}

void offline_packet::enter_msg(void)
{
    unsigned reparea;
    char tmp[256];

    reparea = gettag(reply.area);
    read_inf_area(reparea);

    memset(&uplrec,0,sizeof(UPL_REC));
    strcpy((char *) uplrec.from,reply.mfrom);
    if (reply.flags & flag_email || fmt == format_soup)
        strcpy((char *) uplrec.net_dest,reply.mto);
    else
        strcpy((char *) uplrec.to,reply.mto);
    strcpy((char *) uplrec.subj,reply.subj);

    uplrec.destzone = reply.destzone;
    uplrec.destnet = reply.destnet;
    uplrec.destnode = reply.destnode;
    uplrec.destpoint = reply.destpoint;

    uplrec.msg_attr = 0;
    if (reply.flags & flag_private) uplrec.msg_attr |= UPL_PRIVATE;
    if (reply.flags & flag_email) uplrec.msg_attr |= UPL_NETMAIL;
    if (reply.flags & flag_netmail)
    {
        uplrec.msg_attr |= UPL_NETMAIL;
        if (reply.netflags & NET_CRASH) uplrec.netmail_attr |= UPL_NETCRASH;
        if (reply.netflags & NET_DIRECT) uplrec.netmail_attr |= UPL_NETDIRECT;
        if (reply.netflags & NET_IMMEDIATE) uplrec.netmail_attr |= UPL_NETIMMEDIATE;
        if (reply.netflags & NET_HOLD) uplrec.netmail_attr |= UPL_NETHOLD;
        if (reply.netflags & NET_KILLSENT) uplrec.netmail_attr |= UPL_NETKILL;
        if (reply.netflags & NET_FATTACH) uplrec.netmail_attr |= UPL_NETFILE;
        if (reply.netflags & NET_FREQ) uplrec.netmail_attr |= UPL_NETFRQ;
    }
    if (fmt == format_omen)
    {
        if (reply.flags & flag_omen_del)
            uplrec.user_area[0] = 1;
        else if (reply.flags & flag_omen_tog)
            uplrec.user_area[0] = 2;
        else if (reply.flags & flag_omen_move)
        {
            uplrec.user_area[0] = 3;
            strcpy((char *) uplrec.net_dest, reply.fname);
            reply.fname[0] = '\0';
        }
    }

    uplrec.unix_date = time(NULL);

    if (uplrec.replyto) uplrec.msg_attr |= UPL_IS_REPLY;
    uplrec.replyto = reply.replyto;
    if ((reply.replyto > 0) && (msgid_kludge[0] != 0) && ((reply.flags & flag_email) == 0))
        strcat(strcpy((char *) uplrec.net_dest,"REPLY: "),msgid_kludge);
    strcpy((char *) uplrec.filename,reply.fname);
    strcpy((char *) uplrec.echotag,(char *) area_buf[reparea-area_start].echotag);
    uplrec.area_flags = area_buf[reparea-area_start].area_flags;
    uplrec.network_type = area_buf[reparea-area_start].network_type;

    fseek(Fupl,0,SEEK_END);
    if (fwrite(&uplrec,sizeof(UPL_REC),1,Fupl)) replies++;

    fclose(Fupl);
    if (fmt == format_omen)
        sprintf(tmp,"%sOMEN%s.upl",setup.replypath,omentag);
    else
        sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    Fupl = fopen_ign(tmp,"r+b");
}

void offline_packet::edit_msg(unsigned num)
{
    char tmp[256];
    unsigned reparea;

    reparea = gettag(reply.area);
    read_inf_area(reparea);

    memset(&uplrec,0,sizeof(UPL_REC));
    strcpy((char *) uplrec.from,reply.mfrom);
    if (reply.flags & flag_email || fmt == format_soup)
        strcpy((char *) uplrec.net_dest,reply.mto);
    else
        strcpy((char *) uplrec.to,reply.mto);
    strcpy((char *) uplrec.subj,reply.subj);

    uplrec.destzone = reply.destzone;
    uplrec.destnet = reply.destnet;
    uplrec.destnode = reply.destnode;
    uplrec.destpoint = reply.destpoint;
    
    uplrec.msg_attr = 0;
    if ((reply.flags & flag_private) > 0) uplrec.msg_attr |= UPL_PRIVATE;
    if (reply.flags & flag_netmail)
    {
        uplrec.msg_attr |= UPL_NETMAIL;
        if (reply.netflags & NET_CRASH) uplrec.netmail_attr |= UPL_NETCRASH;
        if (reply.netflags & NET_DIRECT) uplrec.netmail_attr |= UPL_NETDIRECT;
        if (reply.netflags & NET_IMMEDIATE) uplrec.netmail_attr |= UPL_NETIMMEDIATE;
        if (reply.netflags & NET_HOLD) uplrec.netmail_attr |= UPL_NETHOLD;
        if (reply.netflags & NET_KILLSENT) uplrec.netmail_attr |= UPL_NETKILL;
        if (reply.netflags & NET_FATTACH) uplrec.netmail_attr |= UPL_NETFILE;
        if (reply.netflags & NET_FREQ) uplrec.netmail_attr |= UPL_NETFRQ;
    }

    uplrec.unix_date = time(NULL);

    uplrec.replyto = reply.replyto;
    strcpy((char *) uplrec.filename,reply.fname);
    strcpy((char *) uplrec.echotag,(char *) area_buf[reparea-area_start].echotag);
    uplrec.area_flags = area_buf[reparea-area_start].area_flags;
    uplrec.network_type = area_buf[reparea-area_start].network_type;

    fseek(Fupl,sizeof(UPL_HEADER)+(num-1)*sizeof(UPL_REC),SEEK_SET);
    fwrite(&uplrec,sizeof(UPL_REC),1,Fupl);

    fclose(Fupl);
    if (fmt == format_omen)
        sprintf(tmp,"%somen%s.upl",setup.replypath,omentag);
    else
        sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    Fupl = fopen_ign(tmp,"r+b");
}

void offline_packet::toggle_deleted(unsigned msgnum, char deleted)
{
    fseek(Fupl,sizeof(UPL_HEADER)+(msgnum-1)*sizeof(UPL_REC),SEEK_SET);
    if (fread(&uplrec,sizeof(UPL_REC),1,Fupl) == 1) {
        if (deleted)
            uplrec.msg_attr |= UPL_INACTIVE;
        else
            uplrec.msg_attr &= ~UPL_INACTIVE;
        
        fseek(Fupl,sizeof(UPL_HEADER)+(msgnum-1)*sizeof(UPL_REC),SEEK_SET);
        fwrite(&uplrec,sizeof(UPL_REC),1,Fupl);
        fflush(Fupl);
    }
}

void offline_packet::delete_reply(unsigned msgnum)
{
    char tmp[256];
    fpos_t fsize;
    
    read_reply(msgnum);
    
    fseek(Fupl,0,SEEK_END);
    fgetpos(Fupl,&fsize);
    delete_space(Fupl,sizeof(UPL_HEADER)+(msgnum-1)*sizeof(UPL_REC),
                 sizeof(UPL_REC),fsize);
    ftrunc(Fupl,fsize-sizeof(UPL_REC));
    
    FileRemove(strcat(strcpy(tmp,setup.replypath),reply.fname));
    replies--;
}

char *offline_packet::export_msg(char * /*out*/ )
{
    return NULL;
}

void offline_packet::read_arealist(FILE * /*F*/ )
{
}

void offline_packet::write_arealist(FILE * /*F*/ )
{
}
