#ifdef __linux__
#  define PLOT '.'
#  define ASTERISK '*'
#  define PVT 'p'
#else
#  define PLOT 250
#  define ASTERISK 15
#  define PVT 158
#  define ACS_UARROW 24
#  define ACS_DARROW 25
#  define ACS_BLOCK 219
#  define ACS_BOARD 176
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "files.h"
#include "screen.h"
#include "vars.h"
#include "keyb.h"
#include "readsets.h"
#include "scrolbox.h"
#include "setup.h"
#include "general.h"
#include "readmail.h"
#include "readrepl.h"
#include "shell.h"
#include "bluewave.h"
#include "entermsg.h"
#include "scrsaver.h"
#include "showansi.h"
#include "addrbook.h"
#include "readfunc.h"
#include "pgp.h"

#define MAX_SPACES 2

#define key_lineup            1
#define key_linedown          2
#define key_pageup            3
#define key_pagedown          4
#define key_home              5
#define key_end               6
#define key_nextmsg           7
#define key_prevmsg           8
#define key_seealso           9
#define key_replyto           10
#define key_nextthread        11
#define key_prevthread        12
#define key_firstmsg          13
#define key_lastmsg           14
#define key_jumpmsg           15
#define key_quit              16
#define key_replymsg          17
#define key_replyanother      18
#define key_replynetmail      19
#define key_replyorig         20
#define key_replyoriganother  21
#define key_entermsg          22
#define key_enteranother      23
#define key_forwardmsg        24
#define key_intrans           25
#define key_outtrans          26
#define key_savemsg           27
#define key_titlescan         28
#define key_stealtag          29
#define key_stealedittag      30
#define key_extrainfo         31
#define key_ziptoreply        32
#define key_viewoutbound      33
#define key_ansimsg           34
#define key_addrbook          35
#define key_adoptaddr         36
#define key_markreply         37
#define key_marksave          38
#define key_markprint         39
#define key_markdel           40
#define key_flagread          41
#define key_flagreplied       42
#define key_flagsaved         43
#define key_flagprinted       44
#define key_dosshell          45
#define key_config            46
#define key_help              47
#define key_rot13             48
#define key_search            49
#define key_pgp_addring       50
#define key_justify           51
#define key_omen_delete       52
#define key_omen_pvtpub       53
#define key_omen_move         54
#define key_external_1        55
#define key_external_2        56
#define key_external_3        57
#define key_external_4        58
#define key_external_5        59
#define key_external_6        60
#define key_external_7        61
#define key_external_8        62
#define key_external_9        63

typedef int (*SORT_FUNC) (const void *, const void *);

typedef struct {
    char key1,key2;
    char cmd;
} KeyRec;

int area;

char replyanother;

unsigned ra_ypos,ra_upy;

unsigned *sortrec;
static unsigned msgs;

XTI_REC xti;

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != '\0')
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

static char *convstr(char *str)
{
    int num;
    char big;

    big = 1;

    num = 0;
    while (str[num] != 0)
    {
        if (!big)
        {
            if ((str[num] >= 'A') && (str[num] <= 'Z'))
                str[num] += 32;
            else
                if (str[num] == '') str[num] = ''; else
                    if (str[num] == '') str[num] = ''; else
                        if (str[num] == '') str[num] = '';
        }

        switch (str[num])
        {
            case ' ':
            case '-':
            case '_':
            case '.':
            case '\'':
            case ':':
            case ';':
            case ',':
                big = 1;
                break;
            default:
                big = 0;
        }
        num++;
    }
    return str;
}

void draw_line_ra(unsigned ypos, unsigned pos)
{
    XTI_REC xti;
    char col,ch;
    char tmp[81];
    unsigned len,subjlen,arealen;

    tbar(1,ypos,scrwidth,ypos,color[col_list_number]);

    if (pos > msgs) return;
    pos = sortrec[pos-1];

    if (area < 0)
    {
        subjlen = (scrwidth-15) / 2;
        if (subjlen*2 < scrwidth-15) subjlen++;

        arealen = subjlen/4;
        arealen += subjlen%4;
        len = (subjlen-arealen) / 2;

        fseek(Fpers,(pos-1)*sizeof(pers_rec),SEEK_SET);
        if (fread(&pers,sizeof(pers_rec),1,Fpers) == 0) return;

        pkt->open_area(pkt->get_area_number(pers.area));
        pkt->area_flags(pers.msgnum,&xti);

        memcpy(&msg,&pers.msg,sizeof(msgtype));
        strcpy(tmp,pkt->get_area_tag(pers.area));
        if (arealen < 80) tmp[arealen] = '\0';
        tran(tmp);
        if (xti.marks & XTI_MARK_DISABLED)
            cwritexy(3,ypos,tmp,color[col_list_disabled]);
        else
            cwritexy(3,ypos,tmp,color[col_list_number]);

        tran(msg.mfrom);
        if (xti.marks & XTI_MARK_DISABLED)
        {
            col = color[col_list_disabled];
        }
        else
        {
            col = color[col_list_from];
            if ((stricmp(msg.mfrom,pkt->username) == 0) || (stricmp(msg.mfrom,pkt->useralias) == 0))
                col = color[col_list_fromyou];
        }

        if (len < 35) msg.mfrom[len] = 0;
        if (fmt == format_qwk)
            cwritexy(4+arealen,ypos,convstr(msg.mfrom),col);
        else
            cwritexy(4+arealen,ypos,msg.mfrom,col);

        if (xti.marks & XTI_MARK_DISABLED)
            col = color[col_list_disabled];
        else {
            if (xti.flags & XTI_IS_PERSONAL)
                col = color[col_list_toyou];
            else
                col = color[col_list_to];
        }

        if (len < 35) msg.mto[len] = 0;
        if (fmt == format_qwk)
            cwritexy(5+arealen+len,ypos,convstr(tran(msg.mto)),col);
        else
            cwritexy(5+arealen+len,ypos,tran(msg.mto),col);

        if (subjlen < 71) msg.subj[subjlen] = 0;
        if (xti.marks & XTI_MARK_DISABLED)
            cwritexy(6+arealen+len*2,ypos,tran(msg.subj),color[col_list_disabled]);
        else
            cwritexy(6+arealen+len*2,ypos,tran(msg.subj),color[col_list_subj]);
    }
    else
    {
        subjlen = (scrwidth-22) / 2;
        if (subjlen*2 < scrwidth-22) subjlen++;
        len = subjlen/2;

        pkt->read_msg(pos);
        pkt->area_flags(pos,&xti);

        sprintf(tmp,"%7lu",msg.mnum);
        if (xti.marks & XTI_MARK_DISABLED)
            cwritexy(3,ypos,tmp,color[col_list_disabled]);
        else
            cwritexy(3,ypos,tmp,color[col_list_number]);

        tran(msg.mfrom);
        if (xti.marks & XTI_MARK_DISABLED)
            col = color[col_list_disabled];
        else
        {
            col = color[col_list_from];
            if ((stricmp(msg.mfrom,pkt->username) == 0) || (stricmp(msg.mfrom,pkt->useralias) == 0))
                col = color[col_list_fromyou];
        }

        if (len < 35) msg.mfrom[len] = 0;
        if (fmt == format_qwk)
            cwritexy(11,ypos,convstr(msg.mfrom),col);
        else
            cwritexy(11,ypos,msg.mfrom,col);

        if (xti.marks & XTI_MARK_DISABLED)
            col = color[col_list_disabled];
        else
        {
            if (xti.flags & XTI_IS_PERSONAL)
                col = color[col_list_toyou];
            else
                col = color[col_list_to];
        }

        if (len < 35) msg.mto[len] = 0;
        if (fmt == format_qwk)
            cwritexy(12+len,ypos,convstr(tran(msg.mto)),col);
        else
            cwritexy(12+len,ypos,tran(msg.mto),col);

        if (subjlen < 71) msg.subj[subjlen] = 0;
        if (xti.marks & XTI_MARK_DISABLED)
            cwritexy(13+len*2,ypos,tran(msg.subj),color[col_list_disabled]);
        else
            cwritexy(13+len*2,ypos,tran(msg.subj),color[col_list_subj]);
    }

    col = color[col_list_flags];
    if ((xti.flags & XTI_HAS_READ)>0) ch = ASTERISK; else ch=PLOT;
    writechr(scrwidth-8,ypos,ch,col);
    if ((xti.flags & XTI_HAS_REPLIED)>0) ch = '~'; else ch=PLOT;
    writechr(scrwidth-7,ypos,ch,col);
    if ((xti.marks & XTI_MARK_SAVE)>0) ch = 'S'; else ch=PLOT;
    writechr(scrwidth-6,ypos,ch,col);
    if ((xti.marks & XTI_MARK_REPLY)>0) ch = 'R'; else ch=PLOT;
    writechr(scrwidth-5,ypos,ch,col);
    if ((xti.marks & XTI_MARK_PRINT)>0) ch = 'P'; else ch=PLOT;
    writechr(scrwidth-4,ypos,ch,col);
    if ((xti.marks & XTI_MARK_DELETE)>0) ch = 'D'; else ch=PLOT;
    writechr(scrwidth-3,ypos,ch,col);
    if ((msg.flags & flag_private)>0) ch = PVT; else ch=PLOT;
    writechr(scrwidth-2,ypos,ch,col);
}

void color_draw(int x, int y, char *txt, char col, char letter)
{
    char colarr[256],upper,whole,*pstr;
    int num,found,slen;

    memset(colarr,col,sizeof(colarr)-1); colarr[sizeof(colarr)-1] = 0;
    for (num=0; num<5; num++)
    {
        upper = (strchr(kw_flags[num],'@') == NULL);
        whole = (strchr(kw_flags[num],'!') != NULL);
        if (strchr(kw_flags[num],letter) != NULL) continue;
        pstr = txt;
        while ((found = find_text((unsigned char *) kw_search[num],(unsigned char *) pstr,upper,whole)) != -1)
        {
            slen = strlen(kw_search[num]);
            memset(colarr+found+(int) (pstr-txt),color[col_msg_searchtxt],slen);
            pstr += found+slen;
        }
    }

    num = 0;
    while (*txt != '\0')
    {
        writechr(x+num,y,*txt,colarr[num]);
        num++; txt++;
    }
}

#define WSSTART(a) (a == ' ' || a == 9)
#define WSEOL(a) (a == ' ' || a == 9 || a == '\0')
#define CPC(a) (a == '\'' || a == '!' || a == '-' || a == '?')
#define GPC(a) (CPC(a) || a == '"' || a == '#' || a == '$' || a == '%' || \
    a == '&' || a == '(' || a == ')' || a == '+' || a == ',' || a == '.' || \
    a == ':' || a == ';' || a == '<' || a == '=' || a == '>' || a == '^' || \
    a == '`' || a == '{' || a == '|' || a == '}' || a == '~')
#define CHAR(a) ((a >= '0' && a <= '9') || (a >= 'A' && a <= 'Z') || \
    (a >= 'a' && a <= 'z') || (a >= 0x7f && a <= 0xff) || CPC(a))


void write_bolded(int x, int y, char *str, char col)
{
    char *strp,ws,pos,character,quit,first_gpc,any_bolds;
    char cell[512],bold_col;
    int num,start,end;

    memset(cell,col,sizeof(cell));

    strp = str; ws = 1; pos = 0; quit = 0; any_bolds = 0;
    while (!quit)
    {
        switch (pos)
        {
            case 0:
                /* Searching for start */
            __pos1:
                if (*strp == '\0') quit = 1; /* EOL, quit */
                if (WSSTART(*strp)) ws = 1;
                else if (ws == 1 && (CPC(*strp))) ws = 2;
                else if (ws == 1 && (GPC(*strp)))
                {
                    ws = 3;
                    first_gpc = *strp;
                }
                else if ((*strp == '_' || *strp == '*' || *strp == '/') && ws)
                {
                    character = *strp;
                    start = (int) (strp-str+1);
                    pos = 1;
                    if (character == '*') bold_col = color[col_text_bold];
                    else if (character == '_') bold_col = color[col_text_underlined];
                    else if (character == '/') bold_col = color[col_text_italic];
                }
                else ws = 0;
                break;
            case 1:
                /* Skip message text */
                if (*strp == character)
                {
                    pos = 2;
                    end = (int) (strp-str-1);
                }
                else if (!CHAR((unsigned char) *strp))
                {
                    ws = 0;
                    pos = 0;
                    goto __pos1;
                }
                break;
            case 2:
                /* Wait for end of it */
                if (WSEOL(*strp))
                {
                    /* Whoaa! Found bolded/underlined word! */
                    ws = 1; pos = 0; any_bolds = 1;
                    for (num=start; num<=end; num++)
                    {
                        cell[num*2+1] = bold_col;
                    }
                    break;
                }
                if (ws != 4 && GPC(*strp) && (ws != 3 || first_gpc == *strp))
                {
                    /* GPC, skip it. */
                    ws = 4;
                    break;
                }
                /* Blew it at end */
                ws = 0; pos = 0;
                goto __pos1;
        }
        strp++;
    }

    if (!any_bolds)
    {
        /* Didn't find any bolded/underlined text. */
        cwritexy(x,y,str,col);
        return;
    }

    num = 0;
    while (*str != '\0')
    {
        cell[num] = *str;
        num += 2;
        str++;
    }
    writeblock(x,y,cell,num);
}

void draw_textline(int ypos, char *str)
{
    unsigned char *strp;

    char tmp[256],col;
    int n1,n2,n3,n4,xpos,norm,space,spaces,missing;

    if (str[0] == '\0')
    {
        tbar(1,ypos,scrwidth-1,ypos,color[col_text_normal]);
        return;
    }
    strp = (unsigned char *) str;
    while (*strp != '\0')
    {
        *strp = inbound[*strp];
        strp++;
    }

    xpos = 1;
    switch (pkt->linerec->line_type)
    {
        case LINE_TYPE_QUOTE:
            col = color[col_text_quote]; norm = 0;
            break;
        case LINE_TYPE_TEAR:
            col = color[col_text_tearline]; norm = 0;
            break;
        case LINE_TYPE_TAG:
            col = color[col_text_tagline]; norm = 0;
            break;
        case LINE_TYPE_ORIGIN:
            col = color[col_text_origin]; norm = 0;
            break;
        case LINE_TYPE_KLUDGE:
            col = color[col_text_ext]; norm = 0;
            break;
        default:
            col = color[col_text_normal];
            if (str[0] == ' ' || setup.justify == JUSTIFY_NONE)
            {
                norm = 0;
                xpos = 1;
            }
            else
            {
                norm = 1;
                xpos = setup.left_margin;
            }
            break;
    }

    tbar(1,ypos,scrwidth-1,ypos,col);
    if (search_mode && (xti.marks & XTI_MARK_DISABLED) == 0)
    {
        color_draw(xpos,ypos,str,col,'X');
        return;
    }

    strp = (unsigned char *) str;
    if (setup.justify == JUSTIFY_BOTH && norm)
    {
        spaces = 0;
        while (*strp != '\0')
        {
            if (*strp == ' ') spaces++;
            strp++;
        }
        missing = pkt->txt_length-(int) ((char *) strp-str);

        if (spaces > 0 && missing/spaces < MAX_SPACES)
        {
            n1 = 0; n2 = 0;
            space = 0;
            while (str[n1] != '\0')
            {
                tmp[n2] = str[n1];
                n2++;
                if (str[n1] == ' ')
                {
                    space++;
                    n4 = missing/spaces;
                    if (space <= missing%spaces) n4++;
                    for (n3=0; n3<n4; n3++)
                    {
                        tmp[n2] = ' ';
                        n2++;
                    }
                }
                n1++;
            }
            tmp[n2] = 0;
            strp = (unsigned char *) tmp;
        }
        else
        {
            strp = (unsigned char *) str;
        }
    }

    if (pkt->linerec->line_type == LINE_TYPE_SPECIAL)
        write_bolded(xpos,ypos,(char *) strp,col);
    else
        cwritexy(xpos,ypos,(char *) strp,col);
}

int compare_subj(const unsigned *op1, const unsigned *op2)
{
    int rc;

    char s1[101],s2[101];
    strupr(tran(strcpy(s1,pkt->read_subj(*op1))));
    unsigned long m1 = msg.mnum;
    strupr(tran(strcpy(s2,pkt->read_subj(*op2))));
    unsigned long m2 = msg.mnum;

    rc = strcmp(s1,s2);
    if (rc == 0)
    {
        rc = (m1 <  m2 ? -1 :
              m1 == m2 ?  0 :
              m1 >  m2
             );
    }
    return rc;
}

int compare_from(const unsigned *op1, const unsigned *op2)
{
    int rc;

    char s1[101],s2[101];
    strupr(tran(strcpy(s1,pkt->read_from(*op1))));
    unsigned long m1 = msg.mnum;
    strupr(tran(strcpy(s2,pkt->read_from(*op2))));
    unsigned long m2 = msg.mnum;

    rc = strcmp(s1,s2);
    if (rc == 0)
    {
        rc = (m1 <  m2 ? -1 :
              m1 == m2 ?  0 :
              m1 >  m2
             );
    }
    return rc;
}

int compare_to(const unsigned *op1, const unsigned *op2)
{
    int rc;

    char s1[101],s2[101];
    strupr(tran(strcpy(s1,pkt->read_to(*op1))));
    unsigned long m1 = msg.mnum;
    strupr(tran(strcpy(s2,pkt->read_to(*op2))));
    unsigned long m2 = msg.mnum;

    rc = strcmp(s1,s2);
    if (rc == 0)
    {
        rc = (m1 <  m2 ? -1 :
              m1 == m2 ?  0 :
              m1 >  m2
             );
    }
    return rc;
}

void draw_scrollbar(long linenum)
{
    unsigned num,startpos,len;

    if ((setup.misc_flags & MISC_SHOW_SCROLLBAR) == 0)
    {
        tbar(scrwidth,7,scrwidth,scrsize,color[col_text_normal]);
        return;
    }

    if (pkt->txt_lines > scrsize-6)
    {
        writechr(scrwidth,7,ACS_UARROW,color[col_scroll_arrow]);
        writechr(scrwidth,scrsize,ACS_DARROW,color[col_scroll_arrow]);
        startpos = (scrsize-8)*(linenum+1)/pkt->txt_lines+8;
        len = (scrsize-8)*(scrsize-6)/pkt->txt_lines;
        if (len < 1) len = 1;
        if (linenum+(scrsize-6) >= pkt->txt_lines)
            if (startpos+len < scrsize) startpos++;
        for (num=8; num<scrsize; num++)
        {
            if ((num >= startpos) && (num < startpos+len))
            {
                writechr(scrwidth,num,ACS_BLOCK,color[col_scroll_block]);
            }
            else
            {
                writechr(scrwidth,num,ACS_BOARD,color[col_scroll_backg]);
            }
        }
    }
    else
    {
        for (num=7; num<=scrsize; num++)
            writechr(scrwidth,num,' ',color[col_text_normal]);
    }
}

void toggle_readflag(XTI_REC *xti)
{
    char col;

    if (xti->flags & XTI_HAS_READ)
        col = color[col_msg_flags_off];
    else
        col = color[col_msg_flags_on];

    xti->flags ^= XTI_HAS_READ;

    if (area < 0)
        pkt->save_area_flags(pers.msgnum,xti);
    else
        pkt->save_area_flags(sortrec[ra_ypos+ra_upy-1],xti);
    cwritexy(53,2,"Read",col);
}

void select_justify(char old_justify)
{
    unsigned short cx,cy;
    char *oldscr;

    char tmp[81];
    int slen;

    if (setup.justify == JUSTIFY_NONE)
        setup.justify = old_justify;
    else
        setup.justify = JUSTIFY_NONE;

    sprintf(tmp,lang[199],lang[200+setup.justify]);
    slen = strlen(tmp)/2;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(12,tmp,color[col_info_hilight]);
    try_key(2);
    old_scr(cx,cy,&oldscr);
}

int msglist_tab(SCROLL_BOX *scrbox)
{
    char str1[36],str2[36];
    unsigned pos,num;

    pos = scrbox->ypos+scrbox->upy;
    if (pos >= msgs) return 0;

    switch (opt.sort_msgs)
    {
        case MSGSORT_SUBJ:
            /* Jump to next different subject */
            tran(strcpy(str1,pkt->read_subj(sortrec[pos-1])));
            for (num=pos; num<msgs; num++)
            {
                tran(strcpy(str2,pkt->read_subj(sortrec[num])));
                if (stricmp(str1,str2) != 0)
                {
                    /* Found */
                    scrbox->upy = num;
                    scrbox->ypos = 1;
                    return 1;
                }
            }
            break;
        case MSGSORT_FROM:
            /* Jump to next different from-field */
            tran(strcpy(str1,pkt->read_from(sortrec[pos-1])));
            for (num=pos; num<msgs; num++)
            {
                tran(strcpy(str2,pkt->read_from(sortrec[num])));
                if (strcmp(str1,str2) != 0)
                {
                    /* Found */
                    scrbox->upy = num;
                    scrbox->ypos = 1;
                    return 1;
                }
            }
            break;
        case MSGSORT_TO:
            /* Jump to next different to-field */
            tran(strcpy(str1,pkt->read_to(sortrec[pos-1])));
            for (num=ra_ypos+ra_upy+1; num<msgs; num++)
            {
                tran(strcpy(str2,pkt->read_subj(sortrec[num])));
                if (strcmp(str1,str2) != 0)
                {
                    /* Found */
                    scrbox->upy = num;
                    scrbox->ypos = 1;
                    return 1;
                }
            }
            break;
        default:
            err_box("Messages are not sorted");
            break;
    }

    return 0;
}

int msglist_shifttab(SCROLL_BOX *scrbox)
{
    char str1[36],str2[36];
    unsigned pos,num;

    pos = scrbox->ypos+scrbox->upy;
    if (pos == 1) return 0;

    switch (opt.sort_msgs)
    {
        case MSGSORT_SUBJ:
            /* Jump to next different subject */
            tran(strcpy(str1,pkt->read_subj(sortrec[pos-1])));
            for (num=scrbox->ypos+scrbox->upy-2; num>0; num--)
            {
                tran(strcpy(str2,pkt->read_subj(sortrec[num])));
                if (stricmp(str1,str2) != 0)
                {
                    scrbox->upy = num;
                    scrbox->ypos = 1;
                    return 1;
                }
            }
            scrbox->upy = 0;
            scrbox->ypos = 1;
            return 1;
        case MSGSORT_FROM:
            /* Jump to next different from-field */
            tran(strcpy(str1,pkt->read_from(sortrec[pos-1])));
            for (num=scrbox->ypos+scrbox->upy-2; num>0; num--)
            {
                tran(strcpy(str2,pkt->read_from(sortrec[num])));
                if (strcmp(str1,str2) != 0)
                {
                    scrbox->upy = num;
                    scrbox->ypos = 1;
                    return 1;
                }
            }
            scrbox->upy = 0;
            scrbox->ypos = 1;
            return 1;
        case MSGSORT_TO:
            /* Jump to next different to-field */
            tran(strcpy(str1,pkt->read_to(sortrec[pos-1])));
            for (num=scrbox->ypos+scrbox->upy-2; num>0; num--)
            {
                tran(strcpy(str2,pkt->read_subj(sortrec[num])));
                if (strcmp(str1,str2) != 0)
                {
                    scrbox->upy = num;
                    scrbox->ypos = 1;
                    return 1;
                }
            }
            scrbox->upy = 0;
            scrbox->ypos = 1;
            return 1;
        default:
            err_box("Messages are not sorted");
            break;
    }

    return 0;
}

int turn_flag_read(SCROLL_BOX *scrbox)
{
    ra_ypos = scrbox->ypos;
    ra_upy = scrbox->upy;
    turn_flag(XTI_HAS_READ);
    return 0;
}

int turn_flag_replied(SCROLL_BOX *scrbox)
{
    ra_ypos = scrbox->ypos;
    ra_upy = scrbox->upy;
    turn_flag(XTI_HAS_REPLIED);
    return 0;
}

int turn_mark_reply(SCROLL_BOX *scrbox)
{
    ra_ypos = scrbox->ypos;
    ra_upy = scrbox->upy;
    turn_mark(XTI_MARK_REPLY);
    return 0;
}

int turn_mark_save(SCROLL_BOX *scrbox)
{
    ra_ypos = scrbox->ypos;
    ra_upy = scrbox->upy;
    turn_mark(XTI_MARK_SAVE);
    return 0;
}

int turn_mark_print(SCROLL_BOX *scrbox)
{
    ra_ypos = scrbox->ypos;
    ra_upy = scrbox->upy;
    turn_mark(XTI_MARK_PRINT);
    return 0;
}

int turn_mark_delete(SCROLL_BOX *scrbox)
{
    ra_ypos = scrbox->ypos;
    ra_upy = scrbox->upy;
    turn_mark(XTI_MARK_DELETE);
    return 0;
}

int enter_new_message(SCROLL_BOX *scrbox)
{
    enter_newmsg(sortrec[scrbox->ypos+scrbox->upy-1]);
    return 0;
}

unsigned select_area(unsigned origarea)
{
    unsigned short cx, cy;
    char *oldscr;

    unsigned max, upy, num;
    int ypos;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_area_frame],color[col_area_title],lang[21]);
    cwritexy(5,4,lang[99],color[col_area_help]);
    max = scrwidth-36; if (max > 60) max = 60;
    cwritexy(18+max,4,lang[100],color[col_area_help]);
    draw_hline(3,scrwidth-2,5,color[col_area_frame]);

    ypos = 1; upy = origarea-1;
    if (pkt->areas-upy < scrsize-7) max = pkt->areas-upy; else max = scrsize-7;

    for (num=1; num<=max; num++)
        draw_line_em(num+5,num+upy);
    tattrbar(4,6,scrwidth-3,6,color[col_area_selectbar]);

    area_list_em(0,&ypos,&upy);
    old_scr(cx,cy,&oldscr);
    return ypos+upy;
}

void read_area(int areanum)
{
    /*
     areanum:
       -1 = Personal msg scan
       -2 = Messages marked for reply
       -3 = Keyword search
     */
    unsigned short ox,oy,ox2,oy2;
    char *oldscr, *oldscr2;

    char anum[6];
    char title[61],str[81],tmp[256],*pstr;
    char linestr[256];

    unsigned long mnum;
    unsigned old_ypos,old_upy;

    unsigned long lastmsg;
    char direction;

    unsigned max,slen;
    char narea,quit,ch,noclr;

    unsigned r_at,r_to,mnro;
    unsigned long typos;

    unsigned long num,lnum;

    FILE *Fkbd;
    unsigned keys;

    char col,loadtable,old_justify;

    msgtype tmpmsg;
    SCROLL_BOX scrbox;
    KeyRec keyarr[512];


    old_justify = setup.justify;
    search_mode = areanum == -3 ? 1 : 0;
    area = areanum;
    if (area < 0)
    {
        strcpy(anum, "-1");
        fseek(Fpers,0,SEEK_END);
        msgs = (ftell(Fpers) / sizeof(pers_rec));

        read_setup(NULL);
        read_table(1,inbound,opt.intable);
        read_table(0,outbound,opt.outtable);

        tran(strcpy(title,lang[63-area]));
    }
    else
    {
        strcpy(anum, pkt->get_area_number(area));
        if (pkt->open_area(anum) == 0) return;
        msgs = pkt->get_msgs(anum);
        tran(strcpy(title, pkt->get_area_name(area)));
    }

    /* Allocate memory for sort index */
    sortrec = (unsigned *) malloc(sizeof(unsigned)*msgs);
    if (sortrec == NULL) return;

    save_scr(&ox,&oy,&oldscr);
    slen = strlen(lang[67])/2;
    draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_info_frame],color[col_info_title],NULL);
    cmiddle(12,lang[67],color[col_info_text]);

    /* Read messages to memory */
    msgs_in_mem = 0;
    if ((area >= 0) && (arcfmt != format_sky))
    {
        mem_msgs = (msgtype *) malloc(sizeof(msgtype)*msgs);
        if (mem_msgs != NULL)
        {
            lnum = 0;
            for (num=1; num<=msgs; num++)
            {
                pkt->read_msg(num);
                memcpy(&mem_msgs[lnum],&msg,sizeof(msgtype));
                lnum++;
            }
            msgs_in_mem = 1;
        }
    }
    else
    {
        mem_msgs = NULL;
    }

    /* Sort messages */
    for (num=0; num<msgs; num++)
        sortrec[num] = num+1;

    /* Remove DISABLED flag from all messages in area */
    for (mnum=1; mnum<=msgs; mnum++)
    {
        if (area < 0)
        {
            fseek(Fpers,(mnum-1)*sizeof(pers_rec),SEEK_SET);
            if (fread(&pers,sizeof(pers_rec),1,Fpers) == 0) return;

            pkt->open_area(pkt->get_area_number(pers.area));
            pkt->area_flags(pers.msgnum,&xti);
            xti.marks &= ~XTI_MARK_DISABLED;
            pkt->save_area_flags(pers.msgnum,&xti);
        }
        else
        {
            pkt->area_flags(mnum,&xti);
            xti.marks &= ~XTI_MARK_DISABLED;
            pkt->save_area_flags(mnum,&xti);
        }
    }

    /* Sort messages */
    if (area >= 0 && arcfmt != format_sky)
    {
        switch (opt.sort_msgs)
        {
            case MSGSORT_SUBJ:
                qsort(sortrec,msgs,sizeof(unsigned),(SORT_FUNC) compare_subj);
                break;
            case MSGSORT_FROM:
                qsort(sortrec,msgs,sizeof(unsigned),(SORT_FUNC) compare_from);
                break;
            case MSGSORT_TO:
                qsort(sortrec,msgs,sizeof(unsigned),(SORT_FUNC) compare_to);
                break;
        }
    }

    /* Get position of first message to read */
    ra_ypos = 1; ra_upy = 0;
    for (num=1; num<=msgs; num++)
    {
        mnum = sortrec[num-1];
        if (area < 0)
        {
            fseek(Fpers,(mnum-1)*sizeof(pers_rec),SEEK_SET);
            fread(&pers,sizeof(pers),1,Fpers);
            pkt->open_area(pkt->get_area_number(pers.area));
            pkt->area_flags(pers.msgnum,&xti);
        }
        else
        {
            pkt->area_flags(mnum,&xti);
        }

        if ((xti.flags & XTI_HAS_READ) == 0)
        {
            if (num <= scrsize-4)
            {
                ra_ypos = num;
                ra_upy = 0;
            }
            else
            {
                ra_ypos = scrsize-4;
                ra_upy = num - (scrsize-4);
            }
            break;
        }
    }

    if ((opt.rflags & AUTO_TITLE_SCAN) == 0) goto jumpover;
titlescan:
    /* Read setup configuration */
    if (area < 0) read_setup(NULL); else read_setup(pkt->get_area_tag(areanum));
    read_table(1,inbound,opt.intable);

    draw_shaded_box(1,1,scrwidth,3,color[col_list_frame],color[col_list_title],title);
    //draw_shaded_box(1,1,scrwidth,scrsize,color[col_list_frame],color[col_list_title],title);
    //draw_hline(1,scrwidth,3,color[col_list_frame]);
    clockcolor = color[col_list_clock];
    draw_clock();

    if (area < 0)
    {
        unsigned subjlen,arealen,len;

        cwritexy(3,2,lang[68],color[col_list_help]);
        subjlen = (scrwidth-15) / 2;
        if (subjlen*2 < scrwidth-15) subjlen++;

        arealen = subjlen/4;
        arealen += subjlen%4;
        len = (subjlen-arealen) / 2;
        cwritexy(4+arealen,2,lang[70],color[col_list_help]);
        cwritexy(5+arealen+len,2,lang[71],color[col_list_help]);
        cwritexy(6+arealen+len*2,2,lang[72],color[col_list_help]);
    }
    else
    {
        cwritexy(3,2,lang[69],color[col_list_help]);
        cwritexy(11,2,lang[70],color[col_list_help]);
        max = (scrwidth-22) / 2;
        if (max*2 < max-22) max++;
        max /= 2;
        cwritexy(12+max,2,lang[71],color[col_list_help]);
        cwritexy(13+max*2,2,lang[72],color[col_list_help]);
    }

//redraw_msglist:
    if (msgs-ra_upy <= scrsize-4) max = msgs-ra_upy; else max = scrsize-4;

    memset(&scrbox,0,sizeof(scrbox));
    scrbox.ypos = ra_ypos;
    scrbox.upy = ra_upy;
    scrbox.xstart = 1;
    scrbox.xend = scrwidth;
    scrbox.ystart = 4;
    scrbox.yend = scrsize;
    scrbox.lines = &msgs;
    scrbox.scrollbar_color = color[col_list_selectbar];
    scrbox.background_color = color[col_list_number];
    scrbox.draw_func = (DRAW_FUNC) draw_line_ra;
    add_key(9, 0, (SCROLL_FUNC) msglist_tab, &scrbox);
    add_key(0, 15, (SCROLL_FUNC) msglist_shifttab, &scrbox);
    add_key(0, 165, (SCROLL_FUNC) msglist_shifttab, &scrbox);
    add_key('*', 0, (SCROLL_FUNC) turn_flag_read, &scrbox);
    add_key('~', 0, (SCROLL_FUNC) turn_flag_replied, &scrbox);
    add_key(18, 0, (SCROLL_FUNC) turn_mark_reply, &scrbox);
    add_key(19, 0, (SCROLL_FUNC) turn_mark_save, &scrbox);
    add_key(16, 0, (SCROLL_FUNC) turn_mark_print, &scrbox);
    add_key('E', 0, (SCROLL_FUNC) enter_new_message, &scrbox);
    add_key(0, 'S', (SCROLL_FUNC) turn_mark_delete, &scrbox);
    if (scroll_box(&scrbox) == 0)
    {
        deinit_scroll_box(&scrbox);
        goto __quit;
    }
    deinit_scroll_box(&scrbox);

    ra_ypos = scrbox.ypos;
    ra_upy = scrbox.upy;

    draw_line_ra(ra_ypos+3,ra_ypos+ra_upy);

jumpover:
    /* Read keyboard configuration */
#ifdef __linux__
    if ((Fkbd = FileOpen("~/.skyreader/readmsg.kbd","rb")) == NULL)
#else
    if ((Fkbd = FileOpen("readmsg.kbd","rb")) == NULL)
#endif
    {
        draw_shaded_box(scrwidth/2-30,10,scrwidth/2+30,15,color[col_warn_frame],color[col_warn_title],"Error!");
#ifdef __linux
        cmiddle(12,"Keyboard configuration file '~/.skyreader/readmsg.kbd' not found!",color[col_warn_hilight]);
#else
        cmiddle(12,"Keyboard configuration file 'readmsg.kbd' not found!",color[col_warn_hilight]);
#endif
        cmiddle(13,"Create it from SkyReader's setup!",color[col_warn_hilight]);
        try_key(10);
        goto titlescan;
    }
    else
    {
        keys = fread(keyarr,sizeof(KeyRec),sizeof(keyarr)/sizeof(keyarr[0]),Fkbd);
        fclose(Fkbd);
    }

    noclr = 0; rot13 = 0; loadtable = 0;
    if (area > 0)
    {
        strcpy(areatag, pkt->get_area_tag(area));
        tran(strcpy(areaname, pkt->get_area_name(area)));
        origarea = area;
    }
    direction = 0;
drawmsg:
    if (area < 0)
    {
        fseek(Fpers,(sortrec[ra_ypos+ra_upy-1]-1)*sizeof(pers_rec),SEEK_SET);
        fread(&pers,sizeof(pers_rec),1,Fpers);

        read_setup(pkt->get_area_tag(pers.area));

        read_table(0,outbound,opt.outtable);

        strcpy(areatag,pkt->get_area_tag(pers.area));
        tran(strcpy(areaname,pkt->get_area_name(pers.area)));
        pkt->open_area(pkt->get_area_number(pers.area));
        pkt->read_msg(pers.msgnum);

        origarea = pers.area;
        pkt->area_flags(pers.msgnum,&xti);
    }
    else
    {
        pkt->read_msg(sortrec[ra_ypos+ra_upy-1]);
        pkt->area_flags(sortrec[ra_ypos+ra_upy-1],&xti);
    }

    if ((direction) && (xti.marks & XTI_MARK_DISABLED))
    {
        if (direction == 1)
        {
            if (ra_ypos+ra_upy == msgs)
                goto __quit;
            else
                ra_upy++;
        }
        else
        {
            if (ra_upy+ra_ypos == 1)
                goto __quit;
            else
            {
                if (ra_ypos > 1) ra_ypos--; else ra_upy--;
            }
        }
        goto drawmsg;
    }
    direction = 0;
    lastmsg = ra_ypos+ra_upy;

    if (!pkt->init_text())
    {
        err_box(lang[203]);
        goto titlescan;
    }

    if (pkt->chrs_kludge[0] != 0)
    {
        read_table(1,inbound,opt.intable);
        read_table2(1,inbound,pkt->chrs_kludge);
        loadtable = 1;
    }
    else
    {
        if (loadtable)
        {
            read_table(1,inbound,opt.intable);
            loadtable = 0;
        }
    }

    tbar(1,2,scrwidth,5,color[col_msg_frame]);

    if (search_mode)
    {
        sprintf(str," %s ",lang[66]);
    }
    else
    {
        sprintf(str," %s ",areaname);
    }

    /* Draw title */

    _draw_hline(1,scrwidth,1,color[col_msg_frame]);
    cmiddle(1,str,color[col_msg_title]);
    cwritexy(1,2,lang[73],color[col_msg_label]);
    cwritexy(1,3,lang[74],color[col_msg_label]);
    cwritexy(1,4,lang[75],color[col_msg_label]);
    cwritexy(1,5,lang[76],color[col_msg_label]);
    cwritexy(48,3,lang[77],color[col_msg_label]);
    cwritexy(48,4,lang[78],color[col_msg_label]);

    cwritexy(59,3,msg.date,color[col_msg_date]);

    sprintf(str,"%d/%d  #%lu",ra_ypos+ra_upy,msgs,msg.mnum);
    cwritexy(8,2,str,color[col_msg_msgnum]); /* Print msg number */

    clockcolor = color[col_msg_clock];
    draw_clock(); /* Draw clock */

    if (noclr) noclr = 0; else typos = 0;

    if (msg.flags & flag_private)
        cwritexy(27,2,"Pvt",color[col_msg_status]);

    if (msg.flags & flag_received)
        cwritexy(31,2,"Read",color[col_msg_status]);

    if ((xti.flags & XTI_HAS_READ)>0)
        col = color[col_msg_flags_on]; else col = color[col_msg_flags_off];
    cwritexy(53,2,"Read",col);

    if ((xti.flags & XTI_HAS_REPLIED)>0)
        col = color[col_msg_flags_on]; else col = color[col_msg_flags_off];
    cwritexy(58,2,"Replied",col);

    if ((xti.flags & XTI_HAS_SAVED)>0)
        col = color[col_msg_flags_on]; else col = color[col_msg_flags_off];
    cwritexy(66,2,"Saved",col);

    if ((xti.flags & XTI_HAS_PRINTED)>0)
        col = color[col_msg_flags_on]; else col = color[col_msg_flags_off];
    cwritexy(72,2,"Printed",col);

    if ((xti.marks & XTI_MARK_REPLY)>0)
        col = color[col_msg_marks_on]; else col = color[col_msg_marks_off];
    cwritexy(59,4,"Reply",col);

    if ((xti.marks & XTI_MARK_SAVE)>0)
        col = color[col_msg_marks_on]; else col = color[col_msg_marks_off];
    cwritexy(65,4,"Save",col);

    if ((xti.marks & XTI_MARK_PRINT)>0)
        col = color[col_msg_marks_on]; else col = color[col_msg_marks_off];
    cwritexy(70,4,"Print",col);

    if ((xti.marks & XTI_MARK_DELETE)>0)
        col = color[col_msg_marks_on]; else col = color[col_msg_marks_off];
    cwritexy(76,4,"Del",col);

    tbar(1,7,80,7,color[col_text_normal]);

    if ((xti.flags & XTI_IS_PERSONAL) && (opt.rflags & NOICE_PERSONAL)) beep();

    xti.flags |= XTI_HAS_READ;
    if (area<0)
        pkt->save_area_flags(pers.msgnum,&xti);
    else
        pkt->save_area_flags(sortrec[ra_ypos+ra_upy-1],&xti);

redraw:
    _draw_hline(1,scrwidth,6,color[col_msg_frame]);

    /* In: xxxx */
    slen = 0;
    if (intab[0] != '\0')
    {
        sprintf(str,lang[295],intab);
        slen = strlen(str);
        writechr(2,6,'[',color[col_msg_frame]);
        writechr(slen+3,6,']',color[col_msg_frame]);
        cwritexy(3,6,str,color[col_msg_title]);
        slen += 3;
    }

    /* Out: xxxx */
    if (outtab[0] != '\0')
    {
        sprintf(str,lang[296],outtab);
        writechr(slen+2,6,'[',color[col_msg_frame]);
        writechr(slen+strlen(str)+3,6,']',color[col_msg_frame]);
        cwritexy(slen+3,6,str,color[col_msg_title]);
    }

    /* Lines: xxxx */
    sprintf(str,"%s %4d",lang[81],pkt->txt_lines);
    slen = strlen(str);
    writechr(scrwidth-slen-2,6,'[',color[col_msg_frame]);
    writechr(scrwidth-1,6,']',color[col_msg_frame]);
    cwritexy(scrwidth-slen-1,6,str,color[col_msg_title]);

    /* Reply to, reply at */
    memcpy(&tmpmsg,&msg,sizeof(msg));
    r_at = 0; r_to = 0;
    if ((area > -1) && ((msg.replyto > 0) || (msg.replyat > 0)))
    {
        str[0] = '\0';
        for (num=0; num<msgs; num++)
        {
            mnro = pkt->read_num(sortrec[num]);
            if (mnro == tmpmsg.replyto)
            {
                r_to = num+1;
                sprintf(str+strlen(str)," %s%d ",lang[79],r_to);
                if (r_at > 0) break;
            }
            if (mnro == tmpmsg.replyat)
            {
                r_at = num+1;
                sprintf(str+strlen(str)," %s%d ",lang[80],r_at);
                if (r_to > 0) break;
            }
        }
        cmiddle(6,str,color[col_msg_title]);
    }
    memcpy(&msg,&tmpmsg,sizeof(msg));

    tran(msg.mfrom);
    if (fmt == format_qwk) convstr(msg.mfrom);

    strcpy(tmp, msg.mfrom);
    if (fmt == format_bw)
    {
        num = pkt->area_type(origarea);
        if ((num & TYPE_ECHO) && (num & TYPE_NET) && ((num & TYPE_INET) == 0))
        {
            /* Take point number from FMPT kludge */
            msg_point = (unsigned short) pkt->fmpt;

            /* From INTL kludge? */
            if (msg_point == 0 && pkt->intl_kludge[0] != '\0')
            {
                strcpy(str,pkt->intl_kludge);
                if ((pstr = strchr(str,' ')) != NULL)
                    if ((pstr = strchr(pstr+1,'.')) != NULL)
                        msg_point = (unsigned short) atol(pstr+1);
            }

            /* From MSGID kludge? */
            if (msg_point == 0)
            {
                strcpy(str,pkt->msgid_kludge);
                if ((pstr = strchr(str,' ')) != NULL)
                {
                    *pstr = '\0';
                    if ((pstr = strchr(str,'.')) != NULL)
                        msg_point = (unsigned short) atol(pstr+1);
                }
            }
            sprintf(tmp+strlen(tmp),", %i:%i/%i.%i",msg.zone,msg.net,msg.node,msg_point);
        }
    }

    /* From */
    if ((search_mode) && ((xti.marks & XTI_MARK_DISABLED) == 0))
        color_draw(8,3,tmp,color[col_msg_from],'F');
    else
        cwritexy(8,3,tmp,color[col_msg_from]);

    /* To */
    tran(msg.mto);
    if (fmt == format_qwk) convstr(msg.mto);
    if ((search_mode) && ((xti.marks & XTI_MARK_DISABLED) == 0))
        color_draw(8,4,msg.mto,color[col_msg_to],'T');
    else
        cwritexy(8,4,msg.mto,color[col_msg_to]);

    /* Subject */
    tran(msg.subj); slen = strlen(msg.subj);
    if (slen > scrwidth-7) { ch = msg.subj[scrwidth-7]; msg.subj[scrwidth-7] = '\0'; }
    if ((search_mode) && ((xti.marks & XTI_MARK_DISABLED) == 0))
        color_draw(8,5,msg.subj,color[col_msg_subj],'S');
    else
        write_bolded(8,5,msg.subj,color[col_msg_subj]);
    if (slen > scrwidth-7) msg.subj[scrwidth-7] = ch;

    tbar(1,7,scrwidth-1,scrsize,color[col_text_normal]);
    max = scrsize-6;
    if (max > pkt->txt_lines-typos) max = pkt->txt_lines-typos;
    for (num=1; num<=max; num++)
        draw_textline(num+6,pkt->read_line(linestr,num+typos));

    draw_scrollbar(typos);
    quit = 0;
    narea = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = (char) toupper(sk_getch());
            if (ch == 0) {
                ch = sk_getch();
                for (num=0; num<keys; num++)
                  if ((keyarr[num].key1 == 0) && (keyarr[num].key2 == ch))
                    goto what_to_do;
            }
            else
            {
                for (num=0; num<keys; num++)
                    if (toupper(keyarr[num].key1) == ch)
                    {
                    what_to_do:
                        switch(keyarr[num].cmd)
                        {
                            case key_lineup:
                                if (typos>0)
                                {
                                    typos--;
                                    scroll_down(1,7,scrwidth-1,scrsize);
                                    draw_textline(7,pkt->read_line(linestr,typos+1));
                                    draw_scrollbar(typos);
                                }
                                break;
                            case key_linedown:
                                if (typos+scrsize-6 < pkt->txt_lines || (setup.misc_flags & MISC_SCROLL_DOWN && typos < pkt->txt_lines-1))
                                {
                                    typos++;
                                    scroll_up(1,7,scrwidth-1,scrsize);
                                    draw_textline(scrsize,pkt->read_line(linestr,typos+scrsize-6));
                                    draw_scrollbar(typos);
                                }
                                break;
                            case key_pageup:
                                if (typos > 0)
                                {
                                    if (typos < scrsize-7) typos = 0; else typos -= scrsize-7;
                                    goto redraw;
                                }
                                break;
                            case key_pagedown:
                                if (typos+scrsize-6<pkt->txt_lines) {
                                    typos += scrsize-7;
                                    if (typos > pkt->txt_lines) typos = pkt->txt_lines;
                                    goto redraw;
                                }
                                break;
                            case key_home:
                                if (typos > 0)
                                {
                                    typos = 0;
                                    goto redraw;
                                }
                                break;
                            case key_end:
                                if (typos+scrsize-6 < pkt->txt_lines)
                                {
                                    typos = pkt->txt_lines-scrsize+6;
                                    goto redraw;
                                }
                                break;
                            case key_nextmsg:
                                if (ra_ypos+ra_upy<msgs)
                                {
                                    if (ra_ypos == scrsize-4) ra_upy++; else ra_ypos++;
                                    direction = 1;
                                    goto drawmsg;
                                }
                                else
                                {
                                    quit = 1;
                                    narea = 1;
                                }
                                break;
                            case key_prevmsg:
                                if (ra_ypos+ra_upy > 1)
                                {
                                    if (ra_ypos == 1) ra_upy--; else ra_ypos--;
                                    direction = 2;
                                    goto drawmsg;
                                }
                                else
                                {
                                    quit = 1;
                                    narea = 1;
                                }
                                break;
                            case key_seealso:
                                if (r_at > 0)
                                {
                                    ra_ypos = 1; ra_upy = r_at-1;
                                    pkt->read_msg(r_at);
                                    goto drawmsg;
                                }
                                break;
                            case key_replyto:
                                if (r_to > 0) {
                                    ra_ypos = 1; ra_upy = r_to-1;
                                    pkt->read_msg(r_to);
                                    goto drawmsg;
                                }
                                break;
                            case key_nextthread:
                                switch (opt.sort_msgs) {
                                    case MSGSORT_SUBJ:
                                        strupr(tran(strcpy(str,msg.subj)));
                                        for (num=ra_ypos+ra_upy; num<msgs; num++)
                                            if (strcmp(str,strupr(tran(pkt->read_subj(sortrec[num])))) != 0) {
                                                ra_upy = num;
                                                ra_ypos = 0;
                                                break;
                                            }
                                        if (ra_ypos != 0) ra_upy = msgs-1;
                                        ra_ypos = 1; 
                                        goto drawmsg;
                                    case MSGSORT_FROM:
                                        strupr(tran(strcpy(str,msg.mfrom)));
                                        for (num=ra_ypos+ra_upy+1; num<msgs; num++)
                                            if (strcmp(str,strupr(tran(pkt->read_from(sortrec[num])))) != 0) {
                                                ra_upy = num;
                                                ra_ypos = 0;
                                                break;
                                            }
                                        if (ra_ypos != 0) ra_upy = msgs-1;
                                        ra_ypos = 1; 
                                        goto drawmsg;
                                    case MSGSORT_TO:
                                        strupr(tran(strcpy(str,msg.mto)));
                                        for (num=ra_ypos+ra_upy+1; num<msgs; num++)
                                        {
                                            if (strcmp(str,strupr(tran(pkt->read_to(sortrec[num])))) != 0) {
                                                ra_upy = num;
                                                ra_ypos = 0;
                                                break;
                                            }
                                        }
                                        if (ra_ypos != 0) ra_upy = msgs-1;
                                        ra_ypos = 1; 
                                        goto drawmsg;
                                    default:
                                        // TNNE JOTAIN VALITUSTA ETTEI OLE SORTATTU!
                                        break;
                                }
                                break;
                            case key_prevthread:
                                switch (opt.sort_msgs) {
                                    case MSGSORT_SUBJ:
                                        strupr(tran(strcpy(str,msg.subj)));
                                        for (num=ra_ypos+ra_upy-2; num>0; num--)
                                            if (strcmp(str,strupr(tran(pkt->read_subj(sortrec[num])))) != 0) {
                                                ra_upy = num;
                                                ra_ypos = 0;
                                                break;
                                            }
                                        if (ra_ypos != 0) ra_upy = 0;
                                        ra_ypos = 1; 
                                        goto drawmsg;
                                    case MSGSORT_FROM:
                                        strupr(tran(strcpy(str,msg.mfrom)));
                                        for (num=ra_ypos+ra_upy-2; num>0; num--)
                                            if (strcmp(str,strupr(tran(pkt->read_from(sortrec[num])))) != 0) {
                                                ra_upy = num;
                                                ra_ypos = 0;
                                                break;
                                            }
                                        if (ra_ypos != 0) ra_upy = 0;
                                        ra_ypos = 1; 
                                        goto drawmsg;
                                    case MSGSORT_TO:
                                        strupr(tran(strcpy(str,msg.mto)));
                                        for (num=ra_ypos+ra_upy-2; num>0; num--)
                                            if (strcmp(str,strupr(tran(pkt->read_to(sortrec[num])))) != 0) {
                                                ra_upy = num;
                                                ra_ypos = 0;
                                                break;
                                            }
                                        if (ra_ypos != 0) ra_upy = 0;
                                        ra_ypos = 1; 
                                        goto drawmsg;
                                    default:
                                        // TNNE JOTAIN VALITUSTA ETTEI OLE SORTATTU!
                                        break;
                                }
                                break;
                            case key_firstmsg:
                                if (ra_ypos+ra_upy > 1) {
                                    ra_ypos = 1; ra_upy = 0;
                                    goto drawmsg;
                                }
                                break;
                            case key_lastmsg:
                                if (ra_ypos+ra_upy < msgs) {
                                    if ((long) (msgs-scrsize-4) < 0) ra_upy = 0; else
                                        ra_upy = msgs-(scrsize-4);
                                    ra_ypos = msgs-ra_upy;
                                    goto drawmsg;
                                }
                                break;
                            case key_jumpmsg:
                                num = jump_msg();
                                if ((num > 0) && (num <= msgs)) {
                                    ra_ypos = 1; ra_upy = num-1;
                                    pkt->read_msg(num);
                                    goto drawmsg;
                                }
                                break;
                            case key_quit:
                                quit = 1;
                                break;
                            case key_replymsg: reply_msg(); break;
                            case key_replyanother: reply_another(0,0,0); break;
                            case key_replynetmail: reply_netmail(); break;
                            case key_replyorig: reply_orig(); break;
                            case key_replyoriganother: reply_another(1,0,0); break;
                            case key_entermsg: enter_newmsg(sortrec[ra_ypos+ra_upy-1]); break;
                            case key_enteranother: enter_msg(1); break;
                            case key_forwardmsg: forward_msg(); break;
                            case key_intrans:
                                transtable(NULL,inbound);
                                goto redraw;
                            case key_outtrans:
                                transtable(NULL,outbound);
                                goto redraw;
                            case key_savemsg: save_msg(0); break;
                            case key_titlescan: goto titlescan;
                            case key_stealtag: steal_tagline(0,typos); break;
                            case key_stealedittag: steal_tagline(1,typos); break;
                            case key_extrainfo: show_kludges = !show_kludges; goto drawmsg;
                            case key_ziptoreply:
                                pkt->deinit_msgtext();
                                if (zip_to_reply())
                                {
                                    noclr = 1;
                                    goto drawmsg;
                                }
                                break;
                            case key_viewoutbound:
                                pkt->deinit_msgtext();
                                read_replies(0);
                                pkt->read_msg(ra_ypos+ra_upy);
                                noclr = 1;
                                goto drawmsg;
                            case key_ansimsg:
                                show_ansi(pkt->export_msg(tmp));
                                FileRemove(tmp);
                                break;
                            case key_adoptaddr:
                                num = pkt->area_type(origarea);
                                adopt_address(0,num & TYPE_INET && num & TYPE_NET);
                                break;
                            case key_addrbook: address_book(NULL); break;
                            case key_markreply: toggle_replymark(&xti); break;
                            case key_marksave: toggle_savemark(&xti); break;
                            case key_markprint: toggle_printmark(&xti); break;
                            case key_markdel: {
                                toggle_deletemark(&xti);
                                if (ra_ypos+ra_upy < msgs) {
                                    if (ra_ypos == scrsize-4) ra_upy++; else ra_ypos++;
                                    goto drawmsg;
                                } else {
                                    quit = 1;
                                    narea = 1;
                                }
                                break;
                            }
                            case key_flagread: toggle_readflag(&xti); break;
                            case key_flagreplied: toggle_replyflag(&xti); break;
                            case key_flagsaved: toggle_saveflag(&xti); break;
                            case key_flagprinted: toggle_printflag(&xti); break;
                            case key_dosshell: shell_dos(); break;
                            case key_config:
                                num = setup.justify;
                                setup.justify = old_justify;
                                run_setup();
                                old_justify = setup.justify;
                                if (setup.left_margin == 0) setup.left_margin = 1;
                                if ((setup.right_margin > scrwidth-1) || (setup.right_margin == 0))
                                    pkt->txt_length = (scrwidth-1)-setup.left_margin+1;
                                else
                                    pkt->txt_length = setup.right_margin-setup.left_margin+1;
                                read_setup(NULL); // flush cache
                                if (area < 1)
                                    read_setup(pkt->get_area_tag(pers.area));
                                else
                                    read_setup(pkt->get_area_tag(area));
                                read_table(1,inbound,opt.intable);
                                read_table(0,outbound,opt.outtable);
                                goto drawmsg;
                                //case key_help: break;
                            case key_rot13: rot13 = !rot13; goto redraw;
                            case key_search:
                                old_ypos = ra_ypos;
                                old_upy = ra_upy;
                                if (search_message(ra_ypos+ra_upy,area,msgs))
                                {
                                    ra_ypos = 1;
                                    ra_upy = 0;
                                    direction = 1;
                                    goto drawmsg;
                                }
                                break;
                            case key_pgp_addring:
                                pgp_add_ring();
                                break;
                            case key_justify:
                                select_justify(old_justify);
                                goto drawmsg;
                            case key_omen_delete:
                            case key_omen_pvtpub:
                            case key_omen_move:
                                if (fmt != format_omen)
                                {
                                    err_box("This command works only with OMEN packets.");
                                    break;
                                }
                                memset(&reply, 0, sizeof(reply));
                                if (area < 1)
                                    strcpy(reply.area, pkt->get_area_tag(pers.area));
                                else
                                    strcpy(reply.area, pkt->get_area_tag(area));
                                strcpy(reply.mfrom, pkt->username);
                                strcpy(reply.mto, msg.mfrom);
                                reply.replyto = msg.mnum;
                                reply.fname[0] = '\0';
                                switch(keyarr[num].cmd)
                                {
                                    case key_omen_delete:
                                        sprintf(reply.subj, "Delete message #%lu", ra_ypos+ra_upy);
                                        reply.flags = flag_omen_del;
                                        note_box("Message deleted");
                                        break;
                                    case key_omen_pvtpub:
                                        sprintf(reply.subj, "Toggle private/public status in message #%lu", ra_ypos+ra_upy);
                                        reply.flags = flag_omen_tog;
                                        note_box("Message private status toggled");
                                        break;
                                    case key_omen_move:
                                        num = select_area(area < 1 ? pers.area : area);
                                        sprintf(reply.fname, "%lu", num);
                                        sprintf(reply.subj, "Move message #%lu to area #%lu", ra_ypos+ra_upy, num);
                                        reply.flags = flag_omen_move;
                                        note_box("Message moved");
                                        break;
                                }
                                pkt->enter_msg();
                                break;
                            case key_external_1:
                            case key_external_2:
                            case key_external_3:
                            case key_external_4:
                            case key_external_5:
                            case key_external_6:
                            case key_external_7:
                            case key_external_8:
                            case key_external_9:
                            {
                                char *strp;

                                save_scr(&ox2, &oy2, &oldscr2);
                                save_msg(2);
                                tclrscr(); refresh();
                                strp = strchr(setup.extprog[keyarr[num].cmd-key_external_1], ' ');
                                if (strp != NULL) *strp++ = '\0';
                                swapexec(setup.extprog[keyarr[num].cmd-key_external_1], strp, 0);
                                if (strp != NULL) *(strp-1) = ' ';
#ifdef __linux__
                                FileRemove("~/.skyreader/extsave.txt");
#else
                                FileRemove("extsave.txt");
#endif
                                old_scr(ox2, oy2, &oldscr2);
                                break;
                            }
                        }
                        break;
                    }
            }
        } else give_timeslice();
    }

    if (search_mode && area != -3) goto __quit;

    if ((opt.rflags & AUTO_TITLE_SCAN) && (!narea))
        goto titlescan;
__quit:
    pkt->deinit_msgtext();
    if (search_mode)
    {
        search_mode = 0;
        if (area == -3)
        {
            fclose(Fpers);
            sprintf(tmp,"%ssky_find.idx", setup.workpath);
            FileRemove(tmp);
        }
        else
        {
            for (mnum=1; mnum<=msgs; mnum++)
            {
                if (area < 0)
                {
                    fseek(Fpers,(mnum-1)*sizeof(pers_rec),SEEK_SET);
                    if (fread(&pers,sizeof(pers_rec),1,Fpers) == 0) return;

                    pkt->open_area(pkt->get_area_number(pers.area));
                    pkt->area_flags(pers.msgnum,&xti);
                    xti.marks &= ~XTI_MARK_DISABLED;
                    pkt->save_area_flags(pers.msgnum,&xti);
                }
                else
                {
                    pkt->area_flags(mnum,&xti);
                    xti.marks &= ~XTI_MARK_DISABLED;
                    pkt->save_area_flags(mnum,&xti);
                }
            }
            ra_ypos = old_ypos;
            ra_upy = old_upy;
            slen = strlen(lang[274])/2;
            draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_info_frame],color[col_info_title],NULL);
            cmiddle(12,lang[274],color[col_info_hilight]);
            try_key(2);
            goto drawmsg;
        }
    }
    setup.justify = old_justify;
    clockcolor = color[col_clock];
    old_scr(ox,oy,&oldscr);
    if (mem_msgs) free(mem_msgs);
    free(sortrec);
    msgs_in_mem = 0;
}
