#include <stdio.h>

int main(int argc, char *argv[])
{
    FILE *Fp, *Fo, *Fm;
    char data1[1000], data2[1000];
    unsigned long fpos;
    int r1, r2, pos;

    if (argc != 4)
    {
        printf("Usage: sdiff <orig file> <modified file> <patch>\n");
        return 0;
    }

    Fo = fopen(argv[1], "rb");
    if (Fo == NULL)
    {
        printf("Can't open %s\n", argv[1]);
        return 1;
    }
    Fm = fopen(argv[2], "rb");
    if (Fo == NULL)
    {
        printf("Can't open %s\n", argv[2]);
        return 1;
    }
    Fp = fopen(argv[3], "w+b");
    if (Fp == NULL)
    {
        printf("Can't create %s\n", argv[3]);
        return 1;
    }

    while ((r1 = fread(data1, 1, sizeof(data1), Fo)) > 0)
    {
        r2 = fread(data2, 1, sizeof(data2), Fm);
        if (r1 != r2)
        {
            printf("Ei saman kokoisia!\n");
            return 2;
        }

        for (pos=0; pos<r1; pos++)
            if (data1[pos] != data2[pos])
            {
                fpos = ftell(Fo)-r1+pos;
                fwrite(&fpos, 4, 1, Fp);
                fwrite(&data1[pos], 1, 1, Fp);
                fwrite(&data2[pos], 1, 1, Fp);
                printf("Pos = %ld, old = %d, new = %d\n", fpos, data1[pos], data2[pos]);
            }
    }

    fclose(Fo);
    fclose(Fm);
    fclose(Fp);

    return 0;
}
