#define SETUP_VERSION 1

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "keycfg.h"
#include "setprefs.h"
#include "vars.h"
#include "files.h"
#include "general.h"
#include "screen.h"
#include "readsets.h"
#include "keyb.h"
#include "scrsaver.h"
#include "shell.h"
#include "setup.h"
#include "version.h"

static char yes_txt_short[] = "Yes";
static char no_txt_short[] = "No ";

char mailpkt[13];
PrefsRecord defopt;

char *yesno2(unsigned short yes)
{
    if (yes > 0)
        return yes_txt_short;
    else
        return no_txt_short;
}

void setup_global(void)
{

    void setup_global_string_settings(void);
    void setup_global_misc_settings(void);
    void setup_global_mail_packet_options(void);
    void setup_global_video_configuration(void);

    unsigned short cx,cy;
    char *oldscr;

    char ch,pos,quit;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(8,10,35,18,color[col_box_frame],color[col_box_title],"Global");
    cwritexy(10,11,"Misc Settings",color[col_box_text]);
    cwritexy(10,12,"Mail Packet Options",color[col_box_text]);
    cwritexy(10,13,"Keyboard Configuration",color[col_box_text]);
    cwritexy(10,14,"Color Configuration",color[col_box_text]);
#ifdef __linux__
    cwritexy(10,15,"Video Configuration",color[col_box_disabled]);
#else
    cwritexy(10,15,"Video Configuration",color[col_box_text]);
#endif
    cwritexy(10,16,"Translation Table Setup",color[col_box_text]);
    cwritexy(10,17,"Name settings etc.",color[col_box_text]);
    tattrbar(9,11,34,11,color[col_box_select]);

    pos = 1; quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    switch (pos)
                    {
                        case 1:
                            setup_global_misc_settings();
                            break;
                        case 2:
                            setup_global_mail_packet_options();
                            break;
                        case 3:
                            keyboard_config();
                            break;
                        case 4:
                            err_box("Color configuration isn't ready yet - edit colors.cfg file..");
                            break;
                        case 5:
#ifndef __linux__
                            setup_global_video_configuration();
#endif
                            break;
                        case 6:
                            transtable(NULL,NULL);
                            break;
                        case 7:
                            setup_global_string_settings();
                            break;
                    }
                    break;
                case 27: pos = 0; quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
#ifdef __linux__
                            if (pos == 5)
                                tattrbar(9,10+pos,34,10+pos,color[col_box_disabled]);
                            else
                                tattrbar(9,10+pos,34,10+pos,color[col_box_text]);
#else
                            tattrbar(9,10+pos,34,10+pos,color[col_box_text]);
#endif
                            if (pos == 7) pos = 1; else pos++;
                            tattrbar(9,10+pos,34,10+pos,color[col_box_select]);
                            break;
                        case 'H':
#ifdef __linux__
                            if (pos == 5)
                                tattrbar(9,10+pos,34,10+pos,color[col_box_disabled]);
                            else
                                tattrbar(9,10+pos,34,10+pos,color[col_box_text]);
#else
                            tattrbar(9,10+pos,34,10+pos,color[col_box_text]);
#endif
                            if (pos == 1) pos = 7; else pos--;
                            tattrbar(9,10+pos,34,10+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
}

void setup_archivers(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char info,pos,*pstr;
    char *pointers[12] =
    {
        setup.rar_cmd,
        setup.unrar_cmd,
        setup.zip_cmd,
        setup.unzip_cmd,
        setup.arj_cmd,
        setup.unarj_cmd,
        setup.lha_cmd,
        setup.unlha_cmd,
        setup.uc2_cmd,
        setup.unuc2_cmd,
        setup.aux_cmd,
        setup.unaux_cmd
    };

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(8,10,72,23,color[col_box_frame],color[col_box_title],"Archivers");
    cwritexy(10,11,"RAR Compression   : ",color[col_box_text]); cwritexy(30,11,setup.rar_cmd,color[col_box_hilight]);
    cwritexy(10,12,"RAR Decompression : ",color[col_box_text]); cwritexy(30,12,setup.unrar_cmd,color[col_box_hilight]);
    cwritexy(10,13,"ZIP Compression   : ",color[col_box_text]); cwritexy(30,13,setup.zip_cmd,color[col_box_hilight]);
    cwritexy(10,14,"ZIP Decompression : ",color[col_box_text]); cwritexy(30,14,setup.unzip_cmd,color[col_box_hilight]);
    cwritexy(10,15,"ARJ Compression   : ",color[col_box_text]); cwritexy(30,15,setup.arj_cmd,color[col_box_hilight]);
    cwritexy(10,16,"ARJ Decompression : ",color[col_box_text]); cwritexy(30,16,setup.unarj_cmd,color[col_box_hilight]);
    cwritexy(10,17,"LHA Compression   : ",color[col_box_text]); cwritexy(30,17,setup.lha_cmd,color[col_box_hilight]);
    cwritexy(10,18,"LHA Decompression : ",color[col_box_text]); cwritexy(30,18,setup.unlha_cmd,color[col_box_hilight]);
    cwritexy(10,19,"UC2 Compression   : ",color[col_box_text]); cwritexy(30,19,setup.uc2_cmd,color[col_box_hilight]);
    cwritexy(10,20,"UC2 Decompression : ",color[col_box_text]); cwritexy(30,20,setup.unuc2_cmd,color[col_box_hilight]);
    cwritexy(10,21,"AUX Compression   : ",color[col_box_text]); cwritexy(30,21,setup.aux_cmd,color[col_box_hilight]);
    cwritexy(10,22,"AUX Decompression : ",color[col_box_text]); cwritexy(30,22,setup.unaux_cmd,color[col_box_hilight]);
    pos = 1; pstr = setup.rar_cmd;
    key_xpos = 0; key_xovr = 0;
    do {
        info = get_string(30,10+pos,sizeof(CmdStr)-1,41,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
        switch (info) {
            case 0:
            case 1:
                if (pos == 12) pos = 1; else pos++;
                key_xpos = 0; key_xovr = 0;
                pstr = pointers[pos-1];
                break;
            case 2:
                if (pos == 1) pos = 12; else pos--;
                key_xpos = 0; key_xovr = 0;
                pstr = pointers[pos-1];
                break;
        }
    } while (info != 5);
    old_scr(cx,cy,&oldscr);
}

void setup_external(void) {
    unsigned short cx,cy;
    char *oldscr;

    char info,pos,*pstr;

    char *pointers[12] = {
        setup.editor,
        setup.spellchk,
        setup.tagmgr,
        setup.extprog[0],
        setup.extprog[1],
        setup.extprog[2],
        setup.extprog[3],
        setup.extprog[4],
        setup.extprog[5],
        setup.extprog[6],
        setup.extprog[7],
        setup.extprog[8],
    };

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(8,10,72,23,color[col_box_frame],color[col_box_title],"External programs");
    cwritexy(10,11,"Message editor    : ",color[col_box_text]); cwritexy(30,11,setup.editor,color[col_box_hilight]);
    cwritexy(10,12,"Spell checker     : ",color[col_box_text]); cwritexy(30,12,setup.spellchk,color[col_box_hilight]);
    cwritexy(10,13,"Tagline manager   : ",color[col_box_text]); cwritexy(30,13,setup.tagmgr,color[col_box_hilight]);
    cwritexy(10,14,"External program 1: ",color[col_box_text]); cwritexy(30,14,setup.extprog[0],color[col_box_hilight]);
    cwritexy(10,15,"External program 2: ",color[col_box_text]); cwritexy(30,15,setup.extprog[1],color[col_box_hilight]);
    cwritexy(10,16,"External program 3: ",color[col_box_text]); cwritexy(30,16,setup.extprog[2],color[col_box_hilight]);
    cwritexy(10,17,"External program 4: ",color[col_box_text]); cwritexy(30,17,setup.extprog[3],color[col_box_hilight]);
    cwritexy(10,18,"External program 5: ",color[col_box_text]); cwritexy(30,18,setup.extprog[4],color[col_box_hilight]);
    cwritexy(10,19,"External program 6: ",color[col_box_text]); cwritexy(30,19,setup.extprog[5],color[col_box_hilight]);
    cwritexy(10,20,"External program 7: ",color[col_box_text]); cwritexy(30,20,setup.extprog[6],color[col_box_hilight]);
    cwritexy(10,21,"External program 8: ",color[col_box_text]); cwritexy(30,21,setup.extprog[7],color[col_box_hilight]);
    cwritexy(10,22,"External program 9: ",color[col_box_text]); cwritexy(30,22,setup.extprog[8],color[col_box_hilight]);
    pos = 1; pstr = setup.editor;
    key_xpos = 0; key_xovr = 0;
    do {
        info = get_string(30,10+pos,sizeof(CmdStr)-1,41,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
        switch (info) {
            case 0:
            case 1:
                if (pos == 12) pos = 1; else pos++;
                pstr = pointers[pos-1];
                break;
            case 2:
                if (pos == 1) pos = 12; else pos--;
                pstr = pointers[pos-1];
                break;
        }
    } while (info != 5);
    old_scr(cx,cy,&oldscr);
}

void setup_directories(void) {
    unsigned short cx,cy;
    char *oldscr;

    char info,pos,*pstr;

    char *pointers[8] = {
        setup.datapath,
        setup.downpath,
        setup.uppath,
        setup.workpath,
        setup.replypath,
        setup.packetpath,
        setup.oldpktpath,
        setup.PGPPath
    };

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(8,10,72,19,color[col_box_frame],color[col_box_title],"Directories");
    cwritexy(10,11,"Data files        : ",color[col_box_text]); cwritexy(30,11,setup.datapath,color[col_box_hilight]);
    cwritexy(10,12,"Message packets   : ",color[col_box_text]); cwritexy(30,12,setup.downpath,color[col_box_hilight]);
    cwritexy(10,13,"Reply packets     : ",color[col_box_text]); cwritexy(30,13,setup.uppath,color[col_box_hilight]);
    cwritexy(10,14,"Work path         : ",color[col_box_text]); cwritexy(30,14,setup.workpath,color[col_box_hilight]);
    cwritexy(10,15,"Reply work path   : ",color[col_box_text]); cwritexy(30,15,setup.replypath,color[col_box_hilight]);
    cwritexy(10,16,"Unpacked packets  : ",color[col_box_text]); cwritexy(30,16,setup.packetpath,color[col_box_hilight]);
    cwritexy(10,17,"Old msg packets   : ",color[col_box_text]); cwritexy(30,17,setup.oldpktpath,color[col_box_hilight]);
    cwritexy(10,18,"PGP.EXE path      : ",color[col_box_text]); cwritexy(30,18,setup.PGPPath,color[col_box_hilight]);
    pos = 1; pstr = setup.datapath;
    key_xpos = 0; key_xovr = 0;
    do {
        info = get_string(30,10+pos,sizeof(CmdStr)-1,41,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
        switch (info) {
            case 0:
            case 1:
                if (pos == 8) pos = 1; else pos++;
                key_xpos = 0; key_xovr = 0;
                pstr = pointers[pos-1];
                break;
            case 2:
                if (pos == 1) pos = 8; else pos--;
                key_xpos = 0; key_xovr = 0;
                pstr = pointers[pos-1];
                break;
        }
    } while (info != 5);
    old_scr(cx,cy,&oldscr);
    if (!isdir(setup.datapath)) ask_mkdir(setup.datapath);
    if (!isdir(setup.downpath)) ask_mkdir(setup.downpath);
    if (!isdir(setup.uppath)) ask_mkdir(setup.uppath);
    if (!isdir(setup.workpath)) ask_mkdir(setup.workpath);
    if (!isdir(setup.replypath)) ask_mkdir(setup.replypath);
    if (!isdir(setup.packetpath)) ask_mkdir(setup.packetpath);
    if (!isdir(setup.oldpktpath)) ask_mkdir(setup.oldpktpath);
    if (!isdir(setup.PGPPath)) ask_mkdir(setup.PGPPath);
}

static void AddSlash(char *txt) {
    int slen;

    slen = strlen(txt);
    if ((slen > 0) && (txt[slen-1] != SLASH)) {
        txt[slen] = SLASH;
        txt[slen+1] = 0;
    }
}

void run_setup(void)
{
#ifndef __linux__
    char backg[256];
#endif
    char starts[] = { 10, 23, 31, 42, 52, 65, 71 };

    char ch,quit,pos,oldclockcolor;

    unsigned short cx,cy;
    char *oldscr;
    unsigned y;

    char *oldsets = (char *) malloc(sizeof(SetupRecord));
    char *ptr;

    FILE *F;

    save_scr(&cx,&cy,&oldscr);

    memcpy(oldsets,&setup,sizeof(setup));
    pos = 1; 
__back:
    tbar(1,1,scrwidth,1,color[col_title]);
    cmiddle(1," "Reader_Name" v"version" ",color[col_title]);
    oldclockcolor = clockcolor;
    clockcolor = color[col_clock];
    draw_clock();

#ifdef __linux__
    unsigned x;

    for (y=2; y<=scrsize; y++)
    {
        for (x=1; x<=scrwidth; x++)
        {
            writechr(x,y,ACS_CKBOARD,color[col_background]);
        }
    }
#else
    memset(backg,'',scrwidth);
    backg[scrwidth] = '\0';
    for (y=2; y<=scrsize; y++)
        cwritexy(1,y,backg,color[col_background]);
#endif

    draw_shaded_box(8,3,72,5,color[col_box_frame],color[col_box_title],NULL);
    cwritexy(11,4,"Preferences  Global  Archivers  External  Directories  Quit",color[col_box_text]);

    tattrbar(starts[pos-1],4,starts[pos]-1,4,color[col_box_select]);

    quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                __check:
                    switch (pos)
                    {
                        case 1: setup_preferences(); break;
                        case 2: setup_global(); break;
                        case 3: setup_archivers(); break;
                        case 4: setup_external(); break;
                        case 5: setup_directories(); break;
                        case 6: quit = 1;
                    }
                    break;
                case 27:
                    quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos();
                            break;
                        case 'P': goto __check;
                        case 'K':
                            tattrbar(starts[pos-1],4,starts[pos]-1,4,color[col_box_text]);
                            if (pos == 1) pos = 6; else pos--;
                            tattrbar(starts[pos-1],4,starts[pos]-1,4,color[col_box_select]);
                            break;
                        case 'M':
                            tattrbar(starts[pos-1],4,starts[pos]-1,4,color[col_box_text]);
                            if (pos == 6) pos = 1; else pos++;
                            tattrbar(starts[pos-1],4,starts[pos]-1,4,color[col_box_select]);
                            break;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }
    ptr = (char *) &setup;
    for (y=0; y<sizeof(SetupRecord); y++)
        if (ptr[y] != oldsets[y]) {
            draw_shaded_box(scrwidth/2-11,10,scrwidth/2+12,14,color[col_info_frame],color[col_info_title],NULL);
            cmiddle(12,"Save settings? (Y/n)",color[col_info_hilight]);
            for (;;)
            {
                ch = (char) toupper(sk_getch());
                if ((ch == 13) || (ch == 'Y')) {
                    AddSlash(setup.datapath);
                    AddSlash(setup.downpath);
                    AddSlash(setup.uppath);
                    AddSlash(setup.workpath);
                    AddSlash(setup.packetpath);
                    AddSlash(setup.oldpktpath);
                    AddSlash(setup.PGPPath);

                    setup.VerID = SETUP_VERSION;
                    if ((F = FileOpen(cfgfile,"w+b")) != NULL)
                    {
                        fwrite(&setup,sizeof(setup),1,F);
                        fclose(F);
                    }
                    break;
                }
                if (ch == 'N') {
                    if ((F = FileOpen(cfgfile,"rb")) != NULL)
                    {
                        fread(&setup,sizeof(setup),1,F);
                        fclose(F);
                    }
                    break;
                }
                if (ch == 27) goto __back;
            }
            break;
        }
    clockcolor = oldclockcolor;
    old_scr(cx,cy,&oldscr);
    free(oldsets);

    if (setup.msgtxt[0] == '\0') strcpy(setup.msgtxt,"msgtemp.txt");
}

void setup_global_misc_settings(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char *justifying[3] =
    {
        "None", "Left", "Both"
    };

    char quit,pos,ch,tmp[11];

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(10,12,52,24,color[col_box_frame],color[col_box_title],"Misc settings");

    cwritexy(12,13,"Display date/time :",color[col_box_text]);
    cwritexy(12,14,"Screen saver secs :",color[col_box_text]);
    cwritexy(12,15,"Append to savefile:",color[col_box_text]);
    cwritexy(12,16,"Scroll bar in msgs:",color[col_box_text]);
    cwritexy(12,17,"Tagline after sig :",color[col_box_text]);
    cwritexy(12,18,"Left marginal     :",color[col_box_text]);
    cwritexy(12,19,"Right marginal    :",color[col_box_text]);
    cwritexy(12,20,"Text justifying   :",color[col_box_text]);
    cwritexy(12,21,"Scroll more down  :",color[col_box_text]);
    cwritexy(12,22,"BW tear line      :",color[col_box_text]);
    cwritexy(12,23,"BW version number :",color[col_box_text]);

    cwritexy(32,13,yesno2(setup.misc_flags & MISC_SHOW_TIME),color[col_box_hilight]);
    sprintf(tmp,"%d",setup.scrsaver);
    cwritexy(32,14,tmp,color[col_box_hilight]);

    if (setup.misc_flags & MISC_ASK_APPEND)
        cwritexy(32,15,"Ask",color[col_box_hilight]);
    else
        cwritexy(32,15,yesno2(setup.misc_flags & MISC_APPEND_SAVEFILE),color[col_box_hilight]);
    cwritexy(32,16,yesno2(setup.misc_flags & MISC_SHOW_SCROLLBAR),color[col_box_hilight]);
    cwritexy(32,17,yesno2(setup.misc_flags & MISC_TAG_AFTER_SIG),color[col_box_hilight]);
    sprintf(tmp,"%d",setup.left_margin);
    cwritexy(32,18,tmp,color[col_box_hilight]);
    sprintf(tmp,"%d",setup.right_margin);
    cwritexy(32,19,tmp,color[col_box_hilight]);
    cwritexy(32,20,justifying[setup.justify],color[col_box_hilight]);
    cwritexy(32,21,yesno2(setup.misc_flags & MISC_SCROLL_DOWN),color[col_box_hilight]);
    if (registered)
    {
        ch = setup.tearline[19]; setup.tearline[19] = '\0';
        cwritexy(32,22,setup.tearline,color[col_box_hilight]);
        setup.tearline[19] = ch;
        cwritexy(32,23,setup.vernum,color[col_box_hilight]);
    }
    else
    {
        cwritexy(32,22,"(reg. only)",color[col_box_hilight]);
        cwritexy(32,23,"(reg. only)",color[col_box_hilight]);
    }

    tattrbar(11,13,29,13,color[col_box_select]);
    pos = 1; quit = 0;
    while (!quit)
    {
        if (sk_kbhit())
        {
            ch = sk_getch();
            switch (ch)
            {
                case 13:
                    switch (pos)
                    {
                        case 1:
                            setup.misc_flags ^= MISC_SHOW_TIME;
                            cwritexy(32,13,yesno2(setup.misc_flags & MISC_SHOW_TIME),color[col_box_hilight]);
                            break;
                        case 2:
                            sprintf(tmp,"%d",setup.scrsaver);
                            get_string(32,14,5,5,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.scrsaver = atol(tmp);
                            sprintf(tmp,"%d",setup.scrsaver);
                            cwritexy(32,14,tmp,color[col_box_hilight]);
                            break;
                        case 3:
                            if (setup.misc_flags & MISC_ASK_APPEND)
                            {
                                setup.misc_flags ^= MISC_ASK_APPEND;
                                setup.misc_flags &= ~(MISC_APPEND_SAVEFILE);
                                cwritexy(32,15,"No ",color[col_box_hilight]);
                            }
                            else if (setup.misc_flags & MISC_APPEND_SAVEFILE)
                            {
                                setup.misc_flags ^= MISC_APPEND_SAVEFILE;
                                setup.misc_flags |= MISC_ASK_APPEND;
                                cwritexy(32,15,"Ask",color[col_box_hilight]);
                            }
                            else
                            {
                                setup.misc_flags |= MISC_APPEND_SAVEFILE;
                                cwritexy(32,15,"Yes",color[col_box_hilight]);
                            }
                            break;
                        case 4:
                            setup.misc_flags ^= MISC_SHOW_SCROLLBAR;
                            cwritexy(32,16,yesno2(setup.misc_flags & MISC_SHOW_SCROLLBAR),color[col_box_hilight]);
                            break;
                        case 5:
                            setup.misc_flags ^= MISC_TAG_AFTER_SIG;
                            cwritexy(32,17,yesno2(setup.misc_flags & MISC_TAG_AFTER_SIG),color[col_box_hilight]);
                            break;
                        case 6:
                            sprintf(tmp,"%d",setup.left_margin);
                            get_string(32,18,3,3,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.left_margin = atol(tmp);
                            if (setup.left_margin == 0) setup.left_margin = 1;
                            sprintf(tmp,"%d",setup.left_margin);
                            cwritexy(32,18,tmp,color[col_box_hilight]);
                            break;
                        case 7:
                            sprintf(tmp,"%d",setup.right_margin);
                            get_string(32,19,3,3,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.right_margin = atol(tmp);
                            sprintf(tmp,"%d",setup.right_margin);
                            cwritexy(32,19,tmp,color[col_box_hilight]);
                            break;
                        case 8:
                            if (setup.justify < 2)
                                setup.justify++;
                            else
                                setup.justify = 0;
                            cwritexy(32,20,justifying[setup.justify],color[col_box_hilight]);
                            break;
                        case 9:
                            setup.misc_flags ^= MISC_SCROLL_DOWN;
                            cwritexy(32,21,yesno2(setup.misc_flags & MISC_SCROLL_DOWN),color[col_box_hilight]);
                            break;
                        case 10:
                            if (registered) get_string(32,22,sizeof(setup.tearline)-1,19,setup.tearline,128,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            break;
                        case 11:
                            if (registered) get_string(32,23,sizeof(setup.vernum)-1,sizeof(setup.vernum)-1,setup.vernum,128,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            break;
                    }
                    break;
                case 27:
                    quit = 1;
                    break;
                case 0:
                    ch = sk_getch();
                    switch (ch)
                    {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            tattrbar(11,12+pos,29,12+pos,color[col_box_text]);
                            if (pos == 11) pos = 1; else pos++;
                            tattrbar(11,12+pos,29,12+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(11,12+pos,29,12+pos,color[col_box_text]);
                            if (pos == 1) pos = 11; else pos--;
                            tattrbar(11,12+pos,29,12+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        }
        else
        {
            give_timeslice();
        }
    }
    old_scr(cx,cy,&oldscr);
}

void setup_global_mail_packet_options(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char quit,pos,ch;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(10,12,53,24,color[col_box_frame],color[col_box_title],"Mail packet options");

    cwritexy(12,13,"Show files in list      :",color[col_box_text]);
    cwritexy(12,14,"Sort packets by         :",color[col_box_text]);
    cwritexy(12,15,"Display archiver output :",color[col_box_text]);
    cwritexy(12,16,"Automatic packet rename :",color[col_box_text]);
    cwritexy(12,17,"Auto save bookmarks     :",color[col_box_text]);
    cwritexy(12,18,"Keep packets unpacked   :",color[col_box_text]);
    cwritexy(12,19," - Keep packed packets  :",color[col_box_text]);
    cwritexy(12,20,"Create QWK indexes      :",color[col_box_text]);
    cwritexy(12,21,"Mixed case in QWK msgs  :",color[col_box_text]);
    cwritexy(12,22,"Auto move msg packet    :",color[col_box_text]);
    cwritexy(12,23,"Display directories     :",color[col_box_text]);

    ch = setup.msgpktmask[14]; setup.msgpktmask[14] = 0;
    cwritexy(38,13,setup.msgpktmask,color[col_box_hilight]);
    setup.msgpktmask[14] = ch;
    if ((setup.packetsort < 1) || (setup.packetsort > 3)) setup.packetsort = 1;
    switch (setup.packetsort) {
        case PKTSORT_DATE:
            cwritexy(38,14,"Date",color[col_box_hilight]);
            break;
        case PKTSORT_NAME:
            cwritexy(38,14,"Name",color[col_box_hilight]);
            break;
        case PKTSORT_EXT:
            cwritexy(38,14,"Ext ",color[col_box_hilight]);
            break;
    }

    cwritexy(38,15,yesno2(setup.misc_flags & MISC_DISPLAY_OUTPUT),color[col_box_hilight]);
    cwritexy(38,16,yesno2(setup.packet_flags & PKT_REN_PACKET),color[col_box_hilight]);
    cwritexy(38,17,yesno2(setup.packet_flags & PKT_SAVE_BOOK),color[col_box_hilight]);
    cwritexy(38,18,yesno2(setup.packet_flags & PKT_SAVE_UNPACKED),color[col_box_hilight]);
    cwritexy(38,19,yesno2(setup.packet_flags & PKT_KEEP_PACKED),color[col_box_hilight]);

    if (setup.packet_flags & PKT_QWK_INDEXES_ALWAYS)
        cwritexy(38,20,"Always",color[col_box_hilight]);
    else
        cwritexy(38,20,"Detect",color[col_box_hilight]);

    if (setup.packet_flags & PKT_QWK_MIXED_CASE)
        cwritexy(38,21,"Always",color[col_box_hilight]);
    else
        cwritexy(38,21,"Detect",color[col_box_hilight]);

    cwritexy(38,22,yesno2(setup.packet_flags & PKT_AUTO_MOVE_PACKET),color[col_box_hilight]);
    cwritexy(38,23,yesno2(setup.packet_flags & PKT_DISPLAY_DIRS),color[col_box_hilight]);

    tattrbar(11,13,36,13,color[col_box_select]);
    pos = 1; quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = sk_getch();
            switch (ch) {
                case 13:
                    switch (pos) {
                        case 1:
                            get_string(38,13,255,14,setup.msgpktmask,0,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            tbar(37,13,52,13,color[col_box_hilight]);
                            ch = setup.msgpktmask[14]; setup.msgpktmask[14] = 0;
                            cwritexy(38,13,setup.msgpktmask,color[col_box_hilight]);
                            setup.msgpktmask[14] = ch;
                            break;
                        case 2:
                            if (setup.packetsort == 3) setup.packetsort = 1; else setup.packetsort++;
                            switch (setup.packetsort) {
                                case PKTSORT_DATE:
                                    cwritexy(38,14,"Date",color[col_box_hilight]);
                                    break;
                                case PKTSORT_NAME:
                                    cwritexy(38,14,"Name",color[col_box_hilight]);
                                    break;
                                case PKTSORT_EXT:
                                    cwritexy(38,14,"Ext ",color[col_box_hilight]);
                                    break;
                            }
                            break;
                        case 3:
                            setup.misc_flags ^= MISC_DISPLAY_OUTPUT;
                            cwritexy(38,15,yesno2(setup.misc_flags & MISC_DISPLAY_OUTPUT),color[col_box_hilight]);
                            break;
                        case 4:
                            setup.packet_flags ^= PKT_REN_PACKET;
                            cwritexy(38,16,yesno2(setup.packet_flags & PKT_REN_PACKET),color[col_box_hilight]);
                            break;
                        case 5:
                            setup.packet_flags ^= PKT_SAVE_BOOK;
                            cwritexy(38,17,yesno2(setup.packet_flags & PKT_SAVE_BOOK),color[col_box_hilight]);
                            break;
                        case 6:
                            /*setup.packet_flags ^= PKT_SAVE_UNPACKED;
                            cwritexy(38,18,yesno2(setup.packet_flags & PKT_SAVE_UNPACKED),color[col_box_hilight]);*/
                            break;
                        case 7:
                            setup.packet_flags ^= PKT_KEEP_PACKED;
                            cwritexy(38,19,yesno2(setup.packet_flags & PKT_KEEP_PACKED),color[col_box_hilight]);
                            break;
                        case 8:
                            setup.packet_flags ^= PKT_QWK_INDEXES_ALWAYS;
                            if (setup.packet_flags & PKT_QWK_INDEXES_ALWAYS)
                                cwritexy(38,20,"Always",color[col_box_hilight]);
                            else
                                cwritexy(38,20,"Detect",color[col_box_hilight]);
                            break;
                        case 9:
                            setup.packet_flags ^= PKT_QWK_MIXED_CASE;
                            if (setup.packet_flags & PKT_QWK_MIXED_CASE)
                                cwritexy(38,21,"Always",color[col_box_hilight]);
                            else
                                cwritexy(38,21,"Detect",color[col_box_hilight]);
                            break;
                        case 10:
                            setup.packet_flags ^= PKT_AUTO_MOVE_PACKET;
                            cwritexy(38,22,yesno2(setup.packet_flags & PKT_AUTO_MOVE_PACKET),color[col_box_hilight]);
                            break;
                        case 11:
                            setup.packet_flags ^= PKT_DISPLAY_DIRS;
                            cwritexy(38,23,yesno2(setup.packet_flags & PKT_DISPLAY_DIRS),color[col_box_hilight]);
                            break;
                    }
                    break;
                case 27: quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            tattrbar(11,12+pos,36,12+pos,color[col_box_text]);
                            if (pos == 11) pos = 1; else pos++;
                            tattrbar(11,12+pos,36,12+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(11,12+pos,36,12+pos,color[col_box_text]);
                            if (pos == 1) pos = 11; else pos--;
                            tattrbar(11,12+pos,36,12+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
}

void setup_global_string_settings(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char info,pos,*pstr;

    char *pointers[] =
    {
        setup.UsrName,
        setup.inet_addr,
        setup.pgp_userid,
        setup.msgtxt,
        setup.title
    };

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(10,12,74,18,color[col_box_frame],color[col_box_title],"Name settings");
    cwritexy(12,13,"Your name         :",color[col_box_text]);
    cwritexy(12,14,"Internet address  :",color[col_box_text]);
    cwritexy(12,15,"PGP USER ID       :",color[col_box_text]);
    cwritexy(12,16,"Temp msgtxt file  :",color[col_box_text]);
    cwritexy(12,17,"Title Name        :",color[col_box_text]);
    cwritexy(32,13,setup.UsrName,color[col_box_hilight]);
    for (pos=1; pos<5; pos++)
    {
        pstr = pointers[pos];
        info = pstr[41]; pstr[41] = 0;
        cwritexy(32,13+pos,pstr,color[col_box_hilight]);
        pstr[41] = info;
    }
    pos = 1; pstr = setup.UsrName;
    key_xpos = 0; key_xovr = 0; info = 0;
    while (info != 5)
    {
        switch (pos)
        {
            case 1:
                info = get_string(32,12+pos,35,35,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                break;
            case 3:
                info = get_string(32,12+pos,50,41,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                break;
            case 4:
                info = get_string(32,12+pos,60,41,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                break;
            default:
                info = get_string(32,12+pos,128,41,pstr,128+8,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                break;
        }

        switch (info)
        {
            case 0:
            case 1:
                if (pos == 5) pos = 1; else pos++;
                key_xpos = 0; key_xovr = 0;
                pstr = pointers[pos-1];
                break;
            case 2:
                if (pos == 1) pos = 5; else pos--;
                key_xpos = 0; key_xovr = 0;
                pstr = pointers[pos-1];
                break;
        }
    }
    old_scr(cx,cy,&oldscr);
}

void setup_global_video_configuration(void)
{
    unsigned short cx,cy;
    char *oldscr;

    char ch,pos,quit,tmp[30];

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(10,12,49,19,color[col_box_frame],color[col_box_title],"Video Configuration");
#ifdef __OS2__
    cwritexy(12,13,"Use mode:    Cols  Rows  HRes  VRes",color[col_box_text]);
#elif defined (__NT__)
    cwritexy(12,13,"Use mode:    Cols  Rows",color[col_box_text]);
#else
    cwritexy(12,13,"Use mode:    Cols  Rows  AX     BX",color[col_box_text]);
#endif
    cwritexy(12,14,"Mode #1 :",color[col_box_text]);
    cwritexy(12,15,"Mode #2 :",color[col_box_text]);
    cwritexy(12,16,"Mode #3 :",color[col_box_text]);
    cwritexy(12,17,"Mode #4 :",color[col_box_text]);
    cwritexy(12,18,"Mode #5 :",color[col_box_text]);
    tattrbar(11,13,20,13,color[col_box_select]);

    writechr(22,13,setup.modenum+'0',color[col_box_hilight]);
    for (pos=0; pos<5; pos++) {
#ifdef __OS2__
        sprintf(tmp,"%-5i %-5i %-5i %-5i",setup.scrmode[pos].columns,setup.scrmode[pos].rows,
                setup.scrmode[pos].hres,setup.scrmode[pos].vres);
#elif defined (__NT__)
        sprintf(tmp,"%-5i %-5i",setup.scrmode[pos].columns,setup.scrmode[pos].rows);
#else
        sprintf(tmp,"%-5i %-5i %-5X %-5X",setup.scrmode[pos].columns,setup.scrmode[pos].rows,
                setup.scrmode[pos]._ax,setup.scrmode[pos]._bx);
#endif
        cwritexy(25,14+pos,tmp,color[col_box_hilight]);
    }

    pos = 1; quit = 0;
    while (!quit) {
        if (sk_kbhit()) {
            ch = sk_getch();
            switch (ch) {
                case 13:
                    switch (pos) {
                        case 1:
                            if (setup.modenum < 5) setup.modenum++; else setup.modenum = 1;
                            writechr(22,13,setup.modenum+'0',color[col_box_hilight]);
                            break;
                        default:
                            key_xpos = 0; key_xovr = 0;

                            sprintf(tmp,"%d",setup.scrmode[pos-2].columns);
                            get_string(25,12+pos,5,5,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.scrmode[pos-2].columns = atol(tmp);
                            sprintf(tmp,"%d",setup.scrmode[pos-2].columns);
                            cwritexy(25,12+pos,tmp,color[col_box_hilight]);

                            sprintf(tmp,"%d",setup.scrmode[pos-2].rows);
                            get_string(31,12+pos,5,5,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.scrmode[pos-2].rows = atol(tmp);
                            sprintf(tmp,"%d",setup.scrmode[pos-2].rows);
                            cwritexy(31,12+pos,tmp,color[col_box_hilight]);
#ifdef __OS2__
                            sprintf(tmp,"%d",setup.scrmode[pos-2].hres);
                            get_string(37,12+pos,5,5,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.scrmode[pos-2].hres = atol(tmp);
                            sprintf(tmp,"%d",setup.scrmode[pos-2].hres);
                            cwritexy(37,12+pos,tmp,color[col_box_hilight]);

                            sprintf(tmp,"%d",setup.scrmode[pos-2].vres);
                            get_string(43,12+pos,5,5,tmp,128+2,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            setup.scrmode[pos-2].vres = atol(tmp);
                            sprintf(tmp,"%d",setup.scrmode[pos-2].vres);
                            cwritexy(43,12+pos,tmp,color[col_box_hilight]);
#elif !defined (__NT__)
                            sprintf(tmp,"%x",setup.scrmode[pos-2]._ax);
                            get_string(37,12+pos,5,5,tmp,128+16,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            sscanf(tmp,"%hx",&setup.scrmode[pos-2]._ax);

                            sprintf(tmp,"%x",setup.scrmode[pos-2]._bx);
                            get_string(43,12+pos,5,5,tmp,128+16,color[col_box_text],color[col_box_hilight],color[col_box_scroll]);
                            sscanf(tmp,"%hx",&setup.scrmode[pos-2]._bx);
#endif
                            break;
                    }
                    break;
                case 27: quit = 1; break;
                case 0:
                    ch = sk_getch();
                    switch (ch) {
                        case '$':
                            shell_dos();
                            break;
                        case 'P':
                            tattrbar(11,12+pos,20,12+pos,color[col_box_text]);
                            if (pos == 6) pos = 1; else pos++;
                            tattrbar(11,12+pos,20,12+pos,color[col_box_select]);
                            break;
                        case 'H':
                            tattrbar(11,12+pos,20,12+pos,color[col_box_text]);
                            if (pos == 1) pos = 6; else pos--;
                            tattrbar(11,12+pos,20,12+pos,color[col_box_select]);
                            break;
                    }
                    break;
            }
        } else give_timeslice();
    }
    old_scr(cx,cy,&oldscr);
}
