#ifdef __linux__
#  define CHECK 'x'
#  define LEFT_BRACKET ACS_LTEE
#  define RIGHT_BRACKET ACS_RTEE
#else
#  define CHECK ''
#  define LEFT_BRACKET ''
#  define RIGHT_BRACKET ''
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>

#include "shell.h"
#include "addrbook.h"
#include "entermsg.h"
#include "readarea.h"
#include "readmail.h"
#include "scrsaver.h"
#include "taglines.h"
#include "readsets.h"
#include "screen.h"
#include "pgp.h"
#include "keyb.h"
#include "general.h"
#include "files.h"
#include "vars.h"
#include "editor.h"

static char initials[11];
static char oldline[256],oldquote[80],quotestr[256],output[256];
static char QuoteStyle;

static FILE *Ftext;

void remove_chars(char *fname, int crlf)
{
    FILE *Fin,*Fout;
    char tmp[256],data[100],outbuf[100];
    int outpos,write,last_enter,last;
    size_t num,readed;

    Fin = FileOpen(fname,"rb");
    if (Fin == NULL) return;

    sprintf(tmp,"%sskytemp.$$$",setup.replypath);
    Fout = FileOpen(tmp,"w+b");
    if (Fout == NULL)
    {
        fclose(Fin);
        return;
    }

    write = 0; last = -1; outpos = 0; last_enter = 0;
    while ((readed = fread(data,1,sizeof(data),Fin)) > 0)
    {
        if (crlf)
        {
            for (num=0; num<readed; num++)
            {
                last_enter = 0;

                if (last == 10 || last == 13)
                {
                    outbuf[outpos++] = 13;
                    if (outpos == sizeof(outbuf))
                    {
                        fwrite(outbuf,outpos,1,Fout);
                        outpos = 0;
                    }
                    outbuf[outpos++] = 10;
                    if (outpos == sizeof(outbuf))
                    {
                        fwrite(outbuf,outpos,1,Fout);
                        outpos = 0;
                    }
                    last_enter = 1;

                    last = (data[num] != 10 || last == 10) ? data[num] : -1;
                    continue;
                }

                if (last != -1)
                {
                    outbuf[outpos++] = last;
                    if (outpos == sizeof(outbuf))
                    {
                        fwrite(outbuf,outpos,1,Fout);
                        outpos = 0;
                    }
                }
                last = data[num];
            }
        }
        else
        {
            for (num=0; num<readed; num++)
            {
                last_enter = 0;

                if (last == 13 && data[num] != 10) last = 10;
                if (last != 13 && last != -1)
                {
                    outbuf[outpos++] = last;
                    if (outpos == sizeof(outbuf))
                    {
                        fwrite(outbuf,outpos,1,Fout);
                        outpos = 0;
                    }
                }
                last = data[num];
            }
        }
    }

    if (last != 13 && last != 10 && last != -1)
    {
        outbuf[outpos++] = last;
        if (outpos == sizeof(outbuf))
        {
            fwrite(outbuf,outpos,1,Fout);
            outpos = 0;
        }
    }

    if (outpos > 0) fwrite(outbuf,outpos,1,Fout);
    if (last_enter)
    {
        fseek(Fout, -2, SEEK_END);
        if (fread(outbuf, 1, 2, Fout) == 2)
        {
            if (outbuf[0] == 13 || outbuf[0] == 10)
            {
                fseek(Fout, -2, SEEK_END);
                ftrunc(Fout, ftell(Fout));
            }
            else if (outbuf[1] == 13 || outbuf[1] == 10)
            {
                fseek(Fout, -1, SEEK_END);
                ftrunc(Fout, ftell(Fout));
            }
        }
    }

    if (crlf)
        fwrite("\r\n", 2, 1, Fout);
    else
        fwrite("\n", 1, 1, Fout);

    fclose(Fin);
    fclose(Fout);

    FileRemove(fname);
    FileRename(tmp,fname);
}

void rot13file(char *fname)
{
#define BUFSIZE 512

    char buffer[BUFSIZE];
    FILE *F;

    unsigned num,ovr;
    unsigned long lnum,fsize;

    size_t readed;

    /* Open file */
    F = FileOpen(fname,"r+b");
    if (F == NULL) return;

    /* Get size */
    fseek(F,0,SEEK_END);
    fsize = ftell(F);

    /* For netmail etc. if first line starts with 'To:', don't ROT that line */
    if (fmt == format_qwk)
    {
        fseek(F,0,SEEK_SET);
        readed = fread(buffer,1,200,F);
        if (strnicmp(buffer,"TO:",3) == 0)
        {
            for (ovr=0; ovr<readed; ovr++)
                if (buffer[ovr] == 13) break;
        }
        else ovr = 0;
    }
    else ovr = 0;

    if (fsize > BUFSIZE)
    {
        for (lnum=0; lnum<fsize/BUFSIZE; lnum++)
        {
            fseek(F,ovr+lnum*BUFSIZE,SEEK_SET);
            readed = fread(buffer,1,BUFSIZE,F);
            for (num=0; num<readed; num++)
            {
                if ((buffer[num] >= 'A') && (buffer[num] <= 'Z'))
                {
                    if (buffer[num] >= 'A'+13) buffer[num] -= 13; else buffer[num] += 13;
                }
                else if ((buffer[num] >= 'a') && (buffer[num] <= 'z'))
                {
                    if (buffer[num] >= 'a'+13) buffer[num] -= 13; else buffer[num] += 13;
                }
            }
            fseek(F,ovr+lnum*BUFSIZE,SEEK_SET);
            fwrite(buffer,1,readed,F);
        }
    }

    lnum = fsize / BUFSIZE;
    fseek(F,ovr+lnum*BUFSIZE,SEEK_SET);
    readed = fread(buffer,1,fsize % BUFSIZE,F);
    for (num=0; num<readed; num++)
    {
        if ((buffer[num] >= 'A') && (buffer[num] <= 'Z'))
        {
            if (buffer[num] >= 'A'+13) buffer[num] -= 13; else buffer[num] += 13;
        }
        else if ((buffer[num] >= 'a') && (buffer[num] <= 'z'))
        {
            if (buffer[num] >= 'a'+13) buffer[num] -= 13; else buffer[num] += 13;
        }
    }

    fseek(F,ovr+lnum*BUFSIZE,SEEK_SET);
    fwrite(buffer,1,readed,F);
    fclose(F);
}

void transtxt(char *str, unsigned char *bound)
{
    unsigned char *strp;

    strp = (unsigned char *) str;
    while (*strp != '\0')
    {
        *strp = bound[*strp];
        strp++;
    }
}

void start_quoting(char *origmsg)
{
    char ok,num,slen;

    if (opt.quote == QUOTE_BBBS)
        strcpy(initials, "> ");
    else
    {
        ok = 1;
        initials[0] = 0; slen = 0;
        for (num=0; origmsg[num] != '\0'; num++)
        {
            if ((ok) && (origmsg[num] != ' '))
            {
                initials[slen] = (char) toupper(origmsg[num]);
                if (slen < 4) slen++;
                ok = 0;
            }
            else
                if (origmsg[num] == ' ') ok = 1;
        }

        if (opt.quote == QUOTE_IDIOT)
        {
            initials[slen] = '>'; initials[slen+1] = 0;
        }
        else if (opt.quote == QUOTE_IDIOT2)
        {
            initials[slen] = '>'; initials[slen+1] = 0;
            memmove(initials+1,initials,slen+2);
            initials[0] = ' ';
        }
        else
        {
            initials[slen] = '>'; initials[slen+1] = ' '; initials[slen+2] = 0;
            memmove(initials+1,initials,slen+3);
            initials[0] = ' ';
        }
    }

    oldquote[0] = '\0';
    oldline[0] = '\0';
    quotestr[0] = '\0';
}

void finish_quoting(void)
{
    if (oldline[0] != 0)
    {
        fprintf(Ftext,"%s%s\r\n",initials,oldline);
    }

    if (quotestr[0] != 0)
        if (QuoteStyle != QUOTE_IDIOT && QuoteStyle != QUOTE_IDIOT2)
        {
            if (oldquote[0] != ' ')
                fprintf(Ftext," %s> %s\r\n",oldquote,quotestr);
            else
                fprintf(Ftext,"%s> %s\r\n",oldquote,quotestr);
        }
        else
        {
            if (QuoteStyle == QUOTE_IDIOT || oldquote[0] == ' ')
                fprintf(Ftext,"%s%s%s\r\n",initials,oldquote,quotestr);
            else
                fprintf(Ftext,"%s %s%s\r\n",initials,oldquote,quotestr);
        }
}

void quote_line(char *linestr)
{
    char *pstr,addline;
    int last,slen,num,left;

    slen = strlen(linestr);
    left = QUOTE_MAX; last = -1;
    for (num=0; num<slen; num++)
    {
        if (linestr[num] == '\0')
            break;
        else if ((linestr[num] == '"') || (linestr[num] == '\'') || (linestr[num] == '<'))
            break;
        else if (linestr[num] == '>' || (num == 0 && linestr[num] == ':' && linestr[num+1] != ')' && linestr[num+1] != '(' && linestr[num+1] != '-'))
        {
            left = QUOTE_MAX;
            last = num;
        }
        else
        {
            left--;
            if (left == 0) break;
        }
    }
    if (last != -1 && (strncmp(linestr,"... ",4) == 0)) last = -1;

    if (last > -1)
    {
        if (oldline[0] != 0)
        {
            if (QuoteStyle != QUOTE_IDIOT2)
                fprintf(Ftext,"%s%s\r\n",initials,oldline);
            else
                fprintf(Ftext,"%s %s\r\n",initials,oldline);
            oldline[0] = 0;
        }

        if (quotestr[0] != 0)
        {
            if (!((strncmp(oldquote,linestr,last+1) == 0) && (oldquote[last+1] == 0)))
            {
                if (QuoteStyle != QUOTE_IDIOT && QuoteStyle != QUOTE_IDIOT2)
                {
                    if (oldquote[0] != ' ' && QuoteStyle != QUOTE_BBBS)
                        sprintf(output," %s> %s",oldquote,quotestr);
                    else
                        sprintf(output,"%s> %s",oldquote,quotestr);
                }
                else
                {
                    if (QuoteStyle == QUOTE_IDIOT || oldquote[0] == ' ')
                        sprintf(output,"%s%s%s",initials,oldquote,quotestr);
                    else
                        sprintf(output,"%s %s%s",initials,oldquote,quotestr);
                }
                fprintf(Ftext,"%s\r\n",output);
                quotestr[0] = 0;
            }
        }

        strncpy(oldquote,linestr,last+1);
        oldquote[last+1] = 0;
        
        if (QuoteStyle != QUOTE_IDIOT && QuoteStyle != QUOTE_IDIOT2)
        {
            if (oldquote[0] != ' ' && QuoteStyle != QUOTE_BBBS)
            {
                output[0] = ' ';
                strncpy(output+1,linestr,last+1);
                output[last+2] = 0;
            }
            else
            {
                strncpy(output,linestr,last+1);
                output[last+1] = 0;
            }
            
            num = 1;
            while (linestr[last+num] == ' ') num++;
            if (quotestr[0] != 0)
            {
                strcat(strcat(strcat(strcat(output,"> "),quotestr)," "),linestr+last+num);
                quotestr[0] = 0;
            }
            else
                strcat(strcat(output,"> "),linestr+last+num);
        }
        else
        {
            if (quotestr[0] != '\0')
            {
                if (QuoteStyle == QUOTE_IDIOT || oldquote[0] == ' ')
                    sprintf(output,"%s%s%s %s",initials,oldquote,quotestr,linestr+last+1);
                else
                    sprintf(output,"%s %s%s %s",initials,oldquote,quotestr,linestr+last+1);
                quotestr[0] = '\0';
            }
            else
            {
                if (QuoteStyle != QUOTE_IDIOT2 || linestr[0] == ' ')
                    sprintf(output,"%s%s",initials,linestr);
                else
                    sprintf(output,"%s %s",initials,linestr);
            }
        }

    __quote_again:
        slen = strlen(output);
        if (slen > 79)
        {
            pstr = output+slen-1;
            for (;;)
            {
                if ((*pstr == ' ') && (slen <= 79)) break;
                pstr--;
                slen--;
                if (slen <= last+num+3)
                {
                    pstr = NULL;
                    break;
                }
            }

            if ((pstr == NULL) || ((int) (pstr-output) <= last+num+3))
            {
                strcpy(quotestr,output+79);
                output[79] = 0;
            }
            else
            {
                *pstr = 0;
                strcpy(quotestr,pstr+1);
                
                if (strlen(quotestr) > 79)
                {
                    fprintf(Ftext,"%s\r\n",output);
                    if (oldquote[0] != ' ' && QuoteStyle != QUOTE_IDIOT && QuoteStyle != QUOTE_IDIOT2)
                        sprintf(output," %s> %s",oldquote,quotestr);
                    else
                        sprintf(output,"%s> %s",oldquote,quotestr);
                    
                    goto __quote_again;
                }
            }
        }
        fprintf(Ftext,"%s\r\n",output);
        return;
    }

    if (quotestr[0] != 0)
    {
        if (QuoteStyle != QUOTE_IDIOT && QuoteStyle != QUOTE_IDIOT2)
        {
            if (oldquote[0] != ' ')
                sprintf(output," %s> %s",oldquote,quotestr);
            else
                sprintf(output,"%s> %s",oldquote,quotestr);
        }
        else
        {
            if (QuoteStyle == QUOTE_IDIOT || oldquote[0] == ' ')
                sprintf(output,"%s%s%s",initials,oldquote,quotestr);
            else
                sprintf(output,"%s %s%s",initials,oldquote,quotestr);
        }
        fprintf(Ftext,"%s\r\n",output);
        quotestr[0] = 0;
    }
    oldquote[0] = 0;

    addline = 0;
    if (oldline[0] != 0)
    {
        if (QuoteStyle != QUOTE_IDIOT2)
            sprintf(output,"%s%s %s",initials,oldline,linestr);
        else
            sprintf(output,"%s %s %s",initials,oldline,linestr);
        oldline[0] = 0;
        if (linestr[0] == 0) addline = 1;
    }
    else
    {
        if (linestr[0] != 0)
        {
            if (QuoteStyle != QUOTE_IDIOT2)
                sprintf(output,"%s%s",initials,linestr);
            else
                sprintf(output,"%s %s",initials,linestr);
        }
        else
            output[0] = 0;
    }

__again:
    slen = strlen(output);
    if (slen > 79)
    {
        pstr = output+slen-1; num = strlen(initials)+1;
        for (;;)
        {
            if ((*pstr == ' ') && (slen <= 79)) break;
            pstr--;
            slen--;
            if (slen == num)
            {
                pstr = NULL;
                break;
            }
        }

        if (pstr == NULL)
        {
            strcpy(oldline,output+79);
            output[79] = 0;
            fprintf(Ftext,"%s\r\n",output);
            fprintf(Ftext,"%s%s\r\n",initials,oldline);
            if (addline) fprintf(Ftext,"\r\n");
            oldline[0] = 0;
            return;
        }
        else
        {
            *pstr = 0;
            strcpy(oldline,pstr+1);
            if (strlen(oldline) > (79-strlen(initials)))
            {
                fprintf(Ftext,"%s\r\n",output);
                if (addline)
                {
                    fprintf(Ftext,"\r\n");
                    addline = 0;
                }
                strcat(strcpy(output,initials),oldline);
                goto __again;
            }
        }
    }

    fprintf(Ftext,"%s\r\n",output);
    if (addline) fprintf(Ftext,"\r\n");
    return;
}

int _highwrite(int x, int y, char *str, int *keypos, char disabled) {
    int ch;

    if (disabled)
    {
        highwrite_locol = color[col_emsg_disabled];
        highwrite_hicol = color[col_emsg_disabled];
    }

    ch = highwrite(x,y,str,keypos);

    if (disabled)
    {
        highwrite_locol = color[col_emsg_text];
        highwrite_hicol = color[col_emsg_hilight];
    }
    return ch;
}

void split_message(int max_reply)
{
    char origname[13], tmp[256], str[256], *strp, last, *cr, *start, *subj;
    long origlines, lines, pos;
    int readed, num, next, part, parts;
    FILE *Forig, *Fdest;
    struct stat statbuf;

    if (opt.autosplit < 10)
    {
        pkt->enter_msg();
        return;
    }

    subj = reply.subj+strlen(reply.subj);
    if (reply.subj[0] != '\0' && *(subj-1) != ' ')
    {
        *subj++ = ' ';
        *subj = '\0';
    }
    strcpy(origname, reply.fname);
    sprintf(str, "%s%s", setup.replypath, origname);
    Forig = FileOpen(str, "r+b");
    if (Forig == NULL)
    {
        err_box("Can't open message file!");
        return;
    }

    origlines = 0; last = 0;
    while ((readed = fread(str, 1, sizeof(str), Forig)) > 0)
    {
        strp = str;
        while (readed > 0)
        {
            if (*strp == 10 && last != 13)
                origlines++;
            else if (*strp == 13)
                origlines++;
            readed--; last = *strp++;
        }
    }
    fseek(Forig, 0, SEEK_SET);

    if (origlines <= opt.autosplit)
    {
        fclose(Forig);
        pkt->enter_msg();
        return;
    }
    parts = origlines/opt.autosplit+1;
    parts += (parts*2-2)/opt.autosplit;

    if (fmt == format_soup) cr = "\n"; else cr = "\r\n";

    /* Skip lines */
    lines = 1; next = 0;
    while ((readed = fread(str, 1, sizeof(str), Forig)) > 0)
    {
        strp = str; num = 0;
        while (num < readed && lines < opt.autosplit)
        {
            if (*strp == 10)
            {
                lines++;
                next = 0;
            }
            else if (next)
            {
                next = 0; lines++;
                continue;
            }
            next = *strp == 13;
            num++; last = *strp++;
        }
        if (num != readed) break;
    }
    if (next) { next = 0; lines++; }
    origlines -= lines-1; pos = ftell(Forig)-readed+num;

    part = 2;
    while (origlines > 0)
    {
        for (;;)
        {
            max_reply++;
            sprintf(tmp,"%s%05u.MSG",setup.replypath,max_reply);

            if (FileStat(tmp, &statbuf) != 0) break;
            if (max_reply == 65535)
            {
                err_box("Too many replies! Max. 65535");
                return;
            }
        }
        sprintf(reply.fname, "%05u.MSG", max_reply);

        Fdest = FileOpen(tmp, "w+b");
        if (Fdest == NULL)
        {
            err_box("Can't create file - can't split message!");
            fclose(Forig);
            pkt->enter_msg();
            return;
        }

        fprintf(Fdest, " >>> Continued from previous message%s", cr);

        lines = 1+(origlines > opt.autosplit);
        for (;;)
        {
            if (num == 0)
            {
                readed = fread(str, 1, sizeof(str), Forig);
                if (readed == 0) break;
                strp = str; num = 0;
            }

            start = strp;
            while (num < readed && lines < opt.autosplit)
            {
                if (*strp == 10)
                {
                    lines++;
                    next = 0;
                }
                else if (next)
                {
                    next = 0; lines++;
                    continue;
                }
                next = *strp == 13;
                num++; last = *strp++;
            }
            if ((int) (strp-start) > 0) fwrite(start, (int) (strp-start), 1, Fdest);
            if (num != readed) break;
            num = 0;
        }
        if (next) { next = 0; lines++; }
        if (origlines > opt.autosplit) fprintf(Fdest, " >>> Continued in next message%s", cr);
        origlines -= lines-1-(origlines > opt.autosplit);

        fclose(Fdest);
        sprintf(subj, "[%02d/%02d]", part, parts); part++;
        pkt->enter_msg();
    }
    ftrunc(Forig, pos);
    fseek(Forig, 0, SEEK_END);
    fprintf(Forig, " >>> Continued in next message%s", cr);
    fclose(Forig);

    strcpy(reply.fname, origname);
    sprintf(subj, "[01/%02d]", parts);
    pkt->enter_msg();
}

char write_msg(unsigned long msgnum, char *atag, char *pmto, char *psubj, char priv, char quote, char MsgToYou)
{
    unsigned short cx,cy;
    char *oldscr;

    char endy,endy2,ypos,ch,info;

    char area[61],aname[61],origmsg[36],mto[200],out[161],*pstr,*pstr2;

    FILE *F,*Fsig;

    char Abort;

    size_t readed;

    time_t oldtime;
#ifndef __NO_DRIVES__
    unsigned drive,drives;
#endif

    char disabled,ok;

    unsigned short zone,net,node,point;

    unsigned StartReply;
    unsigned CrossStart;
    unsigned CrossArea;

    char editing;

    unsigned slen,spos;

    int oldtxtlen,addcr;
    char addr,found,quit,first,sol,writeit,oldjustify;

    long old_file_size;

    unsigned long lnum,msgline;

    unsigned num,usr,max_reply;
    char tmp[256],tmp2[256];
    struct stat statbuf;
    ADDR_REC addr_rec;

    int oldatype;

    memset(&addr_rec,0,sizeof(addr_rec));
    strcpy(area, atag);

    oldatype = pkt->area_type(origarea);

    if (pmto == NULL)
        mto[0] = 0;
    else
    {
        strncpy(mto,pmto,sizeof(mto)-1); mto[sizeof(mto)-1] = '\0';
    }
    
    if (psubj == NULL)
    {
        reply.subj[0] = 0;
    }
    else
    {
        strncpy(reply.subj,psubj,pkt->subj_len);
        reply.subj[pkt->subj_len] = '\0'; transtxt(reply.subj, inbound);
        strncpy(msg.subj,psubj,pkt->subj_len);
        msg.subj[pkt->subj_len] = '\0'; transtxt(msg.subj, inbound);
    }

    CrossStart = pkt->gettag(area);
    StartReply = pkt->replies+1;

    InCross = 0; crossp = 0; carbon = 0; blindc = 0; InCarbon = 0; Abort = 0;
    userot13 = rot13;
    pgpflags = 0; add_addrbook = 0;
    clearspaces = (opt.wflags & REMOVE_SPACES) > 0;
    if (quote == 2)
    {
        net_crash = (reply.netflags & NET_CRASH) > 0;
        net_direct = (reply.netflags & NET_DIRECT) > 0;
        net_immediate = (reply.netflags & NET_IMMEDIATE) > 0;
        net_hold = (reply.netflags & NET_HOLD) > 0;
        net_killsent = (reply.netflags & NET_KILLSENT) > 0;
        net_fattach = (reply.netflags & NET_FATTACH) > 0;
        net_freq = (reply.netflags & NET_FREQ) > 0;
    }
    else
    {
        net_crash = 0; net_direct = 0; net_immediate = 0; net_hold = 0;
        net_killsent = 0; net_fattach = 0; net_freq = 0;
    }
    strcpy(origmsg, msg.mfrom);
    editing = 0;

    anum = pkt->gettag(area);

    addr = 0;

    num = pkt->area_type(anum);
    if ((fmt == format_hippo) && (num & TYPE_NET) && (num & TYPE_ECHO))
    {
        slen = strlen(reply.subj);
        if (((reply.subj[0] >= '0') && (reply.subj[0] <= '9')) &&
            ((reply.subj[1] == ':') || ((reply.subj[1] >= '0') && (reply.subj[1] <= '9'))) && (slen > 5))
        {
            pstr = strchr(reply.subj,' ');
            if (pstr == NULL)
                spos = slen+1;
            else
                spos = (int) (pstr-reply.subj);

            ch = reply.subj[spos]; reply.subj[spos] = 0;
            str2addr(reply.subj,&zone,&net,&node,&point);
            reply.subj[spos] = ch;
            addr = 1;
            memmove(reply.subj,pstr+1,slen-spos);
        }
    }

carbon_again:

    if (quote != 2 || InCarbon || InCross)
    {
        /* Search next unused reply. */
        max_reply = 0;
        for (;;)
        {
            max_reply++;
            sprintf(tmp,"%s%05u.MSG",setup.replypath,max_reply);

            if (FileStat(tmp, &statbuf) == 0)
            {
                if (max_reply == 65535)
                {
                    err_box("Too many replies! Max. 65535");
                    return 0;
                }
            }
            else
                break;
        }
    }
    if (InCarbon) mto[0] = '\0';

    save_scr(&cx,&cy,&oldscr);
edit_again:
    if (InCross)
        anum = CrossArea;
    else
        anum = pkt->gettag(area);

another_area:
    if (anum == 0)
    {
        if (fmt == format_soup)
        {
            atype = TYPE_ECHO | TYPE_INET | TYPE_NOPVT;
        }
        else
        {
            draw_shaded_box(scrwidth/2-30,10,scrwidth/2+31,15,color[col_warn_frame],color[col_warn_title],"Warning! Area not found!");
            cmiddle(11,area,color[col_warn_hilight]);
            cmiddle(13,"Using all area flags.",color[col_warn_text]);
            cmiddle(14,"Press any key to continue",color[col_warn_hilight]);
            if ((sk_getch()) == 0) sk_getch();
            atype = TYPE_ANYNAME+TYPE_NET+TYPE_ECHO;
        }
    } else atype = pkt->area_type(anum);

    if (atype & TYPE_NOPUB)
    {
        priv = 1;
    }
    else
    {
        if (atype & TYPE_NOPVT)
            priv = 0;
    }

    if (atype & TYPE_NORIGHTS)
    {
        if (crossp)
        {
            num = strlen(pkt->get_area_tag(anum)) >> 1;
            draw_shaded_box(scrwidth/2-17-num,11,scrwidth/2+16+num,15,color[col_warn_frame],color[col_warn_title],NULL);
            sprintf(tmp,lang[154],pkt->get_area_tag(anum));
            cmiddle(13,tmp,color[col_warn_hilight]);
            try_key(2);
            goto over_cross;
        }
        else
        {
            slen = strlen(lang[155])/2;
            draw_shaded_box(scrwidth/2-slen-2,11,scrwidth/2+slen+2,15,color[col_warn_frame],color[col_warn_title],NULL);
            cmiddle(13,lang[155],color[col_warn_hilight]);
            try_key(2);
            old_scr(cx,cy,&oldscr);
            return 0;
        }
    }

    if ((atype & TYPE_ALIAS) == 0)
        strcpy(reply.mfrom, pkt->username);
    else
        strcpy(reply.mfrom, pkt->useralias);

    if (InCross)
        transtxt(strcpy(aname, pkt->get_area_name(CrossArea)),inbound);
    else
        transtxt(strcpy(aname, pkt->get_area_name(pkt->gettag(area))),inbound);

    endy = 13;
    if ((atype & TYPE_ECHO) && (atype & TYPE_NET) && ((atype & TYPE_INET) == 0)) endy++;
    endy2 = (char) (endy+7);

    if (quote == 2 && MsgToYou == 99) goto __over_all_stupid_questions;

    sprintf(tmp,lang[122+quote],aname);
    draw_shaded_box(scrwidth/2-39,6,scrwidth/2+40,endy,color[col_emsg_frame],color[col_emsg_title],tmp);

    cwritexy(scrwidth/2-38,7,lang[126],color[col_emsg_hilight]);
    cwritexy(scrwidth/2-38,8,lang[127],color[col_emsg_hilight]);
    if (atype & TYPE_INET && (atype & TYPE_NET) == 0)
        cwritexy(scrwidth/2-38,9,lang[294],color[col_emsg_hilight]);
    else
        cwritexy(scrwidth/2-38,9,lang[128],color[col_emsg_hilight]);
    if (net_freq || net_fattach)
        cwritexy(scrwidth/2-38,10,lang[129],color[col_emsg_hilight]);
    else
        cwritexy(scrwidth/2-38,10,lang[130],color[col_emsg_hilight]);

    ypos = 14;

    if ((atype & TYPE_ECHO) && (atype & TYPE_NET) && ((atype & TYPE_INET) == 0))
    {
        cwritexy(scrwidth/2-38,11,lang[131],color[col_emsg_hilight]);
        ypos++;
    }

    if (priv)
    {
        ch = lang[132][0];
        writechr(scrwidth/2-32,7,ch,color[col_emsg_text]);
    }
    else
    {
        ch = lang[132][1];
        writechr(scrwidth/2-32,7,ch,color[col_emsg_text]);
    }
    cwritexy(scrwidth/2-38,endy-1,lang[133],color[col_emsg_disabled]);
    cwritexy(scrwidth/2-37+strlen(lang[133]),endy-1,lang[134],color[col_emsg_disabled]);

    highwrite_locol = color[col_emsg_text];
    highwrite_hicol = color[col_emsg_hilight];

    draw_shaded_box(scrwidth/2-39,endy,scrwidth/2+40,endy2,color[col_emsg_frame],color[col_emsg_title],NULL);

    writechr(scrwidth/2-39,endy,LEFT_BRACKET,color[col_emsg_frame]);
    writechr(scrwidth/2+40,endy,RIGHT_BRACKET,color[col_emsg_frame]);
    sprintf(tmp," %s ",lang[135]);
    cwritexy(scrwidth/2-37,endy,tmp,color[col_emsg_title]);
    if ((atype & TYPE_ECHO) && (atype & TYPE_NET) && ((atype & TYPE_INET) == 0))
    {
        draw_shaded_box(scrwidth/2-39,endy2,scrwidth/2+40,endy2+4,color[col_emsg_frame],color[col_emsg_title],NULL);
        writechr(scrwidth/2-39,endy2,LEFT_BRACKET,color[col_emsg_frame]);
        writechr(scrwidth/2+40,endy2,RIGHT_BRACKET,color[col_emsg_frame]);
        sprintf(tmp," %s ",lang[136]);
        cwritexy(scrwidth/2-37,endy2,tmp,color[col_emsg_title]);
        keys[12] = toupper(_highwrite(scrwidth/2-37,endy2+1,lang[137],&keypos[0],!pkt->allow_crash));
        keys[13] = toupper(_highwrite(scrwidth/2-37,endy2+2,lang[138],&keypos[1],!pkt->allow_direct));
        keys[14] = toupper(_highwrite(scrwidth/2-37,endy2+3,lang[139],&keypos[2],!pkt->allow_immediate));
        keys[15] = toupper(_highwrite(scrwidth/2+15,endy2+1,lang[140],&keypos[3],!pkt->allow_fattach));
        keys[16] = toupper(_highwrite(scrwidth/2+15,endy2+2,lang[141],&keypos[4],!pkt->allow_net_freq));
        keys[17] = toupper(_highwrite(scrwidth/2-5,endy2+1,lang[142],&keypos[5],!pkt->allow_hold));
        keys[18] = toupper(_highwrite(scrwidth/2-5,endy2+2,lang[143],&keypos[6],!pkt->allow_killsent));
        if (net_crash) writechr(scrwidth/2-36,endy2+1,CHECK,color[col_emsg_hilight]);
        if (net_direct) writechr(scrwidth/2-36,endy2+2,CHECK,color[col_emsg_hilight]);
        if (net_immediate) writechr(scrwidth/2-36,endy2+3,CHECK,color[col_emsg_hilight]);
        if (net_fattach) writechr(scrwidth/2+16,endy2+1,CHECK,color[col_emsg_hilight]);
        if (net_freq) writechr(scrwidth/2+16,endy2+2,CHECK,color[col_emsg_hilight]);
        if (net_hold) writechr(scrwidth/2-4,endy2+1,CHECK,color[col_emsg_hilight]);
        if (net_killsent) writechr(scrwidth/2-4,endy2+2,CHECK,color[col_emsg_hilight]);
        ch = (char) (endy2+4);
        keyb_keys = 19;
    }
    else
    {
        ch = endy2;
        keyb_keys = 12;
    }
    sprintf(tmp," %s ",lang[144]);
    cmiddle(ch,tmp,color[col_emsg_title]);

    keys[0] = 'A';
    keys[1] = toupper(_highwrite(scrwidth/2-37,endy+1,lang[145],&keypos[1],0));
    keys[2] = toupper(_highwrite(scrwidth/2-37,endy+2,lang[146],&keypos[2],0));
    if (opt.signature != NULL) {
        usesig = 1;
        writechr(scrwidth/2-36,endy+2,CHECK,color[col_emsg_hilight]);
    } else usesig = 0;

    if ((atype & TYPE_NOTAGS) > 0)
        disabled = 1;
    else
        disabled = 0;

    keys[3] = toupper(_highwrite(scrwidth/2-37,endy+3,lang[147],&keypos[3],disabled));
    keys[7] = toupper(highwrite(scrwidth/2-37,endy+4,lang[148],&keypos[7]));
    keys[10] = toupper(_highwrite(scrwidth/2-37,endy+5,lang[280],&keypos[9],0));
    keys[8] = toupper(_highwrite(scrwidth/2-37,endy+6,lang[149],&keypos[8],(quote != 1) || (editing)));

    if (atype & TYPE_NOTAGS || (!usetag && editing))
        usetag = 0;
    else
        usetag = (opt.taglines != TAGLINE_NONE);

    if (!usetag)
        writechr(scrwidth/2-36,endy+3,CHECK,color[col_emsg_hilight]);

    right_pos = get_max_langtext_len(150,153);
    right_pos = scrwidth/2+39-right_pos+(right_pos & 1);

    if (InCarbon || InCross) disabled = 1;
    keys[4] = toupper(_highwrite(right_pos,endy+1,lang[150],&keypos[4],disabled));

    if (((atype & TYPE_ECHO) && ((atype & TYPE_NET) == 0)) || (InCarbon) || (InCross))
    {
        if ((atype & TYPE_ECHO) && (((atype & TYPE_NET) == 0)))
        {
            carbon = 0;
            blindc = 0;
        }
        disabled = 1;
    } else
        disabled = 0;

    keys[5] = toupper(_highwrite(right_pos,endy+2,lang[151],&keypos[5],disabled));
    keys[6] = toupper(_highwrite(right_pos,endy+3,lang[152],&keypos[6],disabled));
    keys[9] = toupper(highwrite(right_pos,endy+4,lang[153],&keypos[9]));
    keys[11] = toupper(_highwrite(right_pos,endy+5,lang[281],&keypos[10],0));

    disabled = 0;
    if (userot13) writechr(scrwidth/2-36,endy+4,CHECK,color[col_emsg_hilight]);
    if (crossp) writechr(right_pos+1,endy+1,CHECK,color[col_emsg_hilight]);
    if (carbon) writechr(right_pos+1,endy+2,CHECK,color[col_emsg_hilight]);
    if (blindc) writechr(right_pos+1,endy+3,CHECK,color[col_emsg_hilight]);
    if (clearspaces) writechr(scrwidth/2-36,endy+6,CHECK,color[col_emsg_hilight]);

    highwrite_locol = color[col_box_text];
    highwrite_hicol = color[col_box_hilight];

    usefile = 0;

    switch (quote)
    {
        case 1:
            if (pkt->area_type(origarea) & TYPE_NET)
            {
                zone = msg.zone;
                net = msg.net;
                node = msg.node;
                point = msg_point;
            }
            else
            {
                strcpy(tmp,pkt->origin_line);
                pstr2 = tmp;
                for (;;)
                {
                    if ((pstr = strchr(pstr2,'(')) == NULL) break;
                    pstr2 = pstr+1;
                }
                if (pstr2 != NULL)
                {
                    while ((pstr = strchr(pstr2,' ')) != NULL) pstr2 = pstr+1;
                    while ((pstr = strrchr(pstr2,' ')) != NULL) *pstr = 0;
                    while ((pstr = strrchr(pstr2,'@')) != NULL) *pstr = 0;
                    str2addr(pstr2,&zone,&net,&node,&point);
                }
                else
                {
                    zone = 0; net = 0; node = 0; point = 0;
                }
            }
            break;
        case 2:
            zone = reply.destzone;
            net = reply.destnet;
            node = reply.destnode;
            point = (unsigned short) reply.destpoint;
            break;
        default:
            if (!editing &&  !InCarbon)
            {
                zone = 0; net = 0; node = 0; point = 0;
            }
            break;
    }

    import_file[0] = 0;
    key_xpos = 0; key_xovr = 0;

    quit = 0;
    ypos = 3;

    if (0)
    {
    __adopt_addr:
        if (addr_rec.zone != 0)
        {
            zone = addr_rec.zone;
            net = addr_rec.net;
            node = addr_rec.node;
            point = addr_rec.point;
        }
        if (atype & TYPE_INET && atype & TYPE_NET)
        {
            /* E-Mail area */
            if (addr_rec.inet[0] != '\0') strcpy(mto,addr_rec.inet);
        }
        else if (addr_rec.to_field[0] != '\0' && (atype & TYPE_INET) == 0)
            strcpy(mto,addr_rec.to_field);

        if (addr_rec.subject[0] != '\0') strcpy(reply.subj,addr_rec.subject);
    }

    cwritexy(scrwidth/2-32,8,reply.mfrom,color[col_emsg_text]);
    ch = mto[72]; mto[72] = '\0';
    cwritexy(scrwidth/2-32,9,mto,color[col_emsg_text]); mto[72] = ch;
    slen = strlen(reply.subj);
    if (slen > 72) { ch = reply.subj[72]; reply.subj[72] = '\0'; }
    cwritexy(scrwidth/2-32,10,reply.subj,color[col_emsg_text]);
    if (slen > 72) reply.subj[72] = ch;

    if ((atype & TYPE_ECHO) && (atype & TYPE_NET) && (atype & TYPE_INET) == 0)
    {
        sprintf(tmp,"%u:%u/%u.%u",zone,net,node,point);
        cwritexy(scrwidth/2-32,11,tmp,color[col_emsg_text]);
    }

    while (!quit)
    {
        switch (ypos)
        {
            case 1:
                /* private */
                if (priv) tmp[0] = lang[132][0]; else tmp[0] = lang[132][1];
                tmp[1] = 0;
                do
                {
                    info = get_string(scrwidth/2-32,7,1,1,tmp,5+8+128+256,color[col_emsg_selfieldtxt],color[col_emsg_selfieldback],0);
                    if (key_found == keys[11])
                    {
                        if (address_book(&addr_rec)) goto __adopt_addr;
                    }
                    else if (key_found != 0)
                    {
                        if (do_keys(endy,endy2,area,(quote == 1) && (!editing)))
                            goto another_area;
                    }
                }
                while (key_found != 0);
                priv = (tmp[0] == lang[132][0]);
                if (priv) ch = lang[132][0]; else ch = lang[132][1];
                writechr(scrwidth/2-32,7,ch,color[col_emsg_text]);
                break;
            case 2:
                /* From */
                do {
                    info = get_string(scrwidth/2-32,8,pkt->from_to_len,pkt->from_to_len,reply.mfrom,4+8+128+256,
                                      color[col_emsg_selfieldtxt],color[col_emsg_selfieldback],0);
                    tattrbar(scrwidth/2-32,8,scrwidth/2-32+pkt->from_to_len,8,color[col_emsg_text]);
                    if (key_found == keys[11])
                    {
                        if (address_book(&addr_rec)) goto __adopt_addr;
                    }
                    else if (key_found != 0)
                    {
                        if (do_keys(endy,endy2,area,(quote == 1) && (!editing)))
                            goto another_area;
                    }
                } while (key_found != 0);
                break;
            case 3:
                /* To */
                do {
                    if (atype & TYPE_INET)
                    {
                        info = get_string(scrwidth/2-32,9,fmt != format_soup ? 99 : sizeof(mto)-1,72,mto,4+8+128+256,
                                          color[col_emsg_selfieldtxt],color[col_emsg_selfieldback],0);
                        tattrbar(scrwidth/2-32,9,scrwidth/2-32+71,9,color[col_emsg_text]);
                    }
                    else
                    {
                        info = get_string(scrwidth/2-32,9,pkt->from_to_len,pkt->from_to_len,mto,4+8+128+256,
                                          color[col_emsg_selfieldtxt],color[col_emsg_selfieldback],0);
                        tattrbar(scrwidth/2-32,9,scrwidth/2-32+pkt->from_to_len,9,color[col_emsg_text]);
                    }

                    if (key_found == keys[11])
                    {
                        if (address_book(&addr_rec)) goto __adopt_addr;
                    }
                    else if (key_found != 0)
                    {
                        if (do_keys(endy,endy2,area,(quote == 1) && (!editing)))
                            goto another_area;
                    }
                } while (key_found != 0);

                ok = 0;
                if (mto[0] == '!')
                {
                    /* Quickkey to address book */
                    if (!get_quickkey(0,mto+1))
                    {
                        /* Not found */
                        err_box(lang[290]);
                    }
                    else ok = 1;
                }
                else if (mto[0] == '%')
                {
                    /* Quickkey to mailing list */
                    if (!get_quickkey(1,mto+1))
                    {
                        /* Not found */
                        err_box(lang[291]);
                    }
                    else
                    {
                        ok = 1;
                        // laita carbon copyt plle ym.
                    }
                }

                if (ok)
                {
                    if (atype & TYPE_INET)
                    {
                        if (tempaddr.inet[0] != '\0') strcpy(mto,tempaddr.inet);
                    }
                    else
                    {
                        if (tempaddr.to_field[0] != '\0') strcpy(mto,tempaddr.to_field);
                    }
                    if (tempaddr.subject[0] != '\0') strcpy(reply.subj,tempaddr.subject);
                    if (tempaddr.zone != 0)
                    {
                        zone = tempaddr.zone; net = tempaddr.net;
                        node = tempaddr.node; point = tempaddr.point;
                    }
                    cwritexy(scrwidth/2-32,9,mto,color[col_emsg_text]);
                    cwritexy(scrwidth/2-32,10,reply.subj,color[col_emsg_text]);
                    if ((atype & TYPE_ECHO) && (atype & TYPE_NET) && (atype & TYPE_INET) == 0)
                    {
                        sprintf(tmp,"%u:%u/%u.%u",zone,net,node,point);
                        cwritexy(scrwidth/2-32,11,tmp,color[col_emsg_text]);
                    }
                }
                strcpy(reply.mto,mto);
                break;
            case 4:
                /* Subject */
                do {
                    info = get_string(scrwidth/2-32,10,pkt->subj_len,72,reply.subj,4+8+128+256,
                                      color[col_emsg_selfieldtxt],color[col_emsg_selfieldback],0);
                    tattrbar(scrwidth/2-32,10,scrwidth/2-32+71,10,color[col_emsg_text]);
                    if (key_found == keys[11])
                    {
                        if (address_book(&addr_rec)) goto __adopt_addr;
                    }
                    else if (key_found != 0)
                    {
                        if (do_keys(endy,endy2,area,(quote == 1) && (!editing)))
                            goto another_area;
                    }
                } while (key_found != 0);
                break;
            case 5:
                /* Netmail address */
                sprintf(tmp,"%u:%u/%u.%u",zone,net,node,point);
                do {
                    info = get_string(scrwidth/2-32,11,23,23,tmp,4+8+128+256,color[col_emsg_selfieldtxt],color[col_emsg_selfieldback],0);
                    if (key_found == keys[11])
                    {
                        if (address_book(&addr_rec)) goto __adopt_addr;
                    }
                    else if (key_found != 0)
                    {
                        if (do_keys(endy,endy2,area,(quote == 1) && (!editing)))
                            goto another_area;
                    }
                } while (key_found != 0);
                str2addr(tmp,&zone,&net,&node,&point);

                sprintf(tmp,"%u:%u/%u.%u",zone,net,node,point);

                tbar(scrwidth/2-32,11,scrwidth/2-9,11,color[col_emsg_text]);
                cwritexy(scrwidth/2-32,11,tmp,color[col_emsg_text]);
                break;
        }

        switch (info)
        {
            case 0:
                if ((((atype & TYPE_NET) == 0) || (atype & TYPE_INET)) && (ypos == 4) || (ypos == 5))
                {
                    quit = 1;
                    break;
                }
            case 1:
                if ((atype & TYPE_NET) == 0 || atype & TYPE_INET)
                {
                    switch (ypos)
                    {
                        case 1:
                            if ((atype & TYPE_ANYNAME) == 0)
                                ypos = 3;
                            else
                                ypos = 2;
                            break;
                        case 2:
                        case 3:
                            ypos++;
                            break;
                        case 4:
                            if (((atype & TYPE_NOPUB) == 0) && ((atype & TYPE_NOPVT) == 0))
                                ypos = 1;
                            else
                                if ((atype & TYPE_ANYNAME) == 0)
                                    ypos = 3;
                                else
                                    ypos = 2;
                                break;
                    }
                }
                else
                {
                    switch (ypos)
                    {
                        case 1:
                            if ((atype & TYPE_ANYNAME) == 0)
                                ypos = 3;
                            else
                                ypos = 2;
                            break;
                        case 2:
                        case 3:
                        case 4:
                            ypos++;
                            break;
                        case 5:
                            if (((atype & TYPE_NOPUB) == 0) && ((atype & TYPE_NOPVT) == 0))
                                ypos = 1;
                            else
                                if ((atype & TYPE_ANYNAME) == 0)
                                    ypos = 3;
                                else
                                    ypos = 2;
                                break;
                    }
                }
                break;
            case 2:
                ypos--;
                if ((ypos == 2) && ((atype & TYPE_ANYNAME) == 0)) ypos--;
                if ((ypos == 1) && (((atype & TYPE_NOPUB) > 0) || ((atype & TYPE_NOPVT) > 0))) ypos--;
                if (ypos == 0)
                    if ((atype & TYPE_ECHO) && (atype & TYPE_NET) && ((atype & TYPE_INET) == 0))
                        ypos = 5;
                    else
                        ypos = 4;
                    break;
            case 3: quit = 1; break;
            case 5:
                if (InCross) goto over_cross;
                if (InCarbon)
                {
                    if (carbon)
                    {
                        strcat(strcpy(tmp,setup.workpath),"CARBON.MSG");
                        for (num=StartReply; num<=pkt->replies; num++)
                        {
                            pkt->read_reply(num);
                            strcat(strcpy(tmp2,setup.replypath),reply.fname);
                            if ((Ftext = FileOpen(tmp2,"w+b")) == NULL)
                            {
                                tclrscr();
                                printf("Error creating file '%s'\n",tmp2);
                                sk_getch();
                                exit(1);
                            }
                            first = 1;
                            for (usr=StartReply; usr<=pkt->replies; usr++)
                            {
                                if (usr != num)
                                {
                                    pkt->read_reply(usr);
                                    if (first)
                                    {
                                        first = 0;
                                        fprintf(Ftext,"%s",conv_macros(lang[299],tmp2));
                                    }
                                    else
                                    {
                                        fprintf(Ftext,"%s",conv_macros(lang[300],tmp2));
                                    }
                                }
                            }
                            fprintf(Ftext,"\r\n");
                            
                            pkt->read_reply(num);
                            if ((F = FileOpen(tmp,"rb")) == NULL)
                            {
                                tclrscr();
                                printf("Error opening file '%s'\n",tmp);
                                exit(1);
                            }
                            
                            do {
                                readed = fread(tmp2,1,sizeof(tmp2),F);
                                if (readed > 0)
                                    fwrite(tmp2,1,readed,Ftext);
                            } while (readed == sizeof(tmp2));
                            
                            fclose(F); fclose(Ftext);
                        }
                    }
                    FileRemove(strcat(strcpy(tmp,setup.workpath),"CARBON.MSG"));
                    old_scr(cx,cy,&oldscr);
                    return 1;
                }
                if (editing)
                {
                    quit = 1;
                }
                else
                {
                    old_scr(cx,cy,&oldscr);
                    return 0;
                }
                break;
        }
    }

    if ((InCarbon))
    {
        sprintf(tmp,"%s%05u.MSG",setup.replypath,max_reply);
        copyfile(strcat(strcpy(tmp2,setup.workpath),"CARBON.MSG"),tmp);
        goto make_header;
    }

    if (InCross)
    {
        sprintf(tmp,"%s%05u.MSG",setup.replypath,max_reply);
        if ((Ftext = FileOpen(tmp,"w+b")) == NULL)
        {
            tclrscr();
            printf("Error creating file '%s'\n",tmp);
            exit(1);
        }
        strcpy(areaname, pkt->get_area_name(CrossStart));
        fprintf(Ftext,"%s\r\n",conv_macros(lang[298],tmp));
        
        strcat(strcpy(tmp,setup.workpath),"CARBON.MSG");
        if ((F = FileOpen(tmp,"r+b")) == NULL)
        {
            tclrscr();
            printf("Error opening file '%s'\n",tmp);
            exit(1);
        }
        do {
            readed = fread(tmp,1,sizeof(tmp),F);
            if (readed)
                fwrite(tmp,1,readed,Ftext);
        } while (readed != 0);
        fclose(F); fclose(Ftext);
        goto make_header;
    }

    if ((quote == 2) || (editing))
    {
        old_scr(cx,cy,&oldscr); save_scr(&cx,&cy,&oldscr);
        if (!ask_edit())
        {
            if (editing) goto _overdone;
            if ((carbon) || (blindc)) goto do_carbon;

            if (crossp)
            {
                if (editing)
                {
                    pkt->export_reply(msgnum,strcat(strcpy(tmp,setup.workpath),"CARBON.MSG"));
                }
                else
                {
                    copyfile(strcat(strcpy(tmp,setup.replypath),reply.fname),
                             strcat(strcpy(tmp2,setup.workpath),"CARBON.MSG"));
                }
            }
            goto make_header;
        }
    }

    if ((quote == 1) && (!editing))
    {
        /* Decrypt PGP message */
        if (pgpflags & 0x08)
        {
            pgp_decrypt_msg();
            pkt->deinit_msgtext();
            sprintf(tmp,"%ssky_pgp.tmp", setup.replypath);
            if (!pkt->init_replytext(tmp))
            {
                note_box("Can't read PGP output!");
                pkt->deinit_replytext();
                pkt->init_text();
                pgpflags &= ~0x08;
            }
        }

        if ((Ftext = FileOpen(setup.msgtxt,"w+b")) == NULL)
        {
            tclrscr();
            printf("Error creating file '%s'\n",tmp);
            exit(1);
        }
        addcr = 0;
        if (addr_rec.first_line[0] != '\0')
        {
            fprintf(Ftext,"%s\r\n",conv_macros(addr_rec.first_line,tmp2));
        }

        if (replyanother)
        {
            fprintf(Ftext,"%s",conv_macros(lang[297],tmp2));
            addcr = 1;
        }
        if (opt.wflags & INSERT_QUOTE)
        {
            /* Insert quote header */
            if (((opt.wflags & QUOTE_NOT4U) == 0) || (!MsgToYou))
            {
                fprintf(Ftext,"%s",conv_macros(opt.quotehdr,tmp2));
                addcr = 1;
            }
        }
        if (opt.wflags2 & SUBJ_HEADER && psubj != NULL && stricmp(msg.subj,reply.subj) != 0)
        {
            /* Insert "subject changed" text */
            fprintf(Ftext,"%s",conv_macros(lang[301],tmp2));
            addcr = 1;
        }

        if (addcr) fprintf(Ftext,"\r\n");

        QuoteStyle = opt.quote;
        out[0] = 0;

        start_quoting(origmsg);
        if ((pgpflags & 0x08) == 0)
        {
            oldjustify = setup.justify;
            setup.justify = JUSTIFY_NONE;
            pkt->init_text();
        }

        oldtxtlen = pkt->txt_length;
        pkt->txt_length = 79;
        for (msgline=1; msgline<=pkt->txt_lines; msgline++)
        {
            if (pgpflags & 0x08)
                pkt->read_replyline(tmp,msgline);
            else
                pkt->read_line(tmp,msgline);
        q_again:
            slen = strlen(tmp);
            while (((tmp[slen-1] == 9) || (tmp[slen-1] == 32)) && (slen > 0)) slen--;
            tmp[slen] = 0;
            
            if ((slen >= 3) && (tmp[0] == '-') && (tmp[1] == '-') && (tmp[2] == '-'))
                if ((slen == 3) || (tmp[3] == ' ')) tmp[1] = '!';
            
            ch = tmp[10]; tmp[10] = 0;
            if ((slen >= 10) && (strcmp(tmp," * Origin:") == 0)) tmp[1] = '!';
            tmp[10] = ch;
            
            if ((slen > 1) && (tmp[0] == '\001')) tmp[0] = '@';
            
            
            /* ---- Quoting part ---- */
            
            found = 0;
            if (clearspaces)
            {
                for (num=0; num<slen; num++)
                    if (!((tmp[num] == 9) || (tmp[num] == ' '))) {
                        found = 1;
                        break;
                    }
                if (found) memmove(tmp,tmp+num,slen-num+1);
            }
            quote_line(tmp);
            
            /* ---- Quoting part ended ---- */
            
        }
        finish_quoting();
        pkt->txt_length = oldtxtlen;
        if ((pgpflags & 0x08) == 0)
        {
            setup.justify = oldjustify;
            pkt->init_text();
        }

        if (out[0] != 0)
        {
            strcpy(tmp,out);
            out[0] = 0;
            goto q_again;
        }
        fprintf(Ftext,"\r\n");
        fclose(Ftext);

        if (pgpflags & 0x08)
        {
            pkt->deinit_replytext();
            FileRemove(strcat(strcpy(tmp,setup.replypath),"sky_pgp.tmp"));
            pkt->deinit_replytext();
            pkt->init_text();
        }
    }
    else
    {
        if ((quote == 2) || (editing))
        {
        __over_all_stupid_questions:
            if (editing)
            {
                pkt->export_reply(msgnum,setup.msgtxt);
            }
            else
            {
                sprintf(tmp,"%s%05lu.MSG",setup.replypath,msgnum);
                pkt->export_reply(msgnum,tmp);
            }

            if (!editing)
            {
                FileRemove(setup.msgtxt);
                sprintf(tmp2,"%s%s", setup.replypath, reply.fname);
                copyfile(tmp2,setup.msgtxt);
            }
        }
        else if ((quote == 3) && (!editing))
        {
            if ((Ftext = FileOpen(setup.msgtxt,"w+b")) == NULL)
            {
                tclrscr();
                printf("Could not create file '%s'\n",tmp);
                exit(1);
            }

            for (num=0; num<=6; num++)
                fprintf(Ftext,"%s",conv_macros(lang[302+num],tmp2));

            for (num=1; num<=pkt->txt_lines; num++)
            {
                pkt->read_line(tmp,num); slen = strlen(tmp);
                while (((tmp[slen-1] == 9) || (tmp[slen-1] == ' ')) && (slen > 0)) slen--;
                tmp[slen] = 0;

                if ((tmp[0] == '-') && (tmp[1] == '-') && (tmp[2] == '-')
                    && ((tmp[3] == ' ') || (tmp[3] == 0))) tmp[1] = '!';

                ch = tmp[10]; tmp[10] = 0;
                if ((slen >= 10) && (strcmp(tmp," * Origin:") == 0)) tmp[1] = '!';
                tmp[10] = ch;

                if ((slen > 1) && (tmp[0] == '\001')) tmp[0] = '@';

                fprintf(Ftext,"%s\r\n",tmp);
            }
            fprintf(Ftext,"%s",conv_macros(lang[309],tmp2));
            fclose(Ftext);
            old_scr(cx,cy,&oldscr); save_scr(&cx,&cy,&oldscr);
            if (!ask_edit()) goto _overdone;
        }
        else if (addr_rec.first_line[0] != '\0')
        {
            if ((Ftext = FileOpen(setup.msgtxt,"w+b")) == NULL)
            {
                tclrscr();
                printf("Error creating file '%s'\n",tmp);
                exit(1);
            }
            fprintf(Ftext,"%s\r\n",conv_macros(addr_rec.first_line,tmp2));
            fclose(Ftext);
        }
    }

    /* Save file date and size for later use */

    if (quote > 0 || editing)
    {
        convert(setup.msgtxt,inbound);
#ifdef __linux__
        remove_chars(setup.msgtxt,0);
#else
        if (fmt == format_soup) remove_chars(setup.msgtxt,1);
#endif
    }
    else if (addr_rec.first_line[0] == '\0')
    {
        FileRemove(setup.msgtxt);
    }

    old_file_size = 0;
    oldtime = 0;
    if ((quote == 1 && !editing) || (quote == 0 && addr_rec.first_line[0] != '\0'))
    {
        if (FileStat(setup.msgtxt,&statbuf) == 0)
        {
            old_file_size = statbuf.st_size;
            oldtime = *ST_MTIME(statbuf);
        }
    }

    /* Insert file into message text */
    
    if (usefile)
    {
        if ((F = FileOpen(import_file,"rb")) != NULL)
        {
            if (quote > 0)
            {
                Ftext = FileOpen(setup.msgtxt,"r+b");
                fseek(Ftext,0,SEEK_END);
            }
            else
            {
                Ftext = FileOpen(setup.msgtxt,"w+b");
            }

            do {
                readed = fread(tmp,1,sizeof(tmp),F);
                if (readed)
                    fwrite(tmp,1,readed,Ftext);
            } while (readed == sizeof(tmp));
            fclose(F); fclose(Ftext);

            old_scr(cx,cy,&oldscr); save_scr(&cx,&cy,&oldscr);
            if (!ask_edit()) goto _overdone;
        }
    }

    /* Add PGP public key to end of message */
    if (pgpflags & 0x01) pgp_post_key();

    /* Start text editor */

#ifndef __NO_DRIVES__
    _dos_getdrive(&drive);
#endif
    getcwd(tmp,sizeof(tmp));
    cursorsize(c_height-3,c_height-2);

    if (opt.editor[0] == 0)
    {
        if (strcmp(setup.editor, "!") == 0)
            tmp2[0] = '\0';
        else
            sprintf(tmp2,"%s %s",setup.editor,setup.msgtxt);
    }
    else
    {
        if (strcmp(opt.editor, "!") == 0)
            tmp2[0] = '\0';
        else
            sprintf(tmp2,"%s %s",opt.editor,setup.msgtxt);
    }
    if (tmp2[0] == '\0')
        fs_editor(setup.msgtxt);
    else
    {
        tclrscr();
        pstr = strchr(tmp2,' '); *pstr = 0;
        swapexec(tmp2,pstr+1,0);
    }

    nocursor();
#ifndef __NO_DRIVES__
    _dos_setdrive(drive,&drives);
#endif
    ChangeDir(tmp);

_overdone:

    /* Check if editing was aborted */

    if ((F = FileOpen(setup.msgtxt,"r+b")) == NULL)
    {
        Abort = 1;
        goto _end;
    }
    fstat(fileno(F),&statbuf);

    if (((!editing && quote == 1) || (quote == 0 && addr_rec.first_line[0] != '\0')) && *ST_MTIME(statbuf) == oldtime && statbuf.st_size == old_file_size)
    {
        fclose(F);
        Abort = 1;
        goto _end;
    }

    sol = 1;
    while ((readed = fread(tmp,1,sizeof(tmp),F)) > 0)
    {
        writeit = 0;
        for (lnum=0; lnum<readed; lnum++)
        {
            switch (tmp[lnum])
            {
                case 13:
                    sol = 1;
                    break;
                case 10:
                    break;
                case 0:
                    tmp[lnum] = ' ';
                    writeit = 1;
                    break;
                case 1:
                    if (sol)
                    {
                        tmp[lnum] = '@';
                        writeit = 1;
                    }
                    break;
                case 26:
                    if (!sol)
                    {
                        tmp[lnum] = ' ';
                        writeit = 1;
                    }
                    else
                    {
                        lnum = ftell(F)-readed+lnum;
                        if (writeit) {
                            fseek(F,-readed,SEEK_CUR);
                            fwrite(tmp,1,readed,F);
                        }
                        fseek(F,0,SEEK_SET);
                        ftrunc(F,lnum);
                        goto __over;
                    }
                    break;
                default:
                    sol = 0;
                    break;
            }
        }
        if (writeit)
        {
            fseek(F,-readed,SEEK_CUR);
            fwrite(tmp,1,readed,F);
        }
    }
__over:

    fseek(F,0,SEEK_END);
    lnum = ftell(F);
    if (lnum < sizeof(tmp)) num = (unsigned) lnum; else num = sizeof(tmp);

    /* Strip off CRs and LFs from end of file */
    while (lnum > 0)
    {
        fseek(F,-num,SEEK_CUR);
        if (fread(tmp,1,num,F) != num) break;
        fseek(F,-num,SEEK_CUR);

        pstr = tmp+num-1;
        while (pstr > tmp && (*pstr == 13 || *pstr == 10)) pstr--;
        if (pstr != tmp)
        {
            lnum = lnum-num + (pstr-tmp)+1;
            break;
        }

        if (num > lnum) break;
        lnum -= num;
    }
    ftrunc(F, lnum);

    fseek(F, 0, SEEK_END);
    fprintf(F, "\r\n");

    fclose(F);

    old_scr(cx,cy,&oldscr);
    save_scr(&cx,&cy,&oldscr);

    /* If AUTO_SAVE not on, display "save msg?" box */

    if ((quote != 2) & ((opt.wflags & AUTO_SAVE) == 0))
    {
    __blah:
        switch (edit_msg())
        {
            case 2: editing = 1; goto edit_again;
            case 3: goto _end;
            case 4:
                tclrscr();
                strcpy(tmp2,setup.spellchk);
                pstr = strchr(tmp2,' '); *pstr = 0;

#ifndef __NO_DRIVES__
                _dos_getdrive(&drive);
#endif
                getcwd(tmp,sizeof(tmp));
                cursorsize(c_height-3,c_height-2);

                swapexec(tmp2,pstr+1,0);

                nocursor();
#ifndef __NO_DRIVES__
                _dos_setdrive(drive,&drives);
#endif
                ChangeDir(tmp);

                old_scr(cx,cy,&oldscr);
                save_scr(&cx,&cy,&oldscr);
                goto __blah;
        }
    }

    editing = 0;

    /* Add tagline */
    if ((quote != 2) && (opt.tagfile[0] != 0) && (usetag) && ((setup.misc_flags & MISC_TAG_AFTER_SIG) == 0))
        make_tagline(1);

    if (pgpflags & 0x02) pgp_sign_msg();
    if (pgpflags & 0x04) pgp_encrypt_msg(mto);

    /* Add signature file */

    if ((quote != 2) && (usesig) && ((Fsig = FileOpen(opt.signature,"rb")) != NULL))
    {
        if ((Ftext = FileOpen(setup.msgtxt,"r+b")) != NULL)
        {
            fseek(Ftext,0,SEEK_END);
            while (fgets(tmp,sizeof(tmp),Fsig) != NULL)
            {
                if (tmp[0] == 26) break;
                if (tmp[0] == 1) tmp[0] = '@';
                slen = strlen(tmp);
                for (num=0; num<slen; num++)
                    if (tmp[num] == 26) tmp[num] = ' ';
                fprintf(Ftext,"%s",conv_macros(tmp,tmp2));
            }
            fclose(Ftext);
        }
        fclose(Fsig);
    }

    if ((quote != 2) && (opt.tagfile[0] != 0) && (usetag) && (setup.misc_flags & MISC_TAG_AFTER_SIG))
        make_tagline(1);

    convert(setup.msgtxt,outbound);
//#ifdef __linux__
    if (fmt != format_soup)
        remove_chars(setup.msgtxt,1);
    else
        remove_chars(setup.msgtxt,0);
//#else
//    remove_chars(setup.msgtxt,10,13);
//#endif
    if (userot13) rot13file(setup.msgtxt);

    sprintf(tmp,"%s%c",setup.replypath,SLASH);
    if ((quote == 2))
        strcat(strcpy(tmp,setup.replypath),reply.fname);
    else
        sprintf(tmp,"%s%05u.MSG",setup.replypath,max_reply);

    if (FileRename(setup.msgtxt,tmp) != 0)
    {
        if (copyfile(setup.msgtxt,tmp)) FileRemove(setup.msgtxt);
    }

do_carbon:
    if (blindc || carbon || crossp)
    {
        if (quote == 2)
            strcat(strcpy(tmp,setup.replypath),reply.fname);
        else
            sprintf(tmp,"%s%05u.MSG",setup.replypath,max_reply);

        copyfile(tmp,strcat(strcpy(tmp2,setup.workpath),"CARBON.MSG"));
    }

make_header:
    transtxt(reply.mfrom,outbound);
    transtxt(strcpy(reply.mto,mto),outbound);
    transtxt(reply.subj,outbound);

    reply.destzone = zone;
    reply.destnet = net;
    reply.destnode = node;
    reply.destpoint = point;

    if (InCross)
        strcpy(reply.area, pkt->get_area_tag(CrossArea));
    else
        strcpy(reply.area, area);

    reply.netflags = 0;
    reply.flags = 0;
    if (quote != 2)
    {
        sprintf(reply.fname,"%05u.MSG",max_reply);
        reply.replyto = msgnum;
    }
    else
    {
        if ((InCarbon) || (InCross))
            sprintf(reply.fname,"%05u.MSG",max_reply);
    }

    if (atype & TYPE_INET && atype & TYPE_NET)
        reply.flags |= flag_email;
    else if (atype & TYPE_NET)
        reply.flags |= flag_netmail;

    if ((atype & TYPE_ANYNAME) || (atype & TYPE_ALIAS)) reply.flags |= flag_alias;
    if (priv) reply.flags |= flag_private;

    if (net_crash) reply.netflags |= NET_CRASH;
    if (net_direct) reply.netflags |= NET_DIRECT;
    if (net_immediate) reply.netflags |= NET_IMMEDIATE;
    if (net_hold) reply.netflags |= NET_HOLD;
    if (net_killsent) reply.netflags |= NET_KILLSENT;
    if (net_fattach) reply.netflags |= NET_FATTACH;
    if (net_freq) reply.netflags |= NET_FREQ;

    if ((quote == 2) && (!InCarbon) && (!InCross))
        pkt->edit_msg(msgnum);
    else
        split_message(max_reply); /* pkt->enter_msg() in this */

    replyanother = 0;

    if ((blindc) || (carbon))
    {
        InCarbon = 1;
        old_scr(cx,cy,&oldscr);
        goto carbon_again;
    }

    if (crossp)
    {
        if (!InCross)
        {
            old_scr(cx,cy,&oldscr);
            save_scr(&cx,&cy,&oldscr);
            if (!select_cross_areas()) goto _end;
            CrossArea = 0;
            InCross = 1;
        }

    over_cross:
        if (InCross)
        {
            for (++CrossArea; CrossArea<=pkt->areas; CrossArea++)
            {
                if ((area_tagged(CrossArea)) && (CrossArea != CrossStart))
                {
                    old_scr(cx,cy,&oldscr);
                    goto carbon_again;
                }
            }
            FileRemove(strcat(strcpy(tmp,setup.workpath),"CARBON.MSG"));
            fclose(Ftag);
            sprintf(tmp, "%satagged.dat", setup.workpath); FileRemove(tmp);
        }
    }
_end:
    old_scr(cx,cy,&oldscr);
    FileRemove(setup.msgtxt);

    if (add_addrbook)
    {
        /* Adopt info to address book */
        adopt_address(3, atype & TYPE_INET && atype & TYPE_NET);
    }

    if (Abort)
    {
        save_scr(&cx,&cy,&oldscr);
        slen = strlen(lang[156])/2;
        draw_shaded_box(scrwidth/2-slen-2,10,scrwidth/2+slen+2,14,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(12,lang[156],color[col_warn_hilight]);
        try_key(2);
        old_scr(cx,cy,&oldscr);
        return 0;
    }

    return 1;
}
