#ifndef __CHECKCRC_H
#define __CHECKCRC_H

#include <stdio.h>
#include <string.h>
#include "crclist.h"

void first_func(void);
void last_func(void);

int checkcrc(void)
{
    char *scan, *prev;
    unsigned long crc, crc2;
    int left, skip;

    scan = (char *) first_func; left = 0;
    while (scan < (char *) last_func)
    {
        if (*scan++ == ncrc_start[left])
        {
            if (!left) prev = scan;
            left++;
            if (left == sizeof(ncrc_start))
            {
                left = -1;
                break;
            }
        }
        else if (left)
        {
            scan = prev;
            left = 0;
        }
    }

    if (left != -1) return 0; /* Didn't find startup position */

    crc = 0xffffffff; skip = 0;
    for (;;)
    {
        if (skip > 0)
            skip--;
        else
        {
            if (scan == CRCSTRING+7)
                skip = 3;
            else
                crc += *scan;

            if (*scan == ncrc_end[left])
            {
                left++;
                if (left == sizeof(ncrc_end))
                {
                    /* CRC read */
                    break;
                }
            }
            else
                left = 0;
        }

        scan++;
    }

    memcpy(&crc2, CRCSTRING+7, 4);
    printf("%lx <-> %lx\n", crc, crc2);
    return crc == crc2;
}

#endif
