#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "offcfg.h"
#include "pkt_bw.h"
#include "files.h"
#include "bluewave.h"
#include "vars.h"
#include "keyb.h"
#include "screen.h"
#include "general.h"
#include "version.h"

char bw_open_packet(offline_packet *bw, char *str)
{
    int num;
    char tmp[256];

    struct stat statbuf;
    find_t SR;
    int Error;


    /* Open .INF file */
    if ((bw->Finfo = fopen_ign(strcat(strcpy(tmp,str),"inf"),"r+b")) == NULL) return 1;

    if (!replymgr)
    {
        if ((BW_PKT(bw)->Ffti = fopen_ign(strcat(strcpy(tmp,str),"fti"),"r+b")) == NULL) return 1;
        if ((bw->Fdat = fopen_ign(strcat(strcpy(tmp,str),"dat"),"r+b")) == NULL) return 1;
        if ((bw->Fmix = fopen_ign(strcat(strcpy(tmp,str),"mix"),"r+b")) == NULL) return 1;
    }

    bw->ansi_files = 0;
    bw->replies = 0;

    if (!fread(&bw->info,sizeof(INF_HEADER),1,bw->Finfo)) return 1;

    sprintf(tmp, "%d %d %d", sizeof(INF_HEADER), bw->info.inf_header_len, ORIGINAL_INF_HEADER_LEN);
    cwritexy(1, 1, tmp, 7);
    refresh(); exit(1);

    if (bw->info.inf_header_len < ORIGINAL_INF_HEADER_LEN)
        bw->inf_header_slen = ORIGINAL_INF_HEADER_LEN;
    else
        bw->inf_header_slen = bw->info.inf_header_len;

    if (bw->info.inf_areainfo_len < ORIGINAL_INF_AREA_LEN)
        bw->inf_area_slen = ORIGINAL_INF_AREA_LEN;
    else
        bw->inf_area_slen = bw->info.inf_areainfo_len;

    strcpy(bw->username, (char *) bw->info.loginname);
    strcpy(bw->useralias, (char *) bw->info.aliasname);
    strcpy(bw->board_name, (char *) bw->info.systemname);
    strcpy(bw->sysop_name, (char *) bw->info.sysop);

    if ((bw->info.from_to_len == 0) || (bw->info.from_to_len > 35))
        bw->from_to_len = 35;
    else
        bw->from_to_len = bw->info.from_to_len;

    if ((bw->info.subject_len == 0) || (bw->info.from_to_len > 71))
        bw->subj_len = 71;
    else
        bw->subj_len = bw->info.subject_len;

    bw->allow_crash = (bw->info.netmail_flags & INF_CAN_CRASH) > 0;
    bw->allow_direct = (bw->info.netmail_flags & INF_CAN_DIRECT) > 0;
    bw->allow_immediate = (bw->info.netmail_flags & INF_CAN_IMM) > 0;
    bw->allow_hold = (bw->info.netmail_flags & INF_CAN_HOLD) > 0;
    bw->allow_killsent = (bw->info.netmail_flags & INF_CAN_KSENT) > 0;
    bw->allow_fattach = (bw->info.netmail_flags & INF_CAN_ATTACH) > 0;
    bw->allow_net_freq = (bw->info.netmail_flags & INF_CAN_FREQ) > 0;

    bw->offline_config = (bw->info.ctrl_flags & INF_NO_CONFIG) == 0;
    bw->know_areas = 1;
    bw->allow_forwarding = bw->info.can_forward;
    bw->allow_freq = (bw->info.ctrl_flags & INF_NO_FREQ) == 0;
    bw->max_freqs = bw->info.maxfreqs;
    bw->ansi_newfiles = bw->info.file_list_type == INF_FLIST_ANSI;

    if ((bw->info.packet_id[0] >= 1) && (bw->info.packet_id[0] <= 8)) {
        memcpy(pktname,&bw->info.packet_id[1],8);
        pktname[bw->info.packet_id[0]] = 0;
    } else
        if (bw->info.packet_id[0] != 0)
            strcpy(pktname,(char *) bw->info.packet_id);

    fseek(bw->Finfo,0,SEEK_END);
    bw->areas = (ftell(bw->Finfo)-bw->inf_header_slen) / bw->inf_area_slen;

    if (!replymgr)
    {
        bw->ansi_files = 0;
        for (num=0; num<5; num++)
        {
            if (FileStat(strcat(strcpy(tmp,setup.workpath),(char *) bw->info.readerfiles[num]),&statbuf) == 0)
            {
                strcpy(bw->ansi_name[bw->ansi_files],(char *) bw->info.readerfiles[num]);
                dtstr(bw->ansi_time[bw->ansi_files],ST_MTIME(&statbuf));
                bw->ansi_files++;
            }
        }

        Error = _dos_findfirst(strcat(strcpy(tmp,setup.workpath),"BLT*.*"),0,&SR);
        while ((Error == 0) && (bw->ansi_files < 255))
        {
            if (FileStat(strcat(strcpy(tmp,setup.workpath),SR.name),&statbuf) == 0)
            {
                strcpy(bw->ansi_name[bw->ansi_files],SR.name);
                dtstr(bw->ansi_time[bw->ansi_files],ST_MTIME(&statbuf));
                bw->ansi_files++;
            }
            Error = _dos_findnext(&SR);
        }
#ifdef FIND_CLOSE
        _dos_findclose(&SR);
#endif

        Error = _dos_findfirst(strcat(strcpy(tmp,setup.workpath),"*.TXT"),0,&SR);
        while ((Error == 0) && (bw->ansi_files < 255))
        {
            if (FileStat(strcat(strcpy(tmp,setup.workpath),SR.name),&statbuf) == 0)
            {
                strcpy(bw->ansi_name[bw->ansi_files],SR.name);
                dtstr(bw->ansi_time[bw->ansi_files],ST_MTIME(&statbuf));
                bw->ansi_files++;
            }
            Error = _dos_findnext(&SR);
        }
#ifdef FIND_CLOSE
        _dos_findclose(&SR);
#endif
    }

    bw->curarea = 0;

    bw->area_start = 1; bw->area_end = 0;
    if (bw->areas < MAX_AREAS)
        bw->abufsize = bw->areas;
    else
        bw->abufsize = MAX_AREAS;

    if ((bw->area_buf = (INF_AREA_INFO *) malloc(sizeof(INF_AREA_INFO)*bw->abufsize)) == NULL) return 2;

    if (!replymgr)
    {
        bw->idxstart = 65535;
        bw->idxend = 0;
        if ((BW_PKT(bw)->fti_buf = (FTI_REC *) malloc(sizeof(FTI_REC)*max_fti)) == NULL) return 2;
    }

    if (!replymgr)
        return off_open_packet(bw, str);

    /* Reply manager .. */
    if ((bw->txt_buf = (unsigned char *) malloc(BUF_SIZE)) == NULL) return 2;

    bw->dat_start = 1; bw->dat_end = 0; bw->lastarea[0] = '\0'; bw->first_linerec = NULL;
    bw->replyopen = 0; bw->replies = 0; bw->fupl_opened = 0; bw->arealist = 0;

    return 0;
}

void bw_close_packet(offline_packet *bw)
{
    fclose(bw->Finfo);
    free(bw->area_buf);

    if (replymgr)
    {
        free(bw->txt_buf);
        return;
    }

    fclose(BW_PKT(bw)->Ffti);
    fclose(bw->Fdat);
    fclose(bw->Fmix);

    free(BW_PKT(bw)->fti_buf);

    off_close_packet(bw);
}

char bw_save_info(offline_packet *bw, char *path)
{
#define bufsize 4096

    FILE *F;
    char *buf;
    size_t readed;

    bw->info.mashtype = arcfmt;
    if ((buf = (char *) malloc(bufsize)) == NULL) return 0;

    if ((F = FileOpen(path,"w+b")) == NULL) return 0;
    fwrite(&bw->info,sizeof(INF_HEADER),1,F);
    fseek(bw->Finfo,bw->inf_header_slen,SEEK_SET);
    readed = fread(buf,1,bufsize,bw->Finfo);
    while (readed > 0)
    {
        fwrite(buf,readed,1,F);
        readed = fread(buf,1,bufsize,bw->Finfo);
    }
    free(buf);
    fclose(F);
    return 1;
#undef bufsize
}

void read_fti(offline_packet *bw, unsigned msgnum)
{
    if ((bw->idxend < msgnum) || (bw->idxstart > msgnum))
    {
        if (msgnum < max_fti/2) bw->idxstart = 1; else bw->idxstart = msgnum - (max_fti / 2);
        fseek(BW_PKT(bw)->Ffti,(bw->msgptr+bw->idxstart-1)*sizeof(FTI_REC),SEEK_SET);
        bw->idxend = bw->idxstart+fread(BW_PKT(bw)->fti_buf,sizeof(FTI_REC),max_fti,BW_PKT(bw)->Ffti)-1;
    }
}

char bw_read_msg(offline_packet *bw, unsigned msgnum)
{
    unsigned num;
    unsigned flags;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        bw->msgtxtptr = msg.blockpos;
        bw->msgtxtsize = msg.txtblocks;
        return 1;
    }

    read_fti(bw, msgnum);
    num = msgnum-bw->idxstart;

    bw->msgtxtptr = BW_PKT(bw)->fti_buf[num].msgptr;
    bw->msgtxtsize = BW_PKT(bw)->fti_buf[num].msglength;
    msg.txtblocks = bw->msgtxtsize;
    msg.blockpos = bw->msgtxtptr;

    msg.mnum = BW_PKT(bw)->fti_buf[num].msgnum;
    msg.replyto = BW_PKT(bw)->fti_buf[num].replyto;
    msg.replyat = BW_PKT(bw)->fti_buf[num].replyat;
    strcpy(msg.mfrom, (char *) BW_PKT(bw)->fti_buf[num].from);
    strcpy(msg.mto, (char *) BW_PKT(bw)->fti_buf[num].to);
    strcpy(msg.subj, (char *) BW_PKT(bw)->fti_buf[num].subject);
    strcpy(msg.date, (char *) BW_PKT(bw)->fti_buf[num].date);

    msg.zone = BW_PKT(bw)->fti_buf[num].orig_zone;
    msg.net = BW_PKT(bw)->fti_buf[num].orig_net;
    msg.node = BW_PKT(bw)->fti_buf[num].orig_node;

    flags = BW_PKT(bw)->fti_buf[num].flags;
    msg.flags = 0;

    if (flags & FTI_MSGPRIVATE) msg.flags = flag_private;
    if (flags & FTI_MSGREAD) msg.flags = flag_received;

    off_read_msg(bw, msgnum);
    return 1;
}

void bw_write_msg(offline_packet *bw, unsigned msgnum)
{
    read_fti(bw, msgnum);

    BW_PKT(bw)->fti_buf[msgnum-bw->idxstart].msgptr = msg.blockpos;
    fseek(BW_PKT(bw)->Ffti,(bw->msgptr+msgnum-1)*sizeof(FTI_REC),SEEK_SET);
    fwrite(&BW_PKT(bw)->fti_buf[msgnum-bw->idxstart],sizeof(FTI_REC),1,BW_PKT(bw)->Ffti);
}

void bw_delete_msg(offline_packet *bw, unsigned msgnum)
{
    unsigned long fsize;

    /* Remove .dat entry */
    fseek(bw->Fdat, 0, SEEK_END); fsize = ftell(bw->Fdat);
    delete_space(bw->Fdat, msg.blockpos, msg.txtblocks, fsize);
    ftrunc(bw->Fdat, fsize-msg.txtblocks);

    /* Remove .fti entry */
    fseek(BW_PKT(bw)->Ffti, 0, SEEK_END); fsize = ftell(BW_PKT(bw)->Ffti);
    delete_space(BW_PKT(bw)->Ffti, (bw->msgptr+msgnum-1)*sizeof(FTI_REC), sizeof(FTI_REC), fsize);
    ftrunc(BW_PKT(bw)->Ffti, fsize-sizeof(FTI_REC));
    bw->idxstart = 65535; bw->idxend = 0;
}

long bw_read_num(offline_packet *bw, unsigned msgnum)
{
    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mnum;
    }

    bw->idxstart = msgnum;
    bw->idxend = msgnum;

    fseek(BW_PKT(bw)->Ffti,(bw->msgptr+msgnum-1)*sizeof(FTI_REC),SEEK_SET);
    fread(BW_PKT(bw)->fti_buf,sizeof(FTI_REC),1,BW_PKT(bw)->Ffti);

    return BW_PKT(bw)->fti_buf[0].msgnum;
}

char *bw_read_from(offline_packet *bw, unsigned msgnum)
{
    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mfrom;
    }

    bw->idxstart = msgnum;
    bw->idxend = msgnum;

    fseek(BW_PKT(bw)->Ffti,(bw->msgptr+msgnum-1)*sizeof(FTI_REC),SEEK_SET);
    fread(BW_PKT(bw)->fti_buf,sizeof(FTI_REC),1,BW_PKT(bw)->Ffti);

    msg.mnum = BW_PKT(bw)->fti_buf[0].msgnum;
    return (char *) BW_PKT(bw)->fti_buf[0].from;
}

char *bw_read_to(offline_packet *bw, unsigned msgnum)
{
    bw->idxstart = msgnum;
    bw->idxend = msgnum;

    fseek(BW_PKT(bw)->Ffti,(bw->msgptr+msgnum-1)*sizeof(FTI_REC),SEEK_SET);
    fread(BW_PKT(bw)->fti_buf,sizeof(FTI_REC),1,BW_PKT(bw)->Ffti);

    msg.mnum = BW_PKT(bw)->fti_buf[0].msgnum;
    return (char *) BW_PKT(bw)->fti_buf[0].to;
}

char *bw_read_subj(offline_packet *bw, unsigned msgnum)
{
    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.subj;
    }

    bw->idxstart = msgnum;
    bw->idxend = msgnum;

    fseek(BW_PKT(bw)->Ffti,(bw->msgptr+msgnum-1)*sizeof(FTI_REC),SEEK_SET);
    fread(BW_PKT(bw)->fti_buf,sizeof(FTI_REC),1,BW_PKT(bw)->Ffti);

    msg.mnum = BW_PKT(bw)->fti_buf[0].msgnum;

    if (opt.rflags & STRIP_RE)
        if ((BW_PKT(bw)->fti_buf[0].subject[0] == 'R') && ((BW_PKT(bw)->fti_buf[0].subject[1] == 'E') || (BW_PKT(bw)->fti_buf[0].subject[1] == 'e')) && (BW_PKT(bw)->fti_buf[0].subject[2] == ':'))
            if (BW_PKT(bw)->fti_buf[0].subject[3] == ' ')
                memmove(BW_PKT(bw)->fti_buf[0].subject,BW_PKT(bw)->fti_buf[0].subject+4,strlen((char *) BW_PKT(bw)->fti_buf[0].subject)-3);
            else
                memmove(BW_PKT(bw)->fti_buf[0].subject,BW_PKT(bw)->fti_buf[0].subject+3,strlen((char *) BW_PKT(bw)->fti_buf[0].subject)-2);

    return (char *) BW_PKT(bw)->fti_buf[0].subject;
}

extern unsigned long serialnum;

void bw_open_replypacket(offline_packet *bw)
{
    char tmp[256];
    char num;

    if (bw->fupl_opened) return;

    replyopen = 0;
    sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
    if ((bw->Fupl = fopen_ign(tmp,"r+b")) != NULL)
    {
        if (fread(&bw->uplheader,sizeof(UPL_HEADER),1,bw->Fupl))
        {
            fseek(bw->Fupl,0,SEEK_END);
            bw->replies = (ftell(bw->Fupl)-sizeof(UPL_HEADER)) / sizeof(UPL_REC);
        }
        else
        {
            fseek(bw->Fupl,0,SEEK_SET);
            goto __upl_header;
        }
        bw->fupl_opened = 1;
    }
    else
    {
        sprintf(tmp,"%s%s.upl",setup.replypath,pktname);
        if ((bw->Fupl = FileOpen(tmp,"w+b")) != NULL)
        {
        __upl_header:
            /* Create .UPL file header */
            memset(&bw->uplheader,0,sizeof(bw->uplheader));

            bw->uplheader.not_registered = !registered;
            bw->uplheader.compress_type = arcfmt;

            bw->uplheader.reader_major = major_num;
            bw->uplheader.reader_minor = minor_num;
            if (registered) sprintf((char *) bw->uplheader.regnum, "%lu", serialnum);
            strcpy((char *) bw->uplheader.reader_name,Reader_Name);
            bw->uplheader.upl_header_len = sizeof(UPL_HEADER);
            bw->uplheader.upl_rec_len = sizeof(UPL_REC);
            strcpy((char *) bw->uplheader.loginname,(char *) bw->info.loginname);
            strcpy((char *) bw->uplheader.aliasname,(char *) bw->info.aliasname);

            if (registered && setup.tearline[0] != '\0')
            {
                conv_macros(setup.tearline, tmp);
                strncpy((char *) bw->uplheader.reader_tear,tmp,15); bw->uplheader.reader_tear[15] = '\0';
            }
            else
                strcpy((char *) bw->uplheader.reader_tear,Reader_Name);

            if (registered && setup.vernum[0] != '\0')
            {
                conv_macros(setup.vernum, tmp);
                strncpy((char *) bw->uplheader.vernum,tmp,19); bw->uplheader.vernum[19] = '\0';
            }
            else
                strcpy((char *) bw->uplheader.vernum,version);

            // if (elite_version()) strcat((char *) bw->uplheader.vernum, " [!CRaCKeD!]"); else
            num = 0;
            while (bw->uplheader.vernum[num] != 0)
            {
                bw->uplheader.vernum[num] -= 10;
                num++;
            }

            fwrite(&bw->uplheader,sizeof(UPL_HEADER),1,bw->Fupl);
            bw->fupl_opened = 1;
            bw->replies = 0;
        }
        else
            bw->replies = 0;
    }
}

void bw_close_replypacket(offline_packet *bw)
{
    UPI_HEADER upiheader;
    UPI_REC upirec;

    FILE *Fupi;
    char num,tmp[256];

    if (bw->info.ver >= 3)
        FileRemove(strcat(strcat(strcpy(tmp,setup.replypath),pktname),".pdq"));

    if (bw->fupl_opened)
    {
        if ((!bw->info.uses_upl_file) && (bw->info.ver < 3))
        {
            sprintf(tmp,"%s%s.upi",setup.replypath,pktname);
            if ((Fupi = FileOpen(tmp,"w+b")) != NULL)
            {
                memset(&upiheader,0,sizeof(upiheader));
                strcpy((char *) upiheader.vernum,version);
                num = 0;
                while (upiheader.vernum[num] != 0)
                {
                    upiheader.vernum[num] -= 10;
                    num++;
                }

                fwrite(&upiheader,sizeof(upiheader),1,Fupi);
                fseek(bw->Fupl,0,SEEK_SET);
                while (fread(&uplrec,sizeof(uplrec),1,bw->Fupl))
                {
                    memset(&upirec,0,sizeof(upirec));
                    strcpy((char *) upirec.from,(char *) uplrec.from);
                    strcpy((char *) upirec.to,(char *) uplrec.to);
                    strcpy((char *) upirec.subj,(char *) uplrec.subj);
                    upirec.unix_date = uplrec.unix_date;
                    strcpy((char *) upirec.fname,(char *) uplrec.filename);
                    strcpy((char *) upirec.echotag,(char *) uplrec.echotag);
                    if (uplrec.msg_attr & UPL_PRIVATE) upirec.flags = UPI_PRIVATE;
                    fwrite(&upirec,sizeof(upirec),1,Fupi);
                }
                fclose(Fupi);
            }
        }

        fclose(bw->Fupl);
        bw->fupl_opened = 0;
    }
}

void bw_read_arealist(offline_packet *bw, FILE *F)
{
    FILE *Fpdq,*Folc;
    PDQ_HEADER pdqhdr;
    PDQ_REC pdqrec;

    unsigned anum,area,astart;
    char areabuf[512],ch,*pstr,*pstr2,*pstr3,global_found,filters,keywords,macros;

    bw->arealist = 0;
    memset(&bw_extcfg,0,sizeof(bw_extcfg));
    sprintf(areabuf,"%s%s.olc",setup.replypath,pktname);
    if ((Folc = fopen_ign(areabuf,"rt")) != NULL)
    {
        /* Read offline configuration from .OLC file */
        global_found = 0;
        filters = 0;
        keywords = 0;
        macros = 0; anum = 0;
        memset(&pdqhdr,0,sizeof(pdqhdr));
        while (_fgets(areabuf,sizeof(areabuf),Folc) != NULL)
        {
            /* Remove spaces from the start of the line */
            pstr = areabuf;
            while ((*pstr) && ((*pstr == ' ') || (*pstr == 9))) pstr++;

            if (*pstr == 0) continue;

            /* Remove spaces from the end of the line */
            pstr2 = pstr;
            while (*pstr2) pstr2++;
            while (((*(pstr2-1) == ' ') || (*(pstr2-1) == '9')) && (pstr2-1 > pstr)) pstr2--;
            *pstr2 = 0;

            if (!global_found)
            {
                if (stricmp(pstr,"[Global Mail Host Information]") == 0)
                    global_found = 1;
                else
                    if (stricmp(pstr,"[Global Mail Host Configuration]") == 0)
                        global_found = 1;
                continue;
            }

            if (pstr[0] == '[')
            {
                pstr++;
                pstr2 = pstr;
                while (*pstr2) pstr2++;
                if ((pstr2 != pstr) && (*(pstr2-1) == ']'))
                {
                    *(pstr2-1) = 0;
                    anum = bw->gettag(bw, pstr);
                }
                continue;
            }

            if ((pstr2 = strchr(pstr,'=')) != NULL)
            {
                /* Remove spaces before '=' */
                pstr3 = pstr2;
                while ((*(pstr3-1) == ' ') || (*(pstr3-1) == 9)) pstr3--;
                *pstr3 = 0;

                /* Remove spaces after '=' */
                pstr2++;
                while ((*pstr2) && ((*pstr2 == ' ') || (*pstr2 == 9))) pstr2++;

                if (stricmp(pstr,"SCAN") == 0 && anum != 0)
                {
                    if (stricmp(pstr2, "All") == 0)
                    {
                        if (bw->area_selected(bw, anum)) ch = 0; else ch = 1;
                        fseek(F,anum-1,SEEK_SET);
                        fwrite(&ch,1,1,F);
                    }
                    if (stricmp(pstr2, "PersOnly") == 0)
                    {
                        ch = 3;
                        fseek(F,anum-1,SEEK_SET);
                        fwrite(&ch,1,1,F);
                    }
                    if (stricmp(pstr2, "Pers+All") == 0)
                    {
                        ch = 4;
                        fseek(F,anum-1,SEEK_SET);
                        fwrite(&ch,1,1,F);
                    }
                    continue;
                }

                if (stricmp(pstr,"FILTER") == 0)
                {
                    if (filters < 10)
                    {
                        strcpy((char *) pdqhdr.filters[filters], pstr2);
                        filters++;
                    }
                    continue;
                }
                if (stricmp(pstr,"KEYWORD") == 0)
                {
                    if (keywords < 10) {
                        strcpy((char *) pdqhdr.keywords[keywords], pstr2);
                        keywords++;
                    }
                    continue;
                }
                if (stricmp(pstr,"MACRO") == 0)
                {
                    if (macros < 3) {
                        if (strnicmp(pstr2,"AUTO,",5) == 0) {
                            bw_extcfg.automacro[macros] = 1;
                            pstr2 += 5;
                        }
                        strcpy((char *) pdqhdr.macros[macros], pstr2);
                        macros++;
                    }
                    continue;
                }
                if (stricmp(pstr,"MENUHOTKEYS") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE"))
                        pdqhdr.flags |= PDQ_HOTKEYS;
                    continue;
                }
                if (stricmp(pstr,"EXPERTMENUS") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE"))
                        pdqhdr.flags |= PDQ_XPERT;
                    continue;
                }
                if (stricmp(pstr,"AREACHANGES") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE"))
                    {
                        pdqhdr.flags |= PDQ_AREA_CHANGES;
                        bw->arealist = 1;

                        fseek(F,0,SEEK_SET);
                        astart = 0;
                        for (area=1; area<=bw->areas; area++)
                        {
                            if (!bw->area_selected(bw, area))
                                areabuf[astart] = 0;
                            else
                                areabuf[astart] = 2;

                            astart++;
                            if (astart == sizeof(areabuf))
                            {
                                astart = 0;
                                fwrite(areabuf,1,sizeof(areabuf),F);
                            }
                        }
                        if (astart > 0) fwrite(areabuf,1,astart,F);
                    }
                    continue;
                }
                if (stricmp(pstr,"SKIPUSERMSGS") == 0)
                {
                    if (!(!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE")))
                        pdqhdr.flags |= PDQ_NOT_MY_MAIL;
                    continue;
                }
                if (stricmp(pstr,"EXTENDEDINFO") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE"))
                        pdqhdr.flags |= INF_EXT_INFO;
                    continue;
                }
                if (stricmp(pstr,"NUMERICEXTENSIONS") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE"))
                        pdqhdr.flags |= INF_NUMERIC_EXT;
                    continue;
                }
                if (stricmp(pstr,"NEWFILELIST") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE") || !stricmp(pstr2,"TEXT"))
                        bw_extcfg.newfiles = INF_FLIST_TEXT;
                    else {
                        if (!stricmp(pstr2,"COLOR"))
                            bw_extcfg.newfiles = INF_FLIST_ANSI;
                        else
                            bw_extcfg.newfiles = INF_FLIST_NONE;
                    }
                    continue;
                }
                if (stricmp(pstr,"MAXPACKETSIZE") == 0)
                {
                    pstr3 = pstr2;
                    while (*pstr3) pstr3++;
                    if (pstr3 != pstr2) {
                        *(pstr3-1) = 0;
                        bw_extcfg.maxsize = atol(pstr2);
                    }
                    continue;
                }
                if (stricmp(pstr,"DOORGRAPHICS") == 0)
                {
                    if (!stricmp(pstr2,"YES") || !stricmp(pstr2,"ON") || !stricmp(pstr2,"TRUE"))
                        pdqhdr.flags |= PDQ_GRAPHICS;
                    continue;
                }
                if (stricmp(pstr,"PASSWORD") == 0)
                {
                    if ((pstr3 = strchr(pstr2,',')) != NULL)
                    {
                        *pstr3 = 0;
                        strcpy((char *) pdqhdr.password,pstr3+1);
                        /*pstr3 = (char *) pdqhdr.password;
                        while (*pstr3)
                        {
                            *pstr3 = (unsigned char) *pstr3 - 10;
                            pstr3++;
                        }*/
                    }
                    else
                        strcpy((char *) pdqhdr.password,(char *) bw->info.password);

                    if (stricmp(pstr2,"DOOR") == 0)
                        pdqhdr.passtype = 1;
                    else
                    {
                        if (stricmp(pstr2,"READER") == 0)
                            pdqhdr.passtype = 2;
                        else
                        {
                            if (stricmp(pstr2,"BOTH") == 0)
                                pdqhdr.passtype = 3;
                            else
                                pdqhdr.passtype = 0;
                        }
                    }
                    continue;
                }
            }
        }
        fclose(Folc);

        sprintf(areabuf,"%s%s.pdq",setup.replypath,pktname);
        if ((Fpdq = FileOpen(areabuf,"w+b")) != NULL)
        {
            fwrite(&pdqhdr,sizeof(pdqhdr),1,Fpdq);
            fclose(Fpdq);
        }
        return;
    }

    sprintf(areabuf,"%s%s.pdq",setup.replypath,pktname);
    if ((Fpdq = fopen_ign(areabuf,"rb")) == NULL) return;
    if (!fread(&pdqhdr,sizeof(pdqhdr),1,Fpdq))
    {
        fclose(Fpdq);
        return;
    }

    bw->arealist = (pdqhdr.flags & PDQ_AREA_CHANGES) > 0;
    if (bw->arealist)
    {
        fseek(F,0,SEEK_SET);
        astart = 0;
        for (area=1; area<=bw->areas; area++)
        {
            if (!bw->area_selected(bw, area))
                areabuf[astart] = 0;
            else
                areabuf[astart] = 2;

            astart++;
            if (astart == sizeof(areabuf))
            {
                astart = 0;
                fwrite(areabuf,1,sizeof(areabuf),F);
            }
        }
        fwrite(areabuf,1,astart,F);
    }

    area = 1;
    while (fread(&pdqrec,sizeof(pdqrec),1,Fpdq))
    {
        anum = bw->gettag(bw, (char *) pdqrec.echotag);

        if (anum > 0)
        {
            if (bw->area_selected(bw, anum)) ch = 0; else ch = 1;
            fseek(F,anum-1,SEEK_SET);
            fwrite(&ch,1,1,F);
        }
        area++;
    }
    fclose(Fpdq);
}

static char *onoff[2] = { "OFF","ON" };
static char *newflist[3] = { "NO","TEXT", "ANSI" };

void bw_write_arealist(offline_packet *bw, FILE *F)
{
    unsigned astart,aend,area;
    char areabuf[512],ok;

    FILE *Fpdq,*Folc;
    PDQ_HEADER pdqhdr;
    PDQ_REC pdqrec;
    int ch;

    astart = 65535; aend = 0;

    ok = 0;
    sprintf(areabuf,"%s%s.pdq",setup.replypath,pktname);
    if ((Fpdq = fopen_ign(areabuf,"r+b")) != NULL)
    {
        if (fread(&pdqhdr,sizeof(PDQ_HEADER),1,Fpdq)) ok = 1;
        fseek(Fpdq,0,SEEK_SET);
    } else
        if ((Fpdq = FileOpen(areabuf,"w+b")) == NULL) return;

    if (!ok)
    {
        memset(&pdqhdr,0,sizeof(PDQ_HEADER));
        memcpy(pdqhdr.keywords,bw->info.keywords,sizeof(bw->info.keywords));
        memcpy(pdqhdr.filters,bw->info.filters,sizeof(bw->info.filters));
        memcpy(pdqhdr.macros,bw->info.macros,sizeof(bw->info.macros));
        strcpy((char *) pdqhdr.password,(char *) bw->info.password);
        for (ch = 0; pdqhdr.password[ch] != '\0'; ch++)
            pdqhdr.password[ch] = pdqhdr.password[ch]-10;
        pdqhdr.passtype = bw->info.passtype;
        pdqhdr.flags = bw->info.uflags;
        bw_extcfg.newfiles = bw->info.file_list_type;
        bw_extcfg.maxsize = bw->info.max_packet_size;
        memcpy(bw_extcfg.automacro, bw->info.auto_macro, sizeof(bw_extcfg.automacro));
    }

    /* .OLC */
    sprintf(areabuf,"%s%s.olc",setup.replypath,pktname);
    if ((Folc = FileOpen(areabuf,"w+t")) != NULL)
    {
        fprintf(Folc,"[Global Mail Host Configuration]\n");

        fprintf(Folc,"MenuHotKeys = %s\n",onoff[(pdqhdr.flags & PDQ_HOTKEYS) > 0]);
        fprintf(Folc,"ExpertMenus = %s\n",onoff[(pdqhdr.flags & PDQ_XPERT) > 0]);
        fprintf(Folc,"AreaChanges = %s\n",onoff[bw->arealist]);
        fprintf(Folc,"SkipUserMsgs = %s\n",onoff[(pdqhdr.flags & PDQ_NOT_MY_MAIL) == 0]);
        fprintf(Folc,"ExtendedInfo = %s\n",onoff[(pdqhdr.flags & INF_EXT_INFO) > 0]);
        fprintf(Folc,"NumericExtensions = %s\n",onoff[(pdqhdr.flags & INF_NUMERIC_EXT) > 0]);
        fprintf(Folc,"NewFileList = %s\n",newflist[bw_extcfg.newfiles]);
        fprintf(Folc,"MaxPacketSize = %iK\n",bw_extcfg.maxsize);
        fprintf(Folc,"DoorGraphics = %s\n",onoff[(pdqhdr.flags & PDQ_GRAPHICS) > 0]);

        /* Password */
        /*pstr = (char *) pdqhdr.password;
        while (*pstr)
        {
            *pstr = (unsigned char) *pstr + 10;
            pstr++;
        }*/

        switch (pdqhdr.passtype) {
            case 0:
                fprintf(Folc,"Password = OFF\n");
                break;
            case 1:
                fprintf(Folc,"Password = DOOR,%s\n",pdqhdr.password);
                break;
            case 2:
                fprintf(Folc,"Password = READER,%s\n",pdqhdr.password);
                break;
            case 3:
                fprintf(Folc,"Password = BOTH,%s\n",pdqhdr.password);
                break;
        }

        /* Filters */
        for (area=0; area<10; area++) {
            if (pdqhdr.filters[area][0] != 0)
                fprintf(Folc,"Filter = %s\n",pdqhdr.filters[area]);
        }

        /* Keywords */
        for (area=0; area<10; area++) {
            if (pdqhdr.keywords[area][0] != 0)
                fprintf(Folc,"Keyword = %s\n",pdqhdr.keywords[area]);
        }

        /* Macros */
        for (area=0; area<3; area++) {
            if (pdqhdr.macros[area][0] != 0) {
                if (bw_extcfg.automacro[area])
                    fprintf(Folc,"Macro = Auto,%s\n",pdqhdr.macros[area]);
                else
                    fprintf(Folc,"Macro = %s\n",pdqhdr.macros[area]);
            }
        }

        if (bw->arealist)
        {
            /* Area settings */
            fseek(F,0,SEEK_SET);
            for (area=1; area<=bw->areas; area++)
            {
                if ((astart > area) || (aend < area))
                {
                    fseek(F,area-1,SEEK_SET);
                    astart = area;
                    aend = area+fread(areabuf,1,sizeof(areabuf),F)-1;
                }
                if (((areabuf[area-astart] == 0) && (bw->area_selected(bw, area) == 2)) || (areabuf[area-astart] == 3))
                {
                    fprintf(Folc,"\n[%s]\n",bw->get_area_tag(bw, area));
                    fprintf(Folc,"Scan = PersOnly\n");
                }
                else if (((areabuf[area-astart] == 0) && (bw->area_selected(bw, area) == 3)) || (areabuf[area-astart] == 4))
                {
                    fprintf(Folc,"\n[%s]\n",bw->get_area_tag(bw, area));
                    fprintf(Folc,"Scan = Pers+All\n");
                }
                else if (((areabuf[area-astart] == 0) && (bw->area_selected(bw, area))) || (areabuf[area-astart] == 1))
                {
                    fprintf(Folc,"\n[%s]\n",bw->get_area_tag(bw, area));
                    fprintf(Folc,"Scan = All\n");
                }
            }
        }
        fclose(Folc);
    }
    /*if (bw->info.ver >= 3) {
        fclose(Fpdq);
        FileRemove(strcat(strcat(strcpy(areabuf,setup.replypath),pktname),".pdq"));
        return;
    }*/

    /* .PDQ */
    pdqhdr.flags |= PDQ_AREA_CHANGES;
    fseek(Fpdq,0,SEEK_SET);
    fwrite(&pdqhdr,sizeof(PDQ_HEADER),1,Fpdq);
    for (area=1; area<=bw->areas; area++)
    {
        if ((astart > area) || (aend < area))
        {
            fseek(F,area-1,SEEK_SET);
            astart = area;
            aend = area+fread(areabuf,1,sizeof(areabuf),F)-1;
        }
        if (((areabuf[area-astart] == 0) && (bw->area_selected(bw, area))) || areabuf[area-astart] == 1 || areabuf[area-astart] > 2)
        {
            strcpy((char *) pdqrec.echotag,bw->get_area_tag(bw, area));
            fwrite(&pdqrec,sizeof(PDQ_REC),1,Fpdq);
        }
    }
    fclose(Fpdq);
}

char *bw_export_msg(offline_packet *bw, char *out)
{
    FILE *F;
    unsigned num,num2;
    size_t readed;

    strcat(strcpy(out,setup.workpath),"TMP_ANSI.");
    if ((F = FileOpen(out,"w+b")) == NULL) return NULL;

    fseek(bw->Fdat,bw->msgtxtptr+1,SEEK_SET);
    num2 = bw->msgtxtsize/BUF_SIZE;
    for (num=1; num<=num2; num++) {
        readed = fread(bw->txt_buf,1,BUF_SIZE,bw->Fdat);
        fwrite(bw->txt_buf,1,readed,F);
    }
    readed = fread(bw->txt_buf,1,bw->msgtxtsize % BUF_SIZE,bw->Fdat);
    fwrite(bw->txt_buf,1,readed,F);

    fclose(F);
    return out;
}

offline_packet *new_bwpacket(void)
{
    offline_packet *off;
    bw_packet *bw;

    off = (offline_packet *) malloc(sizeof(offline_packet));
    bw = (bw_packet *) malloc(sizeof(bw_packet));
    off->child = bw;
    memset(bw, 0, sizeof(*bw));
    memset(off, 0, sizeof(*off));

    off->open_packet = bw_open_packet;
    off->close_packet = bw_close_packet;
    off->save_info = bw_save_info;
    off->read_msg = bw_read_msg;
    off->write_msg = bw_write_msg;
    off->delete_msg = bw_delete_msg;
    off->read_num = bw_read_num;
    off->read_from = bw_read_from;
    off->read_to = bw_read_to;
    off->read_subj = bw_read_subj;
    off->open_replypacket = bw_open_replypacket;
    off->close_replypacket = bw_close_replypacket;
    off->export_msg = bw_export_msg;
    off->read_arealist = bw_read_arealist;
    off->write_arealist = bw_write_arealist;

    return off;
}
