#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pkt_hipp.h"
#include "files.h"
#include "bluewave.h"
#include "vars.h"
#include "general.h"
#include "screen.h"

char hippo_packet::read_msg(unsigned msgnum)
{
    long mnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        msgtxtptr = msg.blockpos;
        msgtxtsize = msg.txtblocks;
        return 1;
    }
    mnum = msgptr+msgnum-1;
    fseek(Fidx,mnum*sizeof(msgtype),SEEK_SET);
    fread(&msg,1,sizeof(msg),Fidx);
    msgtxtptr = msg.blockpos;
    msgtxtsize = msg.txtblocks;
    offline_packet::read_msg(msgnum);
    return 1;
}

long hippo_packet::read_num(unsigned msgnum)
{
    long mnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mnum;
    }
    mnum = msgptr+msgnum-1;
    fseek(Fidx,mnum*sizeof(msgtype),SEEK_SET);
    fread(&msg,1,sizeof(msg),Fidx);
    return msg.mnum;
}

char *hippo_packet::read_from(unsigned msgnum)
{
    long mnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mfrom;
    }
    mnum = msgptr+msgnum-1;
    fseek(Fidx,mnum*sizeof(msgtype),SEEK_SET);
    fread(&msg,1,sizeof(msg),Fidx);
    return msg.mfrom;
}

char *hippo_packet::read_to(unsigned msgnum)
{
    long mnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.mto;
    }
    mnum = msgptr+msgnum-1;
    fseek(Fidx,mnum*sizeof(msgtype),SEEK_SET);
    fread(&msg,1,sizeof(msg),Fidx);
    return msg.mto;
}

char *hippo_packet::read_subj(unsigned msgnum)
{
    long mnum;

    if (msgs_in_mem)
    {
        memcpy(&msg,&mem_msgs[msgnum-1],sizeof(msg));
        return msg.subj;
    }
    mnum = msgptr+msgnum-1;
    fseek(Fidx,mnum*sizeof(msgtype),SEEK_SET);
    fread(&msg,1,sizeof(msg),Fidx);
    offline_packet::read_subj(msgnum);
    return msg.subj;
}

char *hippo_packet::export_msg(char *out)
{
    FILE *F;
    unsigned num,num2;
    size_t readed;

    strcat(strcpy(out,setup.workpath),"TMP_ANSI.");
    if ((F = FileOpen(out,"w+b")) == NULL) return NULL;

    fseek(Fdat,msgtxtptr,SEEK_SET);
    num2 = msgtxtsize/BUF_SIZE;
    for (num=1; num<=num2; num++) {
        readed = fread(txt_buf,1,BUF_SIZE,Fdat);
        fwrite(txt_buf,1,readed,F);
    }
    readed = fread(txt_buf,1,msgtxtsize % BUF_SIZE,Fdat);
    fwrite(txt_buf,1,readed,F);

    fclose(F);
    return out;
}

void hippo_packet::read_arealist(FILE *F)
{
#define BUFSIZE 4096

    FILE *Ffrom;
    char *buf,tmp[256];
    size_t readed;

    if ((buf = (char *) malloc(BUFSIZE)) == NULL) return;
    if ((Ffrom = FileOpen(strcat(strcpy(tmp,setup.workpath),"AREAS.DAT"),"r+b")) == NULL) {
        free(buf);
        return;
    }

    fseek(F,0,SEEK_SET);
    readed = fread(buf,1,BUFSIZE,Ffrom);
    while (readed) {
        fwrite(buf,1,readed,F);
        readed = fread(buf,1,BUFSIZE,Ffrom);
    }
    free(buf);

    fclose(Ffrom);
    FileRemove(tmp);
}

void hippo_packet::write_arealist(FILE *F)
{
#define BUFSIZE 4096

    FILE *Fto;
    char *buf,tmp[256];
    size_t readed;

    if ((buf = (char *) malloc(BUFSIZE)) == NULL) return;
    if ((Fto = FileOpen(strcat(strcpy(tmp,setup.workpath),"AREAS.DAT"),"w+b")) == NULL) {
        free(buf);
        return;
    }
    fseek(F,0,SEEK_SET);
    readed = fread(buf,1,BUFSIZE,F);
    while (readed)
    {
        fwrite(buf,1,readed,Fto);
        readed = fread(buf,1,BUFSIZE,F);
    }

    free(buf);
    fclose(Fto);
}
