#ifndef __PKT_JAM_H
#define __PKT_JAM_H

#include "pkt_obj.h"
#include "jam.h"

class jam_base: public offline_packet
{
public:
    typedef struct PATH_REC
    {
        struct PATH_REC *next;
        struct PATH_REC *prev;

        char msgbase[256];

        unsigned long messages;
        unsigned long unread;
        unsigned short zone,net,node,point;
    }
    PATH_REC;

    FILE *Fjhr,*Fjdx,*Fjlr;
    JAMHDRINFO jamhdr;
    JAMIDXREC jamidx;
    JAMHDR msgrec;

    char msgbase[256],msgbase_opened;
    unsigned long UserCRC;

    int pathpos;
    unsigned last_msg;
    PATH_REC *first_path;
    PATH_REC *path_rec;

    char open_packet(char *str);
    void close_packet(void);

    unsigned getarea(char *areanum);
    unsigned get_msgs(char *areanum);
    unsigned get_personal_msgs(char *areanum);
    unsigned get_unread_msgs(char *areanum);

    unsigned read_lastread(void);
    int open_msgbase(void);
    char open_area(char *area);
    char read_msg(unsigned msgnum);

    long read_num(unsigned msgnum);
    char *read_from(unsigned msgnum);
    char *read_to(unsigned msgnum);
    char *read_subj(unsigned msgnum);

    void area_flags(unsigned num, XTI_REC *xti);
    void save_area_flags(unsigned num, XTI_REC *xti);
    void update_area_flags(void);

    int lock_msgbase(void);
    void unlock_msgbase(void);

    void add_subfield(char *subdata, char *fielddata, unsigned subtype);
    unsigned get_own_address(unsigned zone, unsigned net, unsigned node, unsigned point);
    void enter_msg(void);
};

#endif
