#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "screen.h"
#include "vars.h"
#include "keyb.h"
#include "general.h"
#include "files.h"
#include "shell.h"
#include "bluewave.h"
#include "readsets.h"
#include "scrolbox.h"
#include "scrsaver.h"
#include "readarea.h"
#include "readmail.h"
#include "readfunc.h"
#include "writemsg.h"

static unsigned areas;

#ifdef __linux__
#  define PLOT '-'
#else
#  define PLOT 250
#endif

static char *tran(char *str)
{
    int nro = 0;
    while (str[nro] != 0)
    {
        str[nro] = inbound[(unsigned char) str[nro]];
        nro++;
    }
    return str;
}

static void draw_line(unsigned dypos, unsigned darea)
{
    char tag[61],tmp[81];
    unsigned msgs,unread;
    char col;

    unread = 0;
    msgs = 0;

    tbar(4,dypos,scrwidth-3,dypos,color[col_read_number]);
    if (darea > areas) return;

    darea = areaptrs[darea-1];
    strcpy(tag, pkt->get_area_number(darea));
    pkt->open_area(tag);

    msgs = pkt->get_msgs(tag);
    unread = pkt->get_unread_msgs(tag);

    if (unread == 0)
        col = color[col_read_allread];
    else
        col = color[col_read_number];

    cwritexy(10-strlen(tag),dypos,tag,col);

    strcpy(tmp,pkt->get_area_name(darea));
    if (strlen(tmp) > scrwidth-34) tmp[scrwidth-34] = 0;
    tran(tmp);

    if (unread == 0)
        col = color[col_read_allread];
    else
        col = color[col_read_name];
    cwritexy(11,dypos,tmp,col);

    if (unread == 0)
        col = color[col_read_allread];
    else
        col = color[col_read_total];

    if (msgs==0)
        writechr(scrwidth-18,dypos,PLOT,color[col_read_allread]);
    else {
        sprintf(tmp,"%5d",msgs);
        cwritexy(scrwidth-22,dypos,tmp,col);
    }

    if (unread>0) col = color[col_read_personal];

    msgs = pkt->get_personal_msgs(tag);
    if (msgs == 0)
        writechr(scrwidth-12,dypos,PLOT,color[col_read_allread]);
    else {
        sprintf(tmp,"%5d",msgs);
        cwritexy(scrwidth-16,dypos,tmp,col);
    }

    if (unread == 0)
        writechr(scrwidth-4,dypos,PLOT,color[col_read_allread]);
    else {
        sprintf(tmp,"%5d",unread);
        cwritexy(scrwidth-8,dypos,tmp,color[col_read_unread]);
    }
}

static void enter_msg_rm(SCROLL_BOX *scrbox)
{
    unsigned num;
    char pvt;

    num = pkt->area_type(areaptrs[scrbox->ypos+scrbox->upy-1]);
    if (num & TYPE_NOPUB) pvt = 1; else pvt = 0;

    if (try_open_reply())
    {
        write_msg(0,pkt->get_area_tag(areaptrs[scrbox->ypos+scrbox->upy-1]),"All",NULL,pvt,0,0);
    }
}

void read_flagged(SCROLL_BOX *)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned num,n2,found,slen,last;
    char tmp[256];

    pers_rec pers;
    XTI_REC xti;

    char anum[6];


    /* Open work\sky_pers.idx */
    sprintf(tmp,"%ssky_pers.idx",setup.workpath);
    Fpers = FileOpen(tmp,"w+b");
    if (Fpers == NULL) return;

    save_scr(&cx,&cy,&oldscr);
    slen = get_max_langtext_len(85,87)/2;
    draw_shaded_box(scrwidth/2-slen-4,6,scrwidth/2+slen+4,11,color[col_info_frame],color[col_info_title],lang[95]);

    found = 0; last = 0;
    for (num=1; num<=pkt->areas; num++)
    {
        if (last != (num*100) / pkt->areas)
        {
            last = (num*100) / pkt->areas;
            sprintf(tmp,lang[96],(num*100) / pkt->areas);
            cmiddle(8,tmp,color[col_info_hilight]);
            refresh();
        }

        strcpy(anum,pkt->get_area_number(num));
        if (pkt->open_area(anum))
        {
            for (n2=1; n2<=pkt->get_msgs(anum); n2++)
            {
                pkt->area_flags(n2,&xti);
                if (xti.marks & XTI_MARK_REPLY)
                {
                    /* Message is personal.. */
                    found++;

                    /* Copy message to personal pers.msg */
                    pkt->read_msg(n2);
                    memcpy(&pers.msg,&msg,sizeof(msg));

                    sprintf(tmp,lang[97],found);
                    cmiddle(9,tmp,color[col_info_text]);

                    /* Write to file */
                    pers.area = num;
                    pers.msgnum = n2;
                    if (fwrite(&pers,sizeof(pers),1,Fpers) == 0)
                    {
                        /* Error writing to file */
                        err_box("Error writing to file, out of disk space?");
                        old_scr(cx,cy,&oldscr);
                        fclose(Fpers);

                        sprintf(tmp,"%ssky_pers.idx",setup.workpath);
                        FileRemove(tmp);
                        return;
                    }
                }
            }
        }
    }

    if (found == 0)
    {
        /* No messages found */
        old_scr(cx,cy,&oldscr);
        save_scr(&cx,&cy,&oldscr);
        draw_shaded_box(scrwidth/2-15,8,scrwidth/2+16,12,color[col_info_frame],color[col_info_title],NULL);
        cmiddle(10,lang[98],color[col_info_hilight]);
        try_key(2);
    }
    else
    {
        /* Read messages */
        read_area(-2);
    }
    fclose(Fpers);

    sprintf(tmp,"%ssky_pers.idx",setup.workpath);
    FileRemove(tmp);
    old_scr(cx,cy,&oldscr);
}

int mail_scan(SCROLL_BOX *)
{
    unsigned short cx,cy;
    char *oldscr;

    pers_rec pers;
    XTI_REC xti;

    char tmp[256];

    unsigned num,n2,last;
    unsigned unread,found,msgs,pos;
    size_t slen;

    char *anum;
    int ch,quit,sel;


    /* Create work\sky_pers.idx */
    sprintf(tmp,"%ssky_pers.idx",setup.workpath);
    Fpers = FileOpen(tmp,"w+b");
    if (Fpers == NULL) return 0;

    mailscanned = 1;
    save_scr(&cx,&cy,&oldscr);
    slen = get_max_langtext_len(85,87) / 2;
    draw_shaded_box(scrwidth/2-slen-4,6,scrwidth/2+slen+4,11,color[col_info_frame],color[col_info_title],lang[85]);

    found = 0;
    unread = 0;
    last = 0;

    /* Scan for personal messages */
    for (num=1; num<=pkt->areas; num++)
    {
        if (last != (num*100) / pkt->areas)
        {
            last = (num*100) / pkt->areas;
            sprintf(tmp,lang[86],(num*100) / pkt->areas);
            cmiddle(8,tmp,color[col_info_hilight]);
            refresh();
        }

        /* Open area */
        anum = pkt->get_area_number(num);
        msgs = pkt->get_msgs(anum);
        if (msgs > 0 && pkt->open_area(anum))
        {
            /* Check each message if it is personal */
            for (n2=1; n2<=msgs; n2++)
            {
                /* Get message flags */
                pkt->area_flags(n2,&xti);
                if (xti.flags & XTI_IS_PERSONAL)
                {
                    /* Message is personal.. */
                    found++;

                    /* Is it unread? */
                    pers.unread = (xti.flags & XTI_HAS_READ) == 0;
                    if (pers.unread) unread++;

                    /* Copy message to personal pers.msg */
                    pkt->read_msg(n2);
                    memcpy(&pers.msg,&msg,sizeof(msg));

                    sprintf(tmp,lang[87],found);
                    cmiddle(9,tmp,color[col_info_text]);

                    /* Write to file */
                    pers.area = num;
                    pers.msgnum = n2;
                    if (fwrite(&pers,sizeof(pers),1,Fpers) == 0)
                    {
                        /* Error writing to file */
                        old_scr(cx,cy,&oldscr);
                        err_box("Error writing to file, out of disk space?");
                        fclose(Fpers);

                        sprintf(tmp,"%ssky_pers.idx",setup.workpath);
                        FileRemove(tmp);
                        return 0;
                    }
                }
            }
        }
    }

    if (found == 0)
    {
        /* No messages found */
        old_scr(cx,cy,&oldscr);
        save_scr(&cx,&cy,&oldscr);
        slen = strlen(lang[88])/2;
        draw_shaded_box(scrwidth/2-slen-2,8,scrwidth/2+slen+2,12,color[col_warn_frame],color[col_warn_title],NULL);
        cmiddle(10,lang[88],color[col_warn_hilight]);
        try_key(2);
    }
    else
    {
        /* Some personal messages found */
        slen = get_max_langtext_len(89,94);
        if (strlen(lang[89]) > slen) slen = strlen(lang[89]);
        slen /= 2;

        /* Ask if to read all of them, only unread or quit */
        draw_shaded_box(scrwidth/2-slen-4,6,scrwidth/2+slen+4,15,color[col_info_frame],color[col_info_title],lang[89]);
        sprintf(tmp,lang[90],found);
        cmiddle(8,tmp,color[col_info_text]);
        sprintf(tmp,lang[91],unread);
        cmiddle(9,tmp,color[col_info_text]);

        cmiddle(11,lang[92],color[col_info_hilight]);
        cmiddle(12,lang[93],color[col_info_hilight]);
        cmiddle(13,lang[94],color[col_info_hilight]);

        sel = 1;
        tattrbar(scrwidth/2-slen-3,11,scrwidth/2+slen+3,11,color[col_info_selectbar]);
        quit = 0;
        while (!quit)
        {
            if (sk_kbhit())
            {
                ch = sk_getch();
                switch (ch)
                {
                    case 13:
                        /* Enter = Read all */
                        quit = 1; break;
                    case 27:
                        /* ESC = Quit */
                        quit = 1; sel = 3; break;
                    case 0:
                        ch = sk_getch();
                        switch (ch)
                        {
                            case 'P':
                                /* Down */
                                tattrbar(scrwidth/2-slen-3,10+sel,scrwidth/2+slen+3,10+sel,color[col_info_hilight]);
                                if (sel == 3) sel = 1; else sel++;
                                if ((sel == 2) && (unread == 0)) sel++;
                                tattrbar(scrwidth/2-slen-3,10+sel,scrwidth/2+slen+3,10+sel,color[col_info_selectbar]);
                                break;
                            case 'H':
                                /* Up */
                                tattrbar(scrwidth/2-slen-3,10+sel,scrwidth/2+slen+3,10+sel,color[col_info_hilight]);
                                if (sel == 1) sel = 3; else sel--;
                                if ((sel == 2) && (unread == 0)) sel--;
                                tattrbar(scrwidth/2-slen-3,10+sel,scrwidth/2+slen+3,10+sel,color[col_info_selectbar]);
                                break;
                        }
                }
            }
            else
            {
                give_timeslice();
            }
        }

        if (sel == 1)
        {
            /* Read all personal messages */
            read_area(-1);
        }
        else
        {
            if (sel == 2) {
                /* Read only unread */
                pos = 0;
                for (num=0; num<found; num++) {
                    /* Read record */
                    fseek(Fpers,num*sizeof(pers_rec),SEEK_SET);
                    if (fread(&pers,sizeof(pers),1,Fpers) == 0) break;

                    if (pos != num && pers.unread)
                    {
                        /* Message unread */
                        fseek(Fpers,pos*sizeof(pers_rec),SEEK_SET);
                        if (fwrite(&pers,sizeof(pers_rec),1,Fpers) == 0) break;
                        pos++;
                    }
                }

                /* Truncate file */
                fseek(Fpers,unread*sizeof(pers_rec),SEEK_SET);
                ftrunc(Fpers,pos*sizeof(pers_rec));

                /* Read messages */
                read_area(-1);
            }
        }
    }
    fclose(Fpers);

    /* Remove work\sky_pers.idx */
    sprintf(tmp,"%ssky_pers.idx",setup.workpath);
    FileRemove(tmp);

    old_scr(cx,cy,&oldscr);
    return 0;
}

extern int packet_modified;

int remove_deleted_msgs(SCROLL_BOX *)
{
    unsigned short cx,cy;
    char *oldscr;

    unsigned num,n2,found,afound,pfound,slen,last,areas,mixpos;
    char tmp[256];

    XTI_REC xti;

    char anum[6];
    unsigned long txtoffset;

    if (fmt != format_bw)
    {
        err_box("Currently supported only with Blue Wave packets");
        return 0;
    }

    if (!ask_choice(lang[333], 0)) return 0;

    save_scr(&cx,&cy,&oldscr);
    slen = get_max_langtext_len(85,87)/2;
    draw_shaded_box(scrwidth/2-slen-4,6,scrwidth/2+slen+4,11,color[col_info_frame],color[col_info_title],lang[310]);

    found = 0; last = 0; txtoffset = 0; areas = 0;
    for (num=1; num<=pkt->areas; num++)
    {
        if (last != (num*100) / pkt->areas)
        {
            last = (num*100) / pkt->areas;
            sprintf(tmp,lang[311],(num*100) / pkt->areas);
            cmiddle(8,tmp,color[col_info_hilight]);
            refresh();
        }

        strcpy(anum,pkt->get_area_number(num));
        if ((mixpos = pkt->getarea(anum)) > 0 && pkt->open_area(anum))
        {
            pkt->msgptr -= found;
            afound = 0; pfound = 0;
            for (n2=1; n2<=pkt->get_msgs(anum); n2++)
            {
                pkt->area_flags(n2-afound,&xti);
                if (xti.marks & XTI_MARK_DELETE)
                {
                    /* Message is deleted.. */
                    sprintf(tmp,lang[312], found);
                    cmiddle(9,tmp,color[col_info_text]);

                    packet_modified = 1;

                    pkt->read_msg(n2-afound);
                    msg.blockpos -= txtoffset;
                    txtoffset += msg.txtblocks;
                    pkt->delete_msg(n2-afound);
                    pkt->delete_xti(n2-afound);

                    afound++;
                    if (xti.flags & XTI_IS_PERSONAL) pfound++;
                }
                else if (txtoffset != 0)
                {
                    pkt->read_msg(n2-afound);
                    msg.blockpos -= txtoffset;
                    pkt->write_msg(n2-afound);
                }
            }

            if (found != 0 || afound != 0)
            {
                MIX_REC mix;

                /* Read .mix entry */
                memcpy(&mix, &pkt->mix_buf[mixpos-pkt->mix_start], sizeof(MIX_REC));

                if (mix.totmsgs != afound)
                {
                    /* Update .mix entry */
                    mix.totmsgs -= afound;
                    mix.numpers -= pfound;
                    mix.msghptr -= found*sizeof(FTI_REC);
                    pkt->write_mix(mixpos, &mix);
                }
                else
                {
                    /* No messages left in this area, remove .mix entry */
                    pkt->delete_mix(mixpos);
                    areas++;
                }
                found += afound;
            }
        }
    }
    //pkt->areas -= areas;

    old_scr(cx,cy,&oldscr);

    return found != 0;
}

int arealist_tab(SCROLL_BOX *scrbox)
{
    char *strp;
    unsigned nro,lines;

    for (nro=scrbox->ypos+scrbox->upy+1; nro<=areas; nro++)
    {
        /* Open area */
        strp = pkt->get_area_number(areaptrs[nro-1]);
        if (pkt->open_area(strp))
        {
            if (pkt->get_unread_msgs(strp) > 0)
            {
                lines = nro-scrbox->ypos-scrbox->upy;
                while (lines > 0)
                {
                    if (scrbox->ypos < scrbox->yend-scrbox->ystart+1)
                    {
                        scrbox->ypos++;
                    }
                    else
                    {
                        scrbox->upy++;
                    }
                    lines--;
                }
                return 1;
            }
        }
    }

    return 0;
}

int global_search(SCROLL_BOX *)
{
    if (search_message(1, -3, 0))
        read_area(-3);
    return 0;
}

int arealist_shifttab(SCROLL_BOX *scrbox)
{
    char *strp;
    unsigned nro,lines;

    for (nro=scrbox->ypos+scrbox->upy-1; nro>=1; nro--)
    {
        /* Open area */
        strp = pkt->get_area_number(areaptrs[nro-1]);
        if (pkt->open_area(strp))
        {
            if (pkt->get_unread_msgs(strp) > 0)
            {
                lines = scrbox->ypos+scrbox->upy-nro;
                while (lines > 0)
                {
                    if (scrbox->ypos > 1)
                    {
                        scrbox->ypos--;
                    }
                    else
                    {
                        scrbox->upy--;
                    }
                    lines--;
                }
                return 1;
            }
        }
    }

    scrbox->ypos = 1;
    scrbox->upy = 0;
    return 1;
}

void write_new_msg(unsigned pos)
{
    unsigned short cx,cy;
    char *oldscr;

    int ch,num;
    char pvt;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-25,8,scrwidth/2+26,12,color[col_info_frame],color[col_info_title],lang[82]);
    cmiddle(10,lang[83],color[col_info_hilight]);

    for (;;)
    {
        ch = toupper(sk_getch());
        if (ch == toupper(lang[84][0])) {
            /* Yes! Write message! */
            num = pkt->area_type(areaptrs[pos-1]);
            pvt = num&TYPE_NOPUB ? 0 : 1;
            write_msg(0,pkt->get_area_tag(areaptrs[pos-1]),"All",NULL,pvt,0,0);
            break;
        }

        if ((ch == 13) || (ch == 27) || (ch == toupper(lang[84][1]))) break;
    }
    old_scr(cx,cy,&oldscr);
}

/* Draw message areas and select area */
void read_msgs(void)
{
    unsigned short ox,oy;
    char *oldscr;

    char found,*strp, tmp[256];
    unsigned times,pos,nro,uread;

    SCROLL_BOX scrbox;

    /* Allocate memory to area pointers (which areas will be shown) */
    areaptrs = (short *) malloc(sizeof(short)*pkt->areas);
    if (areaptrs == NULL)
    {
        err_box("Not enough memory!");
        return;
    }

    save_scr(&ox,&oy,&oldscr);

    areas = 0;
    if (opt.rflags & AREAS_ONLY_MSGS)
    {
        uread = opt.rflags & AREAS_ONLY_UNREAD_MSGS;
        for (;;)
        {
            /* Display areas only with msgs */
            for (nro=1; nro<=pkt->areas; nro++)
            {
                if (uread ?
                    pkt->get_unread_msgs(pkt->get_area_number(nro)) :
                    pkt->get_msgs(pkt->get_area_number(nro)))
                {
                    areaptrs[areas] = (short) nro;
                    areas++;
                }
            }
            if (areas != 0 || !uread) break;
            uread = 0;
        }
    }
    else
    {
        /* Display all areas */
        areas = pkt->areas;
        for (nro=0; nro<areas; nro++)
            areaptrs[nro] = (short) (nro+1);
    }

    if (areas == 0)
    {
        /* No messages in areas */
        err_box(lang[22]);
        free(areaptrs);
        return;
    }

    /* Draw headers */
    draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_read_frame],color[col_read_title],lang[21]);
    cwritexy(5,4,lang[62],color[col_read_help]);
    cwritexy(scrwidth-22,4,lang[63],color[col_read_help]);
    draw_hline(3,scrwidth-2,5,color[col_read_frame]);
    sprintf(tmp, " %s ", lang[322]);
    cmiddle(scrsize-1, tmp, color[col_read_title]);

    /* Select area */
    memset(&scrbox,0,sizeof(scrbox));
    scrbox.ypos = 0;
    scrbox.upy = 0;
    scrbox.xstart = 4;
    scrbox.xend = scrwidth-3;
    scrbox.ystart = 6;
    scrbox.yend = scrsize-2;
    scrbox.lines = &areas;
    scrbox.scrollbar_color = color[col_read_selectbar];
    scrbox.background_color = color[col_read_number];
    scrbox.draw_func = (DRAW_FUNC) draw_line;
    add_key(9,0,(SCROLL_FUNC) arealist_tab, &scrbox);
    add_key(0,15,(SCROLL_FUNC) arealist_shifttab, &scrbox);
    add_key(0,165,(SCROLL_FUNC) arealist_shifttab, &scrbox);
    add_key(0,19,(SCROLL_FUNC) read_flagged, &scrbox);
    add_key(0,25,(SCROLL_FUNC) mail_scan, &scrbox);
    add_key('E',0,(SCROLL_FUNC) enter_msg_rm, &scrbox);
    add_key('K',0,(SCROLL_FUNC) global_search, &scrbox);
    add_key(0,32,(SCROLL_FUNC) remove_deleted_msgs, &scrbox);
    pos = 0;

    if (!mailscanned && opt.rflags & AUTO_MAIL_SCAN)
    {
        /* Auto mail scan */
        mail_scan(NULL);
    }
 
    for (;;)
    {
        found = 0;
        if (pos < areas && opt.rflags & AUTO_ADVANTAGE)
        {
            /* Go to next area which has unread messages */
            for (nro=pos; nro<areas; nro++)
            {
                strp = pkt->get_area_number(areaptrs[nro]);
                pkt->open_area(strp);

                if (pkt->get_unread_msgs(strp) > 0)
                {
                    found = 1;
                    break;
                }
            }
        }

        if (found)
        {
            times = nro-pos+1;
        }
        else
        {
            times = (pos<areas) && (opt.rflags & AUTO_ADVANTAGE) ? 1 : 0;
            if (pos == 0 && times == 0) times = 1;
        }

        while (times != 0)
        {
            /* Move one area down */
            if (scrbox.ypos < scrsize-7)
            {
                scrbox.ypos++;
            }
            else
            {
                if (areas > scrbox.upy+scrbox.ypos)
                {
                    scrbox.upy++;
                }
            }
            times--;
        }

        /* Get area */
        pos = scroll_box(&scrbox);
        if (pos == 0) break; /* Quit */

        /* Read setup configuration */
        read_setup(pkt->get_area_tag(areaptrs[pos-1]));

        /* Read translation tables */
        read_table(1,inbound,opt.intable);
        read_table(0,outbound,opt.outtable);

        if (pkt->get_msgs(pkt->get_area_number(areaptrs[pos-1])) == 0)
        {
            /* No messages in area, write new message to it */
            write_new_msg(pos);
        }
        else
        {
            /* Read message area */
            read_area(areaptrs[pos-1]);
            pkt->update_area_flags();

            /* Read setup configuration */
            read_setup(pkt->get_area_tag(areaptrs[pos-1]));
            read_table(1,inbound,opt.intable);
        }
    }

    deinit_scroll_box(&scrbox);
    free(areaptrs);
    old_scr(ox,oy,&oldscr);
}
