#ifndef __SCROLBOX_H
#define __SCROLBOX_H

typedef int (*DRAW_FUNC) (unsigned, unsigned);
typedef int (*SCROLL_FUNC) (void *);

typedef struct _scrol_key
{
    struct _scrol_key *next;
    char key1,key2;
    SCROLL_FUNC func;
}
SCROLL_KEY;

typedef struct
{
    unsigned ypos,upy;
    unsigned xstart,xend;
    unsigned ystart,yend;
    unsigned *lines;
    unsigned char scrollbar_color;
    unsigned char background_color;
    DRAW_FUNC draw_func;
    SCROLL_KEY *first_key;
    SCROLL_KEY *cur_key;
}
SCROLL_BOX;

unsigned scroll_box(SCROLL_BOX *box);
void deinit_scroll_box(SCROLL_BOX *box);
void add_key(char key1, char key2, SCROLL_FUNC func, SCROLL_BOX *box);

#endif
