#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "screen.h"
#include "vars.h"
#include "shell.h"
#include "keyb.h"
#include "files.h"
#include "general.h"
#include "scrsaver.h"

#ifdef __linux__
#  define CHECK 'x'
#else
#  define CHECK 251
#endif

#define BUF_SIZE 4096

typedef struct _tag_line
{
    struct _tag_line *next;
    unsigned long seekpos;
    char comment;
}
TAG_REC;

static fpos_t bufstart,bufend;
static fpos_t lastpos,pos;
static char *readbuf;

static TAG_REC *first_tag;
static TAG_REC *tag;
static unsigned long tagpos;

static char tag_fname[256];
static FILE *Ftag;

static char str[256];

char read_ln(void)
{
    size_t readed,num;

    if ((bufstart > pos) || (bufend < pos + 255))
    {
        fseek(Ftag,pos,SEEK_SET);
        readed = fread(readbuf,1,BUF_SIZE,Ftag);
        bufstart = pos;
        bufend = pos + readed - 1;
    } else readed = 256;

    memcpy(str,&readbuf[pos - bufstart],255);
    if (readed < 255)
        str[readed] = 0;
    else
        str[255] = 0;

    num = 0;
    while (str[num] != 0)
    {
        if (str[num] == '\r' || str[num] == '\n')
        {
            if (str[num] == '\r')
                str[num++] = '\0';
            else
                str[num] = '\0';
            break;
        }
        num++;
    }

    pos += num+1;
    if (num >= readed)
        return 1;
    else
        return 0;
}

char manual_tagline(char *str)
{
    unsigned short cx,cy;
    char *oldscr;

    char info,savefile;

    save_scr(&cx,&cy,&oldscr);
    draw_shaded_box(scrwidth/2-37,10,scrwidth/2+38,15,color[col_info_frame],
                    color[col_info_title],lang[244]);
    keyb_keys = 1;
    highwrite_locol = color[col_info_text];
    highwrite_hicol = color[col_info_hilight];
    keys[0] = highwrite(scrwidth/2-strlen(lang[245])/2,14,lang[245],NULL);
    highwrite_locol = color[col_box_text];
    highwrite_hicol = color[col_box_hilight];
    savefile = 0;
    str[0] = 0;
    key_xpos = 0;
    key_xovr = 0;
    do {
        info = get_string(scrwidth/2-35,12,75,73,str,4+128,color[col_info_hilight],
                          color[col_info_text],0);
        if (key_found != 0) {
            savefile = !savefile;
            if (savefile)
                writechr(26,14,CHECK,color[col_info_hilight]);
            else
                writechr(26,14,' ',color[col_info_hilight]);
        }
    } while (key_found != 0);
    if (info == 5) str[0] = 0;
    old_scr(cx,cy,&oldscr);
    return savefile;
}

void write_tagline(char ypos, char *str)
{
    char col;

    if (strnicmp(str,"[COMMENT]",9) == 0) {
        str += 9;
        col = color[col_tag_comment];
    }
    else if (strnicmp(str,"[ALTLIST]",9) == 0)
    {
        str += 9;
        col = color[col_tag_newfile];
    }
    else if (strnicmp(str,"[EXTERNAL]",10) == 0)
    {
        str += 10;
        col = color[col_tag_external];
    }
    else
        col = color[col_tag_tags];
    cwritexy(5,ypos,str,col);
}

unsigned long get_random_tag(unsigned long random_tags)
{
    unsigned num,seek;

    seek = (rand() % random_tags)+1;

    num = 0;
    tag = first_tag;
    tagpos = 1;
    while (tag != NULL)
    {
        if (!tag->comment)
        {
            if (++num == seek)
            {
                pos = tag->seekpos;
                read_ln();
                if (strnicmp(str,"[ALTLIST]",9) == 0)
                {
                    strcpy(tag_fname,str+9);
                    return 0;
                }
            }
        }
        tag = tag->next;
        tagpos++;
    }
    if (tag == NULL) tagpos = 0;

    return seek;
}

void seek_tag(unsigned pos)
{
    if (tagpos == pos) return;

    if (tagpos > pos || tagpos == 0)
    {
        tagpos = 1;
        tag = first_tag;
    }

    while (tagpos < pos && tag != NULL)
    {
        tag = tag->next;
        tagpos++;
    }
    if (tag == NULL) tagpos = 0;
}

void make_tagline(char tofile)
{
    unsigned short cx,cy,cx2,cy2;
    char *oldscr,*oldscr2;

    char tmp[256],search[50],quit;
    unsigned lines,random_tags;

    char ch,info,savefile,slen;
    unsigned max,ypos;
    unsigned upy,num;

    FILE *Ftxt;
    TAG_REC *prev;


    find_t SR;

    search[0] = 0;
    pos = 0;
    if ((opt.taglines != TAGLINE_MANUAL) && (opt.taglines != TAGLINE_EXTERNAL))
    {
        if ((readbuf = (char *) malloc(BUF_SIZE)) == NULL) return;
        strcpy(tag_fname, opt.tagfile);
    all_again:
        pos = 0;
        bufstart = 1; bufend = 0;

        if ((Ftag = FileOpen(tag_fname,"rb")) == NULL)
        {
            free(readbuf);
            return;
        }

        lastpos = 0;
        lines = 0;
        random_tags = 0;
        quit = 0;

        first_tag = NULL;
        tag = NULL;
        while (!quit)
        {
            lastpos = pos;
            quit = read_ln();

            if (str[0] != '\0' && str[0] != ';')
            {
                prev = tag;
                tag = (TAG_REC *) malloc(sizeof(TAG_REC));
                if (prev != NULL) prev->next = tag;
                if (first_tag == NULL) first_tag = tag;
                tag->next = NULL;
                tag->seekpos = lastpos;
                lines++;
                if (str[0] != '[' || (strnicmp(str,"[COMMENT]",9) && strnicmp(str,"[EXTERNAL]",10)))
                {
                    random_tags++;
                    tag->comment = 0;
                }
                else tag->comment = 1;
            }
        }

        tag = first_tag;
        tagpos = 1;
    }

    srand(clock());
    if (!tofile)
    {
        if (random_tags == 0)
        {
            err_box(lang[276]);
        }
        else
        {
            pos = get_random_tag(random_tags);
            if (pos == 0) goto all_again;
        }
    }
    else switch (opt.taglines)
    {
        case TAGLINE_RANDOM:
            if (random_tags == 0)
            {
                err_box(lang[276]);
            }
            else
            {
                pos = get_random_tag(random_tags);
                if (pos == 0) goto all_again;
            }
            break;
        case TAGLINE_PROMPT:
            save_scr(&cx,&cy,&oldscr);
            draw_shaded_box(3,3,scrwidth-2,scrsize-1,color[col_tag_frame],color[col_tag_title],"Select tagline");
            cwritexy(5,4,lang[246],color[col_tag_hilight]);

            ch = tag_fname[65]; tag_fname[65] = 0;
            cwritexy(11,4,tag_fname,color[col_tag_text]);
            tag_fname[65] = ch;

            draw_hline(3,scrwidth-2,5,color[col_tag_frame]);
            draw_hline(3,scrwidth-2,scrsize-4,color[col_tag_frame]);

            cwritexy(6,scrsize-3,lang[247],color[col_tag_hilight]);
            cwritexy(14,scrsize-3,lang[248],color[col_tag_text]);
            cwritexy(6,scrsize-2,lang[249],color[col_tag_hilight]);
            cwritexy(14,scrsize-2,lang[250],color[col_tag_text]);

            cwritexy(28,scrsize-3,lang[251],color[col_tag_hilight]);
            cwritexy(36,scrsize-3,lang[252],color[col_tag_text]);
            cwritexy(28,scrsize-2,lang[253],color[col_tag_hilight]);
            cwritexy(36,scrsize-2,lang[254],color[col_tag_text]);

            cwritexy(51,scrsize-3,lang[255],color[col_tag_hilight]);
            cwritexy(59,scrsize-3,lang[256],color[col_tag_text]);
            cwritexy(51,scrsize-2,lang[257],color[col_tag_hilight]);
            cwritexy(59,scrsize-2,lang[258],color[col_tag_text]);

            max = scrsize-10;
            if (lines < max) max = lines;
            for (ypos=1; ypos<=max; ypos++)
            {
                seek_tag(ypos);
                pos = tag->seekpos;
                read_ln(); str[scrwidth-8] = '\0';
                write_tagline(ypos+5,str);
            }

            ypos = 1; upy = 0;
            quit = 0;
            tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_selectbar]);
            while (!quit)
            {
                if (sk_kbhit())
                {
                    ch = sk_getch();
                    switch (ch)
                    {
                        case 0:
                            ch = sk_getch();
                            switch (ch)
                            {
                                case 19:
                                    /* Alt-R - Random selection */
                                    if (random_tags == 0)
                                    {
                                        err_box(lang[276]);
                                        break;
                                    }
                                    upy = get_random_tag(random_tags);
                                    if (upy == 0) goto all_again;
                                    ypos = 1;
                                    quit = 1;
                                    break;
                                case 30:
                                    /* Alt-A - Search again */
                                    ch = 0;
                                    for (num=ypos+upy; num<lines; num++)
                                    {
                                        seek_tag(num);
                                        pos = tag->seekpos;
                                        read_ln(); strupr(str);
                                        if (strstr(str,search))
                                        {
                                            upy = num;
                                            ch = 1;
                                            tbar(4,6,scrwidth-3,scrsize-5,color[col_tag_tags]);
                                            max = scrsize-10;
                                            if (max+upy > lines) max = lines-upy;
                                            for (ypos=1; ypos<=max; ypos++) {
                                                seek_tag(ypos+upy);
                                                pos = tag->seekpos;
                                                read_ln(); str[scrwidth-8] = '\0';
                                                write_tagline(ypos+5,str);
                                            }
                                            ypos = 1;
                                            tattrbar(4,6,scrwidth-3,6,color[col_tag_selectbar]);
                                            break;
                                        }
                                    }
                                    if (!ch)
                                    {
                                        save_scr(&cx2,&cy2,&oldscr2);
                                        draw_shaded_box(scrwidth/2-11,13,scrwidth/2+11,17,color[col_warn_frame],color[col_warn_title],NULL);
                                        cmiddle(15,"Tagline not found.",color[col_warn_hilight]);
                                        try_key(2);
                                        old_scr(cx2,cy2,&oldscr2);
                                    }
                                    break;
                                case 31:
                                    /* Alt-S - Search text */
                                    save_scr(&cx2,&cy2,&oldscr2);
                                    draw_shaded_box(scrwidth/2-25,10,scrwidth/2+25,14,color[col_info_frame],
                                                    color[col_info_title],"Search tagline");
                                    key_xpos = 0; key_xovr = 0; keyb_keys = 0;
                                    info = get_string(scrwidth/2-23,12,47,47,search,5+128,color[col_info_hilight],color[col_info_text],0);
                                    old_scr(cx2,cy2,&oldscr2);
                                    if ((search[0] != 0) && (info != 5)) {
                                        ch = 0;
                                        for (num=ypos+upy; num<=lines; num++)
                                        {
                                            seek_tag(num);
                                            pos = tag->seekpos;
                                            read_ln(); strupr(str);
                                            if (strstr(str,search))
                                            {
                                                upy = num-1;
                                                ch = 1;
                                                tbar(4,6,scrwidth-3,scrsize-5,color[col_tag_tags]);
                                                max = scrsize-10;
                                                if (max+upy > lines) max = lines-upy;
                                                for (ypos=1; ypos<=max; ypos++) {
                                                    seek_tag(ypos+upy);
                                                    pos = tag->seekpos;
                                                    read_ln(); str[scrwidth-8] = 0;
                                                    write_tagline(ypos+5,str);
                                                }
                                                ypos = 1;
                                                tattrbar(4,6,scrwidth-3,6,color[col_tag_selectbar]);
                                                break;
                                            }
                                        }
                                        if (!ch)
                                        {
                                            save_scr(&cx2,&cy2,&oldscr2);
                                            draw_shaded_box(scrwidth/2-11,13,scrwidth/2+11,17,color[col_warn_frame],color[col_warn_title],NULL);
                                            cmiddle(15,"Tagline not found.",color[col_warn_hilight]);
                                            try_key(2);
                                            old_scr(cx2,cy2,&oldscr2);
                                        }
                                    }
                                    break;
                                case 33:
                                    /* Alt-F - Load new file */
                                    save_scr(&cx2,&cy2,&oldscr2);
                                    draw_shaded_box(scrwidth/2-35,10,scrwidth/2+35,14,color[col_info_frame],
                                                    color[col_info_title],lang[259]);
                                    key_xpos = 0; key_xovr = 0; keyb_keys = 0;
                                    info = get_string(scrwidth/2-33,12,67,67,tag_fname,4+128,color[col_info_hilight],color[col_info_text],0);
                                    if ((tag_fname[0] != 0) && (info != 5) && (!exists(tag_fname)))
                                    {
                                        slen = strlen(lang[260])/2;
                                        draw_shaded_box(scrwidth/2-slen-2,12,scrwidth/2+slen+2,16,color[col_warn_frame],color[col_warn_title],NULL);
                                        cmiddle(14,lang[260],color[col_warn_hilight]);
                                        try_key(2);
                                        info = 5;
                                    }
                                    old_scr(cx2,cy2,&oldscr2);
                                    if ((info != 5) && (tag_fname[0] != 0)) {
                                        old_scr(cx,cy,&oldscr);
                                        fclose(Ftag);
                                        goto all_again;
                                    }
                                    break;
                                case 47:
                                    /* Alt-V = Random/View first */
                                    if (random_tags == 0)
                                    {
                                        err_box(lang[276]);
                                        break;
                                    }
                                    upy = get_random_tag(random_tags);
                                    if (upy == 0) goto all_again;

                                    tbar(4,6,scrwidth-3,scrsize-5,color[col_tag_tags]);
                                    max = scrsize-10;
                                    if (max+upy > lines) max = lines-upy;
                                    for (ypos=1; ypos<=max; ypos++)
                                    {
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                    }
                                    ypos = 1;
                                    tattrbar(4,6,scrwidth-3,6,color[col_tag_selectbar]);
                                    break;
                                case 50:
                                    /* Alt - Manual entry */
                                    savefile = manual_tagline(str);
                                    if (str[0] != 0) {
                                        ypos = 0;
                                        upy = 65535;
                                        quit = 1;
                                    }
                                    break;
                                case 'P':
                                    if (ypos+upy < lines) {
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_tags]);
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                        if (ypos == scrsize-10)
                                        {
                                            upy++;
                                            scroll_up(5,6,scrwidth-4,scrsize-5);
                                            seek_tag(ypos+upy);
                                            pos = tag->seekpos;
                                            read_ln(); str[scrwidth-8] = 0;
                                            tbar(5,ypos+5,scrwidth-4,ypos+5,color[col_tag_tags]);
                                            write_tagline(ypos+5,str);
                                        } else ypos++;
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_selectbar]);
                                    }
                                    break;
                                case 'H':
                                    if (ypos+upy > 1) {
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_tags]);
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                        if (ypos == 1) {
                                            upy--;
                                            scroll_down(5,6,scrwidth-4,scrsize-5);
                                            seek_tag(ypos+upy);
                                            pos = tag->seekpos;
                                            read_ln(); str[scrwidth-8] = 0;
                                            tbar(5,ypos+5,scrwidth-4,ypos+5,color[col_tag_tags]);
                                            write_tagline(ypos+5,str);
                                        } else ypos--;
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_selectbar]);
                                    }
                                    break;
                                case 'Q':
                                    if (ypos+upy < lines)
                                    {
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_tags]);
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                        if (ypos == scrsize-10)
                                        {
                                            upy += scrsize-11;
                                            if (upy+ypos > lines) upy = lines-ypos;
                                            tbar(5,6,scrwidth-4,scrsize-5,color[col_tag_tags]);
                                            for (ypos=1; ypos<=scrsize-10; ypos++)
                                            {
                                                seek_tag(ypos+upy);
                                                pos = tag->seekpos;
                                                read_ln(); str[scrwidth-8] = 0;
                                                write_tagline(ypos+5,str);
                                            }
                                            ypos = scrsize-10;
                                        } else {
                                            if (lines-upy < scrsize-10)
                                                ypos = lines-upy;
                                            else
                                                ypos = scrsize-10;
                                        }
                                        
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_selectbar]);
                                        break;
                                    }
                                    break;
                                case 'I':
                                    if (ypos+upy > 1) {
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_tags]);
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                        if (ypos == 1) {
                                            if (upy < scrsize-11)
                                                upy = 0;
                                            else
                                                upy -= scrsize-11;
                                            
                                            tbar(5,6,scrwidth-4,scrsize-5,color[col_tag_tags]);
                                            for (ypos=0; ypos<scrsize-10; ypos++) {
                                                seek_tag(ypos+upy+1);
                                                pos = tag->seekpos;
                                                read_ln(); str[scrwidth-8] = 0;
                                                write_tagline(ypos+6,str);
                                            }
                                        }
                                        ypos = 1;
                                        tattrbar(4,6,scrwidth-3,6,color[col_tag_selectbar]);
                                    }
                                    break;
                                case 'O':
                                    if (ypos+upy < lines) {
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_tags]);
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                        if (lines-upy > scrsize-10) {
                                            upy = lines-(scrsize-10);
                                            tbar(5,6,scrwidth-4,scrsize-5,color[col_tag_tags]);
                                            for (ypos=0; ypos<scrsize-10; ypos++) {
                                                seek_tag(ypos+upy+1);
                                                pos = tag->seekpos;
                                                read_ln(); str[scrwidth-8] = 0;
                                                write_tagline(ypos+6,str);
                                            }
                                        }
                                        if (lines-upy < scrsize-10)
                                            ypos = lines-upy;
                                        else
                                            ypos = scrsize-10;
                                        
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_selectbar]);
                                    }
                                    break;
                                case 'G':
                                    if (ypos+upy > 1) {
                                        tattrbar(4,ypos+5,scrwidth-3,ypos+5,color[col_tag_tags]);
                                        seek_tag(ypos+upy);
                                        pos = tag->seekpos;
                                        read_ln(); str[scrwidth-8] = 0;
                                        write_tagline(ypos+5,str);
                                        if (upy > 0) {
                                            upy = 0;
                                            tbar(5,6,scrwidth-4,scrsize-5,color[col_tag_tags]);
                                            for (ypos=0; ypos<scrsize-10; ypos++) {
                                                seek_tag(ypos+1);
                                                pos = tag->seekpos;
                                                read_ln(); str[scrwidth-8] = 0;
                                                write_tagline(ypos+6,str);
                                            }
                                        }
                                        ypos = 1;
                                        tattrbar(4,6,scrwidth-3,6,color[col_tag_selectbar]);
                                    }
                                    break;
                            }
                            break;
                        case 13:
                            seek_tag(ypos+upy);
                            pos = tag->seekpos;
                            read_ln();
                            if (str[0] == '[') {
                                if (strnicmp(str,"[COMMENT]",9) == 0) continue;
                                if (strnicmp(str,"[EXTERNAL]",10) == 0) {
                                    old_scr(cx,cy,&oldscr);
                                    goto __external;
                                }
                                if (strnicmp(str,"[ALTLIST]",9) == 0) {
                                    strcpy(tag_fname,str+9);
                                    old_scr(cx,cy,&oldscr);
                                    fclose(Ftag);
                                    goto all_again;
                                }
                            }
                            quit = 1;
                            break;
                        case 27:
                            ypos = 0; upy = 0;
                            quit = 1;
                            break;
                    }
                } else give_timeslice();
            }
            old_scr(cx,cy,&oldscr);
            pos = ypos+upy;
            break;
        case TAGLINE_MANUAL:
            savefile = manual_tagline(str);
            pos = 65535;
            break;
        case TAGLINE_EXTERNAL:
        __external:
            pos = 65535;
            save_scr(&cx,&cy,&oldscr);
            tclrscr();
            swapexec(setup.tagmgr,NULL,0);
            old_scr(cx,cy,&oldscr);
            if (_dos_findfirst("JH?.REP",0,&SR) == 0)
            {
                if ((Ftag = fopen_ign(SR.name,"rb")) != NULL)
                {
                    _fgets(str,76,Ftag);
                    fclose(Ftag);
                }
                FileRemove(SR.name);
#ifdef FIND_CLOSE
                _dos_findclose(&SR);
#endif
            }
            else
            {
                /* Tagline not found */
                save_scr(&cx,&cy,&oldscr);
                slen = strlen(lang[261])/2;
                draw_shaded_box(scrwidth/2-slen-2,13,scrwidth/2+slen+2,17,color[col_warn_frame],color[col_warn_hilight],NULL);
                cmiddle(15,lang[261],color[col_warn_hilight]);
                try_key(2);
                old_scr(cx,cy,&oldscr);
                str[0] = 0;
            }
            break;
    }

    if ((pos > 0) && (str[0] != '\0'))
    {
        if ((opt.taglines != TAGLINE_MANUAL) && (opt.taglines != TAGLINE_EXTERNAL))
        {
            if (pos < 65535)
            {
                seek_tag(pos);
                pos = tag->seekpos;
                read_ln(); str[scrwidth-8] = '\0';
            }
            fclose(Ftag);
        }

        if ((savefile) && (pos == 65535))
        {
            if ((Ftxt = FileOpen(tag_fname,"a+b")) != NULL)
            {
                fprintf(Ftxt,"%s\r\n",str);
                fclose(Ftxt);
            }
        }

        if (tofile)
        {
            if ((Ftxt = FileOpen(setup.msgtxt,"a+b")) != NULL)
            {
                fprintf(Ftxt,"\r\n... %s\r\n",conv_macros(str,tmp));
                fclose(Ftxt);
            }
        } else
            strcpy(tagline,conv_macros(str,tmp));

    } else fclose(Ftag);

    if ((opt.taglines != TAGLINE_MANUAL) && (opt.taglines != TAGLINE_EXTERNAL))
    {
        free(readbuf);
    }
}
