#ifndef __VARS_H
#define __VARS_H

#include <sys/types.h>
#include <stdio.h>
#include "pkt_obj.h"
#include "files.h"

/* Name and operating system of SkyReader.. */
#ifdef __NT__
#  define OPSYSTEM "W32"
#  define LONGOS "Win32"
#  define Reader_Name "SkyReader/Win32"
#  define DEF_CFG_FILE "SkyW32.CFG"
#elif defined (__OS2__)
#  define OPSYSTEM "2"
#  define LONGOS "OS2"
#  define Reader_Name "SkyReader/2"
#  define DEF_CFG_FILE "SkyOS2.CFG"
#elif defined (__386__)
#  define OPSYSTEM "386"
#  define LONGOS "386"
#  define Reader_Name "SkyReader/386"
#  define DEF_CFG_FILE "SkyDOS.CFG"
#elif defined (__linux__)
#  define OPSYSTEM "L"
#  define LONGOS "Linux"
#  define Reader_Name "SkyReader/Linux"
#  define DEF_CFG_FILE "~/.skyreader/config"
#else
#  define OPSYSTEM "D"
#  define LONGOS "DOS"
#  define Reader_Name "SkyReader/DOS"
#  define DEF_CFG_FILE "SkyDOS.CFG"
#endif

/* Text justifying */
#define JUSTIFY_NONE 0
#define JUSTIFY_LEFT 1
#define JUSTIFY_BOTH 2

/* Detect quote chars in this range */
#define QUOTE_MAX 7

/* Number of bytes to allocate for colors */
#define MaxColors 256

/* Colors */
enum
{
    col_title,
    col_clock,
    col_background,
    col_box_frame,
    col_box_title,
    col_box_text,
    col_box_scroll,
    col_box_hilight,
    col_box_select,
    col_box_disabled,

    col_mail_frame,
    col_mail_title,
    col_mail_filename,
    col_mail_bbsname,
    col_mail_select,

    col_pkt_frame,
    col_pkt_title,
    col_pkt_help,
    col_pkt_filename,
    col_pkt_opened,
    col_pkt_date,
    col_pkt_size,
    col_pkt_unknown,
    col_pkt_total,
    col_pkt_personal,
    col_pkt_read,
    col_pkt_format,
    col_pkt_ulpacket,
    col_pkt_selectbar,

    col_packing_frame,
    col_packing_text,

    col_bbs_name_text,
    col_bbs_name,
    col_sysop_name_text,
    col_sysop_name,

    col_warn_frame,
    col_warn_title,
    col_warn_text,
    col_warn_hilight,
    col_warn_selectbar,

    col_info_frame,
    col_info_title,
    col_info_text,
    col_info_hilight,
    col_info_disabled,
    col_info_selectbar,

    col_emsg_frame,
    col_emsg_title,
    col_emsg_text,
    col_emsg_hilight,
    col_emsg_disabled,
    col_emsg_selfieldtxt,
    col_emsg_selfieldback,
    col_emsg_selectbar,

    col_list_clock,
    col_list_frame,
    col_list_title,
    col_list_help,
    col_list_number,
    col_list_from,
    col_list_fromyou,
    col_list_to,
    col_list_toyou,
    col_list_subj,
    col_list_flags,
    col_list_selectbar,
    col_list_disabled,

    col_area_frame,
    col_area_title,
    col_area_help,
    col_area_number,
    col_area_type,
    col_area_name,
    col_area_tagname,
    col_area_selectbar,
    col_area_tagged,
    col_area_tagged2,

    col_read_frame,
    col_read_title,
    col_read_help,
    col_read_allread,
    col_read_number,
    col_read_name,
    col_read_total,
    col_read_personal,
    col_read_unread,
    col_read_selectbar,

    col_msg_clock,
    col_msg_frame,
    col_msg_title,
    col_msg_label,
    col_msg_msgnum,
    col_msg_from,
    col_msg_to,
    col_msg_subj,
    col_msg_date,
    col_msg_status,
    col_msg_flags_on,
    col_msg_flags_off,
    col_msg_marks_on,
    col_msg_marks_off,
    col_msg_searchtxt,

    col_text_normal,
    col_text_bold,
    col_text_underlined,
    col_text_italic,
    col_text_quote,
    col_text_tagline,
    col_text_tearline,
    col_text_origin,
    col_text_ext,

    col_tag_frame,
    col_tag_title,
    col_tag_hilight,
    col_tag_text,
    col_tag_tags,
    col_tag_external,
    col_tag_comment,
    col_tag_newfile,
    col_tag_selectbar,

    col_scroll_arrow,
    col_scroll_backg,
    col_scroll_block,

    col_editor_text,
    col_editor_quote,
    col_editor_tagline,
};

/* Archiver formats */
#define format_aux  0
#define format_zip  1
#define format_arj  2
#define format_rar  3
#define format_lha  4
#define format_uc2  5
#define format_sky  6

/* Mail packet formats */
#define format_bw    1
#define format_hippo 2
#define format_omen  3
#define format_qwk   4
#define format_soup  5
#define format_jam   6

/* Reply flags */
#define flag_private    0x0001
#define flag_netmail    0x0002
#define flag_deleted    0x0004
#define flag_alias      0x0008
#define flag_email      0x0010
#define flag_omen_del   0x0020
#define flag_omen_tog   0x0040
#define flag_omen_move  0x0080
#define flag_received   0x0100

/* Netmail reply flags */
#define NET_CRASH       0x0001
#define NET_DIRECT      0x0002
#define NET_IMMEDIATE   0x0004
#define NET_HOLD        0x0008
#define NET_KILLSENT    0x0010
#define NET_FATTACH     0x0020
#define NET_FREQ        0x0040

/* Area types */
#define TYPE_ALIAS      0x0001
#define TYPE_ANYNAME    0x0002
#define TYPE_ECHO       0x0004
#define TYPE_NET        0x0008
#define TYPE_NOPVT      0x0010
#define TYPE_NOPUB      0x0020
#define TYPE_NORIGHTS   0x0040
#define TYPE_NOTAGS     0x0080
#define TYPE_INET       0x0100

typedef char LangType[81];
typedef char CmdStr[256];
typedef char PathStr[256];

#define OPTIONS_DEFAULT     1
#define OPTIONS_PKTOVRRIDE  2
#define OPTIONS_AREAOVRRIDE 3

/* Misc sets */
#define MISC_SHOW_TIME          0x01
#define MISC_APPEND_SAVEFILE    0x02
#define MISC_DISPLAY_OUTPUT     0x04
#define MISC_ASK_APPEND         0x08
#define MISC_SHOW_SCROLLBAR     0x10
#define MISC_TAG_AFTER_SIG      0x20
#define MISC_SCROLL_DOWN        0x40

/* Packet sets */
#define PKT_SAVE_BOOK           0x01
#define PKT_REN_PACKET          0x02
#define PKT_SAVE_UNPACKED       0x04
#define PKT_KEEP_PACKED         0x08
#define PKT_QWK_INDEXES_ALWAYS  0x10
#define PKT_QWK_MIXED_CASE      0x20
#define PKT_AUTO_MOVE_PACKET    0x40
#define PKT_DISPLAY_DIRS        0x80

/* Packet sorting */
#define PKTSORT_DATE 1
#define PKTSORT_NAME 2
#define PKTSORT_EXT  3

/* Message sorting */
#define MSGSORT_NONE 0
#define MSGSORT_SUBJ 1
#define MSGSORT_FROM 2
#define MSGSORT_TO   3
#define MSGSORT_DEF  4

/* Reply sorting */
#define REPLYSORT_NONE 0
#define REPLYSORT_TO   1
#define REPLYSORT_AREA 2
#define REPLYSORT_SUBJ 3
#define REPLYSORT_DEF  4

/* Screen resolution structure */
typedef struct {
    unsigned short columns;
    unsigned short rows;
#ifdef __OS2__
    unsigned short hres;
    unsigned short vres;
#elif defined (__NT__)
    unsigned short fill1;
    unsigned short fill2;
#else
    unsigned short _ax;
    unsigned short _bx;
#endif
} SStruct;

/* Configuration structure */
typedef struct
{
    char    VerID;
    char    UsrName[36];

    CmdStr  zip_cmd;
    CmdStr  unzip_cmd;
    CmdStr  arj_cmd;
    CmdStr  unarj_cmd;
    CmdStr  rar_cmd;
    CmdStr  unrar_cmd;
    CmdStr  uc2_cmd;
    CmdStr  unuc2_cmd;
    CmdStr  lha_cmd;
    CmdStr  unlha_cmd;
    CmdStr  aux_cmd;
    CmdStr  unaux_cmd;

    CmdStr  editor;
    CmdStr  spellchk;
    CmdStr  tagmgr;
    CmdStr  PGPPath;

    CmdStr  extprog[9];

    PathStr datapath;
    PathStr downpath;
    PathStr uppath;
    PathStr workpath;
    PathStr replypath;
    PathStr packetpath;
    PathStr oldpktpath;

    char    misc_flags;
    short   scrsaver;
    char    packetsort;
    short   packet_flags;

    char    empty[129+129+129+129+1290]; //

    char    modenum;
    SStruct scrmode[5];

    char    msgpktmask[256];
    char    pgp_userid[51];
    char    title[61];

    char    justify;
    unsigned char left_margin;
    unsigned char right_margin;

    char    empty2[129]; //
    char    msgtxt[256];
    char    empty3[16];
    char    vernum[20];
    char    inet_addr[100];
    char    tearline[30];

    char    reserved[358];
}
SetupRecord;

/* Packet index in PACKETS\pktname.___ file */
typedef struct
{
    char oldname[13];
    char idxname[13];
    unsigned short packet;
}
packet_index;

/* Packet record */
typedef struct
{
    char fname[13];
    unsigned long size;
    char pkt_note[71];
    unsigned char fmt;
    unsigned short total;
    unsigned short personal;
    unsigned char unread;
    unsigned char open;
    unsigned short pktnumber;
    unsigned long time;
    unsigned char arcfmt;
    char replypkt[9];
    char unused[17];
}
pkt_type;

/* Message record */
typedef struct
{
    unsigned long mnum;
    char mfrom[100];
    char mto[100];
    char subj[100];
    char date[20];
    unsigned short area;
    unsigned long replyto;
    unsigned long replyat;
    unsigned long blockpos;
    unsigned long txtblocks;
    unsigned short flags;
    unsigned short zone;
    unsigned short net;
    unsigned short node;
}
msgtype;

/* Reply record */
typedef struct
{
    char mfrom[36];
    char mto[200];
    char subj[100];
    char date[30];

    unsigned long replyto;

    unsigned short destzone;
    unsigned short destnet;
    unsigned short destnode;
    unsigned short destpoint;

    char area[61];
    char flags;
    unsigned short netflags;
    char fname[13];
}
replytype;

/* Personal mail scan record */
typedef struct
{
    unsigned area;
    unsigned msgnum;
    char unread;
    msgtype msg;
}
pers_rec;

/* Read flags */

#define AUTO_TITLE_SCAN         0x0001
#define AUTO_TITLE_DEFAULT      0x0002

#define AUTO_MAIL_SCAN          0x0004
#define AUTO_MAIL_DEFAULT       0x0008

#define NOICE_PERSONAL          0x0010
#define NOICE_PERS_DEFAULT      0x0020

#define AUTO_ADVANTAGE          0x0040
#define AUTO_ADV_DEFAULT        0x0080

#define AREAS_ONLY_MSGS         0x0100
#define AREAS_ONLY_MSGS_DEFAULT 0x0200

#define TREAT_I_NORMAL          0x0400
#define TREAT_I_DEFAULT         0x0800

#define STRIP_RE                0x1000
#define STRIP_RE_DEFAULT        0x2000

#define AREAS_ONLY_UNREAD_MSGS         0x0400
#define AREAS_ONLY_UNREAD_MSGS_DEFAULT 0x0800


/* Write flags */

#define INSERT_QUOTE            0x01
#define INSERT_QUOTE_DEFAULT    0x02

#define QUOTE_NOT4U             0x04
#define QUOTE_NOT4U_DEFAULT     0x08

#define AUTO_SAVE               0x10
#define AUTO_SAVE_DEFAULT       0x20

#define REMOVE_SPACES           0x40
#define REMOVE_SPACES_DEFAULT   0x80

/* Write flags 2 */

#define SUBJ_HEADER             0x01
#define SUBJ_HEADER_DEFAULT     0x02

/* Quote styles */

#define QUOTE_IDIOT             0
#define QUOTE_BBBS              1
#define QUOTE_GOLDED            2
#define QUOTE_IDIOT2            3
#define QUOTE_DEFAULT           4

/* Tagline usage */

#define TAGLINE_NONE            0
#define TAGLINE_RANDOM          1
#define TAGLINE_PROMPT          2
#define TAGLINE_MANUAL          3
#define TAGLINE_EXTERNAL        4
#define TAGLINE_DEFAULT         5

#define DEFAULT_AUTOSPLIT       0x00000001
#define DEFAULT_INTABLE         0x00000002
#define DEFAULT_OUTTABLE        0x00000004
#define DEFAULT_TAGFILE         0x00000008
#define DEFAULT_ADOPTFILE       0x00000010
#define DEFAULT_SIGNATURE       0x00000020
#define DEFAULT_SAVEFILE        0x00000040
#define DEFAULT_REPLYSAVE       0x00000080
#define DEFAULT_KEYWORD         0x00000100
#define DEFAULT_ALIAS           0x00000200
#define DEFAULT_QUOTEHDR        0x00000400
#define DEFAULT_EDITOR          0x00000800


/* Preferences record */
typedef struct {
    char areatag[51];

    unsigned long defaults;     /* See DEFAULT_xxxx     */

    unsigned short rflags;      /* Read flags           */
    unsigned char sort_msgs;    /* See MSGSORT_xxxx     */
    unsigned char wflags;       /* Write flags          */
    unsigned char replysort;    /* See REPLYSORT_xxxx   */
    unsigned char taglines;     /* See TAGLINE_xxxx     */
    unsigned char quote;
    unsigned short autosplit;

    char intable[21];
    char outtable[21];

    char tagfile[81];
    char adoptfile[81];

    char signature[81];
    char savefile[81];
    char replysave[81];
    char keyword[81];
    char alias[36];
    char quotehdr[71];
    CmdStr editor;

    unsigned short wflags2;
    char empty[67];
} PrefsRecord;

extern LangType *lang;          // Language texts
extern char month[12][4];       // Month names
extern char color[MaxColors];   // Colors

extern char cfgfile[256];       // Configuration file name
extern SetupRecord setup;       // Config
extern PrefsRecord opt;         // Area configuration

extern msgtype msg;             // Message record
extern replytype reply;         // Message reply record
extern UPL_REC uplrec;          // Message reply record (BW style)
extern pers_rec pers;           // Personal mail scan record

extern unsigned char inbound[256]; // Inbound translation table
extern unsigned char outbound[256];// Outbound translation table

extern int keyb_keys;           // Number of alt-hotkeys
extern int keys[20];            // Available alt-hotkeys
extern int keypos[20];          // Key positions in alt-hotkeys

extern int ctrl_keys;           // Number of ctrl-hotkeys
extern int ctrls[20];           // Available ctrl-hotkeys
extern int ctrlpos[20];         // Key positions in ctrl-hotkeys

extern int key_found;           // get_string() : Alt-Hot key pressed
extern int ctrl_found;          // get_string() : Ctrl-Hot key pressed
extern int key_xpos;            // get_string() : Current X pos
extern int key_xovr;            // get_string() : Current X over

extern char mailscanned;        // Mail scan already made
extern char replymgr;           // We're in reply manager?

extern char mailpktname[13];    // Mail packet name (SKYLINER.005)
extern char pktname[9];         // Packet name (SKYLINER)
extern char omentag[3];         // OMEN packet tag
extern char replypath[256];     // Reply work path
extern char downpath[256];      // Download path
extern char reppkt[256];        // Reply packet name
extern char ext[5];             // Reply packet extension

extern FILE *Fpktidx;           // Packet index file
extern packet_index pktidx;     // Packet index

extern pkt_type packet;         // Packet information
extern char arcfmt;             // Archiver format
extern char replyopen;          // Reply packet open

extern char fmt;                // Mail packet format
extern char fmt_short[6];       // Format short name

extern FILE *Finf;              // PACKETS.INF file
extern FILE *Fsky;              // ~RESTART.SKY file
extern FILE *Fpers;             // Personal mail scan file
extern FILE *Ffound;            // Keyword search file

extern offline_packet *pkt;     // Mail packet object
extern short *areaptrs;         // Message area pointers

extern unsigned oldarea;
extern unsigned origarea;       // Current area number
extern char areatag[21];        // Current area tag
extern char areaname[61];       // Current area name

extern char msgs_in_mem;        // All messages are readed to memory
extern msgtype *mem_msgs;       // Pointer to messages in memory

extern char show_kludges;       // Show kludges
extern char rot13;              // Rot13 crypting

extern char tagline[256];       // Currently randomized tagline
extern unsigned short msg_point;// Netmail message point address

extern char search_mode;        // Are we in keyword search?
extern char kw_search[5][31];   // Keyword search: search words
extern char kw_flags[5][7];     // Keyword search: search flags

extern char table[];
extern char registered;         // registered version

#endif
